/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.rights;

import org.hsqldb.Database;
import org.hsqldb.HsqlException;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.Routine;
import org.hsqldb.Schema;
import org.hsqldb.SchemaObject;
import org.hsqldb.Session;
import org.hsqldb.error.Error;
import org.hsqldb.lib.HashMappedList;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.result.Result;
import org.hsqldb.rights.Grantee;
import org.hsqldb.rights.GranteeManager;
import org.hsqldb.rights.User;

public final class UserManager {
    private HashMappedList userList;
    private GranteeManager granteeManager;
    Routine pwCheckFunction;
    Routine extAuthenticationFunction;

    public UserManager(Database database) {
        this.granteeManager = database.getGranteeManager();
        this.userList = new HashMappedList();
    }

    public User createUser(Session session, HsqlNameManager.HsqlName hsqlName, String string2, boolean bl) {
        User user = this.granteeManager.addUser(hsqlName);
        if (session == null) {
            user.setPassword(string2, bl);
        } else {
            try {
                this.setPassword(session, user, string2, bl);
            }
            catch (HsqlException hsqlException) {
                this.granteeManager.removeNewUser(hsqlName);
                throw hsqlException;
            }
        }
        this.userList.add(hsqlName.name, user);
        return user;
    }

    public void setPassword(Session session, User user, String string2, boolean bl) {
        if (!bl && !this.checkComplexity(session, string2)) {
            throw Error.error(391);
        }
        user.setPassword(string2, bl);
    }

    public boolean checkComplexity(Session session, String string2) {
        if (session == null || this.pwCheckFunction == null) {
            return true;
        }
        Result result2 = this.pwCheckFunction.invoke(session, new Object[]{string2}, null, true);
        Boolean bl = (Boolean)result2.getValueObject();
        return bl != null && bl != false;
    }

    public void dropUser(String string2) {
        boolean bl = GranteeManager.isReserved(string2);
        if (bl) {
            throw Error.error(4002, string2);
        }
        boolean bl2 = this.granteeManager.removeGrantee(string2);
        if (!bl2) {
            throw Error.error(4001, string2);
        }
        User user = (User)this.userList.remove(string2);
        if (user == null) {
            throw Error.error(4001, string2);
        }
    }

    public void createFirstUser(String string2, String string3) {
        boolean bl = true;
        if (string2.equalsIgnoreCase("SA")) {
            string2 = "SA";
            bl = false;
        }
        HsqlNameManager.HsqlName hsqlName = this.granteeManager.database.nameManager.newHsqlName(string2, bl, 11);
        User user = this.createUser(null, hsqlName, string3, false);
        user.isLocalOnly = true;
        this.granteeManager.grant(hsqlName.name, "DBA", this.granteeManager.getDBARole());
    }

    public User getUser(String string2, String string3) {
        SchemaObject schemaObject;
        int n;
        User user;
        boolean bl;
        if (string2 == null) {
            string2 = "";
        }
        if (string3 == null) {
            string3 = "";
        }
        boolean bl2 = bl = (user = (User)this.userList.get(string2)) != null && user.isLocalOnly;
        if (this.extAuthenticationFunction == null || bl) {
            user = this.get(string2);
            user.checkPassword(string3);
            return user;
        }
        Result result2 = this.extAuthenticationFunction.invokeJavaMethodDirect(new String[]{this.granteeManager.database.getNameString(), string2, string3});
        if (result2.isError()) {
            throw Error.error(4001, result2.getMainString());
        }
        Object[] objectArray = (Object[])result2.getValueObject();
        if (user == null) {
            HsqlNameManager.HsqlName hsqlName = this.granteeManager.database.nameManager.newHsqlName(string2, true, 11);
            user = this.createUser(null, hsqlName, "", false);
            user.isExternalOnly = true;
        }
        if (objectArray == null) {
            user.updateAllRights();
            return user;
        }
        user.clearPrivileges();
        for (n = 0; n < objectArray.length; ++n) {
            try {
                schemaObject = this.granteeManager.getRole((String)objectArray[n]);
                user.grant((Grantee)schemaObject);
                continue;
            }
            catch (HsqlException hsqlException) {
                // empty catch block
            }
        }
        user.updateAllRights();
        for (n = 0; n < objectArray.length; ++n) {
            schemaObject = this.granteeManager.database.schemaManager.findSchema((String)objectArray[n]);
            if (schemaObject == null) continue;
            user.setInitialSchema(((Schema)schemaObject).getName());
            break;
        }
        return user;
    }

    public HashMappedList getUsers() {
        return this.userList;
    }

    public boolean exists(String string2) {
        return this.userList.get(string2) != null;
    }

    public User get(String string2) {
        User user = (User)this.userList.get(string2);
        if (user == null) {
            throw Error.error(4001, string2);
        }
        return user;
    }

    public HsqlArrayList listVisibleUsers(Session session) {
        HsqlArrayList hsqlArrayList = new HsqlArrayList();
        boolean bl = session.isAdmin();
        String string2 = session.getUsername();
        if (this.userList == null || this.userList.size() == 0) {
            return hsqlArrayList;
        }
        for (int i = 0; i < this.userList.size(); ++i) {
            User user = (User)this.userList.get(i);
            if (user == null) continue;
            String string3 = user.getName().getNameString();
            if (bl) {
                hsqlArrayList.add(user);
                continue;
            }
            if (!string2.equals(string3)) continue;
            hsqlArrayList.add(user);
        }
        return hsqlArrayList;
    }

    public User getSysUser() {
        return GranteeManager.systemAuthorisation;
    }

    public synchronized void removeSchemaReference(HsqlNameManager.HsqlName hsqlName) {
        for (int i = 0; i < this.userList.size(); ++i) {
            User user = (User)this.userList.get(i);
            HsqlNameManager.HsqlName hsqlName2 = user.getInitialSchema();
            if (hsqlName2 == null || !hsqlName.equals(hsqlName2)) continue;
            user.setInitialSchema(null);
        }
    }

    public void setPasswordCheckFunction(Routine routine) {
        this.pwCheckFunction = routine;
    }

    public void setExtAuthenticationFunction(Routine routine) {
        this.extAuthenticationFunction = routine;
    }

    public String[] getInitialSchemaSQL() {
        HsqlArrayList hsqlArrayList = new HsqlArrayList(this.userList.size());
        for (int i = 0; i < this.userList.size(); ++i) {
            HsqlNameManager.HsqlName hsqlName;
            User user = (User)this.userList.get(i);
            if (user.isSystem || (hsqlName = user.getInitialSchema()) == null) continue;
            hsqlArrayList.add(user.getInitialSchemaSQL());
        }
        String[] stringArray = new String[hsqlArrayList.size()];
        hsqlArrayList.toArray(stringArray);
        return stringArray;
    }

    public String[] getAuthenticationSQL() {
        StringBuilder stringBuilder;
        HsqlArrayList hsqlArrayList = new HsqlArrayList();
        if (this.pwCheckFunction != null) {
            stringBuilder = new StringBuilder();
            stringBuilder.append("SET").append(' ').append("DATABASE");
            stringBuilder.append(' ').append("PASSWORD").append(' ');
            stringBuilder.append("CHECK").append(' ').append("FUNCTION");
            stringBuilder.append(' ');
            stringBuilder.append(this.pwCheckFunction.getSQLBodyDefinition());
            hsqlArrayList.add(stringBuilder.toString());
        }
        if (this.extAuthenticationFunction != null) {
            stringBuilder = new StringBuilder();
            stringBuilder.append("SET").append(' ').append("DATABASE");
            stringBuilder.append(' ').append("AUTHENTICATION").append(' ');
            stringBuilder.append("FUNCTION").append(' ');
            stringBuilder.append(this.extAuthenticationFunction.getSQLBodyDefinition());
            hsqlArrayList.add(stringBuilder.toString());
        }
        String[] stringArray = new String[hsqlArrayList.size()];
        hsqlArrayList.toArray(stringArray);
        return stringArray;
    }
}

