/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.util;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Panel;
import java.awt.Scrollbar;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.util.Vector;

class Tree
extends Panel {
    private static Font fFont = new Font("Dialog", 0, 12);
    private static FontMetrics fMetrics = Toolkit.getDefaultToolkit().getFontMetrics(fFont);
    private static int iRowHeight = Tree.getMaxHeight(fMetrics);
    private static int iIndentWidth = 12;
    private int iMaxTextLength;
    private Dimension dMinimum;
    private Graphics gImage;
    private Image iImage;
    private int iWidth;
    private int iHeight;
    private int iFirstRow;
    private int iTreeWidth;
    private int iTreeHeight;
    private int iX;
    private int iY;
    private Vector vData = new Vector();
    private int iRowCount;
    private Scrollbar sbHoriz;
    private Scrollbar sbVert;
    private int iSbWidth;
    private int iSbHeight;

    Tree() {
        this.setLayout(null);
        this.sbHoriz = new Scrollbar(0);
        this.add(this.sbHoriz);
        this.sbVert = new Scrollbar(1);
        this.add(this.sbVert);
    }

    @Override
    public void setMinimumSize(Dimension dimension) {
        this.dMinimum = dimension;
    }

    @Override
    public void setBounds(int n, int n2, int n3, int n4) {
        super.setBounds(n, n2, n3, n4);
        this.iSbHeight = this.sbHoriz.getPreferredSize().height;
        this.iSbWidth = this.sbVert.getPreferredSize().width;
        this.iHeight = n4 - this.iSbHeight;
        this.iWidth = n3 - this.iSbWidth;
        this.sbHoriz.setBounds(0, this.iHeight, this.iWidth, this.iSbHeight);
        this.sbVert.setBounds(this.iWidth, 0, this.iSbWidth, this.iHeight);
        this.adjustScroll();
        this.iImage = null;
        this.repaint();
    }

    @Override
    public void removeAll() {
        this.vData = new Vector();
        this.iRowCount = 0;
        this.adjustScroll();
        this.iMaxTextLength = 10;
        this.repaint();
    }

    public void addRow(String string2, String string3, String string4, int n) {
        String[] stringArray = new String[4];
        if (string3 == null) {
            string3 = "";
        }
        stringArray[0] = string2;
        stringArray[1] = string3;
        stringArray[2] = string4;
        stringArray[3] = String.valueOf(n);
        this.vData.addElement(stringArray);
        int n2 = fMetrics.stringWidth(string3);
        if (n2 > this.iMaxTextLength) {
            this.iMaxTextLength = n2;
        }
        ++this.iRowCount;
    }

    public void addRow(String string2, String string3) {
        this.addRow(string2, string3, null, 0);
    }

    public void update() {
        this.adjustScroll();
        this.repaint();
    }

    void adjustScroll() {
        this.iTreeHeight = iRowHeight * (this.iRowCount + 1);
        this.iTreeWidth = this.iMaxTextLength * 2;
        this.sbHoriz.setValues(this.iX, this.iWidth, 0, this.iTreeWidth);
        int n = this.iY / iRowHeight;
        int n2 = this.iHeight / iRowHeight;
        this.sbVert.setValues(n, n2, 0, this.iRowCount + 1);
        this.iX = this.sbHoriz.getValue();
        this.iY = iRowHeight * this.sbVert.getValue();
    }

    @Override
    public boolean handleEvent(Event event) {
        switch (event.id) {
            case 601: 
            case 602: 
            case 603: 
            case 604: 
            case 605: {
                this.iX = this.sbHoriz.getValue();
                this.iY = iRowHeight * this.sbVert.getValue();
                this.repaint();
                return true;
            }
        }
        return super.handleEvent(event);
    }

    @Override
    public void paint(Graphics graphics) {
        if (graphics == null || this.iWidth <= 0 || this.iHeight <= 0) {
            return;
        }
        graphics.setColor(SystemColor.control);
        graphics.fillRect(this.iWidth, this.iHeight, this.iSbWidth, this.iSbHeight);
        if (this.iImage == null) {
            this.iImage = this.createImage(this.iWidth, this.iHeight);
            this.gImage = this.iImage.getGraphics();
            this.gImage.setFont(fFont);
        }
        this.gImage.setColor(Color.white);
        this.gImage.fillRect(0, 0, this.iWidth, this.iHeight);
        int[] nArray = new int[100];
        String[] stringArray = new String[100];
        stringArray[0] = "";
        int n = 0;
        int n2 = iRowHeight;
        n2 -= this.iY;
        boolean bl = false;
        for (int i = 0; i < this.iRowCount; ++i) {
            int n3;
            String[] stringArray2 = (String[])this.vData.elementAt(i);
            String string2 = stringArray2[0];
            String string3 = stringArray2[1];
            String string4 = stringArray2[2];
            for (n3 = n; n3 > 0 && !string2.startsWith(stringArray[n3]); --n3) {
            }
            if (stringArray[n3].length() < string2.length()) {
                ++n3;
            }
            if (bl && n3 > n) continue;
            bl = string4 != null && string4.equals("+");
            stringArray[n3] = string2;
            int n4 = iIndentWidth * n3 - this.iX;
            this.gImage.setColor(Color.lightGray);
            this.gImage.drawLine(n4, n2, n4 + iIndentWidth, n2);
            this.gImage.drawLine(n4, n2, n4, nArray[n3]);
            nArray[n3 + 1] = n2;
            int n5 = n2 + iRowHeight / 3;
            int n6 = n4 + iIndentWidth * 2;
            if (string4 != null) {
                int n7 = n3 + 1;
                nArray[n7] = nArray[n7] + 4;
                int n8 = Integer.parseInt(stringArray2[3]);
                this.gImage.setColor(n8 == 0 ? Color.white : new Color(n8));
                this.gImage.fillRect(n4 + iIndentWidth - 3, n2 - 3, 7, 7);
                this.gImage.setColor(Color.black);
                this.gImage.drawRect(n4 + iIndentWidth - 4, n2 - 4, 8, 8);
                this.gImage.drawLine(n4 + iIndentWidth - 2, n2, n4 + iIndentWidth + 2, n2);
                if (string4.equals("+")) {
                    this.gImage.drawLine(n4 + iIndentWidth, n2 - 2, n4 + iIndentWidth, n2 + 2);
                }
            } else {
                n6 -= iIndentWidth;
            }
            this.gImage.setColor(Color.black);
            this.gImage.drawString(string3, n6, n5);
            n = n3;
            n2 += iRowHeight;
        }
        graphics.drawImage(this.iImage, 0, 0, this);
    }

    @Override
    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    @Override
    public Dimension preferredSize() {
        return this.dMinimum;
    }

    @Override
    public Dimension getPreferredSize() {
        return this.dMinimum;
    }

    @Override
    public Dimension getMinimumSize() {
        return this.dMinimum;
    }

    @Override
    public Dimension minimumSize() {
        return this.dMinimum;
    }

    @Override
    public boolean mouseDown(Event event, int n, int n2) {
        String string2;
        String[] stringArray;
        int n3;
        if (iRowHeight == 0 || n > this.iWidth || n2 > this.iHeight) {
            return true;
        }
        n2 += iRowHeight / 2;
        String[] stringArray2 = new String[100];
        stringArray2[0] = "";
        int n4 = 0;
        int n5 = iRowHeight;
        boolean bl = false;
        n2 += this.iY;
        for (n3 = 0; n3 < this.iRowCount; ++n3) {
            int n6;
            stringArray = (String[])this.vData.elementAt(n3);
            string2 = stringArray[0];
            String string3 = stringArray[2];
            for (n6 = n4; n6 > 0 && !string2.startsWith(stringArray2[n6]); --n6) {
            }
            if (stringArray2[n6].length() < string2.length()) {
                ++n6;
            }
            if (bl && n6 > n4) continue;
            if (n5 <= n2 && n5 + iRowHeight > n2) break;
            stringArray2[n6] = string2;
            bl = string3 != null && string3.equals("+");
            n4 = n6;
            n5 += iRowHeight;
        }
        if (n3 >= 0 && n3 < this.iRowCount) {
            stringArray = (String[])this.vData.elementAt(n3);
            string2 = stringArray[2];
            if (string2 != null && string2.equals("+")) {
                string2 = "-";
            } else if (string2 != null && string2.equals("-")) {
                string2 = "+";
            }
            stringArray[2] = string2;
            this.vData.setElementAt(stringArray, n3);
            this.repaint();
        }
        return true;
    }

    private static int getMaxHeight(FontMetrics fontMetrics) {
        return fontMetrics.getHeight() + 2;
    }
}

