/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.log;

import java.util.List;
import java.util.function.Predicate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.impl.NoOpLog;

final class CompositeLog
implements Log {
    private static final Log NO_OP_LOG = new NoOpLog();
    private final Log fatalLogger;
    private final Log errorLogger;
    private final Log warnLogger;
    private final Log infoLogger;
    private final Log debugLogger;
    private final Log traceLogger;

    public CompositeLog(List<Log> loggers) {
        this.fatalLogger = CompositeLog.initLogger(loggers, Log::isFatalEnabled);
        this.errorLogger = CompositeLog.initLogger(loggers, Log::isErrorEnabled);
        this.warnLogger = CompositeLog.initLogger(loggers, Log::isWarnEnabled);
        this.infoLogger = CompositeLog.initLogger(loggers, Log::isInfoEnabled);
        this.debugLogger = CompositeLog.initLogger(loggers, Log::isDebugEnabled);
        this.traceLogger = CompositeLog.initLogger(loggers, Log::isTraceEnabled);
    }

    private static Log initLogger(List<Log> loggers, Predicate<Log> predicate) {
        return loggers.stream().filter(predicate).findFirst().orElse(NO_OP_LOG);
    }

    @Override
    public boolean isFatalEnabled() {
        return this.fatalLogger != NO_OP_LOG;
    }

    @Override
    public boolean isErrorEnabled() {
        return this.errorLogger != NO_OP_LOG;
    }

    @Override
    public boolean isWarnEnabled() {
        return this.warnLogger != NO_OP_LOG;
    }

    @Override
    public boolean isInfoEnabled() {
        return this.infoLogger != NO_OP_LOG;
    }

    @Override
    public boolean isDebugEnabled() {
        return this.debugLogger != NO_OP_LOG;
    }

    @Override
    public boolean isTraceEnabled() {
        return this.traceLogger != NO_OP_LOG;
    }

    @Override
    public void fatal(Object message2) {
        this.fatalLogger.fatal(message2);
    }

    @Override
    public void fatal(Object message2, Throwable ex) {
        this.fatalLogger.fatal(message2, ex);
    }

    @Override
    public void error(Object message2) {
        this.errorLogger.error(message2);
    }

    @Override
    public void error(Object message2, Throwable ex) {
        this.errorLogger.error(message2);
    }

    @Override
    public void warn(Object message2) {
        this.warnLogger.warn(message2);
    }

    @Override
    public void warn(Object message2, Throwable ex) {
        this.warnLogger.warn(message2, ex);
    }

    @Override
    public void info(Object message2) {
        this.infoLogger.info(message2);
    }

    @Override
    public void info(Object message2, Throwable ex) {
        this.infoLogger.info(message2, ex);
    }

    @Override
    public void debug(Object message2) {
        this.debugLogger.debug(message2);
    }

    @Override
    public void debug(Object message2, Throwable ex) {
        this.debugLogger.debug(message2, ex);
    }

    @Override
    public void trace(Object message2) {
        this.traceLogger.trace(message2);
    }

    @Override
    public void trace(Object message2, Throwable ex) {
        this.traceLogger.trace(message2, ex);
    }
}

