/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.style;

import org.springframework.core.style.ToStringStyler;
import org.springframework.core.style.ValueStyler;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;

public class DefaultToStringStyler
implements ToStringStyler {
    private final ValueStyler valueStyler;

    public DefaultToStringStyler(ValueStyler valueStyler) {
        Assert.notNull((Object)valueStyler, "ValueStyler must not be null");
        this.valueStyler = valueStyler;
    }

    protected final ValueStyler getValueStyler() {
        return this.valueStyler;
    }

    @Override
    public void styleStart(StringBuilder buffer, Object obj2) {
        if (!obj2.getClass().isArray()) {
            buffer.append('[').append(ClassUtils.getShortName(obj2.getClass()));
            this.styleIdentityHashCode(buffer, obj2);
        } else {
            buffer.append('[');
            this.styleIdentityHashCode(buffer, obj2);
            buffer.append(' ');
            this.styleValue(buffer, obj2);
        }
    }

    private void styleIdentityHashCode(StringBuilder buffer, Object obj2) {
        buffer.append('@');
        buffer.append(ObjectUtils.getIdentityHexString(obj2));
    }

    @Override
    public void styleEnd(StringBuilder buffer, Object o) {
        buffer.append(']');
    }

    @Override
    public void styleField(StringBuilder buffer, String fieldName, @Nullable Object value2) {
        this.styleFieldStart(buffer, fieldName);
        this.styleValue(buffer, value2);
        this.styleFieldEnd(buffer, fieldName);
    }

    protected void styleFieldStart(StringBuilder buffer, String fieldName) {
        buffer.append(' ').append(fieldName).append(" = ");
    }

    protected void styleFieldEnd(StringBuilder buffer, String fieldName) {
    }

    @Override
    public void styleValue(StringBuilder buffer, @Nullable Object value2) {
        buffer.append(this.valueStyler.style(value2));
    }

    @Override
    public void styleFieldSeparator(StringBuilder buffer) {
        buffer.append(',');
    }
}

