/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.util;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public abstract class NumberUtils {
    private static int DOUBLE_SCALE = new BigDecimal(Double.MIN_VALUE).scale();
    private static int FLOAT_SCALE = new BigDecimal(1.4E-45f).scale();
    private static final BigInteger LONG_MIN = BigInteger.valueOf(Long.MIN_VALUE);
    private static final BigInteger LONG_MAX = BigInteger.valueOf(Long.MAX_VALUE);
    public static final Set<Class<?>> STANDARD_NUMBER_TYPES;

    public static <T extends Number> T convertNumberToTargetClass(Number number2, Class<T> clazz) throws IllegalArgumentException {
        Assert.notNull((Object)number2, "Number must not be null");
        Assert.notNull(clazz, "Target class must not be null");
        if (clazz.isInstance(number2)) {
            return (T)number2;
        }
        if (Byte.class == clazz) {
            long l = NumberUtils.checkedLongValue(number2, clazz);
            if (l < -128L || l > 127L) {
                NumberUtils.raiseOverflowException(number2, clazz);
            }
            return (T)Byte.valueOf(number2.byteValue());
        }
        if (Short.class == clazz) {
            long l = NumberUtils.checkedLongValue(number2, clazz);
            if (l < -32768L || l > 32767L) {
                NumberUtils.raiseOverflowException(number2, clazz);
            }
            return (T)Short.valueOf(number2.shortValue());
        }
        if (Integer.class == clazz) {
            long l = NumberUtils.checkedLongValue(number2, clazz);
            if (l < Integer.MIN_VALUE || l > Integer.MAX_VALUE) {
                NumberUtils.raiseOverflowException(number2, clazz);
            }
            return (T)Integer.valueOf(number2.intValue());
        }
        if (Long.class == clazz) {
            long l = NumberUtils.checkedLongValue(number2, clazz);
            return (T)Long.valueOf(l);
        }
        if (BigInteger.class == clazz) {
            if (number2 instanceof BigDecimal) {
                return (T)((BigDecimal)number2).toBigInteger();
            }
            return (T)BigInteger.valueOf(number2.longValue());
        }
        if (Float.class == clazz) {
            return (T)Float.valueOf(number2.floatValue());
        }
        if (Double.class == clazz) {
            return (T)Double.valueOf(number2.doubleValue());
        }
        if (BigDecimal.class == clazz) {
            BigDecimal bigDecimal = new BigDecimal(number2.toString());
            if (number2 instanceof Double) {
                return (T)bigDecimal.setScale(DOUBLE_SCALE, 7);
            }
            if (number2 instanceof Float) {
                return (T)bigDecimal.setScale(FLOAT_SCALE, 7);
            }
            return (T)bigDecimal;
        }
        throw new IllegalArgumentException("Could not convert number [" + number2 + "] of type [" + number2.getClass().getName() + "] to unsupported target class [" + clazz.getName() + "]");
    }

    private static long checkedLongValue(Number number2, Class<? extends Number> clazz) {
        BigInteger bigInteger = null;
        if (number2 instanceof BigInteger) {
            bigInteger = (BigInteger)number2;
        } else if (number2 instanceof BigDecimal) {
            bigInteger = ((BigDecimal)number2).toBigInteger();
        }
        if (bigInteger != null && (bigInteger.compareTo(LONG_MIN) < 0 || bigInteger.compareTo(LONG_MAX) > 0)) {
            NumberUtils.raiseOverflowException(number2, clazz);
        }
        return number2.longValue();
    }

    private static void raiseOverflowException(Number number2, Class<?> clazz) {
        throw new IllegalArgumentException("Could not convert number [" + number2 + "] of type [" + number2.getClass().getName() + "] to target class [" + clazz.getName() + "]: overflow");
    }

    public static <T extends Number> T parseNumber(String string2, Class<T> clazz) {
        Assert.notNull((Object)string2, "Text must not be null");
        Assert.notNull(clazz, "Target class must not be null");
        String string3 = StringUtils.trimAllWhitespace(string2);
        if (Byte.class == clazz) {
            return (T)(NumberUtils.isHexNumber(string3) ? Byte.decode(string3) : Byte.valueOf(string3));
        }
        if (Short.class == clazz) {
            return (T)(NumberUtils.isHexNumber(string3) ? Short.decode(string3) : Short.valueOf(string3));
        }
        if (Integer.class == clazz) {
            return (T)(NumberUtils.isHexNumber(string3) ? Integer.decode(string3) : Integer.valueOf(string3));
        }
        if (Long.class == clazz) {
            return (T)(NumberUtils.isHexNumber(string3) ? Long.decode(string3) : Long.valueOf(string3));
        }
        if (BigInteger.class == clazz) {
            return (T)(NumberUtils.isHexNumber(string3) ? NumberUtils.decodeBigInteger(string3) : new BigInteger(string3));
        }
        if (Float.class == clazz) {
            return (T)Float.valueOf(string3);
        }
        if (Double.class == clazz) {
            return (T)Double.valueOf(string3);
        }
        if (BigDecimal.class == clazz || Number.class == clazz) {
            return (T)new BigDecimal(string3);
        }
        throw new IllegalArgumentException("Cannot convert String [" + string2 + "] to target class [" + clazz.getName() + "]");
    }

    public static <T extends Number> T parseNumber(String string2, Class<T> clazz, NumberFormat numberFormat) {
        if (numberFormat != null) {
            Assert.notNull((Object)string2, "Text must not be null");
            Assert.notNull(clazz, "Target class must not be null");
            DecimalFormat decimalFormat = null;
            boolean bl = false;
            if (numberFormat instanceof DecimalFormat) {
                decimalFormat = (DecimalFormat)numberFormat;
                if (BigDecimal.class == clazz && !decimalFormat.isParseBigDecimal()) {
                    decimalFormat.setParseBigDecimal(true);
                    bl = true;
                }
            }
            try {
                Number number2 = numberFormat.parse(StringUtils.trimAllWhitespace(string2));
                T t = NumberUtils.convertNumberToTargetClass(number2, clazz);
                return t;
            }
            catch (ParseException parseException) {
                throw new IllegalArgumentException("Could not parse number: " + parseException.getMessage());
            }
            finally {
                if (bl) {
                    decimalFormat.setParseBigDecimal(false);
                }
            }
        }
        return NumberUtils.parseNumber(string2, clazz);
    }

    private static boolean isHexNumber(String string2) {
        int n = string2.startsWith("-") ? 1 : 0;
        return string2.startsWith("0x", n) || string2.startsWith("0X", n) || string2.startsWith("#", n);
    }

    private static BigInteger decodeBigInteger(String string2) {
        int n = 10;
        int n2 = 0;
        boolean bl = false;
        if (string2.startsWith("-")) {
            bl = true;
            ++n2;
        }
        if (string2.startsWith("0x", n2) || string2.startsWith("0X", n2)) {
            n2 += 2;
            n = 16;
        } else if (string2.startsWith("#", n2)) {
            ++n2;
            n = 16;
        } else if (string2.startsWith("0", n2) && string2.length() > 1 + n2) {
            ++n2;
            n = 8;
        }
        BigInteger bigInteger = new BigInteger(string2.substring(n2), n);
        return bl ? bigInteger.negate() : bigInteger;
    }

    static {
        HashSet<Class> hashSet = new HashSet<Class>(8);
        hashSet.add(Byte.class);
        hashSet.add(Short.class);
        hashSet.add(Integer.class);
        hashSet.add(Long.class);
        hashSet.add(BigInteger.class);
        hashSet.add(Float.class);
        hashSet.add(Double.class);
        hashSet.add(BigDecimal.class);
        STANDARD_NUMBER_TYPES = Collections.unmodifiableSet(hashSet);
    }
}

