/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.booleans;

import it.unimi.dsi.fastutil.BigArrays;
import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.booleans.BooleanArrays;
import it.unimi.dsi.fastutil.booleans.BooleanComparator;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Random;

public final class BooleanBigArrays {
    public static final boolean[][] EMPTY_BIG_ARRAY = new boolean[0][];
    public static final Hash.Strategy HASH_STRATEGY = new BigArrayHashStrategy();
    private static final int SMALL = 7;
    private static final int MEDIUM = 40;

    private BooleanBigArrays() {
    }

    public static boolean get(boolean[][] array2, long index2) {
        return array2[BigArrays.segment(index2)][BigArrays.displacement(index2)];
    }

    public static void set(boolean[][] array2, long index2, boolean value2) {
        array2[BigArrays.segment((long)index2)][BigArrays.displacement((long)index2)] = value2;
    }

    public static void swap(boolean[][] array2, long first2, long second2) {
        boolean t = array2[BigArrays.segment(first2)][BigArrays.displacement(first2)];
        array2[BigArrays.segment((long)first2)][BigArrays.displacement((long)first2)] = array2[BigArrays.segment(second2)][BigArrays.displacement(second2)];
        array2[BigArrays.segment((long)second2)][BigArrays.displacement((long)second2)] = t;
    }

    public static long length(boolean[][] array2) {
        int length = array2.length;
        return length == 0 ? 0L : BigArrays.start(length - 1) + (long)array2[length - 1].length;
    }

    public static void copy(boolean[][] srcArray, long srcPos, boolean[][] destArray, long destPos, long length) {
        if (destPos <= srcPos) {
            int srcSegment = BigArrays.segment(srcPos);
            int destSegment = BigArrays.segment(destPos);
            int srcDispl = BigArrays.displacement(srcPos);
            int destDispl = BigArrays.displacement(destPos);
            while (length > 0L) {
                int l = (int)Math.min(length, (long)Math.min(srcArray[srcSegment].length - srcDispl, destArray[destSegment].length - destDispl));
                System.arraycopy(srcArray[srcSegment], srcDispl, destArray[destSegment], destDispl, l);
                if ((srcDispl += l) == 0x8000000) {
                    srcDispl = 0;
                    ++srcSegment;
                }
                if ((destDispl += l) == 0x8000000) {
                    destDispl = 0;
                    ++destSegment;
                }
                length -= (long)l;
            }
        } else {
            int srcSegment = BigArrays.segment(srcPos + length);
            int destSegment = BigArrays.segment(destPos + length);
            int srcDispl = BigArrays.displacement(srcPos + length);
            int destDispl = BigArrays.displacement(destPos + length);
            while (length > 0L) {
                if (srcDispl == 0) {
                    srcDispl = 0x8000000;
                    --srcSegment;
                }
                if (destDispl == 0) {
                    destDispl = 0x8000000;
                    --destSegment;
                }
                int l = (int)Math.min(length, (long)Math.min(srcDispl, destDispl));
                System.arraycopy(srcArray[srcSegment], srcDispl - l, destArray[destSegment], destDispl - l, l);
                srcDispl -= l;
                destDispl -= l;
                length -= (long)l;
            }
        }
    }

    public static void copyFromBig(boolean[][] srcArray, long srcPos, boolean[] destArray, int destPos, int length) {
        int srcSegment = BigArrays.segment(srcPos);
        int srcDispl = BigArrays.displacement(srcPos);
        while (length > 0) {
            int l = Math.min(srcArray[srcSegment].length - srcDispl, length);
            System.arraycopy(srcArray[srcSegment], srcDispl, destArray, destPos, l);
            if ((srcDispl += l) == 0x8000000) {
                srcDispl = 0;
                ++srcSegment;
            }
            destPos += l;
            length -= l;
        }
    }

    public static void copyToBig(boolean[] srcArray, int srcPos, boolean[][] destArray, long destPos, long length) {
        int destSegment = BigArrays.segment(destPos);
        int destDispl = BigArrays.displacement(destPos);
        while (length > 0L) {
            int l = (int)Math.min((long)(destArray[destSegment].length - destDispl), length);
            System.arraycopy(srcArray, srcPos, destArray[destSegment], destDispl, l);
            if ((destDispl += l) == 0x8000000) {
                destDispl = 0;
                ++destSegment;
            }
            srcPos += l;
            length -= (long)l;
        }
    }

    public static boolean[][] newBigArray(long length) {
        if (length == 0L) {
            return EMPTY_BIG_ARRAY;
        }
        BigArrays.ensureLength(length);
        int baseLength = (int)(length + 0x7FFFFFFL >>> 27);
        boolean[][] base = new boolean[baseLength][];
        int residual = (int)(length & 0x7FFFFFFL);
        if (residual != 0) {
            for (int i = 0; i < baseLength - 1; ++i) {
                base[i] = new boolean[0x8000000];
            }
            base[baseLength - 1] = new boolean[residual];
        } else {
            for (int i = 0; i < baseLength; ++i) {
                base[i] = new boolean[0x8000000];
            }
        }
        return base;
    }

    public static boolean[][] wrap(boolean[] array2) {
        if (array2.length == 0) {
            return EMPTY_BIG_ARRAY;
        }
        if (array2.length <= 0x8000000) {
            return new boolean[][]{array2};
        }
        boolean[][] bigArray = BooleanBigArrays.newBigArray(array2.length);
        for (int i = 0; i < bigArray.length; ++i) {
            System.arraycopy(array2, (int)BigArrays.start(i), bigArray[i], 0, bigArray[i].length);
        }
        return bigArray;
    }

    public static boolean[][] ensureCapacity(boolean[][] array2, long length) {
        return BooleanBigArrays.ensureCapacity(array2, length, BooleanBigArrays.length(array2));
    }

    public static boolean[][] ensureCapacity(boolean[][] array2, long length, long preserve) {
        long oldLength = BooleanBigArrays.length(array2);
        if (length > oldLength) {
            BigArrays.ensureLength(length);
            int valid = array2.length - (array2.length == 0 || array2.length > 0 && array2[array2.length - 1].length == 0x8000000 ? 0 : 1);
            int baseLength = (int)(length + 0x7FFFFFFL >>> 27);
            boolean[][] base = (boolean[][])Arrays.copyOf(array2, baseLength);
            int residual = (int)(length & 0x7FFFFFFL);
            if (residual != 0) {
                for (int i = valid; i < baseLength - 1; ++i) {
                    base[i] = new boolean[0x8000000];
                }
                base[baseLength - 1] = new boolean[residual];
            } else {
                for (int i = valid; i < baseLength; ++i) {
                    base[i] = new boolean[0x8000000];
                }
            }
            if (preserve - (long)valid * 0x8000000L > 0L) {
                BooleanBigArrays.copy(array2, (long)valid * 0x8000000L, base, (long)valid * 0x8000000L, preserve - (long)valid * 0x8000000L);
            }
            return base;
        }
        return array2;
    }

    public static boolean[][] grow(boolean[][] array2, long length) {
        long oldLength = BooleanBigArrays.length(array2);
        return length > oldLength ? BooleanBigArrays.grow(array2, length, oldLength) : array2;
    }

    public static boolean[][] grow(boolean[][] array2, long length, long preserve) {
        long oldLength = BooleanBigArrays.length(array2);
        return length > oldLength ? BooleanBigArrays.ensureCapacity(array2, Math.max(2L * oldLength, length), preserve) : array2;
    }

    public static boolean[][] trim(boolean[][] array2, long length) {
        BigArrays.ensureLength(length);
        long oldLength = BooleanBigArrays.length(array2);
        if (length >= oldLength) {
            return array2;
        }
        int baseLength = (int)(length + 0x7FFFFFFL >>> 27);
        boolean[][] base = (boolean[][])Arrays.copyOf(array2, baseLength);
        int residual = (int)(length & 0x7FFFFFFL);
        if (residual != 0) {
            base[baseLength - 1] = BooleanArrays.trim(base[baseLength - 1], residual);
        }
        return base;
    }

    public static boolean[][] setLength(boolean[][] array2, long length) {
        long oldLength = BooleanBigArrays.length(array2);
        if (length == oldLength) {
            return array2;
        }
        if (length < oldLength) {
            return BooleanBigArrays.trim(array2, length);
        }
        return BooleanBigArrays.ensureCapacity(array2, length);
    }

    public static boolean[][] copy(boolean[][] array2, long offset, long length) {
        BooleanBigArrays.ensureOffsetLength(array2, offset, length);
        boolean[][] a = BooleanBigArrays.newBigArray(length);
        BooleanBigArrays.copy(array2, offset, a, 0L, length);
        return a;
    }

    public static boolean[][] copy(boolean[][] array2) {
        boolean[][] base = (boolean[][])array2.clone();
        int i = base.length;
        while (i-- != 0) {
            base[i] = (boolean[])array2[i].clone();
        }
        return base;
    }

    public static void fill(boolean[][] array2, boolean value2) {
        int i = array2.length;
        while (i-- != 0) {
            Arrays.fill(array2[i], value2);
        }
    }

    public static void fill(boolean[][] array2, long from2, long to2, boolean value2) {
        long length = BooleanBigArrays.length(array2);
        BigArrays.ensureFromTo(length, from2, to2);
        int fromSegment = BigArrays.segment(from2);
        int toSegment = BigArrays.segment(to2);
        int fromDispl = BigArrays.displacement(from2);
        int toDispl = BigArrays.displacement(to2);
        if (fromSegment == toSegment) {
            Arrays.fill(array2[fromSegment], fromDispl, toDispl, value2);
            return;
        }
        if (toDispl != 0) {
            Arrays.fill(array2[toSegment], 0, toDispl, value2);
        }
        while (--toSegment > fromSegment) {
            Arrays.fill(array2[toSegment], value2);
        }
        Arrays.fill(array2[fromSegment], fromDispl, 0x8000000, value2);
    }

    public static boolean equals(boolean[][] a1, boolean[][] a2) {
        if (BooleanBigArrays.length(a1) != BooleanBigArrays.length(a2)) {
            return false;
        }
        int i = a1.length;
        while (i-- != 0) {
            boolean[] t = a1[i];
            boolean[] u = a2[i];
            int j = t.length;
            while (j-- != 0) {
                if (t[j] == u[j]) continue;
                return false;
            }
        }
        return true;
    }

    public static String toString(boolean[][] a) {
        if (a == null) {
            return "null";
        }
        long last2 = BooleanBigArrays.length(a) - 1L;
        if (last2 == -1L) {
            return "[]";
        }
        StringBuilder b = new StringBuilder();
        b.append('[');
        long i = 0L;
        while (true) {
            b.append(String.valueOf(BooleanBigArrays.get(a, i)));
            if (i == last2) {
                return b.append(']').toString();
            }
            b.append(", ");
            ++i;
        }
    }

    public static void ensureFromTo(boolean[][] a, long from2, long to2) {
        BigArrays.ensureFromTo(BooleanBigArrays.length(a), from2, to2);
    }

    public static void ensureOffsetLength(boolean[][] a, long offset, long length) {
        BigArrays.ensureOffsetLength(BooleanBigArrays.length(a), offset, length);
    }

    private static void vecSwap(boolean[][] x, long a, long b, long n) {
        int i = 0;
        while ((long)i < n) {
            BooleanBigArrays.swap(x, a, b);
            ++i;
            ++a;
            ++b;
        }
    }

    private static long med3(boolean[][] x, long a, long b, long c, BooleanComparator comp) {
        int ab = comp.compare(BooleanBigArrays.get(x, a), BooleanBigArrays.get(x, b));
        int ac = comp.compare(BooleanBigArrays.get(x, a), BooleanBigArrays.get(x, c));
        int bc = comp.compare(BooleanBigArrays.get(x, b), BooleanBigArrays.get(x, c));
        return ab < 0 ? (bc < 0 ? b : (ac < 0 ? c : a)) : (bc > 0 ? b : (ac > 0 ? c : a));
    }

    private static void selectionSort(boolean[][] a, long from2, long to2, BooleanComparator comp) {
        for (long i = from2; i < to2 - 1L; ++i) {
            long m3 = i;
            for (long j = i + 1L; j < to2; ++j) {
                if (comp.compare(BooleanBigArrays.get(a, j), BooleanBigArrays.get(a, m3)) >= 0) continue;
                m3 = j;
            }
            if (m3 == i) continue;
            BooleanBigArrays.swap(a, i, m3);
        }
    }

    public static void quickSort(boolean[][] x, long from2, long to2, BooleanComparator comp) {
        long c;
        long a;
        long len = to2 - from2;
        if (len < 7L) {
            BooleanBigArrays.selectionSort(x, from2, to2, comp);
            return;
        }
        long m3 = from2 + len / 2L;
        if (len > 7L) {
            long l = from2;
            long n = to2 - 1L;
            if (len > 40L) {
                long s2 = len / 8L;
                l = BooleanBigArrays.med3(x, l, l + s2, l + 2L * s2, comp);
                m3 = BooleanBigArrays.med3(x, m3 - s2, m3, m3 + s2, comp);
                n = BooleanBigArrays.med3(x, n - 2L * s2, n - s2, n, comp);
            }
            m3 = BooleanBigArrays.med3(x, l, m3, n, comp);
        }
        boolean v = BooleanBigArrays.get(x, m3);
        long b = a = from2;
        long d = c = to2 - 1L;
        while (true) {
            int comparison;
            if (b <= c && (comparison = comp.compare(BooleanBigArrays.get(x, b), v)) <= 0) {
                if (comparison == 0) {
                    BooleanBigArrays.swap(x, a++, b);
                }
                ++b;
                continue;
            }
            while (c >= b && (comparison = comp.compare(BooleanBigArrays.get(x, c), v)) >= 0) {
                if (comparison == 0) {
                    BooleanBigArrays.swap(x, c, d--);
                }
                --c;
            }
            if (b > c) break;
            BooleanBigArrays.swap(x, b++, c--);
        }
        long n = to2;
        long s3 = Math.min(a - from2, b - a);
        BooleanBigArrays.vecSwap(x, from2, b - s3, s3);
        s3 = Math.min(d - c, n - d - 1L);
        BooleanBigArrays.vecSwap(x, b, n - s3, s3);
        s3 = b - a;
        if (s3 > 1L) {
            BooleanBigArrays.quickSort(x, from2, from2 + s3, comp);
        }
        if ((s3 = d - c) > 1L) {
            BooleanBigArrays.quickSort(x, n - s3, n, comp);
        }
    }

    private static long med3(boolean[][] x, long a, long b, long c) {
        int ab = Boolean.compare(BooleanBigArrays.get(x, a), BooleanBigArrays.get(x, b));
        int ac = Boolean.compare(BooleanBigArrays.get(x, a), BooleanBigArrays.get(x, c));
        int bc = Boolean.compare(BooleanBigArrays.get(x, b), BooleanBigArrays.get(x, c));
        return ab < 0 ? (bc < 0 ? b : (ac < 0 ? c : a)) : (bc > 0 ? b : (ac > 0 ? c : a));
    }

    private static void selectionSort(boolean[][] a, long from2, long to2) {
        for (long i = from2; i < to2 - 1L; ++i) {
            long m3 = i;
            for (long j = i + 1L; j < to2; ++j) {
                if (BooleanBigArrays.get(a, j) || !BooleanBigArrays.get(a, m3)) continue;
                m3 = j;
            }
            if (m3 == i) continue;
            BooleanBigArrays.swap(a, i, m3);
        }
    }

    public static void quickSort(boolean[][] x, BooleanComparator comp) {
        BooleanBigArrays.quickSort(x, 0L, BooleanBigArrays.length(x), comp);
    }

    public static void quickSort(boolean[][] x, long from2, long to2) {
        long c;
        long a;
        long len = to2 - from2;
        if (len < 7L) {
            BooleanBigArrays.selectionSort(x, from2, to2);
            return;
        }
        long m3 = from2 + len / 2L;
        if (len > 7L) {
            long l = from2;
            long n = to2 - 1L;
            if (len > 40L) {
                long s2 = len / 8L;
                l = BooleanBigArrays.med3(x, l, l + s2, l + 2L * s2);
                m3 = BooleanBigArrays.med3(x, m3 - s2, m3, m3 + s2);
                n = BooleanBigArrays.med3(x, n - 2L * s2, n - s2, n);
            }
            m3 = BooleanBigArrays.med3(x, l, m3, n);
        }
        boolean v = BooleanBigArrays.get(x, m3);
        long b = a = from2;
        long d = c = to2 - 1L;
        while (true) {
            int comparison;
            if (b <= c && (comparison = Boolean.compare(BooleanBigArrays.get(x, b), v)) <= 0) {
                if (comparison == 0) {
                    BooleanBigArrays.swap(x, a++, b);
                }
                ++b;
                continue;
            }
            while (c >= b && (comparison = Boolean.compare(BooleanBigArrays.get(x, c), v)) >= 0) {
                if (comparison == 0) {
                    BooleanBigArrays.swap(x, c, d--);
                }
                --c;
            }
            if (b > c) break;
            BooleanBigArrays.swap(x, b++, c--);
        }
        long n = to2;
        long s3 = Math.min(a - from2, b - a);
        BooleanBigArrays.vecSwap(x, from2, b - s3, s3);
        s3 = Math.min(d - c, n - d - 1L);
        BooleanBigArrays.vecSwap(x, b, n - s3, s3);
        s3 = b - a;
        if (s3 > 1L) {
            BooleanBigArrays.quickSort(x, from2, from2 + s3);
        }
        if ((s3 = d - c) > 1L) {
            BooleanBigArrays.quickSort(x, n - s3, n);
        }
    }

    public static void quickSort(boolean[][] x) {
        BooleanBigArrays.quickSort(x, 0L, BooleanBigArrays.length(x));
    }

    public static boolean[][] shuffle(boolean[][] a, long from2, long to2, Random random) {
        long i = to2 - from2;
        while (i-- != 0L) {
            long p = (random.nextLong() & Long.MAX_VALUE) % (i + 1L);
            boolean t = BooleanBigArrays.get(a, from2 + i);
            BooleanBigArrays.set(a, from2 + i, BooleanBigArrays.get(a, from2 + p));
            BooleanBigArrays.set(a, from2 + p, t);
        }
        return a;
    }

    public static boolean[][] shuffle(boolean[][] a, Random random) {
        long i = BooleanBigArrays.length(a);
        while (i-- != 0L) {
            long p = (random.nextLong() & Long.MAX_VALUE) % (i + 1L);
            boolean t = BooleanBigArrays.get(a, i);
            BooleanBigArrays.set(a, i, BooleanBigArrays.get(a, p));
            BooleanBigArrays.set(a, p, t);
        }
        return a;
    }

    private static final class BigArrayHashStrategy
    implements Hash.Strategy<boolean[][]>,
    Serializable {
        private static final long serialVersionUID = -7046029254386353129L;

        private BigArrayHashStrategy() {
        }

        @Override
        public int hashCode(boolean[][] o) {
            return Arrays.deepHashCode((Object[])o);
        }

        @Override
        public boolean equals(boolean[][] a, boolean[][] b) {
            return BooleanBigArrays.equals(a, b);
        }
    }
}

