/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.bytes;

import it.unimi.dsi.fastutil.BigList;
import it.unimi.dsi.fastutil.BigListIterator;
import it.unimi.dsi.fastutil.bytes.AbstractByteCollection;
import it.unimi.dsi.fastutil.bytes.ByteBigArrays;
import it.unimi.dsi.fastutil.bytes.ByteBigList;
import it.unimi.dsi.fastutil.bytes.ByteBigListIterator;
import it.unimi.dsi.fastutil.bytes.ByteCollection;
import it.unimi.dsi.fastutil.bytes.ByteStack;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;

public abstract class AbstractByteBigList
extends AbstractByteCollection
implements ByteBigList,
ByteStack {
    protected AbstractByteBigList() {
    }

    protected void ensureIndex(long index2) {
        if (index2 < 0L) {
            throw new IndexOutOfBoundsException("Index (" + index2 + ") is negative");
        }
        if (index2 > this.size64()) {
            throw new IndexOutOfBoundsException("Index (" + index2 + ") is greater than list size (" + this.size64() + ")");
        }
    }

    protected void ensureRestrictedIndex(long index2) {
        if (index2 < 0L) {
            throw new IndexOutOfBoundsException("Index (" + index2 + ") is negative");
        }
        if (index2 >= this.size64()) {
            throw new IndexOutOfBoundsException("Index (" + index2 + ") is greater than or equal to list size (" + this.size64() + ")");
        }
    }

    @Override
    public void add(long index2, byte k) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean add(byte k) {
        this.add(this.size64(), k);
        return true;
    }

    @Override
    public byte removeByte(long i) {
        throw new UnsupportedOperationException();
    }

    @Override
    public byte set(long index2, byte k) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(long index2, Collection<? extends Byte> c) {
        this.ensureIndex(index2);
        Iterator<? extends Byte> i = c.iterator();
        boolean retVal = i.hasNext();
        while (i.hasNext()) {
            this.add(index2++, i.next());
        }
        return retVal;
    }

    @Override
    public boolean addAll(Collection<? extends Byte> c) {
        return this.addAll(this.size64(), c);
    }

    @Override
    public ByteBigListIterator iterator() {
        return this.listIterator();
    }

    @Override
    public ByteBigListIterator listIterator() {
        return this.listIterator(0L);
    }

    @Override
    public ByteBigListIterator listIterator(final long index2) {
        this.ensureIndex(index2);
        return new ByteBigListIterator(){
            long pos;
            long last;
            {
                this.pos = index2;
                this.last = -1L;
            }

            @Override
            public boolean hasNext() {
                return this.pos < AbstractByteBigList.this.size64();
            }

            @Override
            public boolean hasPrevious() {
                return this.pos > 0L;
            }

            @Override
            public byte nextByte() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.last = this.pos++;
                return AbstractByteBigList.this.getByte(this.last);
            }

            @Override
            public byte previousByte() {
                if (!this.hasPrevious()) {
                    throw new NoSuchElementException();
                }
                this.last = --this.pos;
                return AbstractByteBigList.this.getByte(this.pos);
            }

            @Override
            public long nextIndex() {
                return this.pos;
            }

            @Override
            public long previousIndex() {
                return this.pos - 1L;
            }

            @Override
            public void add(byte k) {
                AbstractByteBigList.this.add(this.pos++, k);
                this.last = -1L;
            }

            @Override
            public void set(byte k) {
                if (this.last == -1L) {
                    throw new IllegalStateException();
                }
                AbstractByteBigList.this.set(this.last, k);
            }

            @Override
            public void remove() {
                if (this.last == -1L) {
                    throw new IllegalStateException();
                }
                AbstractByteBigList.this.removeByte(this.last);
                if (this.last < this.pos) {
                    --this.pos;
                }
                this.last = -1L;
            }
        };
    }

    @Override
    public boolean contains(byte k) {
        return this.indexOf(k) >= 0L;
    }

    @Override
    public long indexOf(byte k) {
        ByteBigListIterator i = this.listIterator();
        while (i.hasNext()) {
            byte e = i.nextByte();
            if (k != e) continue;
            return i.previousIndex();
        }
        return -1L;
    }

    @Override
    public long lastIndexOf(byte k) {
        ByteBigListIterator i = this.listIterator(this.size64());
        while (i.hasPrevious()) {
            byte e = i.previousByte();
            if (k != e) continue;
            return i.nextIndex();
        }
        return -1L;
    }

    @Override
    public void size(long size2) {
        long i = this.size64();
        if (size2 > i) {
            while (i++ < size2) {
                this.add((byte)0);
            }
        } else {
            while (i-- != size2) {
                this.remove(i);
            }
        }
    }

    @Override
    public ByteBigList subList(long from2, long to2) {
        this.ensureIndex(from2);
        this.ensureIndex(to2);
        if (from2 > to2) {
            throw new IndexOutOfBoundsException("Start index (" + from2 + ") is greater than end index (" + to2 + ")");
        }
        return new ByteSubList(this, from2, to2);
    }

    @Override
    public void removeElements(long from2, long to2) {
        this.ensureIndex(to2);
        ByteBigListIterator i = this.listIterator(from2);
        long n = to2 - from2;
        if (n < 0L) {
            throw new IllegalArgumentException("Start index (" + from2 + ") is greater than end index (" + to2 + ")");
        }
        while (n-- != 0L) {
            i.nextByte();
            i.remove();
        }
    }

    @Override
    public void addElements(long index2, byte[][] a, long offset, long length) {
        this.ensureIndex(index2);
        ByteBigArrays.ensureOffsetLength(a, offset, length);
        while (length-- != 0L) {
            this.add(index2++, ByteBigArrays.get(a, offset++));
        }
    }

    @Override
    public void addElements(long index2, byte[][] a) {
        this.addElements(index2, a, 0L, ByteBigArrays.length(a));
    }

    @Override
    public void getElements(long from2, byte[][] a, long offset, long length) {
        ByteBigListIterator i = this.listIterator(from2);
        ByteBigArrays.ensureOffsetLength(a, offset, length);
        if (from2 + length > this.size64()) {
            throw new IndexOutOfBoundsException("End index (" + (from2 + length) + ") is greater than list size (" + this.size64() + ")");
        }
        while (length-- != 0L) {
            ByteBigArrays.set(a, offset++, i.nextByte());
        }
    }

    @Override
    public void clear() {
        this.removeElements(0L, this.size64());
    }

    @Override
    @Deprecated
    public int size() {
        return (int)Math.min(Integer.MAX_VALUE, this.size64());
    }

    private boolean valEquals(Object a, Object b) {
        return a == null ? b == null : a.equals(b);
    }

    @Override
    public int hashCode() {
        ByteBigListIterator i = this.iterator();
        int h2 = 1;
        long s2 = this.size64();
        while (s2-- != 0L) {
            byte k = i.nextByte();
            h2 = 31 * h2 + k;
        }
        return h2;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BigList)) {
            return false;
        }
        BigList l = (BigList)o;
        long s2 = this.size64();
        if (s2 != l.size64()) {
            return false;
        }
        if (l instanceof ByteBigList) {
            ByteBigListIterator i1 = this.listIterator();
            ByteBigListIterator i2 = ((ByteBigList)l).listIterator();
            while (s2-- != 0L) {
                if (i1.nextByte() == i2.nextByte()) continue;
                return false;
            }
            return true;
        }
        ByteBigListIterator i1 = this.listIterator();
        BigListIterator i2 = l.listIterator();
        while (s2-- != 0L) {
            if (this.valEquals(i1.next(), i2.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    public int compareTo(BigList<? extends Byte> l) {
        if (l == this) {
            return 0;
        }
        if (l instanceof ByteBigList) {
            ByteBigListIterator i1 = this.listIterator();
            ByteBigListIterator i2 = ((ByteBigList)l).listIterator();
            while (i1.hasNext() && i2.hasNext()) {
                byte e2;
                byte e1 = i1.nextByte();
                int r2 = Byte.compare(e1, e2 = i2.nextByte());
                if (r2 == 0) continue;
                return r2;
            }
            return i2.hasNext() ? -1 : (i1.hasNext() ? 1 : 0);
        }
        ByteBigListIterator i1 = this.listIterator();
        BigListIterator<? extends Byte> i2 = l.listIterator();
        while (i1.hasNext() && i2.hasNext()) {
            int r3 = ((Comparable)i1.next()).compareTo(i2.next());
            if (r3 == 0) continue;
            return r3;
        }
        return i2.hasNext() ? -1 : (i1.hasNext() ? 1 : 0);
    }

    @Override
    public void push(byte o) {
        this.add(o);
    }

    @Override
    public byte popByte() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.removeByte(this.size64() - 1L);
    }

    @Override
    public byte topByte() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.getByte(this.size64() - 1L);
    }

    @Override
    public byte peekByte(int i) {
        return this.getByte(this.size64() - 1L - (long)i);
    }

    @Override
    public boolean rem(byte k) {
        long index2 = this.indexOf(k);
        if (index2 == -1L) {
            return false;
        }
        this.removeByte(index2);
        return true;
    }

    @Override
    public boolean addAll(long index2, ByteCollection c) {
        return this.addAll(index2, (Collection<? extends Byte>)c);
    }

    @Override
    public boolean addAll(long index2, ByteBigList l) {
        return this.addAll(index2, (ByteCollection)l);
    }

    @Override
    public boolean addAll(ByteCollection c) {
        return this.addAll(this.size64(), c);
    }

    @Override
    public boolean addAll(ByteBigList l) {
        return this.addAll(this.size64(), l);
    }

    @Override
    @Deprecated
    public void add(long index2, Byte ok) {
        this.add(index2, (byte)ok);
    }

    @Override
    @Deprecated
    public Byte set(long index2, Byte ok) {
        return this.set(index2, (byte)ok);
    }

    @Override
    @Deprecated
    public Byte get(long index2) {
        return this.getByte(index2);
    }

    @Override
    @Deprecated
    public long indexOf(Object ok) {
        return this.indexOf((Byte)ok);
    }

    @Override
    @Deprecated
    public long lastIndexOf(Object ok) {
        return this.lastIndexOf((Byte)ok);
    }

    @Override
    @Deprecated
    public Byte remove(long index2) {
        return this.removeByte(index2);
    }

    @Override
    @Deprecated
    public void push(Byte o) {
        this.push((byte)o);
    }

    @Override
    @Deprecated
    public Byte pop() {
        return this.popByte();
    }

    @Override
    @Deprecated
    public Byte top() {
        return this.topByte();
    }

    @Override
    @Deprecated
    public Byte peek(int i) {
        return this.peekByte(i);
    }

    @Override
    public String toString() {
        StringBuilder s2 = new StringBuilder();
        ByteBigListIterator i = this.iterator();
        long n = this.size64();
        boolean first2 = true;
        s2.append("[");
        while (n-- != 0L) {
            if (first2) {
                first2 = false;
            } else {
                s2.append(", ");
            }
            byte k = i.nextByte();
            s2.append(String.valueOf(k));
        }
        s2.append("]");
        return s2.toString();
    }

    public static class ByteSubList
    extends AbstractByteBigList
    implements Serializable {
        private static final long serialVersionUID = -7046029254386353129L;
        protected final ByteBigList l;
        protected final long from;
        protected long to;

        public ByteSubList(ByteBigList l, long from2, long to2) {
            this.l = l;
            this.from = from2;
            this.to = to2;
        }

        private boolean assertRange() {
            assert (this.from <= this.l.size64());
            assert (this.to <= this.l.size64());
            assert (this.to >= this.from);
            return true;
        }

        @Override
        public boolean add(byte k) {
            this.l.add(this.to, k);
            ++this.to;
            assert (this.assertRange());
            return true;
        }

        @Override
        public void add(long index2, byte k) {
            this.ensureIndex(index2);
            this.l.add(this.from + index2, k);
            ++this.to;
            assert (this.assertRange());
        }

        @Override
        public boolean addAll(long index2, Collection<? extends Byte> c) {
            this.ensureIndex(index2);
            this.to += (long)c.size();
            return this.l.addAll(this.from + index2, c);
        }

        @Override
        public byte getByte(long index2) {
            this.ensureRestrictedIndex(index2);
            return this.l.getByte(this.from + index2);
        }

        @Override
        public byte removeByte(long index2) {
            this.ensureRestrictedIndex(index2);
            --this.to;
            return this.l.removeByte(this.from + index2);
        }

        @Override
        public byte set(long index2, byte k) {
            this.ensureRestrictedIndex(index2);
            return this.l.set(this.from + index2, k);
        }

        @Override
        public long size64() {
            return this.to - this.from;
        }

        @Override
        public void getElements(long from2, byte[][] a, long offset, long length) {
            this.ensureIndex(from2);
            if (from2 + length > this.size64()) {
                throw new IndexOutOfBoundsException("End index (" + from2 + length + ") is greater than list size (" + this.size64() + ")");
            }
            this.l.getElements(this.from + from2, a, offset, length);
        }

        @Override
        public void removeElements(long from2, long to2) {
            this.ensureIndex(from2);
            this.ensureIndex(to2);
            this.l.removeElements(this.from + from2, this.from + to2);
            this.to -= to2 - from2;
            assert (this.assertRange());
        }

        @Override
        public void addElements(long index2, byte[][] a, long offset, long length) {
            this.ensureIndex(index2);
            this.l.addElements(this.from + index2, a, offset, length);
            this.to += length;
            assert (this.assertRange());
        }

        @Override
        public ByteBigListIterator listIterator(final long index2) {
            this.ensureIndex(index2);
            return new ByteBigListIterator(){
                long pos;
                long last;
                {
                    this.pos = index2;
                    this.last = -1L;
                }

                @Override
                public boolean hasNext() {
                    return this.pos < this.size64();
                }

                @Override
                public boolean hasPrevious() {
                    return this.pos > 0L;
                }

                @Override
                public byte nextByte() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    this.last = this.pos++;
                    return l.getByte(from + this.last);
                }

                @Override
                public byte previousByte() {
                    if (!this.hasPrevious()) {
                        throw new NoSuchElementException();
                    }
                    this.last = --this.pos;
                    return l.getByte(from + this.pos);
                }

                @Override
                public long nextIndex() {
                    return this.pos;
                }

                @Override
                public long previousIndex() {
                    return this.pos - 1L;
                }

                @Override
                public void add(byte k) {
                    if (this.last == -1L) {
                        throw new IllegalStateException();
                    }
                    this.add(this.pos++, k);
                    this.last = -1L;
                    assert (this.assertRange());
                }

                @Override
                public void set(byte k) {
                    if (this.last == -1L) {
                        throw new IllegalStateException();
                    }
                    this.set(this.last, k);
                }

                @Override
                public void remove() {
                    if (this.last == -1L) {
                        throw new IllegalStateException();
                    }
                    this.removeByte(this.last);
                    if (this.last < this.pos) {
                        --this.pos;
                    }
                    this.last = -1L;
                    assert (this.assertRange());
                }
            };
        }

        @Override
        public ByteBigList subList(long from2, long to2) {
            this.ensureIndex(from2);
            this.ensureIndex(to2);
            if (from2 > to2) {
                throw new IllegalArgumentException("Start index (" + from2 + ") is greater than end index (" + to2 + ")");
            }
            return new ByteSubList(this, from2, to2);
        }

        @Override
        public boolean rem(byte k) {
            long index2 = this.indexOf(k);
            if (index2 == -1L) {
                return false;
            }
            --this.to;
            this.l.removeByte(this.from + index2);
            assert (this.assertRange());
            return true;
        }

        @Override
        public boolean addAll(long index2, ByteCollection c) {
            this.ensureIndex(index2);
            return super.addAll(index2, c);
        }

        @Override
        public boolean addAll(long index2, ByteBigList l) {
            this.ensureIndex(index2);
            return super.addAll(index2, l);
        }
    }
}

