/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.chars;

import it.unimi.dsi.fastutil.chars.AbstractChar2ShortFunction;
import it.unimi.dsi.fastutil.chars.AbstractCharSet;
import it.unimi.dsi.fastutil.chars.Char2ShortMap;
import it.unimi.dsi.fastutil.chars.Char2ShortMaps;
import it.unimi.dsi.fastutil.chars.CharIterator;
import it.unimi.dsi.fastutil.chars.CharSet;
import it.unimi.dsi.fastutil.objects.AbstractObjectSet;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.shorts.AbstractShortCollection;
import it.unimi.dsi.fastutil.shorts.ShortCollection;
import it.unimi.dsi.fastutil.shorts.ShortIterator;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;

public abstract class AbstractChar2ShortMap
extends AbstractChar2ShortFunction
implements Char2ShortMap,
Serializable {
    private static final long serialVersionUID = -4940583368468432370L;

    protected AbstractChar2ShortMap() {
    }

    @Override
    public boolean containsValue(short v) {
        return this.values().contains(v);
    }

    @Override
    public boolean containsKey(char k) {
        Iterator i = this.char2ShortEntrySet().iterator();
        while (i.hasNext()) {
            if (((Char2ShortMap.Entry)i.next()).getCharKey() != k) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public CharSet keySet() {
        return new AbstractCharSet(){

            @Override
            public boolean contains(char k) {
                return AbstractChar2ShortMap.this.containsKey(k);
            }

            @Override
            public int size() {
                return AbstractChar2ShortMap.this.size();
            }

            @Override
            public void clear() {
                AbstractChar2ShortMap.this.clear();
            }

            @Override
            public CharIterator iterator() {
                return new CharIterator(){
                    private final ObjectIterator<Char2ShortMap.Entry> i;
                    {
                        this.i = Char2ShortMaps.fastIterator(AbstractChar2ShortMap.this);
                    }

                    @Override
                    public char nextChar() {
                        return ((Char2ShortMap.Entry)this.i.next()).getCharKey();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.i.hasNext();
                    }

                    @Override
                    public void remove() {
                        this.i.remove();
                    }
                };
            }
        };
    }

    @Override
    public ShortCollection values() {
        return new AbstractShortCollection(){

            @Override
            public boolean contains(short k) {
                return AbstractChar2ShortMap.this.containsValue(k);
            }

            @Override
            public int size() {
                return AbstractChar2ShortMap.this.size();
            }

            @Override
            public void clear() {
                AbstractChar2ShortMap.this.clear();
            }

            @Override
            public ShortIterator iterator() {
                return new ShortIterator(){
                    private final ObjectIterator<Char2ShortMap.Entry> i;
                    {
                        this.i = Char2ShortMaps.fastIterator(AbstractChar2ShortMap.this);
                    }

                    @Override
                    public short nextShort() {
                        return ((Char2ShortMap.Entry)this.i.next()).getShortValue();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.i.hasNext();
                    }
                };
            }
        };
    }

    @Override
    public void putAll(Map<? extends Character, ? extends Short> m3) {
        if (m3 instanceof Char2ShortMap) {
            ObjectIterator<Char2ShortMap.Entry> i = Char2ShortMaps.fastIterator((Char2ShortMap)m3);
            while (i.hasNext()) {
                Char2ShortMap.Entry e = (Char2ShortMap.Entry)i.next();
                this.put(e.getCharKey(), e.getShortValue());
            }
        } else {
            int n = m3.size();
            Iterator<Map.Entry<? extends Character, ? extends Short>> i = m3.entrySet().iterator();
            while (n-- != 0) {
                Map.Entry<? extends Character, ? extends Short> e = i.next();
                this.put(e.getKey(), e.getValue());
            }
        }
    }

    @Override
    public int hashCode() {
        int h2 = 0;
        int n = this.size();
        ObjectIterator<Char2ShortMap.Entry> i = Char2ShortMaps.fastIterator(this);
        while (n-- != 0) {
            h2 += ((Char2ShortMap.Entry)i.next()).hashCode();
        }
        return h2;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Map)) {
            return false;
        }
        Map m3 = (Map)o;
        if (m3.size() != this.size()) {
            return false;
        }
        return this.char2ShortEntrySet().containsAll(m3.entrySet());
    }

    public String toString() {
        StringBuilder s2 = new StringBuilder();
        ObjectIterator<Char2ShortMap.Entry> i = Char2ShortMaps.fastIterator(this);
        int n = this.size();
        boolean first2 = true;
        s2.append("{");
        while (n-- != 0) {
            if (first2) {
                first2 = false;
            } else {
                s2.append(", ");
            }
            Char2ShortMap.Entry e = (Char2ShortMap.Entry)i.next();
            s2.append(String.valueOf(e.getCharKey()));
            s2.append("=>");
            s2.append(String.valueOf(e.getShortValue()));
        }
        s2.append("}");
        return s2.toString();
    }

    public static abstract class BasicEntrySet
    extends AbstractObjectSet<Char2ShortMap.Entry> {
        protected final Char2ShortMap map;

        public BasicEntrySet(Char2ShortMap map23) {
            this.map = map23;
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            if (o instanceof Char2ShortMap.Entry) {
                Char2ShortMap.Entry e = (Char2ShortMap.Entry)o;
                char k = e.getCharKey();
                return this.map.containsKey(k) && this.map.get(k) == e.getShortValue();
            }
            Map.Entry e = (Map.Entry)o;
            Object key = e.getKey();
            if (key == null || !(key instanceof Character)) {
                return false;
            }
            char k = ((Character)key).charValue();
            Object value2 = e.getValue();
            if (value2 == null || !(value2 instanceof Short)) {
                return false;
            }
            return this.map.containsKey(k) && this.map.get(k) == ((Short)value2).shortValue();
        }

        @Override
        public boolean remove(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            if (o instanceof Char2ShortMap.Entry) {
                Char2ShortMap.Entry e = (Char2ShortMap.Entry)o;
                return this.map.remove(e.getCharKey(), e.getShortValue());
            }
            Map.Entry e = (Map.Entry)o;
            Object key = e.getKey();
            if (key == null || !(key instanceof Character)) {
                return false;
            }
            char k = ((Character)key).charValue();
            Object value2 = e.getValue();
            if (value2 == null || !(value2 instanceof Short)) {
                return false;
            }
            short v = (Short)value2;
            return this.map.remove(k, v);
        }

        @Override
        public int size() {
            return this.map.size();
        }
    }

    public static class BasicEntry
    implements Char2ShortMap.Entry {
        protected char key;
        protected short value;

        public BasicEntry() {
        }

        public BasicEntry(Character key, Short value2) {
            this.key = key.charValue();
            this.value = value2;
        }

        public BasicEntry(char key, short value2) {
            this.key = key;
            this.value = value2;
        }

        @Override
        public char getCharKey() {
            return this.key;
        }

        @Override
        public short getShortValue() {
            return this.value;
        }

        @Override
        public short setValue(short value2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            if (o instanceof Char2ShortMap.Entry) {
                Char2ShortMap.Entry e = (Char2ShortMap.Entry)o;
                return this.key == e.getCharKey() && this.value == e.getShortValue();
            }
            Map.Entry e = (Map.Entry)o;
            Object key = e.getKey();
            if (key == null || !(key instanceof Character)) {
                return false;
            }
            Object value2 = e.getValue();
            if (value2 == null || !(value2 instanceof Short)) {
                return false;
            }
            return this.key == ((Character)key).charValue() && this.value == (Short)value2;
        }

        @Override
        public int hashCode() {
            return this.key ^ this.value;
        }

        public String toString() {
            return this.key + "->" + this.value;
        }
    }
}

