/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.chars;

import it.unimi.dsi.fastutil.chars.AbstractChar2ObjectMap;
import it.unimi.dsi.fastutil.chars.Char2ObjectMap;
import it.unimi.dsi.fastutil.chars.Char2ObjectMaps;
import it.unimi.dsi.fastutil.chars.Char2ObjectSortedMap;
import it.unimi.dsi.fastutil.chars.CharComparator;
import it.unimi.dsi.fastutil.chars.CharSortedSet;
import it.unimi.dsi.fastutil.chars.CharSortedSets;
import it.unimi.dsi.fastutil.objects.ObjectBidirectionalIterable;
import it.unimi.dsi.fastutil.objects.ObjectBidirectionalIterator;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import it.unimi.dsi.fastutil.objects.ObjectSortedSet;
import it.unimi.dsi.fastutil.objects.ObjectSortedSets;
import java.io.Serializable;
import java.util.Comparator;
import java.util.Map;
import java.util.NoSuchElementException;

public final class Char2ObjectSortedMaps {
    public static final EmptySortedMap EMPTY_MAP = new EmptySortedMap();

    private Char2ObjectSortedMaps() {
    }

    public static Comparator<? super Map.Entry<Character, ?>> entryComparator(CharComparator comparator) {
        return (x, y) -> comparator.compare(((Character)x.getKey()).charValue(), ((Character)y.getKey()).charValue());
    }

    public static <V> ObjectBidirectionalIterator<Char2ObjectMap.Entry<V>> fastIterator(Char2ObjectSortedMap<V> map23) {
        ObjectSet entries = map23.char2ObjectEntrySet();
        return entries instanceof Char2ObjectSortedMap.FastSortedEntrySet ? ((Char2ObjectSortedMap.FastSortedEntrySet)entries).fastIterator() : entries.iterator();
    }

    public static <V> ObjectBidirectionalIterable<Char2ObjectMap.Entry<V>> fastIterable(Char2ObjectSortedMap<V> map23) {
        ObjectSet entries = map23.char2ObjectEntrySet();
        return entries instanceof Char2ObjectSortedMap.FastSortedEntrySet ? ((Char2ObjectSortedMap.FastSortedEntrySet)entries)::fastIterator : entries;
    }

    public static <V> Char2ObjectSortedMap<V> emptyMap() {
        return EMPTY_MAP;
    }

    public static <V> Char2ObjectSortedMap<V> singleton(Character key, V value2) {
        return new Singleton<V>(key.charValue(), value2);
    }

    public static <V> Char2ObjectSortedMap<V> singleton(Character key, V value2, CharComparator comparator) {
        return new Singleton<V>(key.charValue(), value2, comparator);
    }

    public static <V> Char2ObjectSortedMap<V> singleton(char key, V value2) {
        return new Singleton<V>(key, value2);
    }

    public static <V> Char2ObjectSortedMap<V> singleton(char key, V value2, CharComparator comparator) {
        return new Singleton<V>(key, value2, comparator);
    }

    public static <V> Char2ObjectSortedMap<V> synchronize(Char2ObjectSortedMap<V> m3) {
        return new SynchronizedSortedMap<V>(m3);
    }

    public static <V> Char2ObjectSortedMap<V> synchronize(Char2ObjectSortedMap<V> m3, Object sync) {
        return new SynchronizedSortedMap<V>(m3, sync);
    }

    public static <V> Char2ObjectSortedMap<V> unmodifiable(Char2ObjectSortedMap<V> m3) {
        return new UnmodifiableSortedMap<V>(m3);
    }

    public static class UnmodifiableSortedMap<V>
    extends Char2ObjectMaps.UnmodifiableMap<V>
    implements Char2ObjectSortedMap<V>,
    Serializable {
        private static final long serialVersionUID = -7046029254386353129L;
        protected final Char2ObjectSortedMap<V> sortedMap;

        protected UnmodifiableSortedMap(Char2ObjectSortedMap<V> m3) {
            super(m3);
            this.sortedMap = m3;
        }

        @Override
        public CharComparator comparator() {
            return this.sortedMap.comparator();
        }

        @Override
        public ObjectSortedSet<Char2ObjectMap.Entry<V>> char2ObjectEntrySet() {
            if (this.entries == null) {
                this.entries = ObjectSortedSets.unmodifiable(this.sortedMap.char2ObjectEntrySet());
            }
            return (ObjectSortedSet)this.entries;
        }

        @Override
        @Deprecated
        public ObjectSortedSet<Map.Entry<Character, V>> entrySet() {
            return this.char2ObjectEntrySet();
        }

        @Override
        public CharSortedSet keySet() {
            if (this.keys == null) {
                this.keys = CharSortedSets.unmodifiable(this.sortedMap.keySet());
            }
            return (CharSortedSet)this.keys;
        }

        @Override
        public Char2ObjectSortedMap<V> subMap(char from2, char to2) {
            return new UnmodifiableSortedMap<V>(this.sortedMap.subMap(from2, to2));
        }

        @Override
        public Char2ObjectSortedMap<V> headMap(char to2) {
            return new UnmodifiableSortedMap<V>(this.sortedMap.headMap(to2));
        }

        @Override
        public Char2ObjectSortedMap<V> tailMap(char from2) {
            return new UnmodifiableSortedMap<V>(this.sortedMap.tailMap(from2));
        }

        @Override
        public char firstCharKey() {
            return this.sortedMap.firstCharKey();
        }

        @Override
        public char lastCharKey() {
            return this.sortedMap.lastCharKey();
        }

        @Override
        @Deprecated
        public Character firstKey() {
            return this.sortedMap.firstKey();
        }

        @Override
        @Deprecated
        public Character lastKey() {
            return this.sortedMap.lastKey();
        }

        @Override
        @Deprecated
        public Char2ObjectSortedMap<V> subMap(Character from2, Character to2) {
            return new UnmodifiableSortedMap<V>(this.sortedMap.subMap(from2, to2));
        }

        @Override
        @Deprecated
        public Char2ObjectSortedMap<V> headMap(Character to2) {
            return new UnmodifiableSortedMap<V>(this.sortedMap.headMap(to2));
        }

        @Override
        @Deprecated
        public Char2ObjectSortedMap<V> tailMap(Character from2) {
            return new UnmodifiableSortedMap<V>(this.sortedMap.tailMap(from2));
        }
    }

    public static class SynchronizedSortedMap<V>
    extends Char2ObjectMaps.SynchronizedMap<V>
    implements Char2ObjectSortedMap<V>,
    Serializable {
        private static final long serialVersionUID = -7046029254386353129L;
        protected final Char2ObjectSortedMap<V> sortedMap;

        protected SynchronizedSortedMap(Char2ObjectSortedMap<V> m3, Object sync) {
            super(m3, sync);
            this.sortedMap = m3;
        }

        protected SynchronizedSortedMap(Char2ObjectSortedMap<V> m3) {
            super(m3);
            this.sortedMap = m3;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public CharComparator comparator() {
            Object object = this.sync;
            synchronized (object) {
                return this.sortedMap.comparator();
            }
        }

        @Override
        public ObjectSortedSet<Char2ObjectMap.Entry<V>> char2ObjectEntrySet() {
            if (this.entries == null) {
                this.entries = ObjectSortedSets.synchronize(this.sortedMap.char2ObjectEntrySet(), this.sync);
            }
            return (ObjectSortedSet)this.entries;
        }

        @Override
        @Deprecated
        public ObjectSortedSet<Map.Entry<Character, V>> entrySet() {
            return this.char2ObjectEntrySet();
        }

        @Override
        public CharSortedSet keySet() {
            if (this.keys == null) {
                this.keys = CharSortedSets.synchronize(this.sortedMap.keySet(), this.sync);
            }
            return (CharSortedSet)this.keys;
        }

        @Override
        public Char2ObjectSortedMap<V> subMap(char from2, char to2) {
            return new SynchronizedSortedMap<V>(this.sortedMap.subMap(from2, to2), this.sync);
        }

        @Override
        public Char2ObjectSortedMap<V> headMap(char to2) {
            return new SynchronizedSortedMap<V>(this.sortedMap.headMap(to2), this.sync);
        }

        @Override
        public Char2ObjectSortedMap<V> tailMap(char from2) {
            return new SynchronizedSortedMap<V>(this.sortedMap.tailMap(from2), this.sync);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public char firstCharKey() {
            Object object = this.sync;
            synchronized (object) {
                return this.sortedMap.firstCharKey();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public char lastCharKey() {
            Object object = this.sync;
            synchronized (object) {
                return this.sortedMap.lastCharKey();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Deprecated
        public Character firstKey() {
            Object object = this.sync;
            synchronized (object) {
                return this.sortedMap.firstKey();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Deprecated
        public Character lastKey() {
            Object object = this.sync;
            synchronized (object) {
                return this.sortedMap.lastKey();
            }
        }

        @Override
        @Deprecated
        public Char2ObjectSortedMap<V> subMap(Character from2, Character to2) {
            return new SynchronizedSortedMap<V>(this.sortedMap.subMap(from2, to2), this.sync);
        }

        @Override
        @Deprecated
        public Char2ObjectSortedMap<V> headMap(Character to2) {
            return new SynchronizedSortedMap<V>(this.sortedMap.headMap(to2), this.sync);
        }

        @Override
        @Deprecated
        public Char2ObjectSortedMap<V> tailMap(Character from2) {
            return new SynchronizedSortedMap<V>(this.sortedMap.tailMap(from2), this.sync);
        }
    }

    public static class Singleton<V>
    extends Char2ObjectMaps.Singleton<V>
    implements Char2ObjectSortedMap<V>,
    Serializable,
    Cloneable {
        private static final long serialVersionUID = -7046029254386353129L;
        protected final CharComparator comparator;

        protected Singleton(char key, V value2, CharComparator comparator) {
            super(key, value2);
            this.comparator = comparator;
        }

        protected Singleton(char key, V value2) {
            this(key, value2, null);
        }

        final int compare(char k1, char k2) {
            return this.comparator == null ? Character.compare(k1, k2) : this.comparator.compare(k1, k2);
        }

        @Override
        public CharComparator comparator() {
            return this.comparator;
        }

        @Override
        public ObjectSortedSet<Char2ObjectMap.Entry<V>> char2ObjectEntrySet() {
            if (this.entries == null) {
                this.entries = ObjectSortedSets.singleton(new AbstractChar2ObjectMap.BasicEntry<Object>(this.key, this.value), Char2ObjectSortedMaps.entryComparator(this.comparator));
            }
            return (ObjectSortedSet)this.entries;
        }

        @Override
        @Deprecated
        public ObjectSortedSet<Map.Entry<Character, V>> entrySet() {
            return this.char2ObjectEntrySet();
        }

        @Override
        public CharSortedSet keySet() {
            if (this.keys == null) {
                this.keys = CharSortedSets.singleton(this.key, this.comparator);
            }
            return (CharSortedSet)this.keys;
        }

        @Override
        public Char2ObjectSortedMap<V> subMap(char from2, char to2) {
            if (this.compare(from2, this.key) <= 0 && this.compare(this.key, to2) < 0) {
                return this;
            }
            return EMPTY_MAP;
        }

        @Override
        public Char2ObjectSortedMap<V> headMap(char to2) {
            if (this.compare(this.key, to2) < 0) {
                return this;
            }
            return EMPTY_MAP;
        }

        @Override
        public Char2ObjectSortedMap<V> tailMap(char from2) {
            if (this.compare(from2, this.key) <= 0) {
                return this;
            }
            return EMPTY_MAP;
        }

        @Override
        public char firstCharKey() {
            return this.key;
        }

        @Override
        public char lastCharKey() {
            return this.key;
        }

        @Override
        @Deprecated
        public Char2ObjectSortedMap<V> headMap(Character oto) {
            return this.headMap(oto.charValue());
        }

        @Override
        @Deprecated
        public Char2ObjectSortedMap<V> tailMap(Character ofrom) {
            return this.tailMap(ofrom.charValue());
        }

        @Override
        @Deprecated
        public Char2ObjectSortedMap<V> subMap(Character ofrom, Character oto) {
            return this.subMap(ofrom.charValue(), oto.charValue());
        }

        @Override
        @Deprecated
        public Character firstKey() {
            return Character.valueOf(this.firstCharKey());
        }

        @Override
        @Deprecated
        public Character lastKey() {
            return Character.valueOf(this.lastCharKey());
        }
    }

    public static class EmptySortedMap<V>
    extends Char2ObjectMaps.EmptyMap<V>
    implements Char2ObjectSortedMap<V>,
    Serializable,
    Cloneable {
        private static final long serialVersionUID = -7046029254386353129L;

        protected EmptySortedMap() {
        }

        @Override
        public CharComparator comparator() {
            return null;
        }

        @Override
        public ObjectSortedSet<Char2ObjectMap.Entry<V>> char2ObjectEntrySet() {
            return ObjectSortedSets.EMPTY_SET;
        }

        @Override
        @Deprecated
        public ObjectSortedSet<Map.Entry<Character, V>> entrySet() {
            return ObjectSortedSets.EMPTY_SET;
        }

        @Override
        public CharSortedSet keySet() {
            return CharSortedSets.EMPTY_SET;
        }

        @Override
        public Char2ObjectSortedMap<V> subMap(char from2, char to2) {
            return EMPTY_MAP;
        }

        @Override
        public Char2ObjectSortedMap<V> headMap(char to2) {
            return EMPTY_MAP;
        }

        @Override
        public Char2ObjectSortedMap<V> tailMap(char from2) {
            return EMPTY_MAP;
        }

        @Override
        public char firstCharKey() {
            throw new NoSuchElementException();
        }

        @Override
        public char lastCharKey() {
            throw new NoSuchElementException();
        }

        @Override
        @Deprecated
        public Char2ObjectSortedMap<V> headMap(Character oto) {
            return this.headMap(oto.charValue());
        }

        @Override
        @Deprecated
        public Char2ObjectSortedMap<V> tailMap(Character ofrom) {
            return this.tailMap(ofrom.charValue());
        }

        @Override
        @Deprecated
        public Char2ObjectSortedMap<V> subMap(Character ofrom, Character oto) {
            return this.subMap(ofrom.charValue(), oto.charValue());
        }

        @Override
        @Deprecated
        public Character firstKey() {
            return Character.valueOf(this.firstCharKey());
        }

        @Override
        @Deprecated
        public Character lastKey() {
            return Character.valueOf(this.lastCharKey());
        }
    }
}

