/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.chars;

import it.unimi.dsi.fastutil.Arrays;
import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.chars.CharComparator;
import it.unimi.dsi.fastutil.ints.IntArrays;
import java.io.Serializable;
import java.util.Random;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RecursiveAction;
import java.util.concurrent.atomic.AtomicInteger;

public final class CharArrays {
    public static final char[] EMPTY_ARRAY = new char[0];
    private static final int QUICKSORT_NO_REC = 16;
    private static final int PARALLEL_QUICKSORT_NO_FORK = 8192;
    private static final int QUICKSORT_MEDIAN_OF_9 = 128;
    private static final int MERGESORT_NO_REC = 16;
    private static final int DIGIT_BITS = 8;
    private static final int DIGIT_MASK = 255;
    private static final int DIGITS_PER_ELEMENT = 2;
    private static final int RADIXSORT_NO_REC = 1024;
    private static final int PARALLEL_RADIXSORT_NO_FORK = 1024;
    protected static final Segment POISON_PILL = new Segment(-1, -1, -1);
    public static final Hash.Strategy<char[]> HASH_STRATEGY = new ArrayHashStrategy();

    private CharArrays() {
    }

    public static char[] ensureCapacity(char[] array2, int length) {
        if (length > array2.length) {
            char[] t = new char[length];
            System.arraycopy(array2, 0, t, 0, array2.length);
            return t;
        }
        return array2;
    }

    public static char[] ensureCapacity(char[] array2, int length, int preserve) {
        if (length > array2.length) {
            char[] t = new char[length];
            System.arraycopy(array2, 0, t, 0, preserve);
            return t;
        }
        return array2;
    }

    public static char[] grow(char[] array2, int length) {
        if (length > array2.length) {
            int newLength = (int)Math.max(Math.min(2L * (long)array2.length, 0x7FFFFFF7L), (long)length);
            char[] t = new char[newLength];
            System.arraycopy(array2, 0, t, 0, array2.length);
            return t;
        }
        return array2;
    }

    public static char[] grow(char[] array2, int length, int preserve) {
        if (length > array2.length) {
            int newLength = (int)Math.max(Math.min(2L * (long)array2.length, 0x7FFFFFF7L), (long)length);
            char[] t = new char[newLength];
            System.arraycopy(array2, 0, t, 0, preserve);
            return t;
        }
        return array2;
    }

    public static char[] trim(char[] array2, int length) {
        if (length >= array2.length) {
            return array2;
        }
        char[] t = length == 0 ? EMPTY_ARRAY : new char[length];
        System.arraycopy(array2, 0, t, 0, length);
        return t;
    }

    public static char[] setLength(char[] array2, int length) {
        if (length == array2.length) {
            return array2;
        }
        if (length < array2.length) {
            return CharArrays.trim(array2, length);
        }
        return CharArrays.ensureCapacity(array2, length);
    }

    public static char[] copy(char[] array2, int offset, int length) {
        CharArrays.ensureOffsetLength(array2, offset, length);
        char[] a = length == 0 ? EMPTY_ARRAY : new char[length];
        System.arraycopy(array2, offset, a, 0, length);
        return a;
    }

    public static char[] copy(char[] array2) {
        return (char[])array2.clone();
    }

    @Deprecated
    public static void fill(char[] array2, char value2) {
        int i = array2.length;
        while (i-- != 0) {
            array2[i] = value2;
        }
    }

    @Deprecated
    public static void fill(char[] array2, int from2, int to2, char value2) {
        CharArrays.ensureFromTo(array2, from2, to2);
        if (from2 == 0) {
            while (to2-- != 0) {
                array2[to2] = value2;
            }
        } else {
            for (int i = from2; i < to2; ++i) {
                array2[i] = value2;
            }
        }
    }

    @Deprecated
    public static boolean equals(char[] a1, char[] a2) {
        int i = a1.length;
        if (i != a2.length) {
            return false;
        }
        while (i-- != 0) {
            if (a1[i] == a2[i]) continue;
            return false;
        }
        return true;
    }

    public static void ensureFromTo(char[] a, int from2, int to2) {
        Arrays.ensureFromTo(a.length, from2, to2);
    }

    public static void ensureOffsetLength(char[] a, int offset, int length) {
        Arrays.ensureOffsetLength(a.length, offset, length);
    }

    public static void ensureSameLength(char[] a, char[] b) {
        if (a.length != b.length) {
            throw new IllegalArgumentException("Array size mismatch: " + a.length + " != " + b.length);
        }
    }

    public static void swap(char[] x, int a, int b) {
        char t = x[a];
        x[a] = x[b];
        x[b] = t;
    }

    public static void swap(char[] x, int a, int b, int n) {
        int i = 0;
        while (i < n) {
            CharArrays.swap(x, a, b);
            ++i;
            ++a;
            ++b;
        }
    }

    private static int med3(char[] x, int a, int b, int c, CharComparator comp) {
        int ab = comp.compare(x[a], x[b]);
        int ac = comp.compare(x[a], x[c]);
        int bc = comp.compare(x[b], x[c]);
        return ab < 0 ? (bc < 0 ? b : (ac < 0 ? c : a)) : (bc > 0 ? b : (ac > 0 ? c : a));
    }

    private static void selectionSort(char[] a, int from2, int to2, CharComparator comp) {
        for (int i = from2; i < to2 - 1; ++i) {
            int m3 = i;
            for (int j = i + 1; j < to2; ++j) {
                if (comp.compare(a[j], a[m3]) >= 0) continue;
                m3 = j;
            }
            if (m3 == i) continue;
            char u = a[i];
            a[i] = a[m3];
            a[m3] = u;
        }
    }

    private static void insertionSort(char[] a, int from2, int to2, CharComparator comp) {
        int i = from2;
        while (++i < to2) {
            char t = a[i];
            int j = i;
            char u = a[j - 1];
            while (comp.compare(t, u) < 0) {
                a[j] = u;
                if (from2 == j - 1) {
                    --j;
                    break;
                }
                u = a[--j - 1];
            }
            a[j] = t;
        }
    }

    public static void quickSort(char[] x, int from2, int to2, CharComparator comp) {
        int c;
        int a;
        int len = to2 - from2;
        if (len < 16) {
            CharArrays.selectionSort(x, from2, to2, comp);
            return;
        }
        int m3 = from2 + len / 2;
        int l = from2;
        int n = to2 - 1;
        if (len > 128) {
            int s2 = len / 8;
            l = CharArrays.med3(x, l, l + s2, l + 2 * s2, comp);
            m3 = CharArrays.med3(x, m3 - s2, m3, m3 + s2, comp);
            n = CharArrays.med3(x, n - 2 * s2, n - s2, n, comp);
        }
        m3 = CharArrays.med3(x, l, m3, n, comp);
        char v = x[m3];
        int b = a = from2;
        int d = c = to2 - 1;
        while (true) {
            int comparison;
            if (b <= c && (comparison = comp.compare(x[b], v)) <= 0) {
                if (comparison == 0) {
                    CharArrays.swap(x, a++, b);
                }
                ++b;
                continue;
            }
            while (c >= b && (comparison = comp.compare(x[c], v)) >= 0) {
                if (comparison == 0) {
                    CharArrays.swap(x, c, d--);
                }
                --c;
            }
            if (b > c) break;
            CharArrays.swap(x, b++, c--);
        }
        int s3 = Math.min(a - from2, b - a);
        CharArrays.swap(x, from2, b - s3, s3);
        s3 = Math.min(d - c, to2 - d - 1);
        CharArrays.swap(x, b, to2 - s3, s3);
        s3 = b - a;
        if (s3 > 1) {
            CharArrays.quickSort(x, from2, from2 + s3, comp);
        }
        if ((s3 = d - c) > 1) {
            CharArrays.quickSort(x, to2 - s3, to2, comp);
        }
    }

    public static void quickSort(char[] x, CharComparator comp) {
        CharArrays.quickSort(x, 0, x.length, comp);
    }

    public static void parallelQuickSort(char[] x, int from2, int to2, CharComparator comp) {
        if (to2 - from2 < 8192) {
            CharArrays.quickSort(x, from2, to2, comp);
        } else {
            ForkJoinPool pool = new ForkJoinPool(Runtime.getRuntime().availableProcessors());
            pool.invoke(new ForkJoinQuickSortComp(x, from2, to2, comp));
            pool.shutdown();
        }
    }

    public static void parallelQuickSort(char[] x, CharComparator comp) {
        CharArrays.parallelQuickSort(x, 0, x.length, comp);
    }

    private static int med3(char[] x, int a, int b, int c) {
        int ab = Character.compare(x[a], x[b]);
        int ac = Character.compare(x[a], x[c]);
        int bc = Character.compare(x[b], x[c]);
        return ab < 0 ? (bc < 0 ? b : (ac < 0 ? c : a)) : (bc > 0 ? b : (ac > 0 ? c : a));
    }

    private static void selectionSort(char[] a, int from2, int to2) {
        for (int i = from2; i < to2 - 1; ++i) {
            int m3 = i;
            for (int j = i + 1; j < to2; ++j) {
                if (a[j] >= a[m3]) continue;
                m3 = j;
            }
            if (m3 == i) continue;
            char u = a[i];
            a[i] = a[m3];
            a[m3] = u;
        }
    }

    private static void insertionSort(char[] a, int from2, int to2) {
        int i = from2;
        while (++i < to2) {
            char t = a[i];
            int j = i;
            char u = a[j - 1];
            while (t < u) {
                a[j] = u;
                if (from2 == j - 1) {
                    --j;
                    break;
                }
                u = a[--j - 1];
            }
            a[j] = t;
        }
    }

    public static void quickSort(char[] x, int from2, int to2) {
        int c;
        int a;
        int len = to2 - from2;
        if (len < 16) {
            CharArrays.selectionSort(x, from2, to2);
            return;
        }
        int m3 = from2 + len / 2;
        int l = from2;
        int n = to2 - 1;
        if (len > 128) {
            int s2 = len / 8;
            l = CharArrays.med3(x, l, l + s2, l + 2 * s2);
            m3 = CharArrays.med3(x, m3 - s2, m3, m3 + s2);
            n = CharArrays.med3(x, n - 2 * s2, n - s2, n);
        }
        m3 = CharArrays.med3(x, l, m3, n);
        char v = x[m3];
        int b = a = from2;
        int d = c = to2 - 1;
        while (true) {
            int comparison;
            if (b <= c && (comparison = Character.compare(x[b], v)) <= 0) {
                if (comparison == 0) {
                    CharArrays.swap(x, a++, b);
                }
                ++b;
                continue;
            }
            while (c >= b && (comparison = Character.compare(x[c], v)) >= 0) {
                if (comparison == 0) {
                    CharArrays.swap(x, c, d--);
                }
                --c;
            }
            if (b > c) break;
            CharArrays.swap(x, b++, c--);
        }
        int s3 = Math.min(a - from2, b - a);
        CharArrays.swap(x, from2, b - s3, s3);
        s3 = Math.min(d - c, to2 - d - 1);
        CharArrays.swap(x, b, to2 - s3, s3);
        s3 = b - a;
        if (s3 > 1) {
            CharArrays.quickSort(x, from2, from2 + s3);
        }
        if ((s3 = d - c) > 1) {
            CharArrays.quickSort(x, to2 - s3, to2);
        }
    }

    public static void quickSort(char[] x) {
        CharArrays.quickSort(x, 0, x.length);
    }

    public static void parallelQuickSort(char[] x, int from2, int to2) {
        if (to2 - from2 < 8192) {
            CharArrays.quickSort(x, from2, to2);
        } else {
            ForkJoinPool pool = new ForkJoinPool(Runtime.getRuntime().availableProcessors());
            pool.invoke(new ForkJoinQuickSort(x, from2, to2));
            pool.shutdown();
        }
    }

    public static void parallelQuickSort(char[] x) {
        CharArrays.parallelQuickSort(x, 0, x.length);
    }

    private static int med3Indirect(int[] perm, char[] x, int a, int b, int c) {
        char aa = x[perm[a]];
        char bb = x[perm[b]];
        char cc = x[perm[c]];
        int ab = Character.compare(aa, bb);
        int ac = Character.compare(aa, cc);
        int bc = Character.compare(bb, cc);
        return ab < 0 ? (bc < 0 ? b : (ac < 0 ? c : a)) : (bc > 0 ? b : (ac > 0 ? c : a));
    }

    private static void insertionSortIndirect(int[] perm, char[] a, int from2, int to2) {
        int i = from2;
        while (++i < to2) {
            int t = perm[i];
            int j = i;
            int u = perm[j - 1];
            while (a[t] < a[u]) {
                perm[j] = u;
                if (from2 == j - 1) {
                    --j;
                    break;
                }
                u = perm[--j - 1];
            }
            perm[j] = t;
        }
    }

    public static void quickSortIndirect(int[] perm, char[] x, int from2, int to2) {
        int c;
        int a;
        int len = to2 - from2;
        if (len < 16) {
            CharArrays.insertionSortIndirect(perm, x, from2, to2);
            return;
        }
        int m3 = from2 + len / 2;
        int l = from2;
        int n = to2 - 1;
        if (len > 128) {
            int s2 = len / 8;
            l = CharArrays.med3Indirect(perm, x, l, l + s2, l + 2 * s2);
            m3 = CharArrays.med3Indirect(perm, x, m3 - s2, m3, m3 + s2);
            n = CharArrays.med3Indirect(perm, x, n - 2 * s2, n - s2, n);
        }
        m3 = CharArrays.med3Indirect(perm, x, l, m3, n);
        char v = x[perm[m3]];
        int b = a = from2;
        int d = c = to2 - 1;
        while (true) {
            int comparison;
            if (b <= c && (comparison = Character.compare(x[perm[b]], v)) <= 0) {
                if (comparison == 0) {
                    IntArrays.swap(perm, a++, b);
                }
                ++b;
                continue;
            }
            while (c >= b && (comparison = Character.compare(x[perm[c]], v)) >= 0) {
                if (comparison == 0) {
                    IntArrays.swap(perm, c, d--);
                }
                --c;
            }
            if (b > c) break;
            IntArrays.swap(perm, b++, c--);
        }
        int s3 = Math.min(a - from2, b - a);
        IntArrays.swap(perm, from2, b - s3, s3);
        s3 = Math.min(d - c, to2 - d - 1);
        IntArrays.swap(perm, b, to2 - s3, s3);
        s3 = b - a;
        if (s3 > 1) {
            CharArrays.quickSortIndirect(perm, x, from2, from2 + s3);
        }
        if ((s3 = d - c) > 1) {
            CharArrays.quickSortIndirect(perm, x, to2 - s3, to2);
        }
    }

    public static void quickSortIndirect(int[] perm, char[] x) {
        CharArrays.quickSortIndirect(perm, x, 0, x.length);
    }

    public static void parallelQuickSortIndirect(int[] perm, char[] x, int from2, int to2) {
        if (to2 - from2 < 8192) {
            CharArrays.quickSortIndirect(perm, x, from2, to2);
        } else {
            ForkJoinPool pool = new ForkJoinPool(Runtime.getRuntime().availableProcessors());
            pool.invoke(new ForkJoinQuickSortIndirect(perm, x, from2, to2));
            pool.shutdown();
        }
    }

    public static void parallelQuickSortIndirect(int[] perm, char[] x) {
        CharArrays.parallelQuickSortIndirect(perm, x, 0, x.length);
    }

    public static void stabilize(int[] perm, char[] x, int from2, int to2) {
        int curr = from2;
        for (int i = from2 + 1; i < to2; ++i) {
            if (x[perm[i]] == x[perm[curr]]) continue;
            if (i - curr > 1) {
                IntArrays.parallelQuickSort(perm, curr, i);
            }
            curr = i;
        }
        if (to2 - curr > 1) {
            IntArrays.parallelQuickSort(perm, curr, to2);
        }
    }

    public static void stabilize(int[] perm, char[] x) {
        CharArrays.stabilize(perm, x, 0, perm.length);
    }

    private static int med3(char[] x, char[] y, int a, int b, int c) {
        int bc;
        int t = Character.compare(x[a], x[b]);
        int ab = t == 0 ? Character.compare(y[a], y[b]) : t;
        t = Character.compare(x[a], x[c]);
        int ac = t == 0 ? Character.compare(y[a], y[c]) : t;
        t = Character.compare(x[b], x[c]);
        int n = bc = t == 0 ? Character.compare(y[b], y[c]) : t;
        return ab < 0 ? (bc < 0 ? b : (ac < 0 ? c : a)) : (bc > 0 ? b : (ac > 0 ? c : a));
    }

    private static void swap(char[] x, char[] y, int a, int b) {
        char t = x[a];
        char u = y[a];
        x[a] = x[b];
        y[a] = y[b];
        x[b] = t;
        y[b] = u;
    }

    private static void swap(char[] x, char[] y, int a, int b, int n) {
        int i = 0;
        while (i < n) {
            CharArrays.swap(x, y, a, b);
            ++i;
            ++a;
            ++b;
        }
    }

    private static void selectionSort(char[] a, char[] b, int from2, int to2) {
        for (int i = from2; i < to2 - 1; ++i) {
            int m3 = i;
            for (int j = i + 1; j < to2; ++j) {
                int u = Character.compare(a[j], a[m3]);
                if (u >= 0 && (u != 0 || b[j] >= b[m3])) continue;
                m3 = j;
            }
            if (m3 == i) continue;
            char t = a[i];
            a[i] = a[m3];
            a[m3] = t;
            t = b[i];
            b[i] = b[m3];
            b[m3] = t;
        }
    }

    public static void quickSort(char[] x, char[] y, int from2, int to2) {
        int c;
        int a;
        int len = to2 - from2;
        if (len < 16) {
            CharArrays.selectionSort(x, y, from2, to2);
            return;
        }
        int m3 = from2 + len / 2;
        int l = from2;
        int n = to2 - 1;
        if (len > 128) {
            int s2 = len / 8;
            l = CharArrays.med3(x, y, l, l + s2, l + 2 * s2);
            m3 = CharArrays.med3(x, y, m3 - s2, m3, m3 + s2);
            n = CharArrays.med3(x, y, n - 2 * s2, n - s2, n);
        }
        m3 = CharArrays.med3(x, y, l, m3, n);
        char v = x[m3];
        char w = y[m3];
        int b = a = from2;
        int d = c = to2 - 1;
        while (true) {
            int t;
            int comparison;
            if (b <= c && (comparison = (t = Character.compare(x[b], v)) == 0 ? Character.compare(y[b], w) : t) <= 0) {
                if (comparison == 0) {
                    CharArrays.swap(x, y, a++, b);
                }
                ++b;
                continue;
            }
            while (c >= b && (comparison = (t = Character.compare(x[c], v)) == 0 ? Character.compare(y[c], w) : t) >= 0) {
                if (comparison == 0) {
                    CharArrays.swap(x, y, c, d--);
                }
                --c;
            }
            if (b > c) break;
            CharArrays.swap(x, y, b++, c--);
        }
        int s3 = Math.min(a - from2, b - a);
        CharArrays.swap(x, y, from2, b - s3, s3);
        s3 = Math.min(d - c, to2 - d - 1);
        CharArrays.swap(x, y, b, to2 - s3, s3);
        s3 = b - a;
        if (s3 > 1) {
            CharArrays.quickSort(x, y, from2, from2 + s3);
        }
        if ((s3 = d - c) > 1) {
            CharArrays.quickSort(x, y, to2 - s3, to2);
        }
    }

    public static void quickSort(char[] x, char[] y) {
        CharArrays.ensureSameLength(x, y);
        CharArrays.quickSort(x, y, 0, x.length);
    }

    public static void parallelQuickSort(char[] x, char[] y, int from2, int to2) {
        if (to2 - from2 < 8192) {
            CharArrays.quickSort(x, y, from2, to2);
        }
        ForkJoinPool pool = new ForkJoinPool(Runtime.getRuntime().availableProcessors());
        pool.invoke(new ForkJoinQuickSort2(x, y, from2, to2));
        pool.shutdown();
    }

    public static void parallelQuickSort(char[] x, char[] y) {
        CharArrays.ensureSameLength(x, y);
        CharArrays.parallelQuickSort(x, y, 0, x.length);
    }

    public static void mergeSort(char[] a, int from2, int to2, char[] supp) {
        int len = to2 - from2;
        if (len < 16) {
            CharArrays.insertionSort(a, from2, to2);
            return;
        }
        int mid = from2 + to2 >>> 1;
        CharArrays.mergeSort(supp, from2, mid, a);
        CharArrays.mergeSort(supp, mid, to2, a);
        if (supp[mid - 1] <= supp[mid]) {
            System.arraycopy(supp, from2, a, from2, len);
            return;
        }
        int p = from2;
        int q = mid;
        for (int i = from2; i < to2; ++i) {
            a[i] = q >= to2 || p < mid && supp[p] <= supp[q] ? supp[p++] : supp[q++];
        }
    }

    public static void mergeSort(char[] a, int from2, int to2) {
        CharArrays.mergeSort(a, from2, to2, (char[])a.clone());
    }

    public static void mergeSort(char[] a) {
        CharArrays.mergeSort(a, 0, a.length);
    }

    public static void mergeSort(char[] a, int from2, int to2, CharComparator comp, char[] supp) {
        int len = to2 - from2;
        if (len < 16) {
            CharArrays.insertionSort(a, from2, to2, comp);
            return;
        }
        int mid = from2 + to2 >>> 1;
        CharArrays.mergeSort(supp, from2, mid, comp, a);
        CharArrays.mergeSort(supp, mid, to2, comp, a);
        if (comp.compare(supp[mid - 1], supp[mid]) <= 0) {
            System.arraycopy(supp, from2, a, from2, len);
            return;
        }
        int p = from2;
        int q = mid;
        for (int i = from2; i < to2; ++i) {
            a[i] = q >= to2 || p < mid && comp.compare(supp[p], supp[q]) <= 0 ? supp[p++] : supp[q++];
        }
    }

    public static void mergeSort(char[] a, int from2, int to2, CharComparator comp) {
        CharArrays.mergeSort(a, from2, to2, comp, (char[])a.clone());
    }

    public static void mergeSort(char[] a, CharComparator comp) {
        CharArrays.mergeSort(a, 0, a.length, comp);
    }

    public static int binarySearch(char[] a, int from2, int to2, char key) {
        --to2;
        while (from2 <= to2) {
            int mid = from2 + to2 >>> 1;
            char midVal = a[mid];
            if (midVal < key) {
                from2 = mid + 1;
                continue;
            }
            if (midVal > key) {
                to2 = mid - 1;
                continue;
            }
            return mid;
        }
        return -(from2 + 1);
    }

    public static int binarySearch(char[] a, char key) {
        return CharArrays.binarySearch(a, 0, a.length, key);
    }

    public static int binarySearch(char[] a, int from2, int to2, char key, CharComparator c) {
        --to2;
        while (from2 <= to2) {
            int mid = from2 + to2 >>> 1;
            char midVal = a[mid];
            int cmp = c.compare(midVal, key);
            if (cmp < 0) {
                from2 = mid + 1;
                continue;
            }
            if (cmp > 0) {
                to2 = mid - 1;
                continue;
            }
            return mid;
        }
        return -(from2 + 1);
    }

    public static int binarySearch(char[] a, char key, CharComparator c) {
        return CharArrays.binarySearch(a, 0, a.length, key, c);
    }

    public static void radixSort(char[] a) {
        CharArrays.radixSort(a, 0, a.length);
    }

    public static void radixSort(char[] a, int from2, int to2) {
        if (to2 - from2 < 1024) {
            CharArrays.quickSort(a, from2, to2);
            return;
        }
        boolean maxLevel = true;
        int stackSize = 256;
        int stackPos = 0;
        int[] offsetStack = new int[256];
        int[] lengthStack = new int[256];
        int[] levelStack = new int[256];
        offsetStack[stackPos] = from2;
        lengthStack[stackPos] = to2 - from2;
        levelStack[stackPos++] = 0;
        int[] count2 = new int[256];
        int[] pos = new int[256];
        while (stackPos > 0) {
            int first2 = offsetStack[--stackPos];
            int length = lengthStack[stackPos];
            int level = levelStack[stackPos];
            boolean signMask = false;
            int shift2 = (1 - level % 2) * 8;
            int i = first2 + length;
            while (i-- != first2) {
                int n = a[i] >>> shift2 & 0xFF ^ 0;
                count2[n] = count2[n] + 1;
            }
            int lastUsed = -1;
            int p = first2;
            for (int i2 = 0; i2 < 256; ++i2) {
                if (count2[i2] != 0) {
                    lastUsed = i2;
                }
                pos[i2] = p += count2[i2];
            }
            int end2 = first2 + length - count2[lastUsed];
            int c = -1;
            for (int i3 = first2; i3 <= end2; i3 += count2[c]) {
                char t = a[i3];
                c = t >>> shift2 & 0xFF ^ 0;
                if (i3 < end2) {
                    while (true) {
                        int n = c;
                        int n2 = pos[n] - 1;
                        pos[n] = n2;
                        int d = n2;
                        if (n2 <= i3) break;
                        char z = t;
                        t = a[d];
                        a[d] = z;
                        c = t >>> shift2 & 0xFF ^ 0;
                    }
                    a[i3] = t;
                }
                if (level < 1 && count2[c] > 1) {
                    if (count2[c] < 1024) {
                        CharArrays.quickSort(a, i3, i3 + count2[c]);
                    } else {
                        offsetStack[stackPos] = i3;
                        lengthStack[stackPos] = count2[c];
                        levelStack[stackPos++] = level + 1;
                    }
                }
                count2[c] = 0;
            }
        }
    }

    public static void parallelRadixSort(char[] a, int from2, int to2) {
        if (to2 - from2 < 1024) {
            CharArrays.quickSort(a, from2, to2);
            return;
        }
        boolean maxLevel = true;
        LinkedBlockingQueue<Segment> queue = new LinkedBlockingQueue<Segment>();
        queue.add(new Segment(from2, to2 - from2, 0));
        AtomicInteger queueSize = new AtomicInteger(1);
        int numberOfThreads = Runtime.getRuntime().availableProcessors();
        ExecutorService executorService = Executors.newFixedThreadPool(numberOfThreads, Executors.defaultThreadFactory());
        ExecutorCompletionService<Void> executorCompletionService = new ExecutorCompletionService<Void>(executorService);
        int j = numberOfThreads;
        while (j-- != 0) {
            executorCompletionService.submit(() -> {
                int[] count2 = new int[256];
                int[] pos = new int[256];
                while (true) {
                    Segment segment;
                    if (queueSize.get() == 0) {
                        int i = numberOfThreads;
                        while (i-- != 0) {
                            queue.add(POISON_PILL);
                        }
                    }
                    if ((segment = (Segment)queue.take()) == POISON_PILL) {
                        return null;
                    }
                    int first2 = segment.offset;
                    int length = segment.length;
                    int level = segment.level;
                    boolean signMask = false;
                    int shift2 = (1 - level % 2) * 8;
                    int i = first2 + length;
                    while (i-- != first2) {
                        int n = a[i] >>> shift2 & 0xFF ^ 0;
                        count2[n] = count2[n] + 1;
                    }
                    int lastUsed = -1;
                    int p = first2;
                    for (int i2 = 0; i2 < 256; ++i2) {
                        if (count2[i2] != 0) {
                            lastUsed = i2;
                        }
                        pos[i2] = p += count2[i2];
                    }
                    int end2 = first2 + length - count2[lastUsed];
                    int c = -1;
                    for (int i3 = first2; i3 <= end2; i3 += count2[c]) {
                        char t = a[i3];
                        c = t >>> shift2 & 0xFF ^ 0;
                        if (i3 < end2) {
                            while (true) {
                                int n = c;
                                int n2 = pos[n] - 1;
                                pos[n] = n2;
                                int d = n2;
                                if (n2 <= i3) break;
                                char z = t;
                                t = a[d];
                                a[d] = z;
                                c = t >>> shift2 & 0xFF ^ 0;
                            }
                            a[i3] = t;
                        }
                        if (level < 1 && count2[c] > 1) {
                            if (count2[c] < 1024) {
                                CharArrays.quickSort(a, i3, i3 + count2[c]);
                            } else {
                                queueSize.incrementAndGet();
                                queue.add(new Segment(i3, count2[c], level + 1));
                            }
                        }
                        count2[c] = 0;
                    }
                    queueSize.decrementAndGet();
                }
            });
        }
        Throwable problem = null;
        int i = numberOfThreads;
        while (i-- != 0) {
            try {
                executorCompletionService.take().get();
            }
            catch (Exception e) {
                problem = e.getCause();
            }
        }
        executorService.shutdown();
        if (problem != null) {
            throw problem instanceof RuntimeException ? (RuntimeException)problem : new RuntimeException(problem);
        }
    }

    public static void parallelRadixSort(char[] a) {
        CharArrays.parallelRadixSort(a, 0, a.length);
    }

    public static void radixSortIndirect(int[] perm, char[] a, boolean stable) {
        CharArrays.radixSortIndirect(perm, a, 0, perm.length, stable);
    }

    public static void radixSortIndirect(int[] perm, char[] a, int from2, int to2, boolean stable) {
        int[] support;
        if (to2 - from2 < 1024) {
            CharArrays.insertionSortIndirect(perm, a, from2, to2);
            return;
        }
        boolean maxLevel = true;
        int stackSize = 256;
        int stackPos = 0;
        int[] offsetStack = new int[256];
        int[] lengthStack = new int[256];
        int[] levelStack = new int[256];
        offsetStack[stackPos] = from2;
        lengthStack[stackPos] = to2 - from2;
        levelStack[stackPos++] = 0;
        int[] count2 = new int[256];
        int[] pos = new int[256];
        int[] nArray = support = stable ? new int[perm.length] : null;
        while (stackPos > 0) {
            int i;
            int p;
            int first2 = offsetStack[--stackPos];
            int length = lengthStack[stackPos];
            int level = levelStack[stackPos];
            boolean signMask = false;
            int shift2 = (1 - level % 2) * 8;
            int i2 = first2 + length;
            while (i2-- != first2) {
                int n = a[perm[i2]] >>> shift2 & 0xFF ^ 0;
                count2[n] = count2[n] + 1;
            }
            int lastUsed = -1;
            int n = p = stable ? 0 : first2;
            for (i = 0; i < 256; ++i) {
                if (count2[i] != 0) {
                    lastUsed = i;
                }
                pos[i] = p += count2[i];
            }
            if (stable) {
                i = first2 + length;
                while (i-- != first2) {
                    int n2 = a[perm[i]] >>> shift2 & 0xFF ^ 0;
                    int n3 = pos[n2] - 1;
                    pos[n2] = n3;
                    support[n3] = perm[i];
                }
                System.arraycopy(support, 0, perm, first2, length);
                p = first2;
                for (i = 0; i <= lastUsed; ++i) {
                    if (level < 1 && count2[i] > 1) {
                        if (count2[i] < 1024) {
                            CharArrays.insertionSortIndirect(perm, a, p, p + count2[i]);
                        } else {
                            offsetStack[stackPos] = p;
                            lengthStack[stackPos] = count2[i];
                            levelStack[stackPos++] = level + 1;
                        }
                    }
                    p += count2[i];
                }
                java.util.Arrays.fill(count2, 0);
                continue;
            }
            int end2 = first2 + length - count2[lastUsed];
            int c = -1;
            for (int i3 = first2; i3 <= end2; i3 += count2[c]) {
                int t = perm[i3];
                c = a[t] >>> shift2 & 0xFF ^ 0;
                if (i3 < end2) {
                    while (true) {
                        int n4 = c;
                        int n5 = pos[n4] - 1;
                        pos[n4] = n5;
                        int d = n5;
                        if (n5 <= i3) break;
                        int z = t;
                        t = perm[d];
                        perm[d] = z;
                        c = a[t] >>> shift2 & 0xFF ^ 0;
                    }
                    perm[i3] = t;
                }
                if (level < 1 && count2[c] > 1) {
                    if (count2[c] < 1024) {
                        CharArrays.insertionSortIndirect(perm, a, i3, i3 + count2[c]);
                    } else {
                        offsetStack[stackPos] = i3;
                        lengthStack[stackPos] = count2[c];
                        levelStack[stackPos++] = level + 1;
                    }
                }
                count2[c] = 0;
            }
        }
    }

    public static void parallelRadixSortIndirect(int[] perm, char[] a, int from2, int to2, boolean stable) {
        if (to2 - from2 < 1024) {
            CharArrays.radixSortIndirect(perm, a, from2, to2, stable);
            return;
        }
        boolean maxLevel = true;
        LinkedBlockingQueue<Segment> queue = new LinkedBlockingQueue<Segment>();
        queue.add(new Segment(from2, to2 - from2, 0));
        AtomicInteger queueSize = new AtomicInteger(1);
        int numberOfThreads = Runtime.getRuntime().availableProcessors();
        ExecutorService executorService = Executors.newFixedThreadPool(numberOfThreads, Executors.defaultThreadFactory());
        ExecutorCompletionService<Void> executorCompletionService = new ExecutorCompletionService<Void>(executorService);
        int[] support = stable ? new int[perm.length] : null;
        int j = numberOfThreads;
        while (j-- != 0) {
            executorCompletionService.submit(() -> {
                int[] count2 = new int[256];
                int[] pos = new int[256];
                while (true) {
                    int i;
                    Segment segment;
                    if (queueSize.get() == 0) {
                        int i2 = numberOfThreads;
                        while (i2-- != 0) {
                            queue.add(POISON_PILL);
                        }
                    }
                    if ((segment = (Segment)queue.take()) == POISON_PILL) {
                        return null;
                    }
                    int first2 = segment.offset;
                    int length = segment.length;
                    int level = segment.level;
                    boolean signMask = false;
                    int shift2 = (1 - level % 2) * 8;
                    int i3 = first2 + length;
                    while (i3-- != first2) {
                        int n = a[perm[i3]] >>> shift2 & 0xFF ^ 0;
                        count2[n] = count2[n] + 1;
                    }
                    int lastUsed = -1;
                    int p = first2;
                    for (i = 0; i < 256; ++i) {
                        if (count2[i] != 0) {
                            lastUsed = i;
                        }
                        pos[i] = p += count2[i];
                    }
                    if (stable) {
                        i = first2 + length;
                        while (i-- != first2) {
                            int n = a[perm[i]] >>> shift2 & 0xFF ^ 0;
                            int n2 = pos[n] - 1;
                            pos[n] = n2;
                            support[n2] = perm[i];
                        }
                        System.arraycopy(support, first2, perm, first2, length);
                        p = first2;
                        for (i = 0; i <= lastUsed; ++i) {
                            if (level < 1 && count2[i] > 1) {
                                if (count2[i] < 1024) {
                                    CharArrays.radixSortIndirect(perm, a, p, p + count2[i], stable);
                                } else {
                                    queueSize.incrementAndGet();
                                    queue.add(new Segment(p, count2[i], level + 1));
                                }
                            }
                            p += count2[i];
                        }
                        java.util.Arrays.fill(count2, 0);
                    } else {
                        int end2 = first2 + length - count2[lastUsed];
                        int c = -1;
                        for (int i4 = first2; i4 <= end2; i4 += count2[c]) {
                            int t = perm[i4];
                            c = a[t] >>> shift2 & 0xFF ^ 0;
                            if (i4 < end2) {
                                while (true) {
                                    int n = c;
                                    int n3 = pos[n] - 1;
                                    pos[n] = n3;
                                    int d = n3;
                                    if (n3 <= i4) break;
                                    int z = t;
                                    t = perm[d];
                                    perm[d] = z;
                                    c = a[t] >>> shift2 & 0xFF ^ 0;
                                }
                                perm[i4] = t;
                            }
                            if (level < 1 && count2[c] > 1) {
                                if (count2[c] < 1024) {
                                    CharArrays.radixSortIndirect(perm, a, i4, i4 + count2[c], stable);
                                } else {
                                    queueSize.incrementAndGet();
                                    queue.add(new Segment(i4, count2[c], level + 1));
                                }
                            }
                            count2[c] = 0;
                        }
                    }
                    queueSize.decrementAndGet();
                }
            });
        }
        Throwable problem = null;
        int i = numberOfThreads;
        while (i-- != 0) {
            try {
                executorCompletionService.take().get();
            }
            catch (Exception e) {
                problem = e.getCause();
            }
        }
        executorService.shutdown();
        if (problem != null) {
            throw problem instanceof RuntimeException ? (RuntimeException)problem : new RuntimeException(problem);
        }
    }

    public static void parallelRadixSortIndirect(int[] perm, char[] a, boolean stable) {
        CharArrays.parallelRadixSortIndirect(perm, a, 0, a.length, stable);
    }

    public static void radixSort(char[] a, char[] b) {
        CharArrays.ensureSameLength(a, b);
        CharArrays.radixSort(a, b, 0, a.length);
    }

    public static void radixSort(char[] a, char[] b, int from2, int to2) {
        if (to2 - from2 < 1024) {
            CharArrays.selectionSort(a, b, from2, to2);
            return;
        }
        int layers = 2;
        int maxLevel = 3;
        int stackSize = 766;
        int stackPos = 0;
        int[] offsetStack = new int[766];
        int[] lengthStack = new int[766];
        int[] levelStack = new int[766];
        offsetStack[stackPos] = from2;
        lengthStack[stackPos] = to2 - from2;
        levelStack[stackPos++] = 0;
        int[] count2 = new int[256];
        int[] pos = new int[256];
        while (stackPos > 0) {
            int first2 = offsetStack[--stackPos];
            int length = lengthStack[stackPos];
            int level = levelStack[stackPos];
            boolean signMask = false;
            char[] k = level < 2 ? a : b;
            int shift2 = (1 - level % 2) * 8;
            int i = first2 + length;
            while (i-- != first2) {
                int n = k[i] >>> shift2 & 0xFF ^ 0;
                count2[n] = count2[n] + 1;
            }
            int lastUsed = -1;
            int p = first2;
            for (int i2 = 0; i2 < 256; ++i2) {
                if (count2[i2] != 0) {
                    lastUsed = i2;
                }
                pos[i2] = p += count2[i2];
            }
            int end2 = first2 + length - count2[lastUsed];
            int c = -1;
            for (int i3 = first2; i3 <= end2; i3 += count2[c]) {
                char t = a[i3];
                char u = b[i3];
                c = k[i3] >>> shift2 & 0xFF ^ 0;
                if (i3 < end2) {
                    while (true) {
                        int n = c;
                        int n2 = pos[n] - 1;
                        pos[n] = n2;
                        int d = n2;
                        if (n2 <= i3) break;
                        c = k[d] >>> shift2 & 0xFF ^ 0;
                        char z = t;
                        t = a[d];
                        a[d] = z;
                        z = u;
                        u = b[d];
                        b[d] = z;
                    }
                    a[i3] = t;
                    b[i3] = u;
                }
                if (level < 3 && count2[c] > 1) {
                    if (count2[c] < 1024) {
                        CharArrays.selectionSort(a, b, i3, i3 + count2[c]);
                    } else {
                        offsetStack[stackPos] = i3;
                        lengthStack[stackPos] = count2[c];
                        levelStack[stackPos++] = level + 1;
                    }
                }
                count2[c] = 0;
            }
        }
    }

    public static void parallelRadixSort(char[] a, char[] b, int from2, int to2) {
        if (to2 - from2 < 1024) {
            CharArrays.quickSort(a, b, from2, to2);
            return;
        }
        int layers = 2;
        if (a.length != b.length) {
            throw new IllegalArgumentException("Array size mismatch.");
        }
        int maxLevel = 3;
        LinkedBlockingQueue<Segment> queue = new LinkedBlockingQueue<Segment>();
        queue.add(new Segment(from2, to2 - from2, 0));
        AtomicInteger queueSize = new AtomicInteger(1);
        int numberOfThreads = Runtime.getRuntime().availableProcessors();
        ExecutorService executorService = Executors.newFixedThreadPool(numberOfThreads, Executors.defaultThreadFactory());
        ExecutorCompletionService<Void> executorCompletionService = new ExecutorCompletionService<Void>(executorService);
        int j = numberOfThreads;
        while (j-- != 0) {
            executorCompletionService.submit(() -> {
                int[] count2 = new int[256];
                int[] pos = new int[256];
                while (true) {
                    Segment segment;
                    if (queueSize.get() == 0) {
                        int i = numberOfThreads;
                        while (i-- != 0) {
                            queue.add(POISON_PILL);
                        }
                    }
                    if ((segment = (Segment)queue.take()) == POISON_PILL) {
                        return null;
                    }
                    int first2 = segment.offset;
                    int length = segment.length;
                    int level = segment.level;
                    int signMask = level % 2 == 0 ? 128 : 0;
                    char[] k = level < 2 ? a : b;
                    int shift2 = (1 - level % 2) * 8;
                    int i = first2 + length;
                    while (i-- != first2) {
                        int n = k[i] >>> shift2 & 0xFF ^ signMask;
                        count2[n] = count2[n] + 1;
                    }
                    int lastUsed = -1;
                    int p = first2;
                    for (int i2 = 0; i2 < 256; ++i2) {
                        if (count2[i2] != 0) {
                            lastUsed = i2;
                        }
                        pos[i2] = p += count2[i2];
                    }
                    int end2 = first2 + length - count2[lastUsed];
                    int c = -1;
                    for (int i3 = first2; i3 <= end2; i3 += count2[c]) {
                        char t = a[i3];
                        char u = b[i3];
                        c = k[i3] >>> shift2 & 0xFF ^ signMask;
                        if (i3 < end2) {
                            while (true) {
                                int n = c;
                                int n2 = pos[n] - 1;
                                pos[n] = n2;
                                int d = n2;
                                if (n2 <= i3) break;
                                c = k[d] >>> shift2 & 0xFF ^ signMask;
                                char z = t;
                                char w = u;
                                t = a[d];
                                u = b[d];
                                a[d] = z;
                                b[d] = w;
                            }
                            a[i3] = t;
                            b[i3] = u;
                        }
                        if (level < 3 && count2[c] > 1) {
                            if (count2[c] < 1024) {
                                CharArrays.quickSort(a, b, i3, i3 + count2[c]);
                            } else {
                                queueSize.incrementAndGet();
                                queue.add(new Segment(i3, count2[c], level + 1));
                            }
                        }
                        count2[c] = 0;
                    }
                    queueSize.decrementAndGet();
                }
            });
        }
        Throwable problem = null;
        int i = numberOfThreads;
        while (i-- != 0) {
            try {
                executorCompletionService.take().get();
            }
            catch (Exception e) {
                problem = e.getCause();
            }
        }
        executorService.shutdown();
        if (problem != null) {
            throw problem instanceof RuntimeException ? (RuntimeException)problem : new RuntimeException(problem);
        }
    }

    public static void parallelRadixSort(char[] a, char[] b) {
        CharArrays.ensureSameLength(a, b);
        CharArrays.parallelRadixSort(a, b, 0, a.length);
    }

    private static void insertionSortIndirect(int[] perm, char[] a, char[] b, int from2, int to2) {
        int i = from2;
        while (++i < to2) {
            int t = perm[i];
            int j = i;
            int u = perm[j - 1];
            while (a[t] < a[u] || a[t] == a[u] && b[t] < b[u]) {
                perm[j] = u;
                if (from2 == j - 1) {
                    --j;
                    break;
                }
                u = perm[--j - 1];
            }
            perm[j] = t;
        }
    }

    public static void radixSortIndirect(int[] perm, char[] a, char[] b, boolean stable) {
        CharArrays.ensureSameLength(a, b);
        CharArrays.radixSortIndirect(perm, a, b, 0, a.length, stable);
    }

    public static void radixSortIndirect(int[] perm, char[] a, char[] b, int from2, int to2, boolean stable) {
        int[] support;
        if (to2 - from2 < 1024) {
            CharArrays.insertionSortIndirect(perm, a, b, from2, to2);
            return;
        }
        int layers = 2;
        int maxLevel = 3;
        int stackSize = 766;
        int stackPos = 0;
        int[] offsetStack = new int[766];
        int[] lengthStack = new int[766];
        int[] levelStack = new int[766];
        offsetStack[stackPos] = from2;
        lengthStack[stackPos] = to2 - from2;
        levelStack[stackPos++] = 0;
        int[] count2 = new int[256];
        int[] pos = new int[256];
        int[] nArray = support = stable ? new int[perm.length] : null;
        while (stackPos > 0) {
            int i;
            int p;
            int first2 = offsetStack[--stackPos];
            int length = lengthStack[stackPos];
            int level = levelStack[stackPos];
            boolean signMask = false;
            char[] k = level < 2 ? a : b;
            int shift2 = (1 - level % 2) * 8;
            int i2 = first2 + length;
            while (i2-- != first2) {
                int n = k[perm[i2]] >>> shift2 & 0xFF ^ 0;
                count2[n] = count2[n] + 1;
            }
            int lastUsed = -1;
            int n = p = stable ? 0 : first2;
            for (i = 0; i < 256; ++i) {
                if (count2[i] != 0) {
                    lastUsed = i;
                }
                pos[i] = p += count2[i];
            }
            if (stable) {
                i = first2 + length;
                while (i-- != first2) {
                    int n2 = k[perm[i]] >>> shift2 & 0xFF ^ 0;
                    int n3 = pos[n2] - 1;
                    pos[n2] = n3;
                    support[n3] = perm[i];
                }
                System.arraycopy(support, 0, perm, first2, length);
                p = first2;
                for (i = 0; i < 256; ++i) {
                    if (level < 3 && count2[i] > 1) {
                        if (count2[i] < 1024) {
                            CharArrays.insertionSortIndirect(perm, a, b, p, p + count2[i]);
                        } else {
                            offsetStack[stackPos] = p;
                            lengthStack[stackPos] = count2[i];
                            levelStack[stackPos++] = level + 1;
                        }
                    }
                    p += count2[i];
                }
                java.util.Arrays.fill(count2, 0);
                continue;
            }
            int end2 = first2 + length - count2[lastUsed];
            int c = -1;
            for (int i3 = first2; i3 <= end2; i3 += count2[c]) {
                int t = perm[i3];
                c = k[t] >>> shift2 & 0xFF ^ 0;
                if (i3 < end2) {
                    while (true) {
                        int n4 = c;
                        int n5 = pos[n4] - 1;
                        pos[n4] = n5;
                        int d = n5;
                        if (n5 <= i3) break;
                        int z = t;
                        t = perm[d];
                        perm[d] = z;
                        c = k[t] >>> shift2 & 0xFF ^ 0;
                    }
                    perm[i3] = t;
                }
                if (level < 3 && count2[c] > 1) {
                    if (count2[c] < 1024) {
                        CharArrays.insertionSortIndirect(perm, a, b, i3, i3 + count2[c]);
                    } else {
                        offsetStack[stackPos] = i3;
                        lengthStack[stackPos] = count2[c];
                        levelStack[stackPos++] = level + 1;
                    }
                }
                count2[c] = 0;
            }
        }
    }

    private static void selectionSort(char[][] a, int from2, int to2, int level) {
        int layers = a.length;
        int firstLayer = level / 2;
        for (int i = from2; i < to2 - 1; ++i) {
            int m3 = i;
            block1: for (int j = i + 1; j < to2; ++j) {
                for (int p = firstLayer; p < layers; ++p) {
                    if (a[p][j] < a[p][m3]) {
                        m3 = j;
                        continue block1;
                    }
                    if (a[p][j] > a[p][m3]) continue block1;
                }
            }
            if (m3 == i) continue;
            int p = layers;
            while (p-- != 0) {
                char u = a[p][i];
                a[p][i] = a[p][m3];
                a[p][m3] = u;
            }
        }
    }

    public static void radixSort(char[][] a) {
        CharArrays.radixSort(a, 0, a[0].length);
    }

    public static void radixSort(char[][] a, int from2, int to2) {
        if (to2 - from2 < 1024) {
            CharArrays.selectionSort(a, from2, to2, 0);
            return;
        }
        int layers = a.length;
        int maxLevel = 2 * layers - 1;
        int p = layers;
        int l = a[0].length;
        while (p-- != 0) {
            if (a[p].length == l) continue;
            throw new IllegalArgumentException("The array of index " + p + " has not the same length of the array of index 0.");
        }
        int stackSize = 255 * (layers * 2 - 1) + 1;
        int stackPos = 0;
        int[] offsetStack = new int[stackSize];
        int[] lengthStack = new int[stackSize];
        int[] levelStack = new int[stackSize];
        offsetStack[stackPos] = from2;
        lengthStack[stackPos] = to2 - from2;
        levelStack[stackPos++] = 0;
        int[] count2 = new int[256];
        int[] pos = new int[256];
        char[] t = new char[layers];
        while (stackPos > 0) {
            int first2 = offsetStack[--stackPos];
            int length = lengthStack[stackPos];
            int level = levelStack[stackPos];
            boolean signMask = false;
            char[] k = a[level / 2];
            int shift2 = (1 - level % 2) * 8;
            int i = first2 + length;
            while (i-- != first2) {
                int n = k[i] >>> shift2 & 0xFF ^ 0;
                count2[n] = count2[n] + 1;
            }
            int lastUsed = -1;
            int p2 = first2;
            for (int i2 = 0; i2 < 256; ++i2) {
                if (count2[i2] != 0) {
                    lastUsed = i2;
                }
                pos[i2] = p2 += count2[i2];
            }
            int end2 = first2 + length - count2[lastUsed];
            int c = -1;
            for (int i3 = first2; i3 <= end2; i3 += count2[c]) {
                int p3 = layers;
                while (p3-- != 0) {
                    t[p3] = a[p3][i3];
                }
                c = k[i3] >>> shift2 & 0xFF ^ 0;
                if (i3 < end2) {
                    block6: while (true) {
                        int n = c;
                        int n2 = pos[n] - 1;
                        pos[n] = n2;
                        int d = n2;
                        if (n2 <= i3) break;
                        c = k[d] >>> shift2 & 0xFF ^ 0;
                        p3 = layers;
                        while (true) {
                            if (p3-- == 0) continue block6;
                            char u = t[p3];
                            t[p3] = a[p3][d];
                            a[p3][d] = u;
                        }
                        break;
                    }
                    p3 = layers;
                    while (p3-- != 0) {
                        a[p3][i3] = t[p3];
                    }
                }
                if (level < maxLevel && count2[c] > 1) {
                    if (count2[c] < 1024) {
                        CharArrays.selectionSort(a, i3, i3 + count2[c], level + 1);
                    } else {
                        offsetStack[stackPos] = i3;
                        lengthStack[stackPos] = count2[c];
                        levelStack[stackPos++] = level + 1;
                    }
                }
                count2[c] = 0;
            }
        }
    }

    public static char[] shuffle(char[] a, int from2, int to2, Random random) {
        int i = to2 - from2;
        while (i-- != 0) {
            int p = random.nextInt(i + 1);
            char t = a[from2 + i];
            a[from2 + i] = a[from2 + p];
            a[from2 + p] = t;
        }
        return a;
    }

    public static char[] shuffle(char[] a, Random random) {
        int i = a.length;
        while (i-- != 0) {
            int p = random.nextInt(i + 1);
            char t = a[i];
            a[i] = a[p];
            a[p] = t;
        }
        return a;
    }

    public static char[] reverse(char[] a) {
        int length = a.length;
        int i = length / 2;
        while (i-- != 0) {
            char t = a[length - i - 1];
            a[length - i - 1] = a[i];
            a[i] = t;
        }
        return a;
    }

    public static char[] reverse(char[] a, int from2, int to2) {
        int length = to2 - from2;
        int i = length / 2;
        while (i-- != 0) {
            char t = a[from2 + length - i - 1];
            a[from2 + length - i - 1] = a[from2 + i];
            a[from2 + i] = t;
        }
        return a;
    }

    private static final class ArrayHashStrategy
    implements Hash.Strategy<char[]>,
    Serializable {
        private static final long serialVersionUID = -7046029254386353129L;

        private ArrayHashStrategy() {
        }

        @Override
        public int hashCode(char[] o) {
            return java.util.Arrays.hashCode(o);
        }

        @Override
        public boolean equals(char[] a, char[] b) {
            return java.util.Arrays.equals(a, b);
        }
    }

    protected static final class Segment {
        protected final int offset;
        protected final int length;
        protected final int level;

        protected Segment(int offset, int length, int level) {
            this.offset = offset;
            this.length = length;
            this.level = level;
        }

        public String toString() {
            return "Segment [offset=" + this.offset + ", length=" + this.length + ", level=" + this.level + "]";
        }
    }

    protected static class ForkJoinQuickSort2
    extends RecursiveAction {
        private static final long serialVersionUID = 1L;
        private final int from;
        private final int to;
        private final char[] x;
        private final char[] y;

        public ForkJoinQuickSort2(char[] x, char[] y, int from2, int to2) {
            this.from = from2;
            this.to = to2;
            this.x = x;
            this.y = y;
        }

        @Override
        protected void compute() {
            int c;
            int a;
            char[] x = this.x;
            char[] y = this.y;
            int len = this.to - this.from;
            if (len < 8192) {
                CharArrays.quickSort(x, y, this.from, this.to);
                return;
            }
            int m3 = this.from + len / 2;
            int l = this.from;
            int n = this.to - 1;
            int s2 = len / 8;
            l = CharArrays.med3(x, y, l, l + s2, l + 2 * s2);
            m3 = CharArrays.med3(x, y, m3 - s2, m3, m3 + s2);
            n = CharArrays.med3(x, y, n - 2 * s2, n - s2, n);
            m3 = CharArrays.med3(x, y, l, m3, n);
            char v = x[m3];
            char w = y[m3];
            int b = a = this.from;
            int d = c = this.to - 1;
            while (true) {
                int t;
                int comparison;
                if (b <= c && (comparison = (t = Character.compare(x[b], v)) == 0 ? Character.compare(y[b], w) : t) <= 0) {
                    if (comparison == 0) {
                        CharArrays.swap(x, y, a++, b);
                    }
                    ++b;
                    continue;
                }
                while (c >= b && (comparison = (t = Character.compare(x[c], v)) == 0 ? Character.compare(y[c], w) : t) >= 0) {
                    if (comparison == 0) {
                        CharArrays.swap(x, y, c, d--);
                    }
                    --c;
                }
                if (b > c) break;
                CharArrays.swap(x, y, b++, c--);
            }
            s2 = Math.min(a - this.from, b - a);
            CharArrays.swap(x, y, this.from, b - s2, s2);
            s2 = Math.min(d - c, this.to - d - 1);
            CharArrays.swap(x, y, b, this.to - s2, s2);
            s2 = b - a;
            int t = d - c;
            if (s2 > 1 && t > 1) {
                ForkJoinQuickSort2.invokeAll(new ForkJoinQuickSort2(x, y, this.from, this.from + s2), new ForkJoinQuickSort2(x, y, this.to - t, this.to));
            } else if (s2 > 1) {
                ForkJoinQuickSort2.invokeAll(new ForkJoinQuickSort2(x, y, this.from, this.from + s2));
            } else {
                ForkJoinQuickSort2.invokeAll(new ForkJoinQuickSort2(x, y, this.to - t, this.to));
            }
        }
    }

    protected static class ForkJoinQuickSortIndirect
    extends RecursiveAction {
        private static final long serialVersionUID = 1L;
        private final int from;
        private final int to;
        private final int[] perm;
        private final char[] x;

        public ForkJoinQuickSortIndirect(int[] perm, char[] x, int from2, int to2) {
            this.from = from2;
            this.to = to2;
            this.x = x;
            this.perm = perm;
        }

        @Override
        protected void compute() {
            int c;
            int a;
            char[] x = this.x;
            int len = this.to - this.from;
            if (len < 8192) {
                CharArrays.quickSortIndirect(this.perm, x, this.from, this.to);
                return;
            }
            int m3 = this.from + len / 2;
            int l = this.from;
            int n = this.to - 1;
            int s2 = len / 8;
            l = CharArrays.med3Indirect(this.perm, x, l, l + s2, l + 2 * s2);
            m3 = CharArrays.med3Indirect(this.perm, x, m3 - s2, m3, m3 + s2);
            n = CharArrays.med3Indirect(this.perm, x, n - 2 * s2, n - s2, n);
            m3 = CharArrays.med3Indirect(this.perm, x, l, m3, n);
            char v = x[this.perm[m3]];
            int b = a = this.from;
            int d = c = this.to - 1;
            while (true) {
                int comparison;
                if (b <= c && (comparison = Character.compare(x[this.perm[b]], v)) <= 0) {
                    if (comparison == 0) {
                        IntArrays.swap(this.perm, a++, b);
                    }
                    ++b;
                    continue;
                }
                while (c >= b && (comparison = Character.compare(x[this.perm[c]], v)) >= 0) {
                    if (comparison == 0) {
                        IntArrays.swap(this.perm, c, d--);
                    }
                    --c;
                }
                if (b > c) break;
                IntArrays.swap(this.perm, b++, c--);
            }
            s2 = Math.min(a - this.from, b - a);
            IntArrays.swap(this.perm, this.from, b - s2, s2);
            s2 = Math.min(d - c, this.to - d - 1);
            IntArrays.swap(this.perm, b, this.to - s2, s2);
            s2 = b - a;
            int t = d - c;
            if (s2 > 1 && t > 1) {
                ForkJoinQuickSortIndirect.invokeAll(new ForkJoinQuickSortIndirect(this.perm, x, this.from, this.from + s2), new ForkJoinQuickSortIndirect(this.perm, x, this.to - t, this.to));
            } else if (s2 > 1) {
                ForkJoinQuickSortIndirect.invokeAll(new ForkJoinQuickSortIndirect(this.perm, x, this.from, this.from + s2));
            } else {
                ForkJoinQuickSortIndirect.invokeAll(new ForkJoinQuickSortIndirect(this.perm, x, this.to - t, this.to));
            }
        }
    }

    protected static class ForkJoinQuickSort
    extends RecursiveAction {
        private static final long serialVersionUID = 1L;
        private final int from;
        private final int to;
        private final char[] x;

        public ForkJoinQuickSort(char[] x, int from2, int to2) {
            this.from = from2;
            this.to = to2;
            this.x = x;
        }

        @Override
        protected void compute() {
            int c;
            int a;
            char[] x = this.x;
            int len = this.to - this.from;
            if (len < 8192) {
                CharArrays.quickSort(x, this.from, this.to);
                return;
            }
            int m3 = this.from + len / 2;
            int l = this.from;
            int n = this.to - 1;
            int s2 = len / 8;
            l = CharArrays.med3(x, l, l + s2, l + 2 * s2);
            m3 = CharArrays.med3(x, m3 - s2, m3, m3 + s2);
            n = CharArrays.med3(x, n - 2 * s2, n - s2, n);
            m3 = CharArrays.med3(x, l, m3, n);
            char v = x[m3];
            int b = a = this.from;
            int d = c = this.to - 1;
            while (true) {
                int comparison;
                if (b <= c && (comparison = Character.compare(x[b], v)) <= 0) {
                    if (comparison == 0) {
                        CharArrays.swap(x, a++, b);
                    }
                    ++b;
                    continue;
                }
                while (c >= b && (comparison = Character.compare(x[c], v)) >= 0) {
                    if (comparison == 0) {
                        CharArrays.swap(x, c, d--);
                    }
                    --c;
                }
                if (b > c) break;
                CharArrays.swap(x, b++, c--);
            }
            s2 = Math.min(a - this.from, b - a);
            CharArrays.swap(x, this.from, b - s2, s2);
            s2 = Math.min(d - c, this.to - d - 1);
            CharArrays.swap(x, b, this.to - s2, s2);
            s2 = b - a;
            int t = d - c;
            if (s2 > 1 && t > 1) {
                ForkJoinQuickSort.invokeAll(new ForkJoinQuickSort(x, this.from, this.from + s2), new ForkJoinQuickSort(x, this.to - t, this.to));
            } else if (s2 > 1) {
                ForkJoinQuickSort.invokeAll(new ForkJoinQuickSort(x, this.from, this.from + s2));
            } else {
                ForkJoinQuickSort.invokeAll(new ForkJoinQuickSort(x, this.to - t, this.to));
            }
        }
    }

    protected static class ForkJoinQuickSortComp
    extends RecursiveAction {
        private static final long serialVersionUID = 1L;
        private final int from;
        private final int to;
        private final char[] x;
        private final CharComparator comp;

        public ForkJoinQuickSortComp(char[] x, int from2, int to2, CharComparator comp) {
            this.from = from2;
            this.to = to2;
            this.x = x;
            this.comp = comp;
        }

        @Override
        protected void compute() {
            int c;
            int a;
            char[] x = this.x;
            int len = this.to - this.from;
            if (len < 8192) {
                CharArrays.quickSort(x, this.from, this.to, this.comp);
                return;
            }
            int m3 = this.from + len / 2;
            int l = this.from;
            int n = this.to - 1;
            int s2 = len / 8;
            l = CharArrays.med3(x, l, l + s2, l + 2 * s2, this.comp);
            m3 = CharArrays.med3(x, m3 - s2, m3, m3 + s2, this.comp);
            n = CharArrays.med3(x, n - 2 * s2, n - s2, n, this.comp);
            m3 = CharArrays.med3(x, l, m3, n, this.comp);
            char v = x[m3];
            int b = a = this.from;
            int d = c = this.to - 1;
            while (true) {
                int comparison;
                if (b <= c && (comparison = this.comp.compare(x[b], v)) <= 0) {
                    if (comparison == 0) {
                        CharArrays.swap(x, a++, b);
                    }
                    ++b;
                    continue;
                }
                while (c >= b && (comparison = this.comp.compare(x[c], v)) >= 0) {
                    if (comparison == 0) {
                        CharArrays.swap(x, c, d--);
                    }
                    --c;
                }
                if (b > c) break;
                CharArrays.swap(x, b++, c--);
            }
            s2 = Math.min(a - this.from, b - a);
            CharArrays.swap(x, this.from, b - s2, s2);
            s2 = Math.min(d - c, this.to - d - 1);
            CharArrays.swap(x, b, this.to - s2, s2);
            s2 = b - a;
            int t = d - c;
            if (s2 > 1 && t > 1) {
                ForkJoinQuickSortComp.invokeAll(new ForkJoinQuickSortComp(x, this.from, this.from + s2, this.comp), new ForkJoinQuickSortComp(x, this.to - t, this.to, this.comp));
            } else if (s2 > 1) {
                ForkJoinQuickSortComp.invokeAll(new ForkJoinQuickSortComp(x, this.from, this.from + s2, this.comp));
            } else {
                ForkJoinQuickSortComp.invokeAll(new ForkJoinQuickSortComp(x, this.to - t, this.to, this.comp));
            }
        }
    }
}

