/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.floats;

import it.unimi.dsi.fastutil.floats.FloatComparator;

public final class FloatHeaps {
    private FloatHeaps() {
    }

    public static int downHeap(float[] heap, int size2, int i, FloatComparator c) {
        assert (i < size2);
        float e = heap[i];
        if (c == null) {
            int child;
            while ((child = (i << 1) + 1) < size2) {
                float t = heap[child];
                int right2 = child + 1;
                if (right2 < size2 && Float.compare(heap[right2], t) < 0) {
                    child = right2;
                    t = heap[child];
                }
                if (Float.compare(e, t) > 0) {
                    heap[i] = t;
                    i = child;
                    continue;
                }
                break;
            }
        } else {
            int child;
            while ((child = (i << 1) + 1) < size2) {
                float t = heap[child];
                int right3 = child + 1;
                if (right3 < size2 && c.compare(heap[right3], t) < 0) {
                    child = right3;
                    t = heap[child];
                }
                if (c.compare(e, t) > 0) {
                    heap[i] = t;
                    i = child;
                    continue;
                }
                break;
            }
        }
        heap[i] = e;
        return i;
    }

    public static int upHeap(float[] heap, int size2, int i, FloatComparator c) {
        assert (i < size2);
        float e = heap[i];
        if (c == null) {
            int parent;
            float t;
            while (i != 0 && Float.compare(t = heap[parent = i - 1 >>> 1], e) > 0) {
                heap[i] = t;
                i = parent;
            }
        } else {
            int parent;
            float t;
            while (i != 0 && c.compare(t = heap[parent = i - 1 >>> 1], e) > 0) {
                heap[i] = t;
                i = parent;
            }
        }
        heap[i] = e;
        return i;
    }

    public static void makeHeap(float[] heap, int size2, FloatComparator c) {
        int i = size2 >>> 1;
        while (i-- != 0) {
            FloatHeaps.downHeap(heap, size2, i, c);
        }
    }
}

