/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.longs;

import it.unimi.dsi.fastutil.BigArrays;
import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.bytes.ByteBigArrays;
import it.unimi.dsi.fastutil.longs.LongArrays;
import it.unimi.dsi.fastutil.longs.LongComparator;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Random;

public final class LongBigArrays {
    public static final long[][] EMPTY_BIG_ARRAY = new long[0][];
    public static final Hash.Strategy HASH_STRATEGY = new BigArrayHashStrategy();
    private static final int SMALL = 7;
    private static final int MEDIUM = 40;
    private static final int DIGIT_BITS = 8;
    private static final int DIGIT_MASK = 255;
    private static final int DIGITS_PER_ELEMENT = 8;

    private LongBigArrays() {
    }

    public static long get(long[][] array2, long index2) {
        return array2[BigArrays.segment(index2)][BigArrays.displacement(index2)];
    }

    public static void set(long[][] array2, long index2, long value2) {
        array2[BigArrays.segment((long)index2)][BigArrays.displacement((long)index2)] = value2;
    }

    public static void swap(long[][] array2, long first2, long second2) {
        long t = array2[BigArrays.segment(first2)][BigArrays.displacement(first2)];
        array2[BigArrays.segment((long)first2)][BigArrays.displacement((long)first2)] = array2[BigArrays.segment(second2)][BigArrays.displacement(second2)];
        array2[BigArrays.segment((long)second2)][BigArrays.displacement((long)second2)] = t;
    }

    public static void add(long[][] array2, long index2, long incr) {
        long[] lArray = array2[BigArrays.segment(index2)];
        int n = BigArrays.displacement(index2);
        lArray[n] = lArray[n] + incr;
    }

    public static void mul(long[][] array2, long index2, long factor) {
        long[] lArray = array2[BigArrays.segment(index2)];
        int n = BigArrays.displacement(index2);
        lArray[n] = lArray[n] * factor;
    }

    public static void incr(long[][] array2, long index2) {
        long[] lArray = array2[BigArrays.segment(index2)];
        int n = BigArrays.displacement(index2);
        lArray[n] = lArray[n] + 1L;
    }

    public static void decr(long[][] array2, long index2) {
        long[] lArray = array2[BigArrays.segment(index2)];
        int n = BigArrays.displacement(index2);
        lArray[n] = lArray[n] - 1L;
    }

    public static long length(long[][] array2) {
        int length = array2.length;
        return length == 0 ? 0L : BigArrays.start(length - 1) + (long)array2[length - 1].length;
    }

    public static void copy(long[][] srcArray, long srcPos, long[][] destArray, long destPos, long length) {
        if (destPos <= srcPos) {
            int srcSegment = BigArrays.segment(srcPos);
            int destSegment = BigArrays.segment(destPos);
            int srcDispl = BigArrays.displacement(srcPos);
            int destDispl = BigArrays.displacement(destPos);
            while (length > 0L) {
                int l = (int)Math.min(length, (long)Math.min(srcArray[srcSegment].length - srcDispl, destArray[destSegment].length - destDispl));
                System.arraycopy(srcArray[srcSegment], srcDispl, destArray[destSegment], destDispl, l);
                if ((srcDispl += l) == 0x8000000) {
                    srcDispl = 0;
                    ++srcSegment;
                }
                if ((destDispl += l) == 0x8000000) {
                    destDispl = 0;
                    ++destSegment;
                }
                length -= (long)l;
            }
        } else {
            int srcSegment = BigArrays.segment(srcPos + length);
            int destSegment = BigArrays.segment(destPos + length);
            int srcDispl = BigArrays.displacement(srcPos + length);
            int destDispl = BigArrays.displacement(destPos + length);
            while (length > 0L) {
                if (srcDispl == 0) {
                    srcDispl = 0x8000000;
                    --srcSegment;
                }
                if (destDispl == 0) {
                    destDispl = 0x8000000;
                    --destSegment;
                }
                int l = (int)Math.min(length, (long)Math.min(srcDispl, destDispl));
                System.arraycopy(srcArray[srcSegment], srcDispl - l, destArray[destSegment], destDispl - l, l);
                srcDispl -= l;
                destDispl -= l;
                length -= (long)l;
            }
        }
    }

    public static void copyFromBig(long[][] srcArray, long srcPos, long[] destArray, int destPos, int length) {
        int srcSegment = BigArrays.segment(srcPos);
        int srcDispl = BigArrays.displacement(srcPos);
        while (length > 0) {
            int l = Math.min(srcArray[srcSegment].length - srcDispl, length);
            System.arraycopy(srcArray[srcSegment], srcDispl, destArray, destPos, l);
            if ((srcDispl += l) == 0x8000000) {
                srcDispl = 0;
                ++srcSegment;
            }
            destPos += l;
            length -= l;
        }
    }

    public static void copyToBig(long[] srcArray, int srcPos, long[][] destArray, long destPos, long length) {
        int destSegment = BigArrays.segment(destPos);
        int destDispl = BigArrays.displacement(destPos);
        while (length > 0L) {
            int l = (int)Math.min((long)(destArray[destSegment].length - destDispl), length);
            System.arraycopy(srcArray, srcPos, destArray[destSegment], destDispl, l);
            if ((destDispl += l) == 0x8000000) {
                destDispl = 0;
                ++destSegment;
            }
            srcPos += l;
            length -= (long)l;
        }
    }

    public static long[][] newBigArray(long length) {
        if (length == 0L) {
            return EMPTY_BIG_ARRAY;
        }
        BigArrays.ensureLength(length);
        int baseLength = (int)(length + 0x7FFFFFFL >>> 27);
        long[][] base = new long[baseLength][];
        int residual = (int)(length & 0x7FFFFFFL);
        if (residual != 0) {
            for (int i = 0; i < baseLength - 1; ++i) {
                base[i] = new long[0x8000000];
            }
            base[baseLength - 1] = new long[residual];
        } else {
            for (int i = 0; i < baseLength; ++i) {
                base[i] = new long[0x8000000];
            }
        }
        return base;
    }

    public static long[][] wrap(long[] array2) {
        if (array2.length == 0) {
            return EMPTY_BIG_ARRAY;
        }
        if (array2.length <= 0x8000000) {
            return new long[][]{array2};
        }
        long[][] bigArray = LongBigArrays.newBigArray(array2.length);
        for (int i = 0; i < bigArray.length; ++i) {
            System.arraycopy(array2, (int)BigArrays.start(i), bigArray[i], 0, bigArray[i].length);
        }
        return bigArray;
    }

    public static long[][] ensureCapacity(long[][] array2, long length) {
        return LongBigArrays.ensureCapacity(array2, length, LongBigArrays.length(array2));
    }

    public static long[][] ensureCapacity(long[][] array2, long length, long preserve) {
        long oldLength = LongBigArrays.length(array2);
        if (length > oldLength) {
            BigArrays.ensureLength(length);
            int valid = array2.length - (array2.length == 0 || array2.length > 0 && array2[array2.length - 1].length == 0x8000000 ? 0 : 1);
            int baseLength = (int)(length + 0x7FFFFFFL >>> 27);
            long[][] base = (long[][])Arrays.copyOf(array2, baseLength);
            int residual = (int)(length & 0x7FFFFFFL);
            if (residual != 0) {
                for (int i = valid; i < baseLength - 1; ++i) {
                    base[i] = new long[0x8000000];
                }
                base[baseLength - 1] = new long[residual];
            } else {
                for (int i = valid; i < baseLength; ++i) {
                    base[i] = new long[0x8000000];
                }
            }
            if (preserve - (long)valid * 0x8000000L > 0L) {
                LongBigArrays.copy(array2, (long)valid * 0x8000000L, base, (long)valid * 0x8000000L, preserve - (long)valid * 0x8000000L);
            }
            return base;
        }
        return array2;
    }

    public static long[][] grow(long[][] array2, long length) {
        long oldLength = LongBigArrays.length(array2);
        return length > oldLength ? LongBigArrays.grow(array2, length, oldLength) : array2;
    }

    public static long[][] grow(long[][] array2, long length, long preserve) {
        long oldLength = LongBigArrays.length(array2);
        return length > oldLength ? LongBigArrays.ensureCapacity(array2, Math.max(2L * oldLength, length), preserve) : array2;
    }

    public static long[][] trim(long[][] array2, long length) {
        BigArrays.ensureLength(length);
        long oldLength = LongBigArrays.length(array2);
        if (length >= oldLength) {
            return array2;
        }
        int baseLength = (int)(length + 0x7FFFFFFL >>> 27);
        long[][] base = (long[][])Arrays.copyOf(array2, baseLength);
        int residual = (int)(length & 0x7FFFFFFL);
        if (residual != 0) {
            base[baseLength - 1] = LongArrays.trim(base[baseLength - 1], residual);
        }
        return base;
    }

    public static long[][] setLength(long[][] array2, long length) {
        long oldLength = LongBigArrays.length(array2);
        if (length == oldLength) {
            return array2;
        }
        if (length < oldLength) {
            return LongBigArrays.trim(array2, length);
        }
        return LongBigArrays.ensureCapacity(array2, length);
    }

    public static long[][] copy(long[][] array2, long offset, long length) {
        LongBigArrays.ensureOffsetLength(array2, offset, length);
        long[][] a = LongBigArrays.newBigArray(length);
        LongBigArrays.copy(array2, offset, a, 0L, length);
        return a;
    }

    public static long[][] copy(long[][] array2) {
        long[][] base = (long[][])array2.clone();
        int i = base.length;
        while (i-- != 0) {
            base[i] = (long[])array2[i].clone();
        }
        return base;
    }

    public static void fill(long[][] array2, long value2) {
        int i = array2.length;
        while (i-- != 0) {
            Arrays.fill(array2[i], value2);
        }
    }

    public static void fill(long[][] array2, long from2, long to2, long value2) {
        long length = LongBigArrays.length(array2);
        BigArrays.ensureFromTo(length, from2, to2);
        int fromSegment = BigArrays.segment(from2);
        int toSegment = BigArrays.segment(to2);
        int fromDispl = BigArrays.displacement(from2);
        int toDispl = BigArrays.displacement(to2);
        if (fromSegment == toSegment) {
            Arrays.fill(array2[fromSegment], fromDispl, toDispl, value2);
            return;
        }
        if (toDispl != 0) {
            Arrays.fill(array2[toSegment], 0, toDispl, value2);
        }
        while (--toSegment > fromSegment) {
            Arrays.fill(array2[toSegment], value2);
        }
        Arrays.fill(array2[fromSegment], fromDispl, 0x8000000, value2);
    }

    public static boolean equals(long[][] a1, long[][] a2) {
        if (LongBigArrays.length(a1) != LongBigArrays.length(a2)) {
            return false;
        }
        int i = a1.length;
        while (i-- != 0) {
            long[] t = a1[i];
            long[] u = a2[i];
            int j = t.length;
            while (j-- != 0) {
                if (t[j] == u[j]) continue;
                return false;
            }
        }
        return true;
    }

    public static String toString(long[][] a) {
        if (a == null) {
            return "null";
        }
        long last2 = LongBigArrays.length(a) - 1L;
        if (last2 == -1L) {
            return "[]";
        }
        StringBuilder b = new StringBuilder();
        b.append('[');
        long i = 0L;
        while (true) {
            b.append(String.valueOf(LongBigArrays.get(a, i)));
            if (i == last2) {
                return b.append(']').toString();
            }
            b.append(", ");
            ++i;
        }
    }

    public static void ensureFromTo(long[][] a, long from2, long to2) {
        BigArrays.ensureFromTo(LongBigArrays.length(a), from2, to2);
    }

    public static void ensureOffsetLength(long[][] a, long offset, long length) {
        BigArrays.ensureOffsetLength(LongBigArrays.length(a), offset, length);
    }

    private static void vecSwap(long[][] x, long a, long b, long n) {
        int i = 0;
        while ((long)i < n) {
            LongBigArrays.swap(x, a, b);
            ++i;
            ++a;
            ++b;
        }
    }

    private static long med3(long[][] x, long a, long b, long c, LongComparator comp) {
        int ab = comp.compare(LongBigArrays.get(x, a), LongBigArrays.get(x, b));
        int ac = comp.compare(LongBigArrays.get(x, a), LongBigArrays.get(x, c));
        int bc = comp.compare(LongBigArrays.get(x, b), LongBigArrays.get(x, c));
        return ab < 0 ? (bc < 0 ? b : (ac < 0 ? c : a)) : (bc > 0 ? b : (ac > 0 ? c : a));
    }

    private static void selectionSort(long[][] a, long from2, long to2, LongComparator comp) {
        for (long i = from2; i < to2 - 1L; ++i) {
            long m3 = i;
            for (long j = i + 1L; j < to2; ++j) {
                if (comp.compare(LongBigArrays.get(a, j), LongBigArrays.get(a, m3)) >= 0) continue;
                m3 = j;
            }
            if (m3 == i) continue;
            LongBigArrays.swap(a, i, m3);
        }
    }

    public static void quickSort(long[][] x, long from2, long to2, LongComparator comp) {
        long c;
        long a;
        long len = to2 - from2;
        if (len < 7L) {
            LongBigArrays.selectionSort(x, from2, to2, comp);
            return;
        }
        long m3 = from2 + len / 2L;
        if (len > 7L) {
            long l = from2;
            long n = to2 - 1L;
            if (len > 40L) {
                long s2 = len / 8L;
                l = LongBigArrays.med3(x, l, l + s2, l + 2L * s2, comp);
                m3 = LongBigArrays.med3(x, m3 - s2, m3, m3 + s2, comp);
                n = LongBigArrays.med3(x, n - 2L * s2, n - s2, n, comp);
            }
            m3 = LongBigArrays.med3(x, l, m3, n, comp);
        }
        long v = LongBigArrays.get(x, m3);
        long b = a = from2;
        long d = c = to2 - 1L;
        while (true) {
            int comparison;
            if (b <= c && (comparison = comp.compare(LongBigArrays.get(x, b), v)) <= 0) {
                if (comparison == 0) {
                    LongBigArrays.swap(x, a++, b);
                }
                ++b;
                continue;
            }
            while (c >= b && (comparison = comp.compare(LongBigArrays.get(x, c), v)) >= 0) {
                if (comparison == 0) {
                    LongBigArrays.swap(x, c, d--);
                }
                --c;
            }
            if (b > c) break;
            LongBigArrays.swap(x, b++, c--);
        }
        long n = to2;
        long s3 = Math.min(a - from2, b - a);
        LongBigArrays.vecSwap(x, from2, b - s3, s3);
        s3 = Math.min(d - c, n - d - 1L);
        LongBigArrays.vecSwap(x, b, n - s3, s3);
        s3 = b - a;
        if (s3 > 1L) {
            LongBigArrays.quickSort(x, from2, from2 + s3, comp);
        }
        if ((s3 = d - c) > 1L) {
            LongBigArrays.quickSort(x, n - s3, n, comp);
        }
    }

    private static long med3(long[][] x, long a, long b, long c) {
        int ab = Long.compare(LongBigArrays.get(x, a), LongBigArrays.get(x, b));
        int ac = Long.compare(LongBigArrays.get(x, a), LongBigArrays.get(x, c));
        int bc = Long.compare(LongBigArrays.get(x, b), LongBigArrays.get(x, c));
        return ab < 0 ? (bc < 0 ? b : (ac < 0 ? c : a)) : (bc > 0 ? b : (ac > 0 ? c : a));
    }

    private static void selectionSort(long[][] a, long from2, long to2) {
        for (long i = from2; i < to2 - 1L; ++i) {
            long m3 = i;
            for (long j = i + 1L; j < to2; ++j) {
                if (LongBigArrays.get(a, j) >= LongBigArrays.get(a, m3)) continue;
                m3 = j;
            }
            if (m3 == i) continue;
            LongBigArrays.swap(a, i, m3);
        }
    }

    public static void quickSort(long[][] x, LongComparator comp) {
        LongBigArrays.quickSort(x, 0L, LongBigArrays.length(x), comp);
    }

    public static void quickSort(long[][] x, long from2, long to2) {
        long c;
        long a;
        long len = to2 - from2;
        if (len < 7L) {
            LongBigArrays.selectionSort(x, from2, to2);
            return;
        }
        long m3 = from2 + len / 2L;
        if (len > 7L) {
            long l = from2;
            long n = to2 - 1L;
            if (len > 40L) {
                long s2 = len / 8L;
                l = LongBigArrays.med3(x, l, l + s2, l + 2L * s2);
                m3 = LongBigArrays.med3(x, m3 - s2, m3, m3 + s2);
                n = LongBigArrays.med3(x, n - 2L * s2, n - s2, n);
            }
            m3 = LongBigArrays.med3(x, l, m3, n);
        }
        long v = LongBigArrays.get(x, m3);
        long b = a = from2;
        long d = c = to2 - 1L;
        while (true) {
            int comparison;
            if (b <= c && (comparison = Long.compare(LongBigArrays.get(x, b), v)) <= 0) {
                if (comparison == 0) {
                    LongBigArrays.swap(x, a++, b);
                }
                ++b;
                continue;
            }
            while (c >= b && (comparison = Long.compare(LongBigArrays.get(x, c), v)) >= 0) {
                if (comparison == 0) {
                    LongBigArrays.swap(x, c, d--);
                }
                --c;
            }
            if (b > c) break;
            LongBigArrays.swap(x, b++, c--);
        }
        long n = to2;
        long s3 = Math.min(a - from2, b - a);
        LongBigArrays.vecSwap(x, from2, b - s3, s3);
        s3 = Math.min(d - c, n - d - 1L);
        LongBigArrays.vecSwap(x, b, n - s3, s3);
        s3 = b - a;
        if (s3 > 1L) {
            LongBigArrays.quickSort(x, from2, from2 + s3);
        }
        if ((s3 = d - c) > 1L) {
            LongBigArrays.quickSort(x, n - s3, n);
        }
    }

    public static void quickSort(long[][] x) {
        LongBigArrays.quickSort(x, 0L, LongBigArrays.length(x));
    }

    public static long binarySearch(long[][] a, long from2, long to2, long key) {
        --to2;
        while (from2 <= to2) {
            long mid = from2 + to2 >>> 1;
            long midVal = LongBigArrays.get(a, mid);
            if (midVal < key) {
                from2 = mid + 1L;
                continue;
            }
            if (midVal > key) {
                to2 = mid - 1L;
                continue;
            }
            return mid;
        }
        return -(from2 + 1L);
    }

    public static long binarySearch(long[][] a, long key) {
        return LongBigArrays.binarySearch(a, 0L, LongBigArrays.length(a), key);
    }

    public static long binarySearch(long[][] a, long from2, long to2, long key, LongComparator c) {
        --to2;
        while (from2 <= to2) {
            long mid = from2 + to2 >>> 1;
            long midVal = LongBigArrays.get(a, mid);
            int cmp = c.compare(midVal, key);
            if (cmp < 0) {
                from2 = mid + 1L;
                continue;
            }
            if (cmp > 0) {
                to2 = mid - 1L;
                continue;
            }
            return mid;
        }
        return -(from2 + 1L);
    }

    public static long binarySearch(long[][] a, long key, LongComparator c) {
        return LongBigArrays.binarySearch(a, 0L, LongBigArrays.length(a), key, c);
    }

    public static void radixSort(long[][] a) {
        LongBigArrays.radixSort(a, 0L, LongBigArrays.length(a));
    }

    public static void radixSort(long[][] a, long from2, long to2) {
        int maxLevel = 7;
        int stackSize = 1786;
        long[] offsetStack = new long[1786];
        int offsetPos = 0;
        long[] lengthStack = new long[1786];
        int lengthPos = 0;
        int[] levelStack = new int[1786];
        int levelPos = 0;
        offsetStack[offsetPos++] = from2;
        lengthStack[lengthPos++] = to2 - from2;
        levelStack[levelPos++] = 0;
        long[] count2 = new long[256];
        long[] pos = new long[256];
        byte[][] digit = ByteBigArrays.newBigArray(to2 - from2);
        while (offsetPos > 0) {
            int level;
            int signMask;
            long first2 = offsetStack[--offsetPos];
            long length = lengthStack[--lengthPos];
            int n = signMask = (level = levelStack[--levelPos]) % 8 == 0 ? 128 : 0;
            if (length < 40L) {
                LongBigArrays.selectionSort(a, first2, first2 + length);
                continue;
            }
            int shift2 = (7 - level % 8) * 8;
            long i = length;
            while (i-- != 0L) {
                ByteBigArrays.set(digit, i, (byte)(LongBigArrays.get(a, first2 + i) >>> shift2 & 0xFFL ^ (long)signMask));
            }
            i = length;
            while (i-- != 0L) {
                int n2 = ByteBigArrays.get(digit, i) & 0xFF;
                count2[n2] = count2[n2] + 1L;
            }
            int lastUsed = -1;
            long p = 0L;
            for (int i2 = 0; i2 < 256; ++i2) {
                if (count2[i2] != 0L) {
                    lastUsed = i2;
                    if (level < 7 && count2[i2] > 1L) {
                        offsetStack[offsetPos++] = p + first2;
                        lengthStack[lengthPos++] = count2[i2];
                        levelStack[levelPos++] = level + 1;
                    }
                }
                pos[i2] = p += count2[i2];
            }
            long end2 = length - count2[lastUsed];
            count2[lastUsed] = 0L;
            int c = -1;
            for (long i3 = 0L; i3 < end2; i3 += count2[c]) {
                long t = LongBigArrays.get(a, i3 + first2);
                c = ByteBigArrays.get(digit, i3) & 0xFF;
                while (true) {
                    int n3 = c;
                    long l = pos[n3] - 1L;
                    pos[n3] = l;
                    long d = l;
                    if (l <= i3) break;
                    long z = t;
                    int zz = c;
                    t = LongBigArrays.get(a, d + first2);
                    c = ByteBigArrays.get(digit, d) & 0xFF;
                    LongBigArrays.set(a, d + first2, z);
                    ByteBigArrays.set(digit, d, (byte)zz);
                }
                LongBigArrays.set(a, i3 + first2, t);
                count2[c] = 0L;
            }
        }
    }

    private static void selectionSort(long[][] a, long[][] b, long from2, long to2) {
        for (long i = from2; i < to2 - 1L; ++i) {
            long m3 = i;
            for (long j = i + 1L; j < to2; ++j) {
                if (LongBigArrays.get(a, j) >= LongBigArrays.get(a, m3) && (LongBigArrays.get(a, j) != LongBigArrays.get(a, m3) || LongBigArrays.get(b, j) >= LongBigArrays.get(b, m3))) continue;
                m3 = j;
            }
            if (m3 == i) continue;
            long t = LongBigArrays.get(a, i);
            LongBigArrays.set(a, i, LongBigArrays.get(a, m3));
            LongBigArrays.set(a, m3, t);
            t = LongBigArrays.get(b, i);
            LongBigArrays.set(b, i, LongBigArrays.get(b, m3));
            LongBigArrays.set(b, m3, t);
        }
    }

    public static void radixSort(long[][] a, long[][] b) {
        LongBigArrays.radixSort(a, b, 0L, LongBigArrays.length(a));
    }

    public static void radixSort(long[][] a, long[][] b, long from2, long to2) {
        int layers = 2;
        if (LongBigArrays.length(a) != LongBigArrays.length(b)) {
            throw new IllegalArgumentException("Array size mismatch.");
        }
        int maxLevel = 15;
        int stackSize = 3826;
        long[] offsetStack = new long[3826];
        int offsetPos = 0;
        long[] lengthStack = new long[3826];
        int lengthPos = 0;
        int[] levelStack = new int[3826];
        int levelPos = 0;
        offsetStack[offsetPos++] = from2;
        lengthStack[lengthPos++] = to2 - from2;
        levelStack[levelPos++] = 0;
        long[] count2 = new long[256];
        long[] pos = new long[256];
        byte[][] digit = ByteBigArrays.newBigArray(to2 - from2);
        while (offsetPos > 0) {
            int level;
            int signMask;
            long first2 = offsetStack[--offsetPos];
            long length = lengthStack[--lengthPos];
            int n = signMask = (level = levelStack[--levelPos]) % 8 == 0 ? 128 : 0;
            if (length < 40L) {
                LongBigArrays.selectionSort(a, b, first2, first2 + length);
                continue;
            }
            long[][] k = level < 8 ? a : b;
            int shift2 = (7 - level % 8) * 8;
            long i = length;
            while (i-- != 0L) {
                ByteBigArrays.set(digit, i, (byte)(LongBigArrays.get(k, first2 + i) >>> shift2 & 0xFFL ^ (long)signMask));
            }
            i = length;
            while (i-- != 0L) {
                int n2 = ByteBigArrays.get(digit, i) & 0xFF;
                count2[n2] = count2[n2] + 1L;
            }
            int lastUsed = -1;
            long p = 0L;
            for (int i2 = 0; i2 < 256; ++i2) {
                if (count2[i2] != 0L) {
                    lastUsed = i2;
                    if (level < 15 && count2[i2] > 1L) {
                        offsetStack[offsetPos++] = p + first2;
                        lengthStack[lengthPos++] = count2[i2];
                        levelStack[levelPos++] = level + 1;
                    }
                }
                pos[i2] = p += count2[i2];
            }
            long end2 = length - count2[lastUsed];
            count2[lastUsed] = 0L;
            int c = -1;
            for (long i3 = 0L; i3 < end2; i3 += count2[c]) {
                long t = LongBigArrays.get(a, i3 + first2);
                long u = LongBigArrays.get(b, i3 + first2);
                c = ByteBigArrays.get(digit, i3) & 0xFF;
                while (true) {
                    int n3 = c;
                    long l = pos[n3] - 1L;
                    pos[n3] = l;
                    long d = l;
                    if (l <= i3) break;
                    long z = t;
                    int zz = c;
                    t = LongBigArrays.get(a, d + first2);
                    LongBigArrays.set(a, d + first2, z);
                    z = u;
                    u = LongBigArrays.get(b, d + first2);
                    LongBigArrays.set(b, d + first2, z);
                    c = ByteBigArrays.get(digit, d) & 0xFF;
                    ByteBigArrays.set(digit, d, (byte)zz);
                }
                LongBigArrays.set(a, i3 + first2, t);
                LongBigArrays.set(b, i3 + first2, u);
                count2[c] = 0L;
            }
        }
    }

    public static long[][] shuffle(long[][] a, long from2, long to2, Random random) {
        long i = to2 - from2;
        while (i-- != 0L) {
            long p = (random.nextLong() & Long.MAX_VALUE) % (i + 1L);
            long t = LongBigArrays.get(a, from2 + i);
            LongBigArrays.set(a, from2 + i, LongBigArrays.get(a, from2 + p));
            LongBigArrays.set(a, from2 + p, t);
        }
        return a;
    }

    public static long[][] shuffle(long[][] a, Random random) {
        long i = LongBigArrays.length(a);
        while (i-- != 0L) {
            long p = (random.nextLong() & Long.MAX_VALUE) % (i + 1L);
            long t = LongBigArrays.get(a, i);
            LongBigArrays.set(a, i, LongBigArrays.get(a, p));
            LongBigArrays.set(a, p, t);
        }
        return a;
    }

    private static final class BigArrayHashStrategy
    implements Hash.Strategy<long[][]>,
    Serializable {
        private static final long serialVersionUID = -7046029254386353129L;

        private BigArrayHashStrategy() {
        }

        @Override
        public int hashCode(long[][] o) {
            return Arrays.deepHashCode((Object[])o);
        }

        @Override
        public boolean equals(long[][] a, long[][] b) {
            return LongBigArrays.equals(a, b);
        }
    }
}

