/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.objects;

import it.unimi.dsi.fastutil.booleans.AbstractBooleanCollection;
import it.unimi.dsi.fastutil.booleans.BooleanCollection;
import it.unimi.dsi.fastutil.booleans.BooleanIterator;
import it.unimi.dsi.fastutil.objects.AbstractObjectSet;
import it.unimi.dsi.fastutil.objects.AbstractReference2BooleanFunction;
import it.unimi.dsi.fastutil.objects.AbstractReferenceSet;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.Reference2BooleanMap;
import it.unimi.dsi.fastutil.objects.Reference2BooleanMaps;
import it.unimi.dsi.fastutil.objects.ReferenceSet;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;

public abstract class AbstractReference2BooleanMap<K>
extends AbstractReference2BooleanFunction<K>
implements Reference2BooleanMap<K>,
Serializable {
    private static final long serialVersionUID = -4940583368468432370L;

    protected AbstractReference2BooleanMap() {
    }

    @Override
    public boolean containsValue(boolean v) {
        return this.values().contains(v);
    }

    @Override
    public boolean containsKey(Object k) {
        Iterator i = this.reference2BooleanEntrySet().iterator();
        while (i.hasNext()) {
            if (((Reference2BooleanMap.Entry)i.next()).getKey() != k) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public ReferenceSet<K> keySet() {
        return new AbstractReferenceSet<K>(){

            @Override
            public boolean contains(Object k) {
                return AbstractReference2BooleanMap.this.containsKey(k);
            }

            @Override
            public int size() {
                return AbstractReference2BooleanMap.this.size();
            }

            @Override
            public void clear() {
                AbstractReference2BooleanMap.this.clear();
            }

            @Override
            public ObjectIterator<K> iterator() {
                return new ObjectIterator<K>(){
                    private final ObjectIterator<Reference2BooleanMap.Entry<K>> i;
                    {
                        this.i = Reference2BooleanMaps.fastIterator(AbstractReference2BooleanMap.this);
                    }

                    @Override
                    public K next() {
                        return ((Reference2BooleanMap.Entry)this.i.next()).getKey();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.i.hasNext();
                    }

                    @Override
                    public void remove() {
                        this.i.remove();
                    }
                };
            }
        };
    }

    @Override
    public BooleanCollection values() {
        return new AbstractBooleanCollection(){

            @Override
            public boolean contains(boolean k) {
                return AbstractReference2BooleanMap.this.containsValue(k);
            }

            @Override
            public int size() {
                return AbstractReference2BooleanMap.this.size();
            }

            @Override
            public void clear() {
                AbstractReference2BooleanMap.this.clear();
            }

            @Override
            public BooleanIterator iterator() {
                return new BooleanIterator(){
                    private final ObjectIterator<Reference2BooleanMap.Entry<K>> i;
                    {
                        this.i = Reference2BooleanMaps.fastIterator(AbstractReference2BooleanMap.this);
                    }

                    @Override
                    public boolean nextBoolean() {
                        return ((Reference2BooleanMap.Entry)this.i.next()).getBooleanValue();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.i.hasNext();
                    }
                };
            }
        };
    }

    @Override
    public void putAll(Map<? extends K, ? extends Boolean> m3) {
        if (m3 instanceof Reference2BooleanMap) {
            ObjectIterator i = Reference2BooleanMaps.fastIterator((Reference2BooleanMap)m3);
            while (i.hasNext()) {
                Reference2BooleanMap.Entry e = (Reference2BooleanMap.Entry)i.next();
                this.put(e.getKey(), e.getBooleanValue());
            }
        } else {
            int n = m3.size();
            Iterator<Map.Entry<K, Boolean>> i = m3.entrySet().iterator();
            while (n-- != 0) {
                Map.Entry<K, Boolean> e = i.next();
                this.put(e.getKey(), e.getValue());
            }
        }
    }

    @Override
    public int hashCode() {
        int h2 = 0;
        int n = this.size();
        ObjectIterator i = Reference2BooleanMaps.fastIterator(this);
        while (n-- != 0) {
            h2 += ((Reference2BooleanMap.Entry)i.next()).hashCode();
        }
        return h2;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Map)) {
            return false;
        }
        Map m3 = (Map)o;
        if (m3.size() != this.size()) {
            return false;
        }
        return this.reference2BooleanEntrySet().containsAll(m3.entrySet());
    }

    public String toString() {
        StringBuilder s2 = new StringBuilder();
        ObjectIterator i = Reference2BooleanMaps.fastIterator(this);
        int n = this.size();
        boolean first2 = true;
        s2.append("{");
        while (n-- != 0) {
            if (first2) {
                first2 = false;
            } else {
                s2.append(", ");
            }
            Reference2BooleanMap.Entry e = (Reference2BooleanMap.Entry)i.next();
            if (this == e.getKey()) {
                s2.append("(this map)");
            } else {
                s2.append(String.valueOf(e.getKey()));
            }
            s2.append("=>");
            s2.append(String.valueOf(e.getBooleanValue()));
        }
        s2.append("}");
        return s2.toString();
    }

    public static abstract class BasicEntrySet<K>
    extends AbstractObjectSet<Reference2BooleanMap.Entry<K>> {
        protected final Reference2BooleanMap<K> map;

        public BasicEntrySet(Reference2BooleanMap<K> map23) {
            this.map = map23;
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            if (o instanceof Reference2BooleanMap.Entry) {
                Reference2BooleanMap.Entry e = (Reference2BooleanMap.Entry)o;
                Object k = e.getKey();
                return this.map.containsKey(k) && this.map.getBoolean(k) == e.getBooleanValue();
            }
            Map.Entry e = (Map.Entry)o;
            Object k = e.getKey();
            Object value2 = e.getValue();
            if (value2 == null || !(value2 instanceof Boolean)) {
                return false;
            }
            return this.map.containsKey(k) && this.map.getBoolean(k) == ((Boolean)value2).booleanValue();
        }

        @Override
        public boolean remove(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            if (o instanceof Reference2BooleanMap.Entry) {
                Reference2BooleanMap.Entry e = (Reference2BooleanMap.Entry)o;
                return this.map.remove(e.getKey(), e.getBooleanValue());
            }
            Map.Entry e = (Map.Entry)o;
            Object k = e.getKey();
            Object value2 = e.getValue();
            if (value2 == null || !(value2 instanceof Boolean)) {
                return false;
            }
            boolean v = (Boolean)value2;
            return this.map.remove(k, v);
        }

        @Override
        public int size() {
            return this.map.size();
        }
    }

    public static class BasicEntry<K>
    implements Reference2BooleanMap.Entry<K> {
        protected K key;
        protected boolean value;

        public BasicEntry() {
        }

        public BasicEntry(K key, Boolean value2) {
            this.key = key;
            this.value = value2;
        }

        public BasicEntry(K key, boolean value2) {
            this.key = key;
            this.value = value2;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public boolean getBooleanValue() {
            return this.value;
        }

        @Override
        public boolean setValue(boolean value2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            if (o instanceof Reference2BooleanMap.Entry) {
                Reference2BooleanMap.Entry e = (Reference2BooleanMap.Entry)o;
                return this.key == e.getKey() && this.value == e.getBooleanValue();
            }
            Map.Entry e = (Map.Entry)o;
            Object key = e.getKey();
            Object value2 = e.getValue();
            if (value2 == null || !(value2 instanceof Boolean)) {
                return false;
            }
            return this.key == key && this.value == (Boolean)value2;
        }

        @Override
        public int hashCode() {
            return System.identityHashCode(this.key) ^ (this.value ? 1231 : 1237);
        }

        public String toString() {
            return this.key + "->" + this.value;
        }
    }
}

