/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.objects;

import it.unimi.dsi.fastutil.objects.AbstractObject2ShortMap;
import it.unimi.dsi.fastutil.objects.Object2ShortMap;
import it.unimi.dsi.fastutil.objects.Object2ShortMaps;
import it.unimi.dsi.fastutil.objects.Object2ShortSortedMap;
import it.unimi.dsi.fastutil.objects.ObjectBidirectionalIterable;
import it.unimi.dsi.fastutil.objects.ObjectBidirectionalIterator;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import it.unimi.dsi.fastutil.objects.ObjectSortedSet;
import it.unimi.dsi.fastutil.objects.ObjectSortedSets;
import java.io.Serializable;
import java.util.Comparator;
import java.util.Map;
import java.util.NoSuchElementException;

public final class Object2ShortSortedMaps {
    public static final EmptySortedMap EMPTY_MAP = new EmptySortedMap();

    private Object2ShortSortedMaps() {
    }

    public static <K> Comparator<? super Map.Entry<K, ?>> entryComparator(Comparator<? super K> comparator) {
        return (x, y) -> comparator.compare((Object)x.getKey(), (Object)y.getKey());
    }

    public static <K> ObjectBidirectionalIterator<Object2ShortMap.Entry<K>> fastIterator(Object2ShortSortedMap<K> map23) {
        ObjectSet entries = map23.object2ShortEntrySet();
        return entries instanceof Object2ShortSortedMap.FastSortedEntrySet ? ((Object2ShortSortedMap.FastSortedEntrySet)entries).fastIterator() : entries.iterator();
    }

    public static <K> ObjectBidirectionalIterable<Object2ShortMap.Entry<K>> fastIterable(Object2ShortSortedMap<K> map23) {
        ObjectSet entries = map23.object2ShortEntrySet();
        return entries instanceof Object2ShortSortedMap.FastSortedEntrySet ? ((Object2ShortSortedMap.FastSortedEntrySet)entries)::fastIterator : entries;
    }

    public static <K> Object2ShortSortedMap<K> emptyMap() {
        return EMPTY_MAP;
    }

    public static <K> Object2ShortSortedMap<K> singleton(K key, Short value2) {
        return new Singleton<K>(key, value2);
    }

    public static <K> Object2ShortSortedMap<K> singleton(K key, Short value2, Comparator<? super K> comparator) {
        return new Singleton<K>(key, value2, comparator);
    }

    public static <K> Object2ShortSortedMap<K> singleton(K key, short value2) {
        return new Singleton<K>(key, value2);
    }

    public static <K> Object2ShortSortedMap<K> singleton(K key, short value2, Comparator<? super K> comparator) {
        return new Singleton<K>(key, value2, comparator);
    }

    public static <K> Object2ShortSortedMap<K> synchronize(Object2ShortSortedMap<K> m3) {
        return new SynchronizedSortedMap<K>(m3);
    }

    public static <K> Object2ShortSortedMap<K> synchronize(Object2ShortSortedMap<K> m3, Object sync) {
        return new SynchronizedSortedMap<K>(m3, sync);
    }

    public static <K> Object2ShortSortedMap<K> unmodifiable(Object2ShortSortedMap<K> m3) {
        return new UnmodifiableSortedMap<K>(m3);
    }

    public static class UnmodifiableSortedMap<K>
    extends Object2ShortMaps.UnmodifiableMap<K>
    implements Object2ShortSortedMap<K>,
    Serializable {
        private static final long serialVersionUID = -7046029254386353129L;
        protected final Object2ShortSortedMap<K> sortedMap;

        protected UnmodifiableSortedMap(Object2ShortSortedMap<K> m3) {
            super(m3);
            this.sortedMap = m3;
        }

        @Override
        public Comparator<? super K> comparator() {
            return this.sortedMap.comparator();
        }

        @Override
        public ObjectSortedSet<Object2ShortMap.Entry<K>> object2ShortEntrySet() {
            if (this.entries == null) {
                this.entries = ObjectSortedSets.unmodifiable(this.sortedMap.object2ShortEntrySet());
            }
            return (ObjectSortedSet)this.entries;
        }

        @Override
        @Deprecated
        public ObjectSortedSet<Map.Entry<K, Short>> entrySet() {
            return this.object2ShortEntrySet();
        }

        @Override
        public ObjectSortedSet<K> keySet() {
            if (this.keys == null) {
                this.keys = ObjectSortedSets.unmodifiable(this.sortedMap.keySet());
            }
            return (ObjectSortedSet)this.keys;
        }

        @Override
        public Object2ShortSortedMap<K> subMap(K from2, K to2) {
            return new UnmodifiableSortedMap<K>(this.sortedMap.subMap((Object)from2, (Object)to2));
        }

        @Override
        public Object2ShortSortedMap<K> headMap(K to2) {
            return new UnmodifiableSortedMap<K>(this.sortedMap.headMap((Object)to2));
        }

        @Override
        public Object2ShortSortedMap<K> tailMap(K from2) {
            return new UnmodifiableSortedMap<K>(this.sortedMap.tailMap((Object)from2));
        }

        @Override
        public K firstKey() {
            return this.sortedMap.firstKey();
        }

        @Override
        public K lastKey() {
            return this.sortedMap.lastKey();
        }
    }

    public static class SynchronizedSortedMap<K>
    extends Object2ShortMaps.SynchronizedMap<K>
    implements Object2ShortSortedMap<K>,
    Serializable {
        private static final long serialVersionUID = -7046029254386353129L;
        protected final Object2ShortSortedMap<K> sortedMap;

        protected SynchronizedSortedMap(Object2ShortSortedMap<K> m3, Object sync) {
            super(m3, sync);
            this.sortedMap = m3;
        }

        protected SynchronizedSortedMap(Object2ShortSortedMap<K> m3) {
            super(m3);
            this.sortedMap = m3;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Comparator<? super K> comparator() {
            Object object = this.sync;
            synchronized (object) {
                return this.sortedMap.comparator();
            }
        }

        @Override
        public ObjectSortedSet<Object2ShortMap.Entry<K>> object2ShortEntrySet() {
            if (this.entries == null) {
                this.entries = ObjectSortedSets.synchronize(this.sortedMap.object2ShortEntrySet(), this.sync);
            }
            return (ObjectSortedSet)this.entries;
        }

        @Override
        @Deprecated
        public ObjectSortedSet<Map.Entry<K, Short>> entrySet() {
            return this.object2ShortEntrySet();
        }

        @Override
        public ObjectSortedSet<K> keySet() {
            if (this.keys == null) {
                this.keys = ObjectSortedSets.synchronize(this.sortedMap.keySet(), this.sync);
            }
            return (ObjectSortedSet)this.keys;
        }

        @Override
        public Object2ShortSortedMap<K> subMap(K from2, K to2) {
            return new SynchronizedSortedMap<K>(this.sortedMap.subMap((Object)from2, (Object)to2), this.sync);
        }

        @Override
        public Object2ShortSortedMap<K> headMap(K to2) {
            return new SynchronizedSortedMap<K>(this.sortedMap.headMap((Object)to2), this.sync);
        }

        @Override
        public Object2ShortSortedMap<K> tailMap(K from2) {
            return new SynchronizedSortedMap<K>(this.sortedMap.tailMap((Object)from2), this.sync);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public K firstKey() {
            Object object = this.sync;
            synchronized (object) {
                return this.sortedMap.firstKey();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public K lastKey() {
            Object object = this.sync;
            synchronized (object) {
                return this.sortedMap.lastKey();
            }
        }
    }

    public static class Singleton<K>
    extends Object2ShortMaps.Singleton<K>
    implements Object2ShortSortedMap<K>,
    Serializable,
    Cloneable {
        private static final long serialVersionUID = -7046029254386353129L;
        protected final Comparator<? super K> comparator;

        protected Singleton(K key, short value2, Comparator<? super K> comparator) {
            super(key, value2);
            this.comparator = comparator;
        }

        protected Singleton(K key, short value2) {
            this(key, value2, null);
        }

        final int compare(K k1, K k2) {
            return this.comparator == null ? ((Comparable)k1).compareTo(k2) : this.comparator.compare(k1, k2);
        }

        @Override
        public Comparator<? super K> comparator() {
            return this.comparator;
        }

        @Override
        public ObjectSortedSet<Object2ShortMap.Entry<K>> object2ShortEntrySet() {
            if (this.entries == null) {
                this.entries = ObjectSortedSets.singleton(new AbstractObject2ShortMap.BasicEntry<Object>(this.key, this.value), Object2ShortSortedMaps.entryComparator(this.comparator));
            }
            return (ObjectSortedSet)this.entries;
        }

        @Override
        @Deprecated
        public ObjectSortedSet<Map.Entry<K, Short>> entrySet() {
            return this.object2ShortEntrySet();
        }

        @Override
        public ObjectSortedSet<K> keySet() {
            if (this.keys == null) {
                this.keys = ObjectSortedSets.singleton(this.key, this.comparator);
            }
            return (ObjectSortedSet)this.keys;
        }

        @Override
        public Object2ShortSortedMap<K> subMap(K from2, K to2) {
            if (this.compare(from2, this.key) <= 0 && this.compare(this.key, to2) < 0) {
                return this;
            }
            return EMPTY_MAP;
        }

        @Override
        public Object2ShortSortedMap<K> headMap(K to2) {
            if (this.compare(this.key, to2) < 0) {
                return this;
            }
            return EMPTY_MAP;
        }

        @Override
        public Object2ShortSortedMap<K> tailMap(K from2) {
            if (this.compare(from2, this.key) <= 0) {
                return this;
            }
            return EMPTY_MAP;
        }

        @Override
        public K firstKey() {
            return (K)this.key;
        }

        @Override
        public K lastKey() {
            return (K)this.key;
        }
    }

    public static class EmptySortedMap<K>
    extends Object2ShortMaps.EmptyMap<K>
    implements Object2ShortSortedMap<K>,
    Serializable,
    Cloneable {
        private static final long serialVersionUID = -7046029254386353129L;

        protected EmptySortedMap() {
        }

        @Override
        public Comparator<? super K> comparator() {
            return null;
        }

        @Override
        public ObjectSortedSet<Object2ShortMap.Entry<K>> object2ShortEntrySet() {
            return ObjectSortedSets.EMPTY_SET;
        }

        @Override
        @Deprecated
        public ObjectSortedSet<Map.Entry<K, Short>> entrySet() {
            return ObjectSortedSets.EMPTY_SET;
        }

        @Override
        public ObjectSortedSet<K> keySet() {
            return ObjectSortedSets.EMPTY_SET;
        }

        @Override
        public Object2ShortSortedMap<K> subMap(K from2, K to2) {
            return EMPTY_MAP;
        }

        @Override
        public Object2ShortSortedMap<K> headMap(K to2) {
            return EMPTY_MAP;
        }

        @Override
        public Object2ShortSortedMap<K> tailMap(K from2) {
            return EMPTY_MAP;
        }

        @Override
        public K firstKey() {
            throw new NoSuchElementException();
        }

        @Override
        public K lastKey() {
            throw new NoSuchElementException();
        }
    }
}

