/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.shorts;

import it.unimi.dsi.fastutil.BigList;
import it.unimi.dsi.fastutil.BigListIterator;
import it.unimi.dsi.fastutil.shorts.AbstractShortCollection;
import it.unimi.dsi.fastutil.shorts.ShortBigArrays;
import it.unimi.dsi.fastutil.shorts.ShortBigList;
import it.unimi.dsi.fastutil.shorts.ShortBigListIterator;
import it.unimi.dsi.fastutil.shorts.ShortCollection;
import it.unimi.dsi.fastutil.shorts.ShortStack;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;

public abstract class AbstractShortBigList
extends AbstractShortCollection
implements ShortBigList,
ShortStack {
    protected AbstractShortBigList() {
    }

    protected void ensureIndex(long index2) {
        if (index2 < 0L) {
            throw new IndexOutOfBoundsException("Index (" + index2 + ") is negative");
        }
        if (index2 > this.size64()) {
            throw new IndexOutOfBoundsException("Index (" + index2 + ") is greater than list size (" + this.size64() + ")");
        }
    }

    protected void ensureRestrictedIndex(long index2) {
        if (index2 < 0L) {
            throw new IndexOutOfBoundsException("Index (" + index2 + ") is negative");
        }
        if (index2 >= this.size64()) {
            throw new IndexOutOfBoundsException("Index (" + index2 + ") is greater than or equal to list size (" + this.size64() + ")");
        }
    }

    @Override
    public void add(long index2, short k) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean add(short k) {
        this.add(this.size64(), k);
        return true;
    }

    @Override
    public short removeShort(long i) {
        throw new UnsupportedOperationException();
    }

    @Override
    public short set(long index2, short k) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(long index2, Collection<? extends Short> c) {
        this.ensureIndex(index2);
        Iterator<? extends Short> i = c.iterator();
        boolean retVal = i.hasNext();
        while (i.hasNext()) {
            this.add(index2++, i.next());
        }
        return retVal;
    }

    @Override
    public boolean addAll(Collection<? extends Short> c) {
        return this.addAll(this.size64(), c);
    }

    @Override
    public ShortBigListIterator iterator() {
        return this.listIterator();
    }

    @Override
    public ShortBigListIterator listIterator() {
        return this.listIterator(0L);
    }

    @Override
    public ShortBigListIterator listIterator(final long index2) {
        this.ensureIndex(index2);
        return new ShortBigListIterator(){
            long pos;
            long last;
            {
                this.pos = index2;
                this.last = -1L;
            }

            @Override
            public boolean hasNext() {
                return this.pos < AbstractShortBigList.this.size64();
            }

            @Override
            public boolean hasPrevious() {
                return this.pos > 0L;
            }

            @Override
            public short nextShort() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.last = this.pos++;
                return AbstractShortBigList.this.getShort(this.last);
            }

            @Override
            public short previousShort() {
                if (!this.hasPrevious()) {
                    throw new NoSuchElementException();
                }
                this.last = --this.pos;
                return AbstractShortBigList.this.getShort(this.pos);
            }

            @Override
            public long nextIndex() {
                return this.pos;
            }

            @Override
            public long previousIndex() {
                return this.pos - 1L;
            }

            @Override
            public void add(short k) {
                AbstractShortBigList.this.add(this.pos++, k);
                this.last = -1L;
            }

            @Override
            public void set(short k) {
                if (this.last == -1L) {
                    throw new IllegalStateException();
                }
                AbstractShortBigList.this.set(this.last, k);
            }

            @Override
            public void remove() {
                if (this.last == -1L) {
                    throw new IllegalStateException();
                }
                AbstractShortBigList.this.removeShort(this.last);
                if (this.last < this.pos) {
                    --this.pos;
                }
                this.last = -1L;
            }
        };
    }

    @Override
    public boolean contains(short k) {
        return this.indexOf(k) >= 0L;
    }

    @Override
    public long indexOf(short k) {
        ShortBigListIterator i = this.listIterator();
        while (i.hasNext()) {
            short e = i.nextShort();
            if (k != e) continue;
            return i.previousIndex();
        }
        return -1L;
    }

    @Override
    public long lastIndexOf(short k) {
        ShortBigListIterator i = this.listIterator(this.size64());
        while (i.hasPrevious()) {
            short e = i.previousShort();
            if (k != e) continue;
            return i.nextIndex();
        }
        return -1L;
    }

    @Override
    public void size(long size2) {
        long i = this.size64();
        if (size2 > i) {
            while (i++ < size2) {
                this.add((short)0);
            }
        } else {
            while (i-- != size2) {
                this.remove(i);
            }
        }
    }

    @Override
    public ShortBigList subList(long from2, long to2) {
        this.ensureIndex(from2);
        this.ensureIndex(to2);
        if (from2 > to2) {
            throw new IndexOutOfBoundsException("Start index (" + from2 + ") is greater than end index (" + to2 + ")");
        }
        return new ShortSubList(this, from2, to2);
    }

    @Override
    public void removeElements(long from2, long to2) {
        this.ensureIndex(to2);
        ShortBigListIterator i = this.listIterator(from2);
        long n = to2 - from2;
        if (n < 0L) {
            throw new IllegalArgumentException("Start index (" + from2 + ") is greater than end index (" + to2 + ")");
        }
        while (n-- != 0L) {
            i.nextShort();
            i.remove();
        }
    }

    @Override
    public void addElements(long index2, short[][] a, long offset, long length) {
        this.ensureIndex(index2);
        ShortBigArrays.ensureOffsetLength(a, offset, length);
        while (length-- != 0L) {
            this.add(index2++, ShortBigArrays.get(a, offset++));
        }
    }

    @Override
    public void addElements(long index2, short[][] a) {
        this.addElements(index2, a, 0L, ShortBigArrays.length(a));
    }

    @Override
    public void getElements(long from2, short[][] a, long offset, long length) {
        ShortBigListIterator i = this.listIterator(from2);
        ShortBigArrays.ensureOffsetLength(a, offset, length);
        if (from2 + length > this.size64()) {
            throw new IndexOutOfBoundsException("End index (" + (from2 + length) + ") is greater than list size (" + this.size64() + ")");
        }
        while (length-- != 0L) {
            ShortBigArrays.set(a, offset++, i.nextShort());
        }
    }

    @Override
    public void clear() {
        this.removeElements(0L, this.size64());
    }

    @Override
    @Deprecated
    public int size() {
        return (int)Math.min(Integer.MAX_VALUE, this.size64());
    }

    private boolean valEquals(Object a, Object b) {
        return a == null ? b == null : a.equals(b);
    }

    @Override
    public int hashCode() {
        ShortBigListIterator i = this.iterator();
        int h2 = 1;
        long s2 = this.size64();
        while (s2-- != 0L) {
            short k = i.nextShort();
            h2 = 31 * h2 + k;
        }
        return h2;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BigList)) {
            return false;
        }
        BigList l = (BigList)o;
        long s2 = this.size64();
        if (s2 != l.size64()) {
            return false;
        }
        if (l instanceof ShortBigList) {
            ShortBigListIterator i1 = this.listIterator();
            ShortBigListIterator i2 = ((ShortBigList)l).listIterator();
            while (s2-- != 0L) {
                if (i1.nextShort() == i2.nextShort()) continue;
                return false;
            }
            return true;
        }
        ShortBigListIterator i1 = this.listIterator();
        BigListIterator i2 = l.listIterator();
        while (s2-- != 0L) {
            if (this.valEquals(i1.next(), i2.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    public int compareTo(BigList<? extends Short> l) {
        if (l == this) {
            return 0;
        }
        if (l instanceof ShortBigList) {
            ShortBigListIterator i1 = this.listIterator();
            ShortBigListIterator i2 = ((ShortBigList)l).listIterator();
            while (i1.hasNext() && i2.hasNext()) {
                short e2;
                short e1 = i1.nextShort();
                int r2 = Short.compare(e1, e2 = i2.nextShort());
                if (r2 == 0) continue;
                return r2;
            }
            return i2.hasNext() ? -1 : (i1.hasNext() ? 1 : 0);
        }
        ShortBigListIterator i1 = this.listIterator();
        BigListIterator<? extends Short> i2 = l.listIterator();
        while (i1.hasNext() && i2.hasNext()) {
            int r3 = ((Comparable)i1.next()).compareTo(i2.next());
            if (r3 == 0) continue;
            return r3;
        }
        return i2.hasNext() ? -1 : (i1.hasNext() ? 1 : 0);
    }

    @Override
    public void push(short o) {
        this.add(o);
    }

    @Override
    public short popShort() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.removeShort(this.size64() - 1L);
    }

    @Override
    public short topShort() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.getShort(this.size64() - 1L);
    }

    @Override
    public short peekShort(int i) {
        return this.getShort(this.size64() - 1L - (long)i);
    }

    @Override
    public boolean rem(short k) {
        long index2 = this.indexOf(k);
        if (index2 == -1L) {
            return false;
        }
        this.removeShort(index2);
        return true;
    }

    @Override
    public boolean addAll(long index2, ShortCollection c) {
        return this.addAll(index2, (Collection<? extends Short>)c);
    }

    @Override
    public boolean addAll(long index2, ShortBigList l) {
        return this.addAll(index2, (ShortCollection)l);
    }

    @Override
    public boolean addAll(ShortCollection c) {
        return this.addAll(this.size64(), c);
    }

    @Override
    public boolean addAll(ShortBigList l) {
        return this.addAll(this.size64(), l);
    }

    @Override
    @Deprecated
    public void add(long index2, Short ok) {
        this.add(index2, (short)ok);
    }

    @Override
    @Deprecated
    public Short set(long index2, Short ok) {
        return this.set(index2, (short)ok);
    }

    @Override
    @Deprecated
    public Short get(long index2) {
        return this.getShort(index2);
    }

    @Override
    @Deprecated
    public long indexOf(Object ok) {
        return this.indexOf((Short)ok);
    }

    @Override
    @Deprecated
    public long lastIndexOf(Object ok) {
        return this.lastIndexOf((Short)ok);
    }

    @Override
    @Deprecated
    public Short remove(long index2) {
        return this.removeShort(index2);
    }

    @Override
    @Deprecated
    public void push(Short o) {
        this.push((short)o);
    }

    @Override
    @Deprecated
    public Short pop() {
        return this.popShort();
    }

    @Override
    @Deprecated
    public Short top() {
        return this.topShort();
    }

    @Override
    @Deprecated
    public Short peek(int i) {
        return this.peekShort(i);
    }

    @Override
    public String toString() {
        StringBuilder s2 = new StringBuilder();
        ShortBigListIterator i = this.iterator();
        long n = this.size64();
        boolean first2 = true;
        s2.append("[");
        while (n-- != 0L) {
            if (first2) {
                first2 = false;
            } else {
                s2.append(", ");
            }
            short k = i.nextShort();
            s2.append(String.valueOf(k));
        }
        s2.append("]");
        return s2.toString();
    }

    public static class ShortSubList
    extends AbstractShortBigList
    implements Serializable {
        private static final long serialVersionUID = -7046029254386353129L;
        protected final ShortBigList l;
        protected final long from;
        protected long to;

        public ShortSubList(ShortBigList l, long from2, long to2) {
            this.l = l;
            this.from = from2;
            this.to = to2;
        }

        private boolean assertRange() {
            assert (this.from <= this.l.size64());
            assert (this.to <= this.l.size64());
            assert (this.to >= this.from);
            return true;
        }

        @Override
        public boolean add(short k) {
            this.l.add(this.to, k);
            ++this.to;
            assert (this.assertRange());
            return true;
        }

        @Override
        public void add(long index2, short k) {
            this.ensureIndex(index2);
            this.l.add(this.from + index2, k);
            ++this.to;
            assert (this.assertRange());
        }

        @Override
        public boolean addAll(long index2, Collection<? extends Short> c) {
            this.ensureIndex(index2);
            this.to += (long)c.size();
            return this.l.addAll(this.from + index2, c);
        }

        @Override
        public short getShort(long index2) {
            this.ensureRestrictedIndex(index2);
            return this.l.getShort(this.from + index2);
        }

        @Override
        public short removeShort(long index2) {
            this.ensureRestrictedIndex(index2);
            --this.to;
            return this.l.removeShort(this.from + index2);
        }

        @Override
        public short set(long index2, short k) {
            this.ensureRestrictedIndex(index2);
            return this.l.set(this.from + index2, k);
        }

        @Override
        public long size64() {
            return this.to - this.from;
        }

        @Override
        public void getElements(long from2, short[][] a, long offset, long length) {
            this.ensureIndex(from2);
            if (from2 + length > this.size64()) {
                throw new IndexOutOfBoundsException("End index (" + from2 + length + ") is greater than list size (" + this.size64() + ")");
            }
            this.l.getElements(this.from + from2, a, offset, length);
        }

        @Override
        public void removeElements(long from2, long to2) {
            this.ensureIndex(from2);
            this.ensureIndex(to2);
            this.l.removeElements(this.from + from2, this.from + to2);
            this.to -= to2 - from2;
            assert (this.assertRange());
        }

        @Override
        public void addElements(long index2, short[][] a, long offset, long length) {
            this.ensureIndex(index2);
            this.l.addElements(this.from + index2, a, offset, length);
            this.to += length;
            assert (this.assertRange());
        }

        @Override
        public ShortBigListIterator listIterator(final long index2) {
            this.ensureIndex(index2);
            return new ShortBigListIterator(){
                long pos;
                long last;
                {
                    this.pos = index2;
                    this.last = -1L;
                }

                @Override
                public boolean hasNext() {
                    return this.pos < this.size64();
                }

                @Override
                public boolean hasPrevious() {
                    return this.pos > 0L;
                }

                @Override
                public short nextShort() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    this.last = this.pos++;
                    return l.getShort(from + this.last);
                }

                @Override
                public short previousShort() {
                    if (!this.hasPrevious()) {
                        throw new NoSuchElementException();
                    }
                    this.last = --this.pos;
                    return l.getShort(from + this.pos);
                }

                @Override
                public long nextIndex() {
                    return this.pos;
                }

                @Override
                public long previousIndex() {
                    return this.pos - 1L;
                }

                @Override
                public void add(short k) {
                    if (this.last == -1L) {
                        throw new IllegalStateException();
                    }
                    this.add(this.pos++, k);
                    this.last = -1L;
                    assert (this.assertRange());
                }

                @Override
                public void set(short k) {
                    if (this.last == -1L) {
                        throw new IllegalStateException();
                    }
                    this.set(this.last, k);
                }

                @Override
                public void remove() {
                    if (this.last == -1L) {
                        throw new IllegalStateException();
                    }
                    this.removeShort(this.last);
                    if (this.last < this.pos) {
                        --this.pos;
                    }
                    this.last = -1L;
                    assert (this.assertRange());
                }
            };
        }

        @Override
        public ShortBigList subList(long from2, long to2) {
            this.ensureIndex(from2);
            this.ensureIndex(to2);
            if (from2 > to2) {
                throw new IllegalArgumentException("Start index (" + from2 + ") is greater than end index (" + to2 + ")");
            }
            return new ShortSubList(this, from2, to2);
        }

        @Override
        public boolean rem(short k) {
            long index2 = this.indexOf(k);
            if (index2 == -1L) {
                return false;
            }
            --this.to;
            this.l.removeShort(this.from + index2);
            assert (this.assertRange());
            return true;
        }

        @Override
        public boolean addAll(long index2, ShortCollection c) {
            this.ensureIndex(index2);
            return super.addAll(index2, c);
        }

        @Override
        public boolean addAll(long index2, ShortBigList l) {
            this.ensureIndex(index2);
            return super.addAll(index2, l);
        }
    }
}

