/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.shorts;

import it.unimi.dsi.fastutil.objects.ObjectBidirectionalIterable;
import it.unimi.dsi.fastutil.objects.ObjectBidirectionalIterator;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import it.unimi.dsi.fastutil.objects.ObjectSortedSet;
import it.unimi.dsi.fastutil.objects.ObjectSortedSets;
import it.unimi.dsi.fastutil.shorts.AbstractShort2CharMap;
import it.unimi.dsi.fastutil.shorts.Short2CharMap;
import it.unimi.dsi.fastutil.shorts.Short2CharMaps;
import it.unimi.dsi.fastutil.shorts.Short2CharSortedMap;
import it.unimi.dsi.fastutil.shorts.ShortComparator;
import it.unimi.dsi.fastutil.shorts.ShortSortedSet;
import it.unimi.dsi.fastutil.shorts.ShortSortedSets;
import java.io.Serializable;
import java.util.Comparator;
import java.util.Map;
import java.util.NoSuchElementException;

public final class Short2CharSortedMaps {
    public static final EmptySortedMap EMPTY_MAP = new EmptySortedMap();

    private Short2CharSortedMaps() {
    }

    public static Comparator<? super Map.Entry<Short, ?>> entryComparator(ShortComparator comparator) {
        return (x, y) -> comparator.compare((short)((Short)x.getKey()), (short)((Short)y.getKey()));
    }

    public static ObjectBidirectionalIterator<Short2CharMap.Entry> fastIterator(Short2CharSortedMap map23) {
        ObjectSet entries = map23.short2CharEntrySet();
        return entries instanceof Short2CharSortedMap.FastSortedEntrySet ? ((Short2CharSortedMap.FastSortedEntrySet)entries).fastIterator() : entries.iterator();
    }

    public static ObjectBidirectionalIterable<Short2CharMap.Entry> fastIterable(Short2CharSortedMap map23) {
        ObjectSet entries = map23.short2CharEntrySet();
        return entries instanceof Short2CharSortedMap.FastSortedEntrySet ? ((Short2CharSortedMap.FastSortedEntrySet)entries)::fastIterator : entries;
    }

    public static Short2CharSortedMap singleton(Short key, Character value2) {
        return new Singleton(key, value2.charValue());
    }

    public static Short2CharSortedMap singleton(Short key, Character value2, ShortComparator comparator) {
        return new Singleton(key, value2.charValue(), comparator);
    }

    public static Short2CharSortedMap singleton(short key, char value2) {
        return new Singleton(key, value2);
    }

    public static Short2CharSortedMap singleton(short key, char value2, ShortComparator comparator) {
        return new Singleton(key, value2, comparator);
    }

    public static Short2CharSortedMap synchronize(Short2CharSortedMap m3) {
        return new SynchronizedSortedMap(m3);
    }

    public static Short2CharSortedMap synchronize(Short2CharSortedMap m3, Object sync) {
        return new SynchronizedSortedMap(m3, sync);
    }

    public static Short2CharSortedMap unmodifiable(Short2CharSortedMap m3) {
        return new UnmodifiableSortedMap(m3);
    }

    public static class UnmodifiableSortedMap
    extends Short2CharMaps.UnmodifiableMap
    implements Short2CharSortedMap,
    Serializable {
        private static final long serialVersionUID = -7046029254386353129L;
        protected final Short2CharSortedMap sortedMap;

        protected UnmodifiableSortedMap(Short2CharSortedMap m3) {
            super(m3);
            this.sortedMap = m3;
        }

        @Override
        public ShortComparator comparator() {
            return this.sortedMap.comparator();
        }

        @Override
        public ObjectSortedSet<Short2CharMap.Entry> short2CharEntrySet() {
            if (this.entries == null) {
                this.entries = ObjectSortedSets.unmodifiable(this.sortedMap.short2CharEntrySet());
            }
            return (ObjectSortedSet)this.entries;
        }

        @Override
        @Deprecated
        public ObjectSortedSet<Map.Entry<Short, Character>> entrySet() {
            return this.short2CharEntrySet();
        }

        @Override
        public ShortSortedSet keySet() {
            if (this.keys == null) {
                this.keys = ShortSortedSets.unmodifiable(this.sortedMap.keySet());
            }
            return (ShortSortedSet)this.keys;
        }

        @Override
        public Short2CharSortedMap subMap(short from2, short to2) {
            return new UnmodifiableSortedMap(this.sortedMap.subMap(from2, to2));
        }

        @Override
        public Short2CharSortedMap headMap(short to2) {
            return new UnmodifiableSortedMap(this.sortedMap.headMap(to2));
        }

        @Override
        public Short2CharSortedMap tailMap(short from2) {
            return new UnmodifiableSortedMap(this.sortedMap.tailMap(from2));
        }

        @Override
        public short firstShortKey() {
            return this.sortedMap.firstShortKey();
        }

        @Override
        public short lastShortKey() {
            return this.sortedMap.lastShortKey();
        }

        @Override
        @Deprecated
        public Short firstKey() {
            return this.sortedMap.firstKey();
        }

        @Override
        @Deprecated
        public Short lastKey() {
            return this.sortedMap.lastKey();
        }

        @Override
        @Deprecated
        public Short2CharSortedMap subMap(Short from2, Short to2) {
            return new UnmodifiableSortedMap(this.sortedMap.subMap(from2, to2));
        }

        @Override
        @Deprecated
        public Short2CharSortedMap headMap(Short to2) {
            return new UnmodifiableSortedMap(this.sortedMap.headMap(to2));
        }

        @Override
        @Deprecated
        public Short2CharSortedMap tailMap(Short from2) {
            return new UnmodifiableSortedMap(this.sortedMap.tailMap(from2));
        }
    }

    public static class SynchronizedSortedMap
    extends Short2CharMaps.SynchronizedMap
    implements Short2CharSortedMap,
    Serializable {
        private static final long serialVersionUID = -7046029254386353129L;
        protected final Short2CharSortedMap sortedMap;

        protected SynchronizedSortedMap(Short2CharSortedMap m3, Object sync) {
            super(m3, sync);
            this.sortedMap = m3;
        }

        protected SynchronizedSortedMap(Short2CharSortedMap m3) {
            super(m3);
            this.sortedMap = m3;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ShortComparator comparator() {
            Object object = this.sync;
            synchronized (object) {
                return this.sortedMap.comparator();
            }
        }

        @Override
        public ObjectSortedSet<Short2CharMap.Entry> short2CharEntrySet() {
            if (this.entries == null) {
                this.entries = ObjectSortedSets.synchronize(this.sortedMap.short2CharEntrySet(), this.sync);
            }
            return (ObjectSortedSet)this.entries;
        }

        @Override
        @Deprecated
        public ObjectSortedSet<Map.Entry<Short, Character>> entrySet() {
            return this.short2CharEntrySet();
        }

        @Override
        public ShortSortedSet keySet() {
            if (this.keys == null) {
                this.keys = ShortSortedSets.synchronize(this.sortedMap.keySet(), this.sync);
            }
            return (ShortSortedSet)this.keys;
        }

        @Override
        public Short2CharSortedMap subMap(short from2, short to2) {
            return new SynchronizedSortedMap(this.sortedMap.subMap(from2, to2), this.sync);
        }

        @Override
        public Short2CharSortedMap headMap(short to2) {
            return new SynchronizedSortedMap(this.sortedMap.headMap(to2), this.sync);
        }

        @Override
        public Short2CharSortedMap tailMap(short from2) {
            return new SynchronizedSortedMap(this.sortedMap.tailMap(from2), this.sync);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public short firstShortKey() {
            Object object = this.sync;
            synchronized (object) {
                return this.sortedMap.firstShortKey();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public short lastShortKey() {
            Object object = this.sync;
            synchronized (object) {
                return this.sortedMap.lastShortKey();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Deprecated
        public Short firstKey() {
            Object object = this.sync;
            synchronized (object) {
                return this.sortedMap.firstKey();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Deprecated
        public Short lastKey() {
            Object object = this.sync;
            synchronized (object) {
                return this.sortedMap.lastKey();
            }
        }

        @Override
        @Deprecated
        public Short2CharSortedMap subMap(Short from2, Short to2) {
            return new SynchronizedSortedMap(this.sortedMap.subMap(from2, to2), this.sync);
        }

        @Override
        @Deprecated
        public Short2CharSortedMap headMap(Short to2) {
            return new SynchronizedSortedMap(this.sortedMap.headMap(to2), this.sync);
        }

        @Override
        @Deprecated
        public Short2CharSortedMap tailMap(Short from2) {
            return new SynchronizedSortedMap(this.sortedMap.tailMap(from2), this.sync);
        }
    }

    public static class Singleton
    extends Short2CharMaps.Singleton
    implements Short2CharSortedMap,
    Serializable,
    Cloneable {
        private static final long serialVersionUID = -7046029254386353129L;
        protected final ShortComparator comparator;

        protected Singleton(short key, char value2, ShortComparator comparator) {
            super(key, value2);
            this.comparator = comparator;
        }

        protected Singleton(short key, char value2) {
            this(key, value2, null);
        }

        final int compare(short k1, short k2) {
            return this.comparator == null ? Short.compare(k1, k2) : this.comparator.compare(k1, k2);
        }

        @Override
        public ShortComparator comparator() {
            return this.comparator;
        }

        @Override
        public ObjectSortedSet<Short2CharMap.Entry> short2CharEntrySet() {
            if (this.entries == null) {
                this.entries = ObjectSortedSets.singleton(new AbstractShort2CharMap.BasicEntry(this.key, this.value), Short2CharSortedMaps.entryComparator(this.comparator));
            }
            return (ObjectSortedSet)this.entries;
        }

        @Override
        @Deprecated
        public ObjectSortedSet<Map.Entry<Short, Character>> entrySet() {
            return this.short2CharEntrySet();
        }

        @Override
        public ShortSortedSet keySet() {
            if (this.keys == null) {
                this.keys = ShortSortedSets.singleton(this.key, this.comparator);
            }
            return (ShortSortedSet)this.keys;
        }

        @Override
        public Short2CharSortedMap subMap(short from2, short to2) {
            if (this.compare(from2, this.key) <= 0 && this.compare(this.key, to2) < 0) {
                return this;
            }
            return EMPTY_MAP;
        }

        @Override
        public Short2CharSortedMap headMap(short to2) {
            if (this.compare(this.key, to2) < 0) {
                return this;
            }
            return EMPTY_MAP;
        }

        @Override
        public Short2CharSortedMap tailMap(short from2) {
            if (this.compare(from2, this.key) <= 0) {
                return this;
            }
            return EMPTY_MAP;
        }

        @Override
        public short firstShortKey() {
            return this.key;
        }

        @Override
        public short lastShortKey() {
            return this.key;
        }

        @Override
        @Deprecated
        public Short2CharSortedMap headMap(Short oto) {
            return this.headMap((short)oto);
        }

        @Override
        @Deprecated
        public Short2CharSortedMap tailMap(Short ofrom) {
            return this.tailMap((short)ofrom);
        }

        @Override
        @Deprecated
        public Short2CharSortedMap subMap(Short ofrom, Short oto) {
            return this.subMap((short)ofrom, (short)oto);
        }

        @Override
        @Deprecated
        public Short firstKey() {
            return this.firstShortKey();
        }

        @Override
        @Deprecated
        public Short lastKey() {
            return this.lastShortKey();
        }
    }

    public static class EmptySortedMap
    extends Short2CharMaps.EmptyMap
    implements Short2CharSortedMap,
    Serializable,
    Cloneable {
        private static final long serialVersionUID = -7046029254386353129L;

        protected EmptySortedMap() {
        }

        @Override
        public ShortComparator comparator() {
            return null;
        }

        @Override
        public ObjectSortedSet<Short2CharMap.Entry> short2CharEntrySet() {
            return ObjectSortedSets.EMPTY_SET;
        }

        @Override
        @Deprecated
        public ObjectSortedSet<Map.Entry<Short, Character>> entrySet() {
            return ObjectSortedSets.EMPTY_SET;
        }

        @Override
        public ShortSortedSet keySet() {
            return ShortSortedSets.EMPTY_SET;
        }

        @Override
        public Short2CharSortedMap subMap(short from2, short to2) {
            return EMPTY_MAP;
        }

        @Override
        public Short2CharSortedMap headMap(short to2) {
            return EMPTY_MAP;
        }

        @Override
        public Short2CharSortedMap tailMap(short from2) {
            return EMPTY_MAP;
        }

        @Override
        public short firstShortKey() {
            throw new NoSuchElementException();
        }

        @Override
        public short lastShortKey() {
            throw new NoSuchElementException();
        }

        @Override
        @Deprecated
        public Short2CharSortedMap headMap(Short oto) {
            return this.headMap((short)oto);
        }

        @Override
        @Deprecated
        public Short2CharSortedMap tailMap(Short ofrom) {
            return this.tailMap((short)ofrom);
        }

        @Override
        @Deprecated
        public Short2CharSortedMap subMap(Short ofrom, Short oto) {
            return this.subMap((short)ofrom, (short)oto);
        }

        @Override
        @Deprecated
        public Short firstKey() {
            return this.firstShortKey();
        }

        @Override
        @Deprecated
        public Short lastKey() {
            return this.lastShortKey();
        }
    }
}

