/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.shorts;

import it.unimi.dsi.fastutil.shorts.ShortComparator;

public final class ShortHeaps {
    private ShortHeaps() {
    }

    public static int downHeap(short[] heap, int size2, int i, ShortComparator c) {
        assert (i < size2);
        short e = heap[i];
        if (c == null) {
            int child;
            while ((child = (i << 1) + 1) < size2) {
                short t = heap[child];
                int right2 = child + 1;
                if (right2 < size2 && heap[right2] < t) {
                    child = right2;
                    t = heap[child];
                }
                if (e > t) {
                    heap[i] = t;
                    i = child;
                    continue;
                }
                break;
            }
        } else {
            int child;
            while ((child = (i << 1) + 1) < size2) {
                short t = heap[child];
                int right3 = child + 1;
                if (right3 < size2 && c.compare(heap[right3], t) < 0) {
                    child = right3;
                    t = heap[child];
                }
                if (c.compare(e, t) > 0) {
                    heap[i] = t;
                    i = child;
                    continue;
                }
                break;
            }
        }
        heap[i] = e;
        return i;
    }

    public static int upHeap(short[] heap, int size2, int i, ShortComparator c) {
        assert (i < size2);
        short e = heap[i];
        if (c == null) {
            int parent;
            short t;
            while (i != 0 && (t = heap[parent = i - 1 >>> 1]) > e) {
                heap[i] = t;
                i = parent;
            }
        } else {
            int parent;
            short t;
            while (i != 0 && c.compare(t = heap[parent = i - 1 >>> 1], e) > 0) {
                heap[i] = t;
                i = parent;
            }
        }
        heap[i] = e;
        return i;
    }

    public static void makeHeap(short[] heap, int size2, ShortComparator c) {
        int i = size2 >>> 1;
        while (i-- != 0) {
            ShortHeaps.downHeap(heap, size2, i, c);
        }
    }
}

