/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class Validate {
    private static final String DEFAULT_NOT_NAN_EX_MESSAGE = "The validated value is not a number";
    private static final String DEFAULT_FINITE_EX_MESSAGE = "The value is invalid: %f";
    private static final String DEFAULT_EXCLUSIVE_BETWEEN_EX_MESSAGE = "The value %s is not in the specified exclusive range of %s to %s";
    private static final String DEFAULT_INCLUSIVE_BETWEEN_EX_MESSAGE = "The value %s is not in the specified inclusive range of %s to %s";
    private static final String DEFAULT_MATCHES_PATTERN_EX = "The string %s does not match the pattern %s";
    private static final String DEFAULT_IS_NULL_EX_MESSAGE = "The validated object is null";
    private static final String DEFAULT_IS_TRUE_EX_MESSAGE = "The validated expression is false";
    private static final String DEFAULT_NO_NULL_ELEMENTS_ARRAY_EX_MESSAGE = "The validated array contains null element at index: %d";
    private static final String DEFAULT_NO_NULL_ELEMENTS_COLLECTION_EX_MESSAGE = "The validated collection contains null element at index: %d";
    private static final String DEFAULT_NOT_BLANK_EX_MESSAGE = "The validated character sequence is blank";
    private static final String DEFAULT_NOT_EMPTY_ARRAY_EX_MESSAGE = "The validated array is empty";
    private static final String DEFAULT_NOT_EMPTY_CHAR_SEQUENCE_EX_MESSAGE = "The validated character sequence is empty";
    private static final String DEFAULT_NOT_EMPTY_COLLECTION_EX_MESSAGE = "The validated collection is empty";
    private static final String DEFAULT_NOT_EMPTY_MAP_EX_MESSAGE = "The validated map is empty";
    private static final String DEFAULT_VALID_INDEX_ARRAY_EX_MESSAGE = "The validated array index is invalid: %d";
    private static final String DEFAULT_VALID_INDEX_CHAR_SEQUENCE_EX_MESSAGE = "The validated character sequence index is invalid: %d";
    private static final String DEFAULT_VALID_INDEX_COLLECTION_EX_MESSAGE = "The validated collection index is invalid: %d";
    private static final String DEFAULT_VALID_STATE_EX_MESSAGE = "The validated state is false";
    private static final String DEFAULT_IS_ASSIGNABLE_EX_MESSAGE = "Cannot assign a %s to a %s";
    private static final String DEFAULT_IS_INSTANCE_OF_EX_MESSAGE = "Expected type: %s, actual: %s";

    public static void isTrue(boolean expression2, String message2, long value2) {
        if (!expression2) {
            throw new IllegalArgumentException(String.format(message2, value2));
        }
    }

    public static void isTrue(boolean expression2, String message2, double value2) {
        if (!expression2) {
            throw new IllegalArgumentException(String.format(message2, value2));
        }
    }

    public static void isTrue(boolean expression2, String message2, Object ... values2) {
        if (!expression2) {
            throw new IllegalArgumentException(String.format(message2, values2));
        }
    }

    public static void isTrue(boolean expression2) {
        if (!expression2) {
            throw new IllegalArgumentException(DEFAULT_IS_TRUE_EX_MESSAGE);
        }
    }

    public static <T> T notNull(T object) {
        return Validate.notNull(object, DEFAULT_IS_NULL_EX_MESSAGE, new Object[0]);
    }

    public static <T> T notNull(T object, String message2, Object ... values2) {
        if (object == null) {
            throw new NullPointerException(String.format(message2, values2));
        }
        return object;
    }

    public static <T> T[] notEmpty(T[] array2, String message2, Object ... values2) {
        if (array2 == null) {
            throw new NullPointerException(String.format(message2, values2));
        }
        if (array2.length == 0) {
            throw new IllegalArgumentException(String.format(message2, values2));
        }
        return array2;
    }

    public static <T> T[] notEmpty(T[] array2) {
        return Validate.notEmpty(array2, DEFAULT_NOT_EMPTY_ARRAY_EX_MESSAGE, new Object[0]);
    }

    public static <T extends Collection<?>> T notEmpty(T collection, String message2, Object ... values2) {
        if (collection == null) {
            throw new NullPointerException(String.format(message2, values2));
        }
        if (collection.isEmpty()) {
            throw new IllegalArgumentException(String.format(message2, values2));
        }
        return collection;
    }

    public static <T extends Collection<?>> T notEmpty(T collection) {
        return Validate.notEmpty(collection, DEFAULT_NOT_EMPTY_COLLECTION_EX_MESSAGE, new Object[0]);
    }

    public static <T extends Map<?, ?>> T notEmpty(T map23, String message2, Object ... values2) {
        if (map23 == null) {
            throw new NullPointerException(String.format(message2, values2));
        }
        if (map23.isEmpty()) {
            throw new IllegalArgumentException(String.format(message2, values2));
        }
        return map23;
    }

    public static <T extends Map<?, ?>> T notEmpty(T map23) {
        return Validate.notEmpty(map23, DEFAULT_NOT_EMPTY_MAP_EX_MESSAGE, new Object[0]);
    }

    public static <T extends CharSequence> T notEmpty(T chars, String message2, Object ... values2) {
        if (chars == null) {
            throw new NullPointerException(String.format(message2, values2));
        }
        if (chars.length() == 0) {
            throw new IllegalArgumentException(String.format(message2, values2));
        }
        return chars;
    }

    public static <T extends CharSequence> T notEmpty(T chars) {
        return Validate.notEmpty(chars, DEFAULT_NOT_EMPTY_CHAR_SEQUENCE_EX_MESSAGE, new Object[0]);
    }

    public static <T extends CharSequence> T notBlank(T chars, String message2, Object ... values2) {
        if (chars == null) {
            throw new NullPointerException(String.format(message2, values2));
        }
        if (StringUtils.isBlank(chars)) {
            throw new IllegalArgumentException(String.format(message2, values2));
        }
        return chars;
    }

    public static <T extends CharSequence> T notBlank(T chars) {
        return Validate.notBlank(chars, DEFAULT_NOT_BLANK_EX_MESSAGE, new Object[0]);
    }

    public static <T> T[] noNullElements(T[] array2, String message2, Object ... values2) {
        Validate.notNull(array2);
        for (int i = 0; i < array2.length; ++i) {
            if (array2[i] != null) continue;
            Object[] values22 = ArrayUtils.add(values2, Integer.valueOf(i));
            throw new IllegalArgumentException(String.format(message2, values22));
        }
        return array2;
    }

    public static <T> T[] noNullElements(T[] array2) {
        return Validate.noNullElements(array2, DEFAULT_NO_NULL_ELEMENTS_ARRAY_EX_MESSAGE, new Object[0]);
    }

    public static <T extends Iterable<?>> T noNullElements(T iterable, String message2, Object ... values2) {
        Validate.notNull(iterable);
        int i = 0;
        Iterator<?> it = iterable.iterator();
        while (it.hasNext()) {
            if (it.next() == null) {
                Object[] values22 = ArrayUtils.addAll(values2, i);
                throw new IllegalArgumentException(String.format(message2, values22));
            }
            ++i;
        }
        return iterable;
    }

    public static <T extends Iterable<?>> T noNullElements(T iterable) {
        return Validate.noNullElements(iterable, DEFAULT_NO_NULL_ELEMENTS_COLLECTION_EX_MESSAGE, new Object[0]);
    }

    public static <T> T[] validIndex(T[] array2, int index2, String message2, Object ... values2) {
        Validate.notNull(array2);
        if (index2 < 0 || index2 >= array2.length) {
            throw new IndexOutOfBoundsException(String.format(message2, values2));
        }
        return array2;
    }

    public static <T> T[] validIndex(T[] array2, int index2) {
        return Validate.validIndex(array2, index2, DEFAULT_VALID_INDEX_ARRAY_EX_MESSAGE, new Object[]{index2});
    }

    public static <T extends Collection<?>> T validIndex(T collection, int index2, String message2, Object ... values2) {
        Validate.notNull(collection);
        if (index2 < 0 || index2 >= collection.size()) {
            throw new IndexOutOfBoundsException(String.format(message2, values2));
        }
        return collection;
    }

    public static <T extends Collection<?>> T validIndex(T collection, int index2) {
        return Validate.validIndex(collection, index2, DEFAULT_VALID_INDEX_COLLECTION_EX_MESSAGE, new Object[]{index2});
    }

    public static <T extends CharSequence> T validIndex(T chars, int index2, String message2, Object ... values2) {
        Validate.notNull(chars);
        if (index2 < 0 || index2 >= chars.length()) {
            throw new IndexOutOfBoundsException(String.format(message2, values2));
        }
        return chars;
    }

    public static <T extends CharSequence> T validIndex(T chars, int index2) {
        return Validate.validIndex(chars, index2, DEFAULT_VALID_INDEX_CHAR_SEQUENCE_EX_MESSAGE, index2);
    }

    public static void validState(boolean expression2) {
        if (!expression2) {
            throw new IllegalStateException(DEFAULT_VALID_STATE_EX_MESSAGE);
        }
    }

    public static void validState(boolean expression2, String message2, Object ... values2) {
        if (!expression2) {
            throw new IllegalStateException(String.format(message2, values2));
        }
    }

    public static void matchesPattern(CharSequence input, String pattern) {
        if (!Pattern.matches(pattern, input)) {
            throw new IllegalArgumentException(String.format(DEFAULT_MATCHES_PATTERN_EX, input, pattern));
        }
    }

    public static void matchesPattern(CharSequence input, String pattern, String message2, Object ... values2) {
        if (!Pattern.matches(pattern, input)) {
            throw new IllegalArgumentException(String.format(message2, values2));
        }
    }

    public static void notNaN(double value2) {
        Validate.notNaN(value2, DEFAULT_NOT_NAN_EX_MESSAGE, new Object[0]);
    }

    public static void notNaN(double value2, String message2, Object ... values2) {
        if (Double.isNaN(value2)) {
            throw new IllegalArgumentException(String.format(message2, values2));
        }
    }

    public static void finite(double value2) {
        Validate.finite(value2, DEFAULT_FINITE_EX_MESSAGE, value2);
    }

    public static void finite(double value2, String message2, Object ... values2) {
        if (Double.isNaN(value2) || Double.isInfinite(value2)) {
            throw new IllegalArgumentException(String.format(message2, values2));
        }
    }

    public static <T> void inclusiveBetween(T start2, T end2, Comparable<T> value2) {
        if (value2.compareTo(start2) < 0 || value2.compareTo(end2) > 0) {
            throw new IllegalArgumentException(String.format(DEFAULT_INCLUSIVE_BETWEEN_EX_MESSAGE, value2, start2, end2));
        }
    }

    public static <T> void inclusiveBetween(T start2, T end2, Comparable<T> value2, String message2, Object ... values2) {
        if (value2.compareTo(start2) < 0 || value2.compareTo(end2) > 0) {
            throw new IllegalArgumentException(String.format(message2, values2));
        }
    }

    public static void inclusiveBetween(long start2, long end2, long value2) {
        if (value2 < start2 || value2 > end2) {
            throw new IllegalArgumentException(String.format(DEFAULT_INCLUSIVE_BETWEEN_EX_MESSAGE, value2, start2, end2));
        }
    }

    public static void inclusiveBetween(long start2, long end2, long value2, String message2) {
        if (value2 < start2 || value2 > end2) {
            throw new IllegalArgumentException(message2);
        }
    }

    public static void inclusiveBetween(double start2, double end2, double value2) {
        if (value2 < start2 || value2 > end2) {
            throw new IllegalArgumentException(String.format(DEFAULT_INCLUSIVE_BETWEEN_EX_MESSAGE, value2, start2, end2));
        }
    }

    public static void inclusiveBetween(double start2, double end2, double value2, String message2) {
        if (value2 < start2 || value2 > end2) {
            throw new IllegalArgumentException(message2);
        }
    }

    public static <T> void exclusiveBetween(T start2, T end2, Comparable<T> value2) {
        if (value2.compareTo(start2) <= 0 || value2.compareTo(end2) >= 0) {
            throw new IllegalArgumentException(String.format(DEFAULT_EXCLUSIVE_BETWEEN_EX_MESSAGE, value2, start2, end2));
        }
    }

    public static <T> void exclusiveBetween(T start2, T end2, Comparable<T> value2, String message2, Object ... values2) {
        if (value2.compareTo(start2) <= 0 || value2.compareTo(end2) >= 0) {
            throw new IllegalArgumentException(String.format(message2, values2));
        }
    }

    public static void exclusiveBetween(long start2, long end2, long value2) {
        if (value2 <= start2 || value2 >= end2) {
            throw new IllegalArgumentException(String.format(DEFAULT_EXCLUSIVE_BETWEEN_EX_MESSAGE, value2, start2, end2));
        }
    }

    public static void exclusiveBetween(long start2, long end2, long value2, String message2) {
        if (value2 <= start2 || value2 >= end2) {
            throw new IllegalArgumentException(message2);
        }
    }

    public static void exclusiveBetween(double start2, double end2, double value2) {
        if (value2 <= start2 || value2 >= end2) {
            throw new IllegalArgumentException(String.format(DEFAULT_EXCLUSIVE_BETWEEN_EX_MESSAGE, value2, start2, end2));
        }
    }

    public static void exclusiveBetween(double start2, double end2, double value2, String message2) {
        if (value2 <= start2 || value2 >= end2) {
            throw new IllegalArgumentException(message2);
        }
    }

    public static void isInstanceOf(Class<?> type, Object obj2) {
        if (!type.isInstance(obj2)) {
            throw new IllegalArgumentException(String.format(DEFAULT_IS_INSTANCE_OF_EX_MESSAGE, type.getName(), obj2 == null ? "null" : obj2.getClass().getName()));
        }
    }

    public static void isInstanceOf(Class<?> type, Object obj2, String message2, Object ... values2) {
        if (!type.isInstance(obj2)) {
            throw new IllegalArgumentException(String.format(message2, values2));
        }
    }

    public static void isAssignableFrom(Class<?> superType, Class<?> type) {
        if (!superType.isAssignableFrom(type)) {
            throw new IllegalArgumentException(String.format(DEFAULT_IS_ASSIGNABLE_EX_MESSAGE, type == null ? "null" : type.getName(), superType.getName()));
        }
    }

    public static void isAssignableFrom(Class<?> superType, Class<?> type, String message2, Object ... values2) {
        if (!superType.isAssignableFrom(type)) {
            throw new IllegalArgumentException(String.format(message2, values2));
        }
    }
}

