/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.text.similarity;

import java.util.Arrays;
import org.apache.commons.text.similarity.EditDistance;

public class JaroWinklerDistance
implements EditDistance<Double> {
    @Deprecated
    public static final int INDEX_NOT_FOUND = -1;

    @Override
    public Double apply(CharSequence left2, CharSequence right2) {
        if (left2 == null || right2 == null) {
            throw new IllegalArgumentException("CharSequences must not be null");
        }
        double defaultScalingFactor = 0.1;
        int[] mtp = JaroWinklerDistance.matches(left2, right2);
        double m3 = mtp[0];
        if (m3 == 0.0) {
            return 0.0;
        }
        double j = (m3 / (double)left2.length() + m3 / (double)right2.length() + (m3 - (double)mtp[1] / 2.0) / m3) / 3.0;
        double jw = j < 0.7 ? j : j + 0.1 * (double)mtp[2] * (1.0 - j);
        return jw;
    }

    @Deprecated
    protected static int[] matches(CharSequence first2, CharSequence second2) {
        int i;
        CharSequence min2;
        CharSequence max2;
        if (first2.length() > second2.length()) {
            max2 = first2;
            min2 = second2;
        } else {
            max2 = second2;
            min2 = first2;
        }
        int range = Math.max(max2.length() / 2 - 1, 0);
        int[] matchIndexes = new int[min2.length()];
        Arrays.fill(matchIndexes, -1);
        boolean[] matchFlags = new boolean[max2.length()];
        int matches2 = 0;
        block0: for (int mi = 0; mi < min2.length(); ++mi) {
            char c1 = min2.charAt(mi);
            int xn = Math.min(mi + range + 1, max2.length());
            for (int xi = Math.max(mi - range, 0); xi < xn; ++xi) {
                if (matchFlags[xi] || c1 != max2.charAt(xi)) continue;
                matchIndexes[mi] = xi;
                matchFlags[xi] = true;
                ++matches2;
                continue block0;
            }
        }
        char[] ms1 = new char[matches2];
        char[] ms2 = new char[matches2];
        int si = 0;
        for (i = 0; i < min2.length(); ++i) {
            if (matchIndexes[i] == -1) continue;
            ms1[si] = min2.charAt(i);
            ++si;
        }
        si = 0;
        for (i = 0; i < max2.length(); ++i) {
            if (!matchFlags[i]) continue;
            ms2[si] = max2.charAt(i);
            ++si;
        }
        int halfTranspositions = 0;
        for (int mi = 0; mi < ms1.length; ++mi) {
            if (ms1[mi] == ms2[mi]) continue;
            ++halfTranspositions;
        }
        int prefix = 0;
        for (int mi = 0; mi < Math.min(4, min2.length()) && first2.charAt(mi) == second2.charAt(mi); ++mi) {
            ++prefix;
        }
        return new int[]{matches2, halfTranspositions, prefix};
    }
}

