/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.util.serialization;

import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.JsonNode;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.node.ObjectNode;
import org.apache.flink.streaming.connectors.kafka.KafkaDeserializationSchema;
import org.apache.kafka.clients.consumer.ConsumerRecord;

@PublicEvolving
public class JSONKeyValueDeserializationSchema
implements KafkaDeserializationSchema<ObjectNode> {
    private static final long serialVersionUID = 1509391548173891955L;
    private final boolean includeMetadata;
    private ObjectMapper mapper;

    public JSONKeyValueDeserializationSchema(boolean includeMetadata) {
        this.includeMetadata = includeMetadata;
    }

    @Override
    public ObjectNode deserialize(ConsumerRecord<byte[], byte[]> record2) throws Exception {
        if (this.mapper == null) {
            this.mapper = new ObjectMapper();
        }
        ObjectNode node2 = this.mapper.createObjectNode();
        if (record2.key() != null) {
            node2.set("key", (JsonNode)this.mapper.readValue(record2.key(), JsonNode.class));
        }
        if (record2.value() != null) {
            node2.set("value", (JsonNode)this.mapper.readValue(record2.value(), JsonNode.class));
        }
        if (this.includeMetadata) {
            node2.putObject("metadata").put("offset", record2.offset()).put("topic", record2.topic()).put("partition", record2.partition());
        }
        return node2;
    }

    @Override
    public boolean isEndOfStream(ObjectNode nextElement) {
        return false;
    }

    public TypeInformation<ObjectNode> getProducedType() {
        return TypeExtractor.getForClass(ObjectNode.class);
    }
}

