/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.kafka.clients.consumer.internals.AbstractPartitionAssignor;
import org.apache.kafka.clients.consumer.internals.PartitionAssignor;
import org.apache.kafka.common.TopicPartition;

public class RangeAssignor
extends AbstractPartitionAssignor {
    @Override
    public String name() {
        return "range";
    }

    private Map<String, List<String>> consumersPerTopic(Map<String, PartitionAssignor.Subscription> consumerMetadata) {
        HashMap<String, List<String>> res = new HashMap<String, List<String>>();
        for (Map.Entry<String, PartitionAssignor.Subscription> subscriptionEntry : consumerMetadata.entrySet()) {
            String consumerId = subscriptionEntry.getKey();
            for (String topic : subscriptionEntry.getValue().topics()) {
                RangeAssignor.put(res, topic, consumerId);
            }
        }
        return res;
    }

    @Override
    public Map<String, List<TopicPartition>> assign(Map<String, Integer> partitionsPerTopic, Map<String, PartitionAssignor.Subscription> subscriptions) {
        Map<String, List<String>> consumersPerTopic = this.consumersPerTopic(subscriptions);
        HashMap<String, List<TopicPartition>> assignment = new HashMap<String, List<TopicPartition>>();
        for (String string2 : subscriptions.keySet()) {
            assignment.put(string2, new ArrayList());
        }
        for (Map.Entry entry : consumersPerTopic.entrySet()) {
            String topic = (String)entry.getKey();
            List consumersForTopic = (List)entry.getValue();
            Integer numPartitionsForTopic = partitionsPerTopic.get(topic);
            if (numPartitionsForTopic == null) continue;
            Collections.sort(consumersForTopic);
            int numPartitionsPerConsumer = numPartitionsForTopic / consumersForTopic.size();
            int consumersWithExtraPartition = numPartitionsForTopic % consumersForTopic.size();
            List<TopicPartition> partitions = AbstractPartitionAssignor.partitions(topic, numPartitionsForTopic);
            int n = consumersForTopic.size();
            for (int i = 0; i < n; ++i) {
                int start2 = numPartitionsPerConsumer * i + Math.min(i, consumersWithExtraPartition);
                int length = numPartitionsPerConsumer + (i + 1 > consumersWithExtraPartition ? 0 : 1);
                ((List)assignment.get(consumersForTopic.get(i))).addAll(partitions.subList(start2, start2 + length));
            }
        }
        return assignment;
    }
}

