/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import java.util.ArrayList;
import java.util.List;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.ArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.protocol.types.Type;

public class CreatePartitionsRequestData
implements ApiMessage {
    private List<CreatePartitionsTopic> topics = new ArrayList<CreatePartitionsTopic>();
    private int timeoutMs;
    private boolean validateOnly;
    public static final Schema SCHEMA_0;
    public static final Schema SCHEMA_1;
    public static final Schema[] SCHEMAS;

    public CreatePartitionsRequestData(Readable readable, short version) {
        this.read(readable, version);
    }

    public CreatePartitionsRequestData(Struct struct, short version) {
        this.fromStruct(struct, version);
    }

    public CreatePartitionsRequestData() {
        this.timeoutMs = 0;
        this.validateOnly = false;
    }

    @Override
    public short apiKey() {
        return 37;
    }

    @Override
    public short lowestSupportedVersion() {
        return 0;
    }

    @Override
    public short highestSupportedVersion() {
        return 1;
    }

    @Override
    public void read(Readable readable, short version) {
        int arrayLength = readable.readInt();
        if (arrayLength < 0) {
            this.topics.clear();
        } else {
            this.topics.clear();
            for (int i = 0; i < arrayLength; ++i) {
                this.topics.add(new CreatePartitionsTopic(readable, version));
            }
        }
        this.timeoutMs = readable.readInt();
        this.validateOnly = readable.readByte() != 0;
    }

    @Override
    public void write(Writable writable, short version) {
        writable.writeInt(this.topics.size());
        for (CreatePartitionsTopic element : this.topics) {
            element.write(writable, version);
        }
        writable.writeInt(this.timeoutMs);
        writable.writeByte(this.validateOnly ? (byte)1 : 0);
    }

    @Override
    public void fromStruct(Struct struct, short version) {
        Object[] nestedObjects = struct.getArray("topics");
        this.topics = new ArrayList<CreatePartitionsTopic>(nestedObjects.length);
        for (Object nestedObject : nestedObjects) {
            this.topics.add(new CreatePartitionsTopic((Struct)nestedObject, version));
        }
        this.timeoutMs = struct.getInt("timeout_ms");
        this.validateOnly = struct.getBoolean("validate_only");
    }

    @Override
    public Struct toStruct(short version) {
        Struct struct = new Struct(SCHEMAS[version]);
        Struct[] nestedObjects = new Struct[this.topics.size()];
        int i = 0;
        for (CreatePartitionsTopic element : this.topics) {
            nestedObjects[i++] = element.toStruct(version);
        }
        struct.set("topics", (Object)nestedObjects);
        struct.set("timeout_ms", (Object)this.timeoutMs);
        struct.set("validate_only", (Object)this.validateOnly);
        return struct;
    }

    @Override
    public int size(short version) {
        int size2 = 0;
        size2 += 4;
        for (CreatePartitionsTopic element : this.topics) {
            size2 += element.size(version);
        }
        size2 += 4;
        return ++size2;
    }

    public boolean equals(Object obj2) {
        if (!(obj2 instanceof CreatePartitionsRequestData)) {
            return false;
        }
        CreatePartitionsRequestData other = (CreatePartitionsRequestData)obj2;
        if (this.topics == null ? other.topics != null : !this.topics.equals(other.topics)) {
            return false;
        }
        if (this.timeoutMs != other.timeoutMs) {
            return false;
        }
        return this.validateOnly == other.validateOnly;
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + (this.topics == null ? 0 : this.topics.hashCode());
        hashCode = 31 * hashCode + this.timeoutMs;
        hashCode = 31 * hashCode + (this.validateOnly ? 1231 : 1237);
        return hashCode;
    }

    public String toString() {
        return "CreatePartitionsRequestData(topics=" + MessageUtil.deepToString(this.topics.iterator()) + ", timeoutMs=" + this.timeoutMs + ", validateOnly=" + (this.validateOnly ? "true" : "false") + ")";
    }

    public List<CreatePartitionsTopic> topics() {
        return this.topics;
    }

    public int timeoutMs() {
        return this.timeoutMs;
    }

    public boolean validateOnly() {
        return this.validateOnly;
    }

    public CreatePartitionsRequestData setTopics(List<CreatePartitionsTopic> v) {
        this.topics = v;
        return this;
    }

    public CreatePartitionsRequestData setTimeoutMs(int v) {
        this.timeoutMs = v;
        return this;
    }

    public CreatePartitionsRequestData setValidateOnly(boolean v) {
        this.validateOnly = v;
        return this;
    }

    static {
        SCHEMA_1 = SCHEMA_0 = new Schema(new Field("topics", new ArrayOf(CreatePartitionsTopic.SCHEMA_0), "Each topic that we want to create new partitions inside."), new Field("timeout_ms", Type.INT32, "The time in ms to wait for the partitions to be created."), new Field("validate_only", Type.BOOLEAN, "If true, then validate the request, but don't actually increase the number of partitions."));
        SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1};
    }

    public static class CreatePartitionsAssignment
    implements Message {
        private List<Integer> brokerIds = new ArrayList<Integer>();
        public static final Schema SCHEMA_0;
        public static final Schema SCHEMA_1;
        public static final Schema[] SCHEMAS;

        public CreatePartitionsAssignment(Readable readable, short version) {
            this.read(readable, version);
        }

        public CreatePartitionsAssignment(Struct struct, short version) {
            this.fromStruct(struct, version);
        }

        public CreatePartitionsAssignment() {
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 1;
        }

        @Override
        public void read(Readable readable, short version) {
            int arrayLength = readable.readInt();
            if (arrayLength < 0) {
                this.brokerIds.clear();
            } else {
                this.brokerIds.clear();
                for (int i = 0; i < arrayLength; ++i) {
                    this.brokerIds.add(readable.readInt());
                }
            }
        }

        @Override
        public void write(Writable writable, short version) {
            writable.writeInt(this.brokerIds.size());
            for (Integer element : this.brokerIds) {
                writable.writeInt(element);
            }
        }

        @Override
        public void fromStruct(Struct struct, short version) {
            Object[] nestedObjects = struct.getArray("broker_ids");
            this.brokerIds = new ArrayList<Integer>(nestedObjects.length);
            for (Object nestedObject : nestedObjects) {
                this.brokerIds.add((Integer)nestedObject);
            }
        }

        @Override
        public Struct toStruct(short version) {
            Struct struct = new Struct(SCHEMAS[version]);
            Integer[] nestedObjects = new Integer[this.brokerIds.size()];
            int i = 0;
            for (Integer element : this.brokerIds) {
                nestedObjects[i++] = element;
            }
            struct.set("broker_ids", (Object)nestedObjects);
            return struct;
        }

        @Override
        public int size(short version) {
            int size2 = 0;
            size2 += 4;
            return size2 += this.brokerIds.size() * 4;
        }

        public boolean equals(Object obj2) {
            if (!(obj2 instanceof CreatePartitionsAssignment)) {
                return false;
            }
            CreatePartitionsAssignment other = (CreatePartitionsAssignment)obj2;
            return !(this.brokerIds == null ? other.brokerIds != null : !this.brokerIds.equals(other.brokerIds));
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.brokerIds == null ? 0 : this.brokerIds.hashCode());
            return hashCode;
        }

        public String toString() {
            return "CreatePartitionsAssignment(brokerIds=" + MessageUtil.deepToString(this.brokerIds.iterator()) + ")";
        }

        public List<Integer> brokerIds() {
            return this.brokerIds;
        }

        public CreatePartitionsAssignment setBrokerIds(List<Integer> v) {
            this.brokerIds = v;
            return this;
        }

        static {
            SCHEMA_1 = SCHEMA_0 = new Schema(new Field("broker_ids", new ArrayOf(Type.INT32), "The assigned broker IDs."));
            SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1};
        }
    }

    public static class CreatePartitionsTopic
    implements Message {
        private String name;
        private int count;
        private List<CreatePartitionsAssignment> assignments;
        public static final Schema SCHEMA_0;
        public static final Schema SCHEMA_1;
        public static final Schema[] SCHEMAS;

        public CreatePartitionsTopic(Readable readable, short version) {
            this.assignments = new ArrayList<CreatePartitionsAssignment>();
            this.read(readable, version);
        }

        public CreatePartitionsTopic(Struct struct, short version) {
            this.assignments = new ArrayList<CreatePartitionsAssignment>();
            this.fromStruct(struct, version);
        }

        public CreatePartitionsTopic() {
            this.name = "";
            this.count = 0;
            this.assignments = new ArrayList<CreatePartitionsAssignment>();
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 1;
        }

        @Override
        public void read(Readable readable, short version) {
            this.name = readable.readNullableString();
            this.count = readable.readInt();
            int arrayLength = readable.readInt();
            if (arrayLength < 0) {
                this.assignments.clear();
            } else {
                this.assignments.clear();
                for (int i = 0; i < arrayLength; ++i) {
                    this.assignments.add(new CreatePartitionsAssignment(readable, version));
                }
            }
        }

        @Override
        public void write(Writable writable, short version) {
            writable.writeString(this.name);
            writable.writeInt(this.count);
            if (this.assignments == null) {
                writable.writeInt(-1);
            } else {
                writable.writeInt(this.assignments.size());
                for (CreatePartitionsAssignment element : this.assignments) {
                    element.write(writable, version);
                }
            }
        }

        @Override
        public void fromStruct(Struct struct, short version) {
            this.name = struct.getString("name");
            this.count = struct.getInt("count");
            Object[] nestedObjects = struct.getArray("assignments");
            if (nestedObjects == null) {
                this.assignments = null;
            } else {
                this.assignments = new ArrayList<CreatePartitionsAssignment>(nestedObjects.length);
                for (Object nestedObject : nestedObjects) {
                    this.assignments.add(new CreatePartitionsAssignment((Struct)nestedObject, version));
                }
            }
        }

        @Override
        public Struct toStruct(short version) {
            Struct struct = new Struct(SCHEMAS[version]);
            struct.set("name", (Object)this.name);
            struct.set("count", (Object)this.count);
            if (this.assignments == null) {
                struct.set("assignments", null);
            } else {
                Struct[] nestedObjects = new Struct[this.assignments.size()];
                int i = 0;
                for (CreatePartitionsAssignment element : this.assignments) {
                    nestedObjects[i++] = element.toStruct(version);
                }
                struct.set("assignments", (Object)nestedObjects);
            }
            return struct;
        }

        @Override
        public int size(short version) {
            int size2 = 0;
            size2 += 2;
            size2 += MessageUtil.serializedUtf8Length(this.name);
            size2 += 4;
            if (this.assignments == null) {
                size2 += 4;
            } else {
                size2 += 4;
                for (CreatePartitionsAssignment element : this.assignments) {
                    size2 += element.size(version);
                }
            }
            return size2;
        }

        public boolean equals(Object obj2) {
            if (!(obj2 instanceof CreatePartitionsTopic)) {
                return false;
            }
            CreatePartitionsTopic other = (CreatePartitionsTopic)obj2;
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            if (this.count != other.count) {
                return false;
            }
            return !(this.assignments == null ? other.assignments != null : !this.assignments.equals(other.assignments));
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.name == null ? 0 : this.name.hashCode());
            hashCode = 31 * hashCode + this.count;
            hashCode = 31 * hashCode + (this.assignments == null ? 0 : this.assignments.hashCode());
            return hashCode;
        }

        public String toString() {
            return "CreatePartitionsTopic(name='" + this.name + "', count=" + this.count + ", assignments=" + MessageUtil.deepToString(this.assignments.iterator()) + ")";
        }

        public String name() {
            return this.name;
        }

        public int count() {
            return this.count;
        }

        public List<CreatePartitionsAssignment> assignments() {
            return this.assignments;
        }

        public CreatePartitionsTopic setName(String v) {
            this.name = v;
            return this;
        }

        public CreatePartitionsTopic setCount(int v) {
            this.count = v;
            return this;
        }

        public CreatePartitionsTopic setAssignments(List<CreatePartitionsAssignment> v) {
            this.assignments = v;
            return this;
        }

        static {
            SCHEMA_1 = SCHEMA_0 = new Schema(new Field("name", Type.STRING, "The topic name."), new Field("count", Type.INT32, "The new partition count."), new Field("assignments", ArrayOf.nullable(CreatePartitionsAssignment.SCHEMA_0), "The new partition assignments."));
            SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1};
        }
    }
}

