/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import java.util.Iterator;
import java.util.List;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.ArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.ImplicitLinkedHashMultiSet;
import org.apache.kafka.common.utils.ImplicitLinkedHashSet;

public class CreateTopicsResponseData
implements ApiMessage {
    private int throttleTimeMs;
    private CreatableTopicResultSet topics;
    public static final Schema SCHEMA_0 = new Schema(new Field("topics", new ArrayOf(CreatableTopicResult.SCHEMA_0), "Results for each topic we tried to create."));
    public static final Schema SCHEMA_1 = new Schema(new Field("topics", new ArrayOf(CreatableTopicResult.SCHEMA_1), "Results for each topic we tried to create."));
    public static final Schema SCHEMA_2;
    public static final Schema SCHEMA_3;
    public static final Schema[] SCHEMAS;

    public CreateTopicsResponseData(Readable readable, short version) {
        this.topics = new CreatableTopicResultSet(0);
        this.read(readable, version);
    }

    public CreateTopicsResponseData(Struct struct, short version) {
        this.topics = new CreatableTopicResultSet(0);
        this.fromStruct(struct, version);
    }

    public CreateTopicsResponseData() {
        this.throttleTimeMs = 0;
        this.topics = new CreatableTopicResultSet(0);
    }

    @Override
    public short apiKey() {
        return 19;
    }

    @Override
    public short lowestSupportedVersion() {
        return 0;
    }

    @Override
    public short highestSupportedVersion() {
        return 3;
    }

    @Override
    public void read(Readable readable, short version) {
        this.throttleTimeMs = version >= 2 ? readable.readInt() : 0;
        int arrayLength = readable.readInt();
        if (arrayLength < 0) {
            this.topics.clear(0);
        } else {
            this.topics.clear(arrayLength);
            for (int i = 0; i < arrayLength; ++i) {
                this.topics.add(new CreatableTopicResult(readable, version));
            }
        }
    }

    @Override
    public void write(Writable writable, short version) {
        if (version >= 2) {
            writable.writeInt(this.throttleTimeMs);
        }
        writable.writeInt(this.topics.size());
        for (CreatableTopicResult element : this.topics) {
            element.write(writable, version);
        }
    }

    @Override
    public void fromStruct(Struct struct, short version) {
        this.throttleTimeMs = version >= 2 ? struct.getInt("throttle_time_ms") : 0;
        Object[] nestedObjects = struct.getArray("topics");
        this.topics = new CreatableTopicResultSet(nestedObjects.length);
        for (Object nestedObject : nestedObjects) {
            this.topics.add(new CreatableTopicResult((Struct)nestedObject, version));
        }
    }

    @Override
    public Struct toStruct(short version) {
        Struct struct = new Struct(SCHEMAS[version]);
        if (version >= 2) {
            struct.set("throttle_time_ms", (Object)this.throttleTimeMs);
        }
        Struct[] nestedObjects = new Struct[this.topics.size()];
        int i = 0;
        for (CreatableTopicResult element : this.topics) {
            nestedObjects[i++] = element.toStruct(version);
        }
        struct.set("topics", (Object)nestedObjects);
        return struct;
    }

    @Override
    public int size(short version) {
        int size2 = 0;
        if (version >= 2) {
            size2 += 4;
        }
        size2 += 4;
        for (CreatableTopicResult element : this.topics) {
            size2 += element.size(version);
        }
        return size2;
    }

    public boolean equals(Object obj2) {
        if (!(obj2 instanceof CreateTopicsResponseData)) {
            return false;
        }
        CreateTopicsResponseData other = (CreateTopicsResponseData)obj2;
        if (this.throttleTimeMs != other.throttleTimeMs) {
            return false;
        }
        return !(this.topics == null ? other.topics != null : !this.topics.equals(other.topics));
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + this.throttleTimeMs;
        hashCode = 31 * hashCode + (this.topics == null ? 0 : this.topics.hashCode());
        return hashCode;
    }

    public String toString() {
        return "CreateTopicsResponseData(throttleTimeMs=" + this.throttleTimeMs + ", topics=" + MessageUtil.deepToString(this.topics.iterator()) + ")";
    }

    public int throttleTimeMs() {
        return this.throttleTimeMs;
    }

    public CreatableTopicResultSet topics() {
        return this.topics;
    }

    public CreateTopicsResponseData setThrottleTimeMs(int v) {
        this.throttleTimeMs = v;
        return this;
    }

    public CreateTopicsResponseData setTopics(CreatableTopicResultSet v) {
        this.topics = v;
        return this;
    }

    static {
        SCHEMA_3 = SCHEMA_2 = new Schema(new Field("throttle_time_ms", Type.INT32, "The duration in milliseconds for which the request was throttled due to a quota violation, or zero if the request did not violate any quota."), new Field("topics", new ArrayOf(CreatableTopicResult.SCHEMA_1), "Results for each topic we tried to create."));
        SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2, SCHEMA_3};
    }

    public static class CreatableTopicResultSet
    extends ImplicitLinkedHashMultiSet<CreatableTopicResult> {
        public CreatableTopicResultSet() {
        }

        public CreatableTopicResultSet(int expectedNumElements) {
            super(expectedNumElements);
        }

        public CreatableTopicResultSet(Iterator<CreatableTopicResult> iterator) {
            super(iterator);
        }

        @Override
        public CreatableTopicResult find(String name) {
            CreatableTopicResult key = new CreatableTopicResult();
            key.setName(name);
            return this.find(key);
        }

        @Override
        public List<CreatableTopicResult> findAll(String name) {
            CreatableTopicResult key = new CreatableTopicResult();
            key.setName(name);
            return this.findAll(key);
        }
    }

    public static class CreatableTopicResult
    implements Message,
    ImplicitLinkedHashSet.Element {
        private String name;
        private short errorCode;
        private String errorMessage;
        private int next;
        private int prev;
        public static final Schema SCHEMA_0 = new Schema(new Field("name", Type.STRING, "The topic name."), new Field("error_code", Type.INT16, "The error code, or 0 if there was no error."));
        public static final Schema SCHEMA_1;
        public static final Schema SCHEMA_2;
        public static final Schema SCHEMA_3;
        public static final Schema[] SCHEMAS;

        public CreatableTopicResult(Readable readable, short version) {
            this.read(readable, version);
        }

        public CreatableTopicResult(Struct struct, short version) {
            this.fromStruct(struct, version);
        }

        public CreatableTopicResult() {
            this.name = "";
            this.errorCode = 0;
            this.errorMessage = "";
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 3;
        }

        @Override
        public void read(Readable readable, short version) {
            this.name = readable.readNullableString();
            this.errorCode = readable.readShort();
            this.errorMessage = version >= 1 ? readable.readNullableString() : "";
        }

        @Override
        public void write(Writable writable, short version) {
            writable.writeString(this.name);
            writable.writeShort(this.errorCode);
            if (version >= 1) {
                writable.writeNullableString(this.errorMessage);
            }
        }

        @Override
        public void fromStruct(Struct struct, short version) {
            this.name = struct.getString("name");
            this.errorCode = struct.getShort("error_code");
            this.errorMessage = version >= 1 ? struct.getString("error_message") : "";
        }

        @Override
        public Struct toStruct(short version) {
            Struct struct = new Struct(SCHEMAS[version]);
            struct.set("name", (Object)this.name);
            struct.set("error_code", (Object)this.errorCode);
            if (version >= 1) {
                struct.set("error_message", (Object)this.errorMessage);
            }
            return struct;
        }

        @Override
        public int size(short version) {
            int size2 = 0;
            size2 += 2;
            size2 += MessageUtil.serializedUtf8Length(this.name);
            size2 += 2;
            if (version >= 1) {
                size2 += 2;
                if (this.errorMessage != null) {
                    size2 += MessageUtil.serializedUtf8Length(this.errorMessage);
                }
            }
            return size2;
        }

        public boolean equals(Object obj2) {
            if (!(obj2 instanceof CreatableTopicResult)) {
                return false;
            }
            CreatableTopicResult other = (CreatableTopicResult)obj2;
            return !(this.name == null ? other.name != null : !this.name.equals(other.name));
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.name == null ? 0 : this.name.hashCode());
            return hashCode;
        }

        public String toString() {
            return "CreatableTopicResult(name='" + this.name + "', errorCode=" + this.errorCode + ", errorMessage='" + this.errorMessage + "')";
        }

        public String name() {
            return this.name;
        }

        public short errorCode() {
            return this.errorCode;
        }

        public String errorMessage() {
            return this.errorMessage;
        }

        @Override
        public int next() {
            return this.next;
        }

        @Override
        public int prev() {
            return this.prev;
        }

        public CreatableTopicResult setName(String v) {
            this.name = v;
            return this;
        }

        public CreatableTopicResult setErrorCode(short v) {
            this.errorCode = v;
            return this;
        }

        public CreatableTopicResult setErrorMessage(String v) {
            this.errorMessage = v;
            return this;
        }

        @Override
        public void setNext(int v) {
            this.next = v;
        }

        @Override
        public void setPrev(int v) {
            this.prev = v;
        }

        static {
            SCHEMA_3 = SCHEMA_2 = (SCHEMA_1 = new Schema(new Field("name", Type.STRING, "The topic name."), new Field("error_code", Type.INT16, "The error code, or 0 if there was no error."), new Field("error_message", Type.NULLABLE_STRING, "The error message, or null if there was no error.")));
            SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2, SCHEMA_3};
        }
    }
}

