/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import java.util.ArrayList;
import java.util.List;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.ArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.protocol.types.Type;

public class DescribeLogDirsRequestData
implements ApiMessage {
    private List<DescribableLogDirTopic> topics = new ArrayList<DescribableLogDirTopic>();
    public static final Schema SCHEMA_0;
    public static final Schema SCHEMA_1;
    public static final Schema[] SCHEMAS;

    public DescribeLogDirsRequestData(Readable readable, short version) {
        this.read(readable, version);
    }

    public DescribeLogDirsRequestData(Struct struct, short version) {
        this.fromStruct(struct, version);
    }

    public DescribeLogDirsRequestData() {
    }

    @Override
    public short apiKey() {
        return 35;
    }

    @Override
    public short lowestSupportedVersion() {
        return 0;
    }

    @Override
    public short highestSupportedVersion() {
        return 1;
    }

    @Override
    public void read(Readable readable, short version) {
        int arrayLength = readable.readInt();
        if (arrayLength < 0) {
            this.topics.clear();
        } else {
            this.topics.clear();
            for (int i = 0; i < arrayLength; ++i) {
                this.topics.add(new DescribableLogDirTopic(readable, version));
            }
        }
    }

    @Override
    public void write(Writable writable, short version) {
        if (this.topics == null) {
            writable.writeInt(-1);
        } else {
            writable.writeInt(this.topics.size());
            for (DescribableLogDirTopic element : this.topics) {
                element.write(writable, version);
            }
        }
    }

    @Override
    public void fromStruct(Struct struct, short version) {
        Object[] nestedObjects = struct.getArray("topics");
        if (nestedObjects == null) {
            this.topics = null;
        } else {
            this.topics = new ArrayList<DescribableLogDirTopic>(nestedObjects.length);
            for (Object nestedObject : nestedObjects) {
                this.topics.add(new DescribableLogDirTopic((Struct)nestedObject, version));
            }
        }
    }

    @Override
    public Struct toStruct(short version) {
        Struct struct = new Struct(SCHEMAS[version]);
        if (this.topics == null) {
            struct.set("topics", null);
        } else {
            Struct[] nestedObjects = new Struct[this.topics.size()];
            int i = 0;
            for (DescribableLogDirTopic element : this.topics) {
                nestedObjects[i++] = element.toStruct(version);
            }
            struct.set("topics", (Object)nestedObjects);
        }
        return struct;
    }

    @Override
    public int size(short version) {
        int size2 = 0;
        if (this.topics == null) {
            size2 += 4;
        } else {
            size2 += 4;
            for (DescribableLogDirTopic element : this.topics) {
                size2 += element.size(version);
            }
        }
        return size2;
    }

    public boolean equals(Object obj2) {
        if (!(obj2 instanceof DescribeLogDirsRequestData)) {
            return false;
        }
        DescribeLogDirsRequestData other = (DescribeLogDirsRequestData)obj2;
        return !(this.topics == null ? other.topics != null : !this.topics.equals(other.topics));
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + (this.topics == null ? 0 : this.topics.hashCode());
        return hashCode;
    }

    public String toString() {
        return "DescribeLogDirsRequestData(topics=" + MessageUtil.deepToString(this.topics.iterator()) + ")";
    }

    public List<DescribableLogDirTopic> topics() {
        return this.topics;
    }

    public DescribeLogDirsRequestData setTopics(List<DescribableLogDirTopic> v) {
        this.topics = v;
        return this;
    }

    static {
        SCHEMA_1 = SCHEMA_0 = new Schema(new Field("topics", ArrayOf.nullable(DescribableLogDirTopic.SCHEMA_0), "Each topic that we want to describe log directories for, or null for all topics."));
        SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1};
    }

    public static class DescribableLogDirTopic
    implements Message {
        private String topic;
        private List<Integer> partitionIndex;
        public static final Schema SCHEMA_0;
        public static final Schema SCHEMA_1;
        public static final Schema[] SCHEMAS;

        public DescribableLogDirTopic(Readable readable, short version) {
            this.partitionIndex = new ArrayList<Integer>();
            this.read(readable, version);
        }

        public DescribableLogDirTopic(Struct struct, short version) {
            this.partitionIndex = new ArrayList<Integer>();
            this.fromStruct(struct, version);
        }

        public DescribableLogDirTopic() {
            this.topic = "";
            this.partitionIndex = new ArrayList<Integer>();
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 1;
        }

        @Override
        public void read(Readable readable, short version) {
            this.topic = readable.readNullableString();
            int arrayLength = readable.readInt();
            if (arrayLength < 0) {
                this.partitionIndex.clear();
            } else {
                this.partitionIndex.clear();
                for (int i = 0; i < arrayLength; ++i) {
                    this.partitionIndex.add(readable.readInt());
                }
            }
        }

        @Override
        public void write(Writable writable, short version) {
            writable.writeString(this.topic);
            writable.writeInt(this.partitionIndex.size());
            for (Integer element : this.partitionIndex) {
                writable.writeInt(element);
            }
        }

        @Override
        public void fromStruct(Struct struct, short version) {
            this.topic = struct.getString("topic");
            Object[] nestedObjects = struct.getArray("partition_index");
            this.partitionIndex = new ArrayList<Integer>(nestedObjects.length);
            for (Object nestedObject : nestedObjects) {
                this.partitionIndex.add((Integer)nestedObject);
            }
        }

        @Override
        public Struct toStruct(short version) {
            Struct struct = new Struct(SCHEMAS[version]);
            struct.set("topic", (Object)this.topic);
            Integer[] nestedObjects = new Integer[this.partitionIndex.size()];
            int i = 0;
            for (Integer element : this.partitionIndex) {
                nestedObjects[i++] = element;
            }
            struct.set("partition_index", (Object)nestedObjects);
            return struct;
        }

        @Override
        public int size(short version) {
            int size2 = 0;
            size2 += 2;
            size2 += MessageUtil.serializedUtf8Length(this.topic);
            size2 += 4;
            return size2 += this.partitionIndex.size() * 4;
        }

        public boolean equals(Object obj2) {
            if (!(obj2 instanceof DescribableLogDirTopic)) {
                return false;
            }
            DescribableLogDirTopic other = (DescribableLogDirTopic)obj2;
            if (this.topic == null ? other.topic != null : !this.topic.equals(other.topic)) {
                return false;
            }
            return !(this.partitionIndex == null ? other.partitionIndex != null : !this.partitionIndex.equals(other.partitionIndex));
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.topic == null ? 0 : this.topic.hashCode());
            hashCode = 31 * hashCode + (this.partitionIndex == null ? 0 : this.partitionIndex.hashCode());
            return hashCode;
        }

        public String toString() {
            return "DescribableLogDirTopic(topic='" + this.topic + "', partitionIndex=" + MessageUtil.deepToString(this.partitionIndex.iterator()) + ")";
        }

        public String topic() {
            return this.topic;
        }

        public List<Integer> partitionIndex() {
            return this.partitionIndex;
        }

        public DescribableLogDirTopic setTopic(String v) {
            this.topic = v;
            return this;
        }

        public DescribableLogDirTopic setPartitionIndex(List<Integer> v) {
            this.partitionIndex = v;
            return this;
        }

        static {
            SCHEMA_1 = SCHEMA_0 = new Schema(new Field("topic", Type.STRING, "The topic name"), new Field("partition_index", new ArrayOf(Type.INT32), "The partition indxes."));
            SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1};
        }
    }
}

