/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.metrics.stats;

import java.util.List;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.common.metrics.MeasurableStat;
import org.apache.kafka.common.metrics.MetricConfig;
import org.apache.kafka.common.metrics.stats.SampledStat;

public class Rate
implements MeasurableStat {
    protected final TimeUnit unit;
    protected final SampledStat stat;

    public Rate() {
        this(TimeUnit.SECONDS);
    }

    public Rate(TimeUnit unit2) {
        this(unit2, new SampledTotal());
    }

    public Rate(SampledStat stat) {
        this(TimeUnit.SECONDS, stat);
    }

    public Rate(TimeUnit unit2, SampledStat stat) {
        this.stat = stat;
        this.unit = unit2;
    }

    public String unitName() {
        return this.unit.name().substring(0, this.unit.name().length() - 2).toLowerCase(Locale.ROOT);
    }

    @Override
    public void record(MetricConfig config, double value2, long timeMs) {
        this.stat.record(config, value2, timeMs);
    }

    @Override
    public double measure(MetricConfig config, long now) {
        double value2 = this.stat.measure(config, now);
        return value2 / this.convert(this.windowSize(config, now));
    }

    public long windowSize(MetricConfig config, long now) {
        this.stat.purgeObsoleteSamples(config, now);
        long totalElapsedTimeMs = now - this.stat.oldest((long)now).lastWindowMs;
        int numFullWindows = (int)(totalElapsedTimeMs / config.timeWindowMs());
        int minFullWindows = config.samples() - 1;
        if (numFullWindows < minFullWindows) {
            totalElapsedTimeMs += (long)(minFullWindows - numFullWindows) * config.timeWindowMs();
        }
        return totalElapsedTimeMs;
    }

    private double convert(long timeMs) {
        switch (this.unit) {
            case NANOSECONDS: {
                return (double)timeMs * 1000.0 * 1000.0;
            }
            case MICROSECONDS: {
                return (double)timeMs * 1000.0;
            }
            case MILLISECONDS: {
                return timeMs;
            }
            case SECONDS: {
                return (double)timeMs / 1000.0;
            }
            case MINUTES: {
                return (double)timeMs / 60000.0;
            }
            case HOURS: {
                return (double)timeMs / 3600000.0;
            }
            case DAYS: {
                return (double)timeMs / 8.64E7;
            }
        }
        throw new IllegalStateException("Unknown unit: " + (Object)((Object)this.unit));
    }

    public static class SampledTotal
    extends SampledStat {
        public SampledTotal() {
            super(0.0);
        }

        @Override
        protected void update(SampledStat.Sample sample, MetricConfig config, double value2, long timeMs) {
            sample.value += value2;
        }

        @Override
        public double combine(List<SampledStat.Sample> samples, MetricConfig config, long now) {
            double total = 0.0;
            for (SampledStat.Sample sample : samples) {
                total += sample.value;
            }
            return total;
        }
    }
}

