/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.protocol;

import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.types.ArrayOf;
import org.apache.kafka.common.protocol.types.BoundField;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.requests.ResponseHeader;

public class Protocol {
    private static String indentString(int size2) {
        StringBuilder b = new StringBuilder(size2);
        for (int i = 0; i < size2; ++i) {
            b.append(" ");
        }
        return b.toString();
    }

    private static void schemaToBnfHtml(Schema schema, StringBuilder b, int indentSize) {
        String indentStr = Protocol.indentString(indentSize);
        LinkedHashMap<String, Type> subTypes = new LinkedHashMap<String, Type>();
        for (BoundField field2 : schema.fields()) {
            if (field2.def.type instanceof ArrayOf) {
                b.append("[");
                b.append(field2.def.name);
                b.append("] ");
                Type innerType = ((ArrayOf)field2.def.type).type();
                if (subTypes.containsKey(field2.def.name)) continue;
                subTypes.put(field2.def.name, innerType);
                continue;
            }
            b.append(field2.def.name);
            b.append(" ");
            if (subTypes.containsKey(field2.def.name)) continue;
            subTypes.put(field2.def.name, field2.def.type);
        }
        b.append("\n");
        for (Map.Entry entry : subTypes.entrySet()) {
            if (entry.getValue() instanceof Schema) {
                b.append(indentStr);
                b.append((String)entry.getKey());
                b.append(" => ");
                Protocol.schemaToBnfHtml((Schema)entry.getValue(), b, indentSize + 2);
                continue;
            }
            b.append(indentStr);
            b.append((String)entry.getKey());
            b.append(" => ");
            b.append(entry.getValue());
            b.append("\n");
        }
    }

    private static void populateSchemaFields(Schema schema, Set<BoundField> fields2) {
        for (BoundField field2 : schema.fields()) {
            fields2.add(field2);
            if (field2.def.type instanceof ArrayOf) {
                Type innerType = ((ArrayOf)field2.def.type).type();
                if (!(innerType instanceof Schema)) continue;
                Protocol.populateSchemaFields((Schema)innerType, fields2);
                continue;
            }
            if (!(field2.def.type instanceof Schema)) continue;
            Protocol.populateSchemaFields((Schema)field2.def.type, fields2);
        }
    }

    private static void schemaToFieldTableHtml(Schema schema, StringBuilder b) {
        LinkedHashSet<BoundField> fields2 = new LinkedHashSet<BoundField>();
        Protocol.populateSchemaFields(schema, fields2);
        b.append("<table class=\"data-table\"><tbody>\n");
        b.append("<tr>");
        b.append("<th>Field</th>\n");
        b.append("<th>Description</th>\n");
        b.append("</tr>");
        for (BoundField field2 : fields2) {
            b.append("<tr>\n");
            b.append("<td>");
            b.append(field2.def.name);
            b.append("</td>");
            b.append("<td>");
            b.append(field2.def.docString);
            b.append("</td>");
            b.append("</tr>\n");
        }
        b.append("</table>\n");
    }

    public static String toHtml() {
        StringBuilder b = new StringBuilder();
        b.append("<h5>Headers:</h5>\n");
        b.append("<pre>");
        b.append("Request Header => ");
        Protocol.schemaToBnfHtml(RequestHeader.SCHEMA, b, 2);
        b.append("</pre>\n");
        Protocol.schemaToFieldTableHtml(RequestHeader.SCHEMA, b);
        b.append("<pre>");
        b.append("Response Header => ");
        Protocol.schemaToBnfHtml(ResponseHeader.SCHEMA, b, 2);
        b.append("</pre>\n");
        Protocol.schemaToFieldTableHtml(ResponseHeader.SCHEMA, b);
        for (ApiKeys key : ApiKeys.values()) {
            b.append("<h5>");
            b.append("<a name=\"The_Messages_" + key.name + "\">");
            b.append(key.name);
            b.append(" API (Key: ");
            b.append(key.id);
            b.append("):</a></h5>\n\n");
            b.append("<b>Requests:</b><br>\n");
            Schema[] requests = key.requestSchemas;
            for (int i = 0; i < requests.length; ++i) {
                Schema schema = requests[i];
                if (schema != null) {
                    b.append("<p>");
                    b.append("<pre>");
                    b.append(key.name);
                    b.append(" Request (Version: ");
                    b.append(i);
                    b.append(") => ");
                    Protocol.schemaToBnfHtml(requests[i], b, 2);
                    b.append("</pre>");
                    Protocol.schemaToFieldTableHtml(requests[i], b);
                }
                b.append("</p>\n");
            }
            b.append("<b>Responses:</b><br>\n");
            Schema[] responses = key.responseSchemas;
            for (int i = 0; i < responses.length; ++i) {
                Schema schema = responses[i];
                if (schema != null) {
                    b.append("<p>");
                    b.append("<pre>");
                    b.append(key.name);
                    b.append(" Response (Version: ");
                    b.append(i);
                    b.append(") => ");
                    Protocol.schemaToBnfHtml(responses[i], b, 2);
                    b.append("</pre>");
                    Protocol.schemaToFieldTableHtml(responses[i], b);
                }
                b.append("</p>\n");
            }
        }
        return b.toString();
    }

    public static void main(String[] args) {
        System.out.println(Protocol.toHtml());
    }
}

