/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.record;

import java.nio.ByteBuffer;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.record.ControlRecordType;
import org.apache.kafka.common.record.DefaultRecord;
import org.apache.kafka.common.record.InvalidRecordException;
import org.apache.kafka.common.record.Record;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EndTransactionMarker {
    private static final Logger log = LoggerFactory.getLogger(EndTransactionMarker.class);
    private static final short CURRENT_END_TXN_MARKER_VERSION = 0;
    private static final Schema END_TXN_MARKER_SCHEMA_VERSION_V0 = new Schema(new Field("version", Type.INT16), new Field("coordinator_epoch", Type.INT32));
    static final int CURRENT_END_TXN_MARKER_VALUE_SIZE = 6;
    static final int CURRENT_END_TXN_SCHEMA_RECORD_SIZE = DefaultRecord.sizeInBytes(0, 0L, 4, 6, Record.EMPTY_HEADERS);
    private final ControlRecordType type;
    private final int coordinatorEpoch;

    public EndTransactionMarker(ControlRecordType type, int coordinatorEpoch) {
        EndTransactionMarker.ensureTransactionMarkerControlType(type);
        this.type = type;
        this.coordinatorEpoch = coordinatorEpoch;
    }

    public int coordinatorEpoch() {
        return this.coordinatorEpoch;
    }

    public ControlRecordType controlType() {
        return this.type;
    }

    private Struct buildRecordValue() {
        Struct struct = new Struct(END_TXN_MARKER_SCHEMA_VERSION_V0);
        struct.set("version", (Object)0);
        struct.set("coordinator_epoch", (Object)this.coordinatorEpoch);
        return struct;
    }

    public ByteBuffer serializeValue() {
        Struct valueStruct = this.buildRecordValue();
        ByteBuffer value2 = ByteBuffer.allocate(valueStruct.sizeOf());
        valueStruct.writeTo(value2);
        value2.flip();
        return value2;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EndTransactionMarker that = (EndTransactionMarker)o;
        return this.coordinatorEpoch == that.coordinatorEpoch && this.type == that.type;
    }

    public int hashCode() {
        int result2 = this.type != null ? this.type.hashCode() : 0;
        result2 = 31 * result2 + this.coordinatorEpoch;
        return result2;
    }

    private static void ensureTransactionMarkerControlType(ControlRecordType type) {
        if (type != ControlRecordType.COMMIT && type != ControlRecordType.ABORT) {
            throw new IllegalArgumentException("Invalid control record type for end transaction marker" + (Object)((Object)type));
        }
    }

    public static EndTransactionMarker deserialize(Record record2) {
        ControlRecordType type = ControlRecordType.parse(record2.key());
        return EndTransactionMarker.deserializeValue(type, record2.value());
    }

    static EndTransactionMarker deserializeValue(ControlRecordType type, ByteBuffer value2) {
        EndTransactionMarker.ensureTransactionMarkerControlType(type);
        if (value2.remaining() < 6) {
            throw new InvalidRecordException("Invalid value size found for end transaction marker. Must have at least 6 bytes, but found only " + value2.remaining());
        }
        short version = value2.getShort(0);
        if (version < 0) {
            throw new InvalidRecordException("Invalid version found for end transaction marker: " + version + ". May indicate data corruption");
        }
        if (version > 0) {
            log.debug("Received end transaction marker value version {}. Parsing as version {}", (Object)version, (Object)0);
        }
        int coordinatorEpoch = value2.getInt(2);
        return new EndTransactionMarker(type, coordinatorEpoch);
    }
}

