/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.types.ArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.DeleteTopicsResponse;
import org.apache.kafka.common.utils.Utils;

public class DeleteTopicsRequest
extends AbstractRequest {
    private static final String TOPICS_KEY_NAME = "topics";
    private static final String TIMEOUT_KEY_NAME = "timeout";
    private static final Schema DELETE_TOPICS_REQUEST_V0;
    private static final Schema DELETE_TOPICS_REQUEST_V1;
    private static final Schema DELETE_TOPICS_REQUEST_V2;
    private static final Schema DELETE_TOPICS_REQUEST_V3;
    private final Set<String> topics;
    private final Integer timeout;

    public static Schema[] schemaVersions() {
        return new Schema[]{DELETE_TOPICS_REQUEST_V0, DELETE_TOPICS_REQUEST_V1, DELETE_TOPICS_REQUEST_V2, DELETE_TOPICS_REQUEST_V3};
    }

    private DeleteTopicsRequest(Set<String> topics2, Integer timeout, short version) {
        super(ApiKeys.DELETE_TOPICS, version);
        this.topics = topics2;
        this.timeout = timeout;
    }

    public DeleteTopicsRequest(Struct struct, short version) {
        super(ApiKeys.DELETE_TOPICS, version);
        Object[] topicsArray = struct.getArray(TOPICS_KEY_NAME);
        HashSet<String> topics2 = new HashSet<String>(topicsArray.length);
        for (Object topic : topicsArray) {
            topics2.add((String)topic);
        }
        this.topics = topics2;
        this.timeout = struct.getInt(TIMEOUT_KEY_NAME);
    }

    @Override
    protected Struct toStruct() {
        Struct struct = new Struct(ApiKeys.DELETE_TOPICS.requestSchema(this.version()));
        struct.set(TOPICS_KEY_NAME, (Object)this.topics.toArray());
        struct.set(TIMEOUT_KEY_NAME, (Object)this.timeout);
        return struct;
    }

    @Override
    public AbstractResponse getErrorResponse(int throttleTimeMs, Throwable e) {
        HashMap<String, Errors> topicErrors = new HashMap<String, Errors>();
        for (String topic : this.topics) {
            topicErrors.put(topic, Errors.forException(e));
        }
        switch (this.version()) {
            case 0: {
                return new DeleteTopicsResponse(topicErrors);
            }
            case 1: 
            case 2: 
            case 3: {
                return new DeleteTopicsResponse(throttleTimeMs, topicErrors);
            }
        }
        throw new IllegalArgumentException(String.format("Version %d is not valid. Valid versions for %s are 0 to %d", this.version(), this.getClass().getSimpleName(), ApiKeys.DELETE_TOPICS.latestVersion()));
    }

    public Set<String> topics() {
        return this.topics;
    }

    public Integer timeout() {
        return this.timeout;
    }

    public static DeleteTopicsRequest parse(ByteBuffer buffer, short version) {
        return new DeleteTopicsRequest(ApiKeys.DELETE_TOPICS.parseRequest(version, buffer), version);
    }

    static {
        DELETE_TOPICS_REQUEST_V3 = DELETE_TOPICS_REQUEST_V2 = (DELETE_TOPICS_REQUEST_V1 = (DELETE_TOPICS_REQUEST_V0 = new Schema(new Field(TOPICS_KEY_NAME, new ArrayOf(Type.STRING), "An array of topics to be deleted."), new Field(TIMEOUT_KEY_NAME, Type.INT32, "The time in ms to wait for a topic to be completely deleted on the controller node. Values <= 0 will trigger topic deletion and return immediately"))));
    }

    public static class Builder
    extends AbstractRequest.Builder<DeleteTopicsRequest> {
        private final Set<String> topics;
        private final Integer timeout;

        public Builder(Set<String> topics2, Integer timeout) {
            super(ApiKeys.DELETE_TOPICS);
            this.topics = topics2;
            this.timeout = timeout;
        }

        @Override
        public DeleteTopicsRequest build(short version) {
            return new DeleteTopicsRequest(this.topics, this.timeout, version);
        }

        public String toString() {
            StringBuilder bld = new StringBuilder();
            bld.append("(type=DeleteTopicsRequest").append(", topics=(").append(Utils.join(this.topics, ", ")).append(")").append(", timeout=").append(this.timeout).append(")");
            return bld.toString();
        }
    }
}

