/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.security.kerberos;

import java.io.IOException;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.kafka.common.security.kerberos.BadFormatString;
import org.apache.kafka.common.security.kerberos.NoMatchingRule;

class KerberosRule {
    private static final Pattern PARAMETER_PATTERN = Pattern.compile("([^$]*)(\\$(\\d*))?");
    private static final Pattern NON_SIMPLE_PATTERN = Pattern.compile("[/@]");
    private final String defaultRealm;
    private final boolean isDefault;
    private final int numOfComponents;
    private final String format;
    private final Pattern match;
    private final Pattern fromPattern;
    private final String toPattern;
    private final boolean repeat;
    private final boolean toLowerCase;

    KerberosRule(String defaultRealm) {
        this.defaultRealm = defaultRealm;
        this.isDefault = true;
        this.numOfComponents = 0;
        this.format = null;
        this.match = null;
        this.fromPattern = null;
        this.toPattern = null;
        this.repeat = false;
        this.toLowerCase = false;
    }

    KerberosRule(String defaultRealm, int numOfComponents, String format, String match, String fromPattern, String toPattern, boolean repeat, boolean toLowerCase) {
        this.defaultRealm = defaultRealm;
        this.isDefault = false;
        this.numOfComponents = numOfComponents;
        this.format = format;
        this.match = match == null ? null : Pattern.compile(match);
        this.fromPattern = fromPattern == null ? null : Pattern.compile(fromPattern);
        this.toPattern = toPattern;
        this.repeat = repeat;
        this.toLowerCase = toLowerCase;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        if (this.isDefault) {
            buf.append("DEFAULT");
        } else {
            buf.append("RULE:[");
            buf.append(this.numOfComponents);
            buf.append(':');
            buf.append(this.format);
            buf.append(']');
            if (this.match != null) {
                buf.append('(');
                buf.append(this.match);
                buf.append(')');
            }
            if (this.fromPattern != null) {
                buf.append("s/");
                buf.append(this.fromPattern);
                buf.append('/');
                buf.append(this.toPattern);
                buf.append('/');
                if (this.repeat) {
                    buf.append('g');
                }
            }
            if (this.toLowerCase) {
                buf.append("/L");
            }
        }
        return buf.toString();
    }

    static String replaceParameters(String format, String[] params) throws BadFormatString {
        Matcher match = PARAMETER_PATTERN.matcher(format);
        int start2 = 0;
        StringBuilder result2 = new StringBuilder();
        while (start2 < format.length() && match.find(start2)) {
            result2.append(match.group(1));
            String paramNum = match.group(3);
            if (paramNum != null) {
                try {
                    int num = Integer.parseInt(paramNum);
                    if (num < 0 || num >= params.length) {
                        throw new BadFormatString("index " + num + " from " + format + " is outside of the valid range 0 to " + (params.length - 1));
                    }
                    result2.append(params[num]);
                }
                catch (NumberFormatException nfe) {
                    throw new BadFormatString("bad format in username mapping in " + paramNum, nfe);
                }
            }
            start2 = match.end();
        }
        return result2.toString();
    }

    static String replaceSubstitution(String base, Pattern from2, String to2, boolean repeat) {
        Matcher match = from2.matcher(base);
        if (repeat) {
            return match.replaceAll(to2);
        }
        return match.replaceFirst(to2);
    }

    String apply(String[] params) throws IOException {
        String result2 = null;
        if (this.isDefault) {
            if (this.defaultRealm.equals(params[0])) {
                result2 = params[1];
            }
        } else if (params.length - 1 == this.numOfComponents) {
            String base = KerberosRule.replaceParameters(this.format, params);
            if (this.match == null || this.match.matcher(base).matches()) {
                result2 = this.fromPattern == null ? base : KerberosRule.replaceSubstitution(base, this.fromPattern, this.toPattern, this.repeat);
            }
        }
        if (result2 != null && NON_SIMPLE_PATTERN.matcher(result2).find()) {
            throw new NoMatchingRule("Non-simple name " + result2 + " after auth_to_local rule " + this);
        }
        if (this.toLowerCase && result2 != null) {
            result2 = result2.toLowerCase(Locale.ENGLISH);
        }
        return result2;
    }
}

