/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.serialization;

import java.util.Map;
import org.apache.kafka.common.errors.SerializationException;
import org.apache.kafka.common.serialization.Deserializer;

public class ShortDeserializer
implements Deserializer<Short> {
    @Override
    public void configure(Map<String, ?> configs, boolean isKey) {
    }

    @Override
    public Short deserialize(String topic, byte[] data) {
        if (data == null) {
            return null;
        }
        if (data.length != 2) {
            throw new SerializationException("Size of data received by ShortDeserializer is not 2");
        }
        short value2 = 0;
        for (byte b : data) {
            value2 = (short)(value2 << 8);
            value2 = (short)(value2 | b & 0xFF);
        }
        return value2;
    }

    @Override
    public void close() {
    }
}

