/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.Expression;
import org.hsqldb.ExpressionColumn;
import org.hsqldb.ExpressionLogical;
import org.hsqldb.ExpressionPeriod;
import org.hsqldb.ExpressionValue;
import org.hsqldb.HsqlException;
import org.hsqldb.PeriodDefinition;
import org.hsqldb.RangeGroup;
import org.hsqldb.RangeVariable;
import org.hsqldb.Session;
import org.hsqldb.error.Error;
import org.hsqldb.lib.HsqlList;
import org.hsqldb.lib.Set;
import org.hsqldb.types.DateTimeType;
import org.hsqldb.types.Type;

public class ExpressionPeriodOp
extends ExpressionLogical {
    PeriodDefinition leftPeriod;
    PeriodDefinition rightPeriod;
    final boolean isSystemVersionCondition;
    boolean transformed;

    private ExpressionPeriodOp(Expression[] expressionArray) {
        super(44);
        this.nodes = expressionArray;
        this.isSystemVersionCondition = false;
    }

    ExpressionPeriodOp(int n, Expression expression2, Expression expression3) {
        super(n, expression2, expression3);
        this.isSystemVersionCondition = false;
    }

    ExpressionPeriodOp() {
        super(60);
        ExpressionPeriod expressionPeriod = new ExpressionPeriod();
        Expression expression2 = ExpressionPeriodOp.getEpochLimitExpression();
        this.nodes = new Expression[]{expressionPeriod, expression2};
        this.isSystemVersionCondition = false;
    }

    ExpressionPeriodOp(Expression expression2) {
        super(59);
        ExpressionPeriod expressionPeriod = new ExpressionPeriod();
        this.nodes = new Expression[]{expressionPeriod, expression2};
        this.isSystemVersionCondition = true;
    }

    ExpressionPeriodOp(Expression expression2, Expression expression3) {
        super(61);
        ExpressionPeriod expressionPeriod = new ExpressionPeriod();
        ExpressionPeriod expressionPeriod2 = new ExpressionPeriod(expression2, expression3);
        this.nodes = new Expression[]{expressionPeriod, expressionPeriod2};
        this.isSystemVersionCondition = true;
    }

    boolean isSystemVersionCondition() {
        return this.isSystemVersionCondition;
    }

    void setSystemRangeVariable(Session session, RangeVariable rangeVariable) {
        ExpressionPeriod expressionPeriod = (ExpressionPeriod)this.nodes[0];
        expressionPeriod.setRangeVariable(rangeVariable);
        Expression expression2 = this.nodes[1];
        HsqlList hsqlList = expression2.resolveColumnReferences(session, RangeGroup.emptyGroup, RangeGroup.emptyArray, null);
        ExpressionColumn.checkColumnsResolved(hsqlList);
        expression2.resolveTypes(session, null);
        this.transform();
    }

    @Override
    public HsqlList resolveColumnReferences(Session session, RangeGroup rangeGroup, int n, RangeGroup[] rangeGroupArray, HsqlList hsqlList, boolean bl) {
        ExpressionColumn expressionColumn;
        if (this.opType == 59 && this.nodes[1] instanceof ExpressionPeriod && (expressionColumn = ((ExpressionPeriod)this.nodes[1]).columnExpr) != null) {
            try {
                this.nodes[1].resolveColumnReferences(session, rangeGroup, n, rangeGroupArray, hsqlList, bl);
            }
            catch (HsqlException hsqlException) {
                this.nodes[1] = expressionColumn;
            }
        }
        for (int i = 0; i < this.nodes.length; ++i) {
            hsqlList = this.nodes[i].resolveColumnReferences(session, rangeGroup, n, rangeGroupArray, hsqlList, bl);
        }
        if (this.nodes[0] instanceof ExpressionPeriod) {
            this.leftPeriod = ((ExpressionPeriod)this.nodes[0]).period;
        }
        if (this.nodes[1] instanceof ExpressionPeriod) {
            this.rightPeriod = ((ExpressionPeriod)this.nodes[1]).period;
        }
        if (!this.transformed) {
            this.transform();
        }
        return hsqlList;
    }

    @Override
    public void resolveTypes(Session session, Expression expression2) {
        super.resolveTypes(session, expression2);
    }

    private void transform() {
        Expression expression2;
        ExpressionPeriod expressionPeriod = (ExpressionPeriod)this.nodes[0];
        boolean bl = true;
        boolean bl2 = true;
        if (expressionPeriod.isNamedPeriod()) {
            if (expressionPeriod.getPeriodType() == 1) {
                // empty if block
            }
            bl = false;
        } else {
            expression2 = expressionPeriod.getLeftNode();
            if (expression2.opType == 8) {
                expression2.dataType = Type.SQL_TIMESTAMP_WITH_TIME_ZONE;
            }
            expression2 = expressionPeriod.getRightNode();
            if (expression2.opType == 8) {
                expression2.dataType = Type.SQL_TIMESTAMP_WITH_TIME_ZONE;
            }
        }
        if (this.nodes[1] instanceof ExpressionPeriod) {
            expression2 = (ExpressionPeriod)this.nodes[1];
            if (((ExpressionPeriod)expression2).isNamedPeriod()) {
                if (((ExpressionPeriod)expression2).getPeriodType() == 1) {
                    // empty if block
                }
                bl2 = false;
            } else {
                Expression expression3 = expression2.getLeftNode();
                if (expression3.opType == 8) {
                    expression3.dataType = Type.SQL_TIMESTAMP_WITH_TIME_ZONE;
                }
                expression3 = expression2.getRightNode();
                if (expression3.opType == 8) {
                    expression3.dataType = Type.SQL_TIMESTAMP_WITH_TIME_ZONE;
                }
            }
        } else {
            bl2 = false;
        }
        expression2 = ExpressionPeriodOp.newExpression(this.opType, this.nodes, bl, bl2);
        this.nodes = expression2.nodes;
        this.opType = expression2.opType;
        this.transformed = true;
    }

    @Override
    public Object getValue(Session session) {
        Object object = super.getValue(session);
        if (this.opType == 44 && Boolean.FALSE.equals(object)) {
            throw Error.error(3462);
        }
        return object;
    }

    @Override
    void collectObjectNames(Set set2) {
        if (this.leftPeriod != null) {
            set2.add(this.leftPeriod.getName());
        }
        if (this.rightPeriod != null) {
            set2.add(this.rightPeriod.getName());
        }
    }

    static Expression getEpochLimitExpression() {
        return new ExpressionValue(DateTimeType.epochLimitTimestamp, Type.SQL_TIMESTAMP_WITH_TIME_ZONE);
    }

    static ExpressionLogical newExpression(int n, Expression[] expressionArray, boolean bl, boolean bl2) {
        ExpressionLogical expressionLogical;
        ExpressionLogical expressionLogical2;
        ExpressionLogical expressionLogical3;
        Expression expression2 = expressionArray[0];
        Expression expression3 = expressionArray[1];
        switch (n) {
            case 59: {
                if (expression3 instanceof ExpressionPeriod) {
                    expressionLogical3 = new ExpressionLogical(45, expression2.getLeftNode(), expression3.getLeftNode());
                    expressionLogical2 = new ExpressionLogical(41, expression2.getRightNode(), expression3.getRightNode());
                    expressionLogical = new ExpressionLogical(49, expressionLogical3, expressionLogical2);
                    break;
                }
                expressionLogical3 = new ExpressionLogical(45, expression2.getLeftNode(), expression3);
                expressionLogical2 = new ExpressionLogical(43, expression2.getRightNode(), expression3);
                expressionLogical = new ExpressionLogical(49, expressionLogical3, expressionLogical2);
                break;
            }
            case 60: {
                if (expression3 instanceof ExpressionPeriod) {
                    expressionLogical3 = new ExpressionLogical(40, expression2.getLeftNode(), expression3.getLeftNode());
                    expressionLogical2 = new ExpressionLogical(40, expression2.getRightNode(), expression3.getRightNode());
                    expressionLogical = new ExpressionLogical(49, expressionLogical3, expressionLogical2);
                    break;
                }
                expressionLogical = new ExpressionLogical(40, expression2.getRightNode(), expression3);
                break;
            }
            case 61: {
                expressionLogical3 = new ExpressionLogical(44, expression2.getLeftNode(), expression3.getRightNode());
                expressionLogical2 = new ExpressionLogical(43, expression2.getRightNode(), expression3.getLeftNode());
                expressionLogical = new ExpressionLogical(49, expressionLogical3, expressionLogical2);
                break;
            }
            case 62: {
                expressionLogical = new ExpressionLogical(45, expression2.getRightNode(), expression3.getLeftNode());
                break;
            }
            case 64: {
                expressionLogical = new ExpressionLogical(40, expression2.getRightNode(), expression3.getLeftNode());
                break;
            }
            case 63: {
                expressionLogical = new ExpressionLogical(41, expression2.getLeftNode(), expression3.getRightNode());
                break;
            }
            case 65: {
                expressionLogical = new ExpressionLogical(40, expression2.getLeftNode(), expression3.getRightNode());
                break;
            }
            default: {
                throw Error.runtimeError(201, "ExpressionLogical");
            }
        }
        expressionLogical3 = null;
        expressionLogical2 = null;
        if (bl) {
            expressionLogical3 = new ExpressionPeriodOp(expression2.nodes);
        }
        if (bl2) {
            expressionLogical2 = new ExpressionPeriodOp(expression3.nodes);
        }
        if (expressionLogical3 == null) {
            expressionLogical3 = expressionLogical2;
            expressionLogical2 = null;
        }
        if (expressionLogical2 != null) {
            expressionLogical3 = new ExpressionLogical(49, expressionLogical3, expressionLogical2);
            expressionLogical2 = null;
        }
        if (expressionLogical3 != null) {
            expressionLogical = new ExpressionLogical(49, expressionLogical3, expressionLogical);
        }
        return expressionLogical;
    }
}

