/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.lib.tar;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Date;
import org.hsqldb.lib.java.JavaSystem;
import org.hsqldb.lib.tar.RB;
import org.hsqldb.lib.tar.TarMalformatException;

public class PIFGenerator
extends ByteArrayOutputStream {
    OutputStreamWriter writer = new OutputStreamWriter((OutputStream)this, JavaSystem.CS_UTF8);
    String name;
    int fakePid = (int)(new Date().getTime() % 100000L);

    public String getName() {
        return this.name;
    }

    protected PIFGenerator() {
    }

    public PIFGenerator(int n) {
        this();
        if (n < 1) {
            throw new IllegalArgumentException("Sequence numbers start at 1");
        }
        this.name = System.getProperty("java.io.tmpdir") + "/GlobalHead." + this.fakePid + '.' + n;
    }

    public PIFGenerator(File file) {
        this();
        String string2 = file.getParentFile() == null ? "." : file.getParentFile().getPath();
        this.name = string2 + "/PaxHeaders." + this.fakePid + '/' + file.getName();
    }

    public void addRecord(String string2, boolean bl) throws TarMalformatException, IOException {
        this.addRecord(string2, Boolean.toString(bl));
    }

    public void addRecord(String string2, int n) throws TarMalformatException, IOException {
        this.addRecord(string2, Integer.toString(n));
    }

    public void addRecord(String string2, long l) throws TarMalformatException, IOException {
        this.addRecord(string2, Long.toString(l));
    }

    public void addRecord(String string2, String string3) throws TarMalformatException, IOException {
        if (string2 == null || string3 == null || string2.length() < 1 || string3.length() < 1) {
            throw new TarMalformatException(RB.zero_write.getString());
        }
        int n = string2.length() + string3.length() + 3;
        int n2 = 0;
        if (n < 8) {
            n2 = n + 1;
        } else if (n < 97) {
            n2 = n + 2;
        } else if (n < 996) {
            n2 = n + 3;
        } else if (n < 9995) {
            n2 = n + 4;
        } else if (n < 99994) {
            n2 = n + 5;
        } else {
            throw new TarMalformatException(RB.pif_toobig.getString(99991));
        }
        this.writer.write(Integer.toString(n2));
        this.writer.write(32);
        this.writer.write(string2);
        this.writer.write(61);
        this.writer.write(string3);
        this.writer.write(10);
        this.writer.flush();
    }
}

