/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.persist;

import org.hsqldb.HsqlException;
import org.hsqldb.Table;
import org.hsqldb.lib.HashMap;
import org.hsqldb.lib.Iterator;
import org.hsqldb.persist.DataFileCache;
import org.hsqldb.persist.TextCache;

public class TextTableStorageManager {
    private HashMap textCacheList = new HashMap();

    TextTableStorageManager() {
    }

    public DataFileCache openTextFilePersistence(Table table, String string2, boolean bl, boolean bl2) {
        this.closeTextCache(table);
        TextCache textCache = new TextCache(table, string2);
        textCache.open(bl || bl2);
        this.textCacheList.put(table.getName(), textCache);
        return textCache;
    }

    public void closeTextCache(Table table) {
        TextCache textCache = (TextCache)this.textCacheList.remove(table.getName());
        if (textCache != null) {
            try {
                textCache.close();
            }
            catch (HsqlException hsqlException) {
                // empty catch block
            }
        }
    }

    public void closeAllTextCaches(boolean bl) {
        Iterator iterator = this.textCacheList.values().iterator();
        while (iterator.hasNext()) {
            TextCache textCache = (TextCache)iterator.next();
            if (bl && !textCache.table.isDataReadOnly()) {
                textCache.purge();
                continue;
            }
            textCache.close();
        }
    }

    public boolean isAnyTextCacheModified() {
        Iterator iterator = this.textCacheList.values().iterator();
        while (iterator.hasNext()) {
            if (!((TextCache)iterator.next()).isModified()) continue;
            return true;
        }
        return false;
    }
}

