/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.rights;

import org.hsqldb.ExpressionLogical;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.SchemaObject;
import org.hsqldb.Table;
import org.hsqldb.error.Error;
import org.hsqldb.lib.HashSet;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.OrderedHashSet;
import org.hsqldb.rights.Grantee;
import org.hsqldb.rights.GranteeManager;

public final class Right {
    boolean isFull;
    boolean isFullSelect;
    boolean isFullInsert;
    boolean isFullUpdate;
    boolean isFullReferences;
    boolean isFullTrigger;
    boolean isFullDelete;
    OrderedHashSet selectColumnSet;
    OrderedHashSet insertColumnSet;
    OrderedHashSet updateColumnSet;
    OrderedHashSet referencesColumnSet;
    OrderedHashSet triggerColumnSet;
    ExpressionLogical filterExpression;
    Right grantableRights;
    Grantee grantor;
    Grantee grantee;
    public static final OrderedHashSet emptySet = new OrderedHashSet();
    public static final Right fullRights = new Right(true);
    public static final Right noRights = new Right();
    public static final String[] privilegeNames;
    public static final int[] privilegeTypes;

    public Right() {
        this.isFull = false;
    }

    public Right(boolean bl) {
        this.isFull = bl;
    }

    public boolean isFull() {
        return this.isFull;
    }

    public Grantee getGrantor() {
        return this.grantor;
    }

    public Grantee getGrantee() {
        return this.grantee;
    }

    public Right getGrantableRights() {
        return this.grantableRights == null ? noRights : this.grantableRights;
    }

    public Right duplicate() {
        Right right2 = new Right();
        right2.add(this);
        if (this.filterExpression != null) {
            right2.filterExpression = this.filterExpression;
        }
        return right2;
    }

    public void setFilterExpression(ExpressionLogical expressionLogical) {
        if (expressionLogical != null) {
            this.filterExpression = expressionLogical;
        }
    }

    public void add(Right right2) {
        if (this.isFull) {
            return;
        }
        if (right2.isFull) {
            this.clear();
            this.isFull = true;
            return;
        }
        this.isFullSelect |= right2.isFullSelect;
        this.isFullInsert |= right2.isFullInsert;
        this.isFullUpdate |= right2.isFullUpdate;
        this.isFullReferences |= right2.isFullReferences;
        this.isFullDelete |= right2.isFullDelete;
        if (this.isFullSelect) {
            this.selectColumnSet = null;
        } else if (right2.selectColumnSet != null) {
            if (this.selectColumnSet == null) {
                this.selectColumnSet = new OrderedHashSet();
            }
            this.selectColumnSet.addAll(right2.selectColumnSet);
        }
        if (this.isFullInsert) {
            this.insertColumnSet = null;
        } else if (right2.insertColumnSet != null) {
            if (this.insertColumnSet == null) {
                this.insertColumnSet = new OrderedHashSet();
            }
            this.insertColumnSet.addAll(right2.insertColumnSet);
        }
        if (this.isFullUpdate) {
            this.updateColumnSet = null;
        } else if (right2.updateColumnSet != null) {
            if (this.updateColumnSet == null) {
                this.updateColumnSet = new OrderedHashSet();
            }
            this.updateColumnSet.addAll(right2.updateColumnSet);
        }
        if (this.isFullReferences) {
            this.referencesColumnSet = null;
        } else if (right2.referencesColumnSet != null) {
            if (this.referencesColumnSet == null) {
                this.referencesColumnSet = new OrderedHashSet();
            }
            this.referencesColumnSet.addAll(right2.referencesColumnSet);
        }
        if (this.isFullTrigger) {
            this.triggerColumnSet = null;
        } else if (right2.triggerColumnSet != null) {
            if (this.triggerColumnSet == null) {
                this.triggerColumnSet = new OrderedHashSet();
            }
            this.triggerColumnSet.addAll(right2.triggerColumnSet);
        }
    }

    public void remove(SchemaObject schemaObject, Right right2) {
        if (right2.isFull) {
            this.clear();
            return;
        }
        if (this.isFull) {
            this.isFull = false;
            this.isFullDelete = true;
            this.isFullReferences = true;
            this.isFullUpdate = true;
            this.isFullInsert = true;
            this.isFullSelect = true;
        }
        if (right2.isFullDelete) {
            this.isFullDelete = false;
        }
        if (this.isFullSelect || this.selectColumnSet != null) {
            if (right2.isFullSelect) {
                this.isFullSelect = false;
                this.selectColumnSet = null;
            } else if (right2.selectColumnSet != null) {
                if (this.isFullSelect) {
                    this.isFullSelect = false;
                    this.selectColumnSet = ((Table)schemaObject).getColumnNameSet();
                }
                this.selectColumnSet.removeAll(right2.selectColumnSet);
                if (this.selectColumnSet.isEmpty()) {
                    this.selectColumnSet = null;
                }
            }
        }
        if (this.isFullInsert || this.insertColumnSet != null) {
            if (right2.isFullInsert) {
                this.isFullInsert = false;
                this.insertColumnSet = null;
            } else if (right2.insertColumnSet != null) {
                if (this.isFullInsert) {
                    this.isFullInsert = false;
                    this.insertColumnSet = ((Table)schemaObject).getColumnNameSet();
                }
                this.insertColumnSet.removeAll(right2.insertColumnSet);
                if (this.insertColumnSet.isEmpty()) {
                    this.insertColumnSet = null;
                }
            }
        }
        if (this.isFullUpdate || this.updateColumnSet != null) {
            if (right2.isFullUpdate) {
                this.isFullUpdate = false;
                this.updateColumnSet = null;
            } else if (right2.updateColumnSet != null) {
                if (this.isFullUpdate) {
                    this.isFullUpdate = false;
                    this.updateColumnSet = ((Table)schemaObject).getColumnNameSet();
                }
                this.updateColumnSet.removeAll(right2.updateColumnSet);
                if (this.updateColumnSet.isEmpty()) {
                    this.updateColumnSet = null;
                }
            }
        }
        if (this.isFullReferences || this.referencesColumnSet != null) {
            if (right2.isFullReferences) {
                this.isFullReferences = false;
                this.referencesColumnSet = null;
            } else if (right2.referencesColumnSet != null) {
                if (this.isFullReferences) {
                    this.isFullReferences = false;
                    this.referencesColumnSet = ((Table)schemaObject).getColumnNameSet();
                }
                this.referencesColumnSet.removeAll(right2.referencesColumnSet);
                if (this.referencesColumnSet.isEmpty()) {
                    this.referencesColumnSet = null;
                }
            }
        }
        if (this.isFullTrigger || this.triggerColumnSet != null) {
            if (right2.isFullTrigger) {
                this.isFullTrigger = false;
                this.triggerColumnSet = null;
            } else if (right2.triggerColumnSet != null) {
                if (this.isFullTrigger) {
                    this.isFullTrigger = false;
                    this.triggerColumnSet = ((Table)schemaObject).getColumnNameSet();
                }
                this.triggerColumnSet.removeAll(right2.triggerColumnSet);
                if (this.triggerColumnSet.isEmpty()) {
                    this.triggerColumnSet = null;
                }
            }
        }
    }

    void clear() {
        this.isFullDelete = false;
        this.isFullReferences = false;
        this.isFullUpdate = false;
        this.isFullInsert = false;
        this.isFullSelect = false;
        this.isFull = false;
        this.triggerColumnSet = null;
        this.referencesColumnSet = null;
        this.updateColumnSet = null;
        this.insertColumnSet = null;
        this.selectColumnSet = null;
    }

    public boolean isEmpty() {
        if (this.isFull || this.isFullSelect || this.isFullInsert || this.isFullUpdate || this.isFullReferences || this.isFullDelete) {
            return false;
        }
        if (this.selectColumnSet != null && !this.selectColumnSet.isEmpty()) {
            return false;
        }
        if (this.insertColumnSet != null && !this.insertColumnSet.isEmpty()) {
            return false;
        }
        if (this.updateColumnSet != null && !this.updateColumnSet.isEmpty()) {
            return false;
        }
        if (this.referencesColumnSet != null && !this.referencesColumnSet.isEmpty()) {
            return false;
        }
        return this.triggerColumnSet == null || this.triggerColumnSet.isEmpty();
    }

    OrderedHashSet getColumnsForAllRights(Table table) {
        if (this.isFull) {
            return table.getColumnNameSet();
        }
        if (this.isFullSelect || this.isFullInsert || this.isFullUpdate || this.isFullReferences) {
            return table.getColumnNameSet();
        }
        OrderedHashSet orderedHashSet = new OrderedHashSet();
        if (this.selectColumnSet != null) {
            orderedHashSet.addAll(this.selectColumnSet);
        }
        if (this.insertColumnSet != null) {
            orderedHashSet.addAll(this.insertColumnSet);
        }
        if (this.updateColumnSet != null) {
            orderedHashSet.addAll(this.updateColumnSet);
        }
        if (this.referencesColumnSet != null) {
            orderedHashSet.addAll(this.referencesColumnSet);
        }
        return orderedHashSet;
    }

    public boolean contains(Right right2) {
        if (this.isFull) {
            return true;
        }
        if (right2.isFull) {
            return false;
        }
        if (!Right.containsRights(this.isFullSelect, this.selectColumnSet, right2.selectColumnSet, right2.isFullSelect)) {
            return false;
        }
        if (!Right.containsRights(this.isFullInsert, this.insertColumnSet, right2.insertColumnSet, right2.isFullInsert)) {
            return false;
        }
        if (!Right.containsRights(this.isFullUpdate, this.updateColumnSet, right2.updateColumnSet, right2.isFullUpdate)) {
            return false;
        }
        if (!Right.containsRights(this.isFullReferences, this.referencesColumnSet, right2.referencesColumnSet, right2.isFullReferences)) {
            return false;
        }
        if (!Right.containsRights(this.isFullTrigger, this.triggerColumnSet, right2.triggerColumnSet, right2.isFullTrigger)) {
            return false;
        }
        return this.isFullDelete || !right2.isFullDelete;
    }

    void removeDroppedColumns(OrderedHashSet orderedHashSet, Table table) {
        for (int i = 0; i < orderedHashSet.size(); ++i) {
            HsqlNameManager.HsqlName hsqlName = (HsqlNameManager.HsqlName)orderedHashSet.get(i);
            if (table.findColumn(hsqlName.name) < 0) continue;
            orderedHashSet.remove(i);
            --i;
        }
    }

    public OrderedHashSet getColumnsForPrivilege(Table table, int n) {
        if (this.isFull) {
            return table.getColumnNameSet();
        }
        switch (n) {
            case 1: {
                return this.isFullSelect ? table.getColumnNameSet() : (this.selectColumnSet == null ? emptySet : this.selectColumnSet);
            }
            case 4: {
                return this.isFullInsert ? table.getColumnNameSet() : (this.insertColumnSet == null ? emptySet : this.insertColumnSet);
            }
            case 8: {
                return this.isFullUpdate ? table.getColumnNameSet() : (this.updateColumnSet == null ? emptySet : this.updateColumnSet);
            }
            case 64: {
                return this.isFullReferences ? table.getColumnNameSet() : (this.referencesColumnSet == null ? emptySet : this.referencesColumnSet);
            }
            case 128: {
                return this.isFullTrigger ? table.getColumnNameSet() : (this.triggerColumnSet == null ? emptySet : this.triggerColumnSet);
            }
        }
        return emptySet;
    }

    static boolean containsAllColumns(OrderedHashSet orderedHashSet, Table table, boolean[] blArray) {
        for (int i = 0; i < blArray.length; ++i) {
            if (!blArray[i]) continue;
            if (orderedHashSet == null) {
                return false;
            }
            if (orderedHashSet.contains(table.getColumn(i).getName())) continue;
            return false;
        }
        return true;
    }

    static boolean containsRights(boolean bl, OrderedHashSet orderedHashSet, OrderedHashSet orderedHashSet2, boolean bl2) {
        if (bl) {
            return true;
        }
        if (bl2) {
            return false;
        }
        return orderedHashSet2 == null || orderedHashSet != null && orderedHashSet.containsAll(orderedHashSet2);
    }

    boolean canSelect(Table table, boolean[] blArray) {
        if (this.isFull || this.isFullSelect) {
            return true;
        }
        return Right.containsAllColumns(this.selectColumnSet, table, blArray);
    }

    boolean canInsert(Table table, boolean[] blArray) {
        if (this.isFull || this.isFullInsert) {
            return true;
        }
        return Right.containsAllColumns(this.insertColumnSet, table, blArray);
    }

    boolean canUpdate(Table table, boolean[] blArray) {
        if (this.isFull || this.isFullUpdate) {
            return true;
        }
        return Right.containsAllColumns(this.updateColumnSet, table, blArray);
    }

    boolean canReference(Table table, boolean[] blArray) {
        if (this.isFull || this.isFullReferences) {
            return true;
        }
        return Right.containsAllColumns(this.referencesColumnSet, table, blArray);
    }

    boolean canTrigger(Table table, boolean[] blArray) {
        if (this.isFull || this.isFullTrigger) {
            return true;
        }
        return Right.containsAllColumns(this.triggerColumnSet, table, blArray);
    }

    boolean canDelete() {
        return this.isFull || this.isFullDelete;
    }

    public boolean canAccessFully(int n) {
        if (this.isFull) {
            return true;
        }
        switch (n) {
            case 2: {
                return this.isFullDelete;
            }
            case 1: {
                return this.isFullSelect;
            }
            case 4: {
                return this.isFullInsert;
            }
            case 8: {
                return this.isFullUpdate;
            }
            case 64: {
                return this.isFullReferences;
            }
            case 128: {
                return this.isFullTrigger;
            }
            case 32: {
                return this.isFull;
            }
        }
        throw Error.runtimeError(201, "Right");
    }

    public boolean canAccesssNonSelect() {
        if (this.isFull) {
            return true;
        }
        if (this.isFullInsert || this.isFullUpdate || this.isFullDelete || this.isFullReferences || this.isFullTrigger) {
            return true;
        }
        boolean bl = false;
        bl |= this.insertColumnSet != null && !this.insertColumnSet.isEmpty();
        bl |= this.updateColumnSet != null && !this.updateColumnSet.isEmpty();
        bl |= this.referencesColumnSet != null && !this.referencesColumnSet.isEmpty();
        return bl |= this.triggerColumnSet != null && !this.triggerColumnSet.isEmpty();
    }

    public boolean canAccess(int n) {
        if (this.isFull) {
            return true;
        }
        switch (n) {
            case 2: {
                return this.isFullDelete;
            }
            case 1: {
                if (this.isFullSelect) {
                    return true;
                }
                return this.selectColumnSet != null && !this.selectColumnSet.isEmpty();
            }
            case 4: {
                if (this.isFullInsert) {
                    return true;
                }
                return this.insertColumnSet != null && !this.insertColumnSet.isEmpty();
            }
            case 8: {
                if (this.isFullUpdate) {
                    return true;
                }
                return this.updateColumnSet != null && !this.updateColumnSet.isEmpty();
            }
            case 64: {
                if (this.isFullReferences) {
                    return true;
                }
                return this.referencesColumnSet != null && !this.referencesColumnSet.isEmpty();
            }
            case 128: {
                if (this.isFullTrigger) {
                    return true;
                }
                return this.triggerColumnSet != null && !this.triggerColumnSet.isEmpty();
            }
            case 32: {
                return this.isFull;
            }
        }
        throw Error.runtimeError(201, "Right");
    }

    public boolean canAccess(Table table, int[] nArray) {
        if (this.isFull) {
            return true;
        }
        if (this.isFullSelect || this.isFullInsert || this.isFullUpdate || this.isFullDelete || this.isFullReferences || this.isFullTrigger) {
            return true;
        }
        boolean bl = false;
        bl |= this.selectColumnSet != null && this.insertColumnSet.isEmpty();
        bl |= this.insertColumnSet != null && this.insertColumnSet.isEmpty();
        bl |= this.updateColumnSet != null && !this.updateColumnSet.isEmpty();
        bl |= this.referencesColumnSet != null && !this.referencesColumnSet.isEmpty();
        if (!(bl |= this.triggerColumnSet != null && !this.triggerColumnSet.isEmpty())) {
            return false;
        }
        HashSet hashSet = new HashSet();
        hashSet.addAll(this.selectColumnSet);
        hashSet.addAll(this.insertColumnSet);
        hashSet.addAll(this.updateColumnSet);
        hashSet.addAll(this.referencesColumnSet);
        hashSet.addAll(this.triggerColumnSet);
        for (int i = 0; i < nArray.length; ++i) {
            if (hashSet.contains(table.getColumn(i).getName())) continue;
            return false;
        }
        return bl;
    }

    public ExpressionLogical getFilterExpression() {
        return this.filterExpression;
    }

    String getTableRightsSQL(Table table) {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.isFull) {
            return "ALL";
        }
        if (this.isFullSelect) {
            stringBuilder.append("SELECT");
            stringBuilder.append(',');
        } else if (this.selectColumnSet != null) {
            stringBuilder.append("SELECT");
            Right.getColumnList(table, this.selectColumnSet, stringBuilder);
            stringBuilder.append(',');
        }
        if (this.isFullInsert) {
            stringBuilder.append("INSERT");
            stringBuilder.append(',');
        } else if (this.insertColumnSet != null) {
            stringBuilder.append("INSERT");
            Right.getColumnList(table, this.insertColumnSet, stringBuilder);
            stringBuilder.append(',');
        }
        if (this.isFullUpdate) {
            stringBuilder.append("UPDATE");
            stringBuilder.append(',');
        } else if (this.updateColumnSet != null) {
            stringBuilder.append("UPDATE");
            Right.getColumnList(table, this.updateColumnSet, stringBuilder);
            stringBuilder.append(',');
        }
        if (this.isFullDelete) {
            stringBuilder.append("DELETE");
            stringBuilder.append(',');
        }
        if (this.isFullReferences) {
            stringBuilder.append("REFERENCES");
            stringBuilder.append(',');
        } else if (this.referencesColumnSet != null) {
            stringBuilder.append("REFERENCES");
            stringBuilder.append(',');
        }
        if (this.isFullTrigger) {
            stringBuilder.append("TRIGGER");
            stringBuilder.append(',');
        } else if (this.triggerColumnSet != null) {
            stringBuilder.append("TRIGGER");
            stringBuilder.append(',');
        }
        return stringBuilder.toString().substring(0, stringBuilder.length() - 1);
    }

    private static void getColumnList(Table table, OrderedHashSet orderedHashSet, StringBuilder stringBuilder) {
        int n;
        int n2 = 0;
        boolean[] blArray = table.getNewColumnCheckList();
        for (n = 0; n < orderedHashSet.size(); ++n) {
            HsqlNameManager.HsqlName hsqlName = (HsqlNameManager.HsqlName)orderedHashSet.get(n);
            int n3 = table.findColumn(hsqlName.name);
            if (n3 == -1) continue;
            blArray[n3] = true;
            ++n2;
        }
        if (n2 == 0) {
            throw Error.runtimeError(201, "Right");
        }
        stringBuilder.append('(');
        int n4 = 0;
        for (n = 0; n < blArray.length; ++n) {
            if (!blArray[n]) continue;
            stringBuilder.append(table.getColumn((int)n).getName().statementName);
            if (++n4 >= n2) continue;
            stringBuilder.append(',');
        }
        stringBuilder.append(')');
    }

    public void addNewColumn(HsqlNameManager.HsqlName hsqlName) {
        if (this.selectColumnSet != null) {
            this.selectColumnSet.add(hsqlName);
        }
        if (this.insertColumnSet != null) {
            this.insertColumnSet.add(hsqlName);
        }
        if (this.updateColumnSet != null) {
            this.updateColumnSet.add(hsqlName);
        }
        if (this.referencesColumnSet != null) {
            this.referencesColumnSet.add(hsqlName);
        }
        if (this.triggerColumnSet != null) {
            this.triggerColumnSet.add(hsqlName);
        }
    }

    public void setColumns(Table table) {
        if (this.selectColumnSet != null) {
            Right.setColumns(table, this.selectColumnSet);
        }
        if (this.insertColumnSet != null) {
            Right.setColumns(table, this.insertColumnSet);
        }
        if (this.updateColumnSet != null) {
            Right.setColumns(table, this.updateColumnSet);
        }
        if (this.referencesColumnSet != null) {
            Right.setColumns(table, this.referencesColumnSet);
        }
        if (this.triggerColumnSet != null) {
            Right.setColumns(table, this.triggerColumnSet);
        }
    }

    private static void setColumns(Table table, OrderedHashSet orderedHashSet) {
        int n;
        int n2 = 0;
        boolean[] blArray = table.getNewColumnCheckList();
        for (n = 0; n < orderedHashSet.size(); ++n) {
            String string2 = (String)orderedHashSet.get(n);
            int n3 = table.findColumn(string2);
            if (n3 == -1) {
                throw Error.error(5501, string2);
            }
            blArray[n3] = true;
            ++n2;
        }
        if (n2 == 0) {
            throw Error.error(5501);
        }
        orderedHashSet.clear();
        for (n = 0; n < blArray.length; ++n) {
            if (!blArray[n]) continue;
            orderedHashSet.add(table.getColumn(n).getName());
        }
    }

    public void set(int n, OrderedHashSet orderedHashSet) {
        switch (n) {
            case 1: {
                if (orderedHashSet == null) {
                    this.isFullSelect = true;
                }
                this.selectColumnSet = orderedHashSet;
                break;
            }
            case 2: {
                if (orderedHashSet != null) break;
                this.isFullDelete = true;
                break;
            }
            case 4: {
                if (orderedHashSet == null) {
                    this.isFullInsert = true;
                }
                this.insertColumnSet = orderedHashSet;
                break;
            }
            case 8: {
                if (orderedHashSet == null) {
                    this.isFullUpdate = true;
                }
                this.updateColumnSet = orderedHashSet;
                break;
            }
            case 64: {
                if (orderedHashSet == null) {
                    this.isFullReferences = true;
                }
                this.referencesColumnSet = orderedHashSet;
                break;
            }
            case 128: {
                if (orderedHashSet == null) {
                    this.isFullTrigger = true;
                }
                this.triggerColumnSet = orderedHashSet;
                break;
            }
        }
    }

    String[] getTableRightsArray() {
        if (this.isFull) {
            return new String[]{"SELECT", "INSERT", "UPDATE", "DELETE", "REFERENCES"};
        }
        HsqlArrayList hsqlArrayList = new HsqlArrayList();
        String[] stringArray = new String[hsqlArrayList.size()];
        if (this.isFullSelect) {
            hsqlArrayList.add("SELECT");
        }
        if (this.isFullInsert) {
            hsqlArrayList.add("INSERT");
        }
        if (this.isFullUpdate) {
            hsqlArrayList.add("UPDATE");
        }
        if (this.isFullDelete) {
            hsqlArrayList.add("DELETE");
        }
        if (this.isFullReferences) {
            hsqlArrayList.add("REFERENCES");
        }
        if (this.isFullTrigger) {
            hsqlArrayList.add("TRIGGER");
        }
        hsqlArrayList.toArray(stringArray);
        return stringArray;
    }

    static {
        Right.fullRights.grantor = GranteeManager.systemAuthorisation;
        privilegeNames = new String[]{"SELECT", "INSERT", "UPDATE", "DELETE", "REFERENCES", "TRIGGER"};
        privilegeTypes = new int[]{1, 4, 8, 2, 64, 128};
    }
}

