/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.rights;

import org.hsqldb.HsqlNameManager;
import org.hsqldb.error.Error;
import org.hsqldb.lib.StringConverter;
import org.hsqldb.rights.Grantee;
import org.hsqldb.rights.GranteeManager;

public class User
extends Grantee {
    private String password;
    public boolean isLocalOnly;
    public boolean isExternalOnly;
    private HsqlNameManager.HsqlName initialSchema = null;

    User(HsqlNameManager.HsqlName hsqlName, GranteeManager granteeManager) {
        super(hsqlName, granteeManager);
        if (granteeManager != null) {
            this.updateAllRights();
        }
    }

    @Override
    public String getSQL() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("CREATE").append(' ').append("USER");
        stringBuilder.append(' ').append(this.granteeName.statementName).append(' ');
        stringBuilder.append("PASSWORD").append(' ').append("DIGEST");
        stringBuilder.append(' ').append('\'').append(this.password).append('\'');
        return stringBuilder.toString();
    }

    public String getPasswordDigest() {
        return this.password;
    }

    public void setPassword(String string2, boolean bl) {
        if (!bl) {
            string2 = this.granteeManager.digest(string2);
        }
        this.password = string2;
    }

    public void checkPassword(String string2) {
        String string3 = this.granteeManager.digest(string2);
        if (!string3.equals(this.password)) {
            throw Error.error(4000, this.granteeName.statementName);
        }
    }

    public HsqlNameManager.HsqlName getInitialSchema() {
        return this.initialSchema;
    }

    public HsqlNameManager.HsqlName getInitialOrDefaultSchema() {
        if (this.initialSchema != null) {
            return this.initialSchema;
        }
        HsqlNameManager.HsqlName hsqlName = this.granteeManager.database.schemaManager.findSchemaHsqlName(this.getName().getNameString());
        if (hsqlName == null) {
            return this.granteeManager.database.schemaManager.getDefaultSchemaHsqlName();
        }
        return hsqlName;
    }

    public void setInitialSchema(HsqlNameManager.HsqlName hsqlName) {
        this.initialSchema = hsqlName;
    }

    public String getInitialSchemaSQL() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("ALTER").append(' ');
        stringBuilder.append("USER").append(' ');
        stringBuilder.append(this.getName().getStatementName()).append(' ');
        stringBuilder.append("SET").append(' ');
        stringBuilder.append("INITIAL").append(' ');
        stringBuilder.append("SCHEMA").append(' ');
        stringBuilder.append(this.initialSchema.getStatementName());
        return stringBuilder.toString();
    }

    public String getLocalUserSQL() {
        StringBuilder stringBuilder = new StringBuilder(64);
        stringBuilder.append("ALTER").append(' ');
        stringBuilder.append("USER").append(' ');
        stringBuilder.append(this.getName().getStatementName()).append(' ');
        stringBuilder.append("SET").append(' ').append("LOCAL");
        stringBuilder.append(' ').append("TRUE");
        return stringBuilder.toString();
    }

    public String getSetUserPasswordDigestSQL(String string2, boolean bl) {
        if (!bl) {
            string2 = this.granteeManager.digest(string2);
        }
        StringBuilder stringBuilder = new StringBuilder(64);
        stringBuilder.append("ALTER").append(' ');
        stringBuilder.append("USER").append(' ');
        stringBuilder.append(this.getName().getStatementName()).append(' ');
        stringBuilder.append("SET").append(' ');
        stringBuilder.append("PASSWORD").append(' ').append("DIGEST");
        stringBuilder.append(' ').append('\'').append(string2).append('\'');
        return stringBuilder.toString();
    }

    public static String getSetCurrentPasswordDigestSQL(GranteeManager granteeManager, String string2, boolean bl) {
        if (!bl) {
            string2 = granteeManager.digest(string2);
        }
        StringBuilder stringBuilder = new StringBuilder(64);
        stringBuilder.append("SET").append(' ');
        stringBuilder.append("PASSWORD").append(' ').append("DIGEST");
        stringBuilder.append(' ').append('\'').append(string2).append('\'');
        return stringBuilder.toString();
    }

    public String getConnectUserSQL() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("SET").append(' ');
        stringBuilder.append("SESSION").append(' ');
        stringBuilder.append("AUTHORIZATION").append(' ');
        stringBuilder.append(StringConverter.toQuotedString(this.getName().getNameString(), '\'', true));
        return stringBuilder.toString();
    }
}

