/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.rowio;

import org.hsqldb.lib.StringConverter;
import org.hsqldb.persist.TextFileSettings;
import org.hsqldb.rowio.RowOutputText;

public class RowOutputTextQuoted
extends RowOutputText {
    public RowOutputTextQuoted(TextFileSettings textFileSettings) {
        super(textFileSettings);
    }

    @Override
    protected String checkConvertString(String string2, String string3) {
        if (this.textFileSettings.isAllQuoted || string2.length() == 0 || string2.indexOf(this.textFileSettings.quoteChar) != -1 || string3.length() > 0 && string2.contains(string3) || RowOutputTextQuoted.hasUnprintable(string2)) {
            string2 = StringConverter.toQuotedString(string2, this.textFileSettings.quoteChar, true);
        }
        return string2;
    }

    private static boolean hasUnprintable(String string2) {
        int n = string2.length();
        for (int i = 0; i < n; ++i) {
            if (!Character.isISOControl(string2.charAt(i))) continue;
            return true;
        }
        return false;
    }
}

