/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.scriptio;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.GZIPOutputStream;
import org.hsqldb.Database;
import org.hsqldb.error.Error;
import org.hsqldb.lib.FileAccess;
import org.hsqldb.lib.FileUtil;
import org.hsqldb.lib.HsqlByteArrayOutputStream;
import org.hsqldb.persist.Crypto;
import org.hsqldb.scriptio.ScriptWriterText;

public class ScriptWriterEncode
extends ScriptWriterText {
    Crypto crypto;
    HsqlByteArrayOutputStream byteOut;
    OutputStream cryptOut;

    public ScriptWriterEncode(Database database, OutputStream outputStream, FileAccess.FileSync fileSync, boolean bl, Crypto crypto) {
        super(database, outputStream, fileSync, bl);
        try {
            this.cryptOut = crypto.getOutputStream(this.fileStreamOut);
            this.fileStreamOut = new GZIPOutputStream(this.cryptOut);
            this.isCrypt = true;
        }
        catch (IOException iOException) {
            throw Error.error(iOException, 452, 26, new Object[]{iOException.toString(), this.outFile});
        }
    }

    public ScriptWriterEncode(Database database, String string2, boolean bl, Crypto crypto) {
        super(database, string2, bl, true, false);
        try {
            this.cryptOut = crypto.getOutputStream(this.fileStreamOut);
            this.fileStreamOut = new GZIPOutputStream(this.cryptOut);
            this.isCrypt = true;
        }
        catch (IOException iOException) {
            throw Error.error(iOException, 452, 26, new Object[]{iOException.toString(), this.outFile});
        }
    }

    public ScriptWriterEncode(Database database, String string2, Crypto crypto) {
        super(database, string2, false, false, false);
        this.crypto = crypto;
        this.byteOut = new HsqlByteArrayOutputStream();
        this.isCrypt = true;
    }

    @Override
    protected void openFile() {
        try {
            FileUtil fileUtil = this.isUserScript ? FileUtil.getFileUtil() : this.database.logger.getFileAccess();
            OutputStream outputStream = fileUtil.openOutputStreamElement(this.outFile, true);
            this.outDescriptor = fileUtil.getFileSync(outputStream);
            this.fileStreamOut = outputStream;
            this.fileStreamOut = new BufferedOutputStream(outputStream, 16384);
        }
        catch (IOException iOException) {
            throw Error.error(iOException, 452, 26, new Object[]{iOException.toString(), this.outFile});
        }
    }

    @Override
    protected void finishStream() {
        try {
            if (this.fileStreamOut instanceof GZIPOutputStream) {
                ((GZIPOutputStream)this.fileStreamOut).finish();
            }
        }
        catch (IOException iOException) {
            throw Error.error(452, iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void writeRowOutToFile() {
        OutputStream outputStream = this.fileStreamOut;
        synchronized (outputStream) {
            try {
                if (this.byteOut == null) {
                    this.fileStreamOut.write(this.rowOut.getBuffer(), 0, this.rowOut.size());
                    this.byteCount += (long)this.rowOut.size();
                    ++this.lineCount;
                    return;
                }
                int n = this.crypto.getEncodedSize(this.rowOut.size());
                this.byteOut.ensureRoom(n + 4);
                n = this.crypto.encode(this.rowOut.getBuffer(), 0, this.rowOut.size(), this.byteOut.getBuffer(), 4);
                this.byteOut.setPosition(0);
                this.byteOut.writeInt(n);
                this.fileStreamOut.write(this.byteOut.getBuffer(), 0, n + 4);
                this.byteCount += (long)this.rowOut.size();
                ++this.lineCount;
            }
            catch (IOException iOException) {
                throw Error.error(452, iOException);
            }
        }
    }
}

