/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.server;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;

public class HsqlSocketFactory {
    private static HsqlSocketFactory plainImpl;
    private static HsqlSocketFactory sslImpl;

    protected HsqlSocketFactory() throws Exception {
    }

    public static HsqlSocketFactory getInstance(boolean bl) throws Exception {
        return bl ? HsqlSocketFactory.getSSLImpl() : HsqlSocketFactory.getPlainImpl();
    }

    public void configureSocket(Socket socket) {
    }

    public ServerSocket createServerSocket(int n) throws Exception {
        return new ServerSocket(n);
    }

    public ServerSocket createServerSocket(int n, String string2) throws Exception {
        return new ServerSocket(n, 128, InetAddress.getByName(string2));
    }

    public Socket createSocket(Socket socket, String string2, int n) throws Exception {
        return socket == null ? new Socket(string2, n) : socket;
    }

    public Socket createSocket(String string2, int n) throws Exception {
        return new Socket(string2, n);
    }

    public boolean isSecure() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static HsqlSocketFactory getPlainImpl() throws Exception {
        Class<HsqlSocketFactory> clazz = HsqlSocketFactory.class;
        synchronized (HsqlSocketFactory.class) {
            if (plainImpl == null) {
                plainImpl = new HsqlSocketFactory();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return plainImpl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static HsqlSocketFactory getSSLImpl() throws Exception {
        Class<HsqlSocketFactory> clazz = HsqlSocketFactory.class;
        synchronized (HsqlSocketFactory.class) {
            if (sslImpl == null) {
                sslImpl = HsqlSocketFactory.newFactory("org.hsqldb.server.HsqlSocketFactorySecure");
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return sslImpl;
        }
    }

    private static HsqlSocketFactory newFactory(String string2) throws Exception {
        Object obj2;
        Class<?> clazz = Class.forName(string2);
        Class[] classArray = new Class[]{};
        Constructor<?> constructor = clazz.getDeclaredConstructor(classArray);
        Object[] objectArray = new Object[]{};
        try {
            obj2 = constructor.newInstance(objectArray);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            throw throwable instanceof Exception ? (Exception)throwable : new RuntimeException(throwable.toString());
        }
        return (HsqlSocketFactory)obj2;
    }
}

