/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.types;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.temporal.ChronoField;
import java.util.Calendar;
import org.hsqldb.HsqlDateTime;
import org.hsqldb.HsqlException;
import org.hsqldb.Session;
import org.hsqldb.SessionInterface;
import org.hsqldb.error.Error;
import org.hsqldb.lib.StringConverter;
import org.hsqldb.types.DTIType;
import org.hsqldb.types.IntervalMonthData;
import org.hsqldb.types.IntervalSecondData;
import org.hsqldb.types.IntervalType;
import org.hsqldb.types.NumberType;
import org.hsqldb.types.TimeData;
import org.hsqldb.types.TimestampData;
import org.hsqldb.types.Type;

public final class DateTimeType
extends DTIType {
    public final boolean withTimeZone;
    private String nameString;
    public static final long epochSeconds = HsqlDateTime.getDateSeconds("1-01-01");
    public static final TimestampData epochTimestamp = new TimestampData(epochSeconds);
    public static final long epochLimitSeconds = HsqlDateTime.getDateSeconds("10000-01-01");
    public static final TimestampData epochLimitTimestamp = new TimestampData(epochLimitSeconds);

    public DateTimeType(int n, int n2, int n3) {
        super(n, n2, 0L, n3);
        this.withTimeZone = n2 == 94 || n2 == 95;
        this.nameString = this.getNameStringPrivate();
    }

    @Override
    public int displaySize() {
        switch (this.typeCode) {
            case 91: {
                return 10;
            }
            case 92: {
                return 8 + (this.scale == 0 ? 0 : this.scale + 1);
            }
            case 94: {
                return 8 + (this.scale == 0 ? 0 : this.scale + 1) + 6;
            }
            case 93: {
                return 19 + (this.scale == 0 ? 0 : this.scale + 1);
            }
            case 95: {
                return 19 + (this.scale == 0 ? 0 : this.scale + 1) + 6;
            }
        }
        throw Error.runtimeError(201, "DateTimeType");
    }

    @Override
    public int getJDBCTypeCode() {
        switch (this.typeCode) {
            case 94: {
                return 2013;
            }
            case 95: {
                return 2014;
            }
        }
        return this.typeCode;
    }

    @Override
    public Class getJDBCClass() {
        switch (this.typeCode) {
            case 91: {
                return Date.class;
            }
            case 92: {
                return Time.class;
            }
            case 93: {
                return Timestamp.class;
            }
            case 94: {
                return OffsetTime.class;
            }
            case 95: {
                return OffsetDateTime.class;
            }
        }
        throw Error.runtimeError(201, "DateTimeType");
    }

    @Override
    public String getJDBCClassName() {
        switch (this.typeCode) {
            case 91: {
                return "java.sql.Date";
            }
            case 92: {
                return "java.sql.Time";
            }
            case 93: {
                return "java.sql.Timestamp";
            }
            case 94: {
                return "java.time.OffsetTime";
            }
            case 95: {
                return "java.time.OffsetDateTime";
            }
        }
        throw Error.runtimeError(201, "DateTimeType");
    }

    @Override
    public int getJDBCPrecision() {
        return this.displaySize();
    }

    @Override
    public int getSQLGenericTypeCode() {
        return 9;
    }

    @Override
    public String getNameString() {
        return this.nameString;
    }

    @Override
    public boolean canCompareDirect(Type type) {
        return this.typeCode == type.typeCode;
    }

    private String getNameStringPrivate() {
        switch (this.typeCode) {
            case 91: {
                return "DATE";
            }
            case 92: {
                return "TIME";
            }
            case 94: {
                return "TIME WITH TIME ZONE";
            }
            case 93: {
                return "TIMESTAMP";
            }
            case 95: {
                return "TIMESTAMP WITH TIME ZONE";
            }
        }
        throw Error.runtimeError(201, "DateTimeType");
    }

    @Override
    public String getDefinition() {
        String string2;
        switch (this.typeCode) {
            case 91: {
                return "DATE";
            }
            case 92: 
            case 94: {
                if (this.scale == 0) {
                    return this.getNameString();
                }
                string2 = "TIME";
                break;
            }
            case 93: 
            case 95: {
                if (this.scale == 6) {
                    return this.getNameString();
                }
                string2 = "TIMESTAMP";
                break;
            }
            default: {
                throw Error.runtimeError(201, "DateTimeType");
            }
        }
        StringBuilder stringBuilder = new StringBuilder(16);
        stringBuilder.append(string2);
        stringBuilder.append('(');
        stringBuilder.append(this.scale);
        stringBuilder.append(')');
        if (this.withTimeZone) {
            stringBuilder.append(" WITH TIME ZONE");
        }
        return stringBuilder.toString();
    }

    @Override
    public boolean isDateTimeType() {
        return true;
    }

    @Override
    public boolean isDateOrTimestampType() {
        switch (this.typeCode) {
            case 91: 
            case 93: 
            case 95: {
                return true;
            }
            case 92: 
            case 94: {
                return false;
            }
        }
        throw Error.runtimeError(201, "DateTimeType");
    }

    @Override
    public boolean isTimestampType() {
        switch (this.typeCode) {
            case 93: 
            case 95: {
                return true;
            }
            case 91: 
            case 92: 
            case 94: {
                return false;
            }
        }
        throw Error.runtimeError(201, "DateTimeType");
    }

    @Override
    public boolean isTimeType() {
        switch (this.typeCode) {
            case 91: 
            case 93: 
            case 95: {
                return false;
            }
            case 92: 
            case 94: {
                return true;
            }
        }
        throw Error.runtimeError(201, "DateTimeType");
    }

    @Override
    public boolean isDateTimeTypeWithZone() {
        return this.withTimeZone;
    }

    @Override
    public boolean acceptsFractionalPrecision() {
        return this.typeCode != 91;
    }

    @Override
    public Type getAggregateType(Type type) {
        int n;
        if (type == null) {
            return this;
        }
        if (type == SQL_ALL_TYPES) {
            return this;
        }
        if (this.typeCode == type.typeCode) {
            return this.scale >= type.scale ? this : type;
        }
        if (type.typeCode == 0) {
            return this;
        }
        if (type.isCharacterType()) {
            return type.getAggregateType(this);
        }
        if (!type.isDateTimeType()) {
            throw Error.error(5562);
        }
        DateTimeType dateTimeType = (DateTimeType)type;
        if (dateTimeType.startIntervalType > this.endIntervalType || this.startIntervalType > dateTimeType.endIntervalType) {
            throw Error.error(5562);
        }
        int n2 = this.typeCode;
        int n3 = this.scale > dateTimeType.scale ? this.scale : dateTimeType.scale;
        boolean bl = this.withTimeZone || dateTimeType.withTimeZone;
        int n4 = n = dateTimeType.startIntervalType > this.startIntervalType ? this.startIntervalType : dateTimeType.startIntervalType;
        n2 = n == 104 ? (bl ? 94 : 92) : (bl ? 95 : 93);
        return DateTimeType.getDateTimeType(n2, n3);
    }

    @Override
    public Type getCombinedType(Session session, Type type, int n) {
        switch (n) {
            case 40: 
            case 41: 
            case 43: 
            case 44: 
            case 45: 
            case 46: {
                int n2;
                if (this.typeCode == type.typeCode) {
                    return this;
                }
                if (type.typeCode == 0) {
                    return this;
                }
                if (!type.isDateTimeType()) {
                    throw Error.error(5562);
                }
                DateTimeType dateTimeType = (DateTimeType)type;
                if (dateTimeType.startIntervalType > this.endIntervalType || this.startIntervalType > dateTimeType.endIntervalType) {
                    throw Error.error(5562);
                }
                int n3 = this.typeCode;
                int n4 = this.scale > dateTimeType.scale ? this.scale : dateTimeType.scale;
                boolean bl = this.withTimeZone || dateTimeType.withTimeZone;
                int n5 = n2 = dateTimeType.startIntervalType > this.startIntervalType ? this.startIntervalType : dateTimeType.startIntervalType;
                n3 = n2 == 104 ? (bl ? 94 : 92) : (bl ? 95 : 93);
                return DateTimeType.getDateTimeType(n3, n4);
            }
            case 32: 
            case 33: {
                if (type.isIntervalType()) {
                    if (this.typeCode != 91 && type.scale > this.scale) {
                        return DateTimeType.getDateTimeType(this.typeCode, type.scale);
                    }
                    return this;
                }
                if (type.isDateTimeType()) {
                    if (n != 33 || type.typeComparisonGroup != this.typeComparisonGroup) break;
                    if (this.typeCode == 91) {
                        return Type.SQL_INTERVAL_DAY_MAX_PRECISION;
                    }
                    return Type.SQL_INTERVAL_DAY_TO_SECOND_MAX_PRECISION;
                }
                if (!type.isNumberType()) break;
                return this;
            }
        }
        throw Error.error(5562);
    }

    @Override
    public int compare(Session session, Object object, Object object2) {
        if (object == object2) {
            return 0;
        }
        if (object == null) {
            return -1;
        }
        if (object2 == null) {
            return 1;
        }
        switch (this.typeCode) {
            case 92: 
            case 94: {
                long l = ((TimeData)object).getSeconds() - ((TimeData)object2).getSeconds();
                if (l == 0L) {
                    l = ((TimeData)object).getNanos() - ((TimeData)object2).getNanos();
                }
                return l == 0L ? 0 : (l > 0L ? 1 : -1);
            }
            case 91: 
            case 93: 
            case 95: {
                long l = ((TimestampData)object).getSeconds() - ((TimestampData)object2).getSeconds();
                if (l == 0L) {
                    l = ((TimestampData)object).getNanos() - ((TimestampData)object2).getNanos();
                }
                return l == 0L ? 0 : (l > 0L ? 1 : -1);
            }
        }
        throw Error.runtimeError(201, "DateTimeType");
    }

    @Override
    public Object convertToTypeLimits(SessionInterface sessionInterface, Object object) {
        if (object == null) {
            return null;
        }
        switch (this.typeCode) {
            case 91: {
                return object;
            }
            case 92: 
            case 94: {
                TimeData timeData = (TimeData)object;
                int n = timeData.getNanos();
                int n2 = this.scaleNanos(n);
                if (n2 == n) {
                    return timeData;
                }
                return new TimeData(timeData.getSeconds(), n2, timeData.getZone());
            }
            case 93: 
            case 95: {
                TimestampData timestampData = (TimestampData)object;
                int n = timestampData.getNanos();
                int n3 = this.scaleNanos(n);
                if (timestampData.getSeconds() > epochLimitSeconds) {
                    throw Error.error(3408);
                }
                if (n3 == n) {
                    return timestampData;
                }
                return new TimestampData(timestampData.getSeconds(), n3, timestampData.getZone());
            }
        }
        throw Error.runtimeError(201, "DateTimeType");
    }

    int scaleNanos(int n) {
        int n2 = nanoScaleFactors[this.scale];
        return n / n2 * n2;
    }

    @Override
    public Object convertToType(SessionInterface sessionInterface, Object object, Type type) {
        if (object == null) {
            return object;
        }
        switch (type.typeCode) {
            case 40: {
                object = object.toString();
            }
            case 1: 
            case 12: {
                switch (this.typeCode) {
                    case 91: 
                    case 92: 
                    case 93: 
                    case 94: 
                    case 95: {
                        try {
                            return sessionInterface.getScanner().convertToDatetimeInterval(sessionInterface, (String)object, this);
                        }
                        catch (HsqlException hsqlException) {
                            return DateTimeType.convertToDatetimeSpecial(sessionInterface, (String)object, this);
                        }
                    }
                }
                break;
            }
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: {
                break;
            }
            default: {
                throw Error.error(5561);
            }
        }
        switch (this.typeCode) {
            case 91: {
                switch (type.typeCode) {
                    case 91: {
                        return object;
                    }
                    case 95: {
                        long l = ((TimestampData)object).getSeconds() + (long)((TimestampData)object).getZone();
                        long l2 = HsqlDateTime.getNormalisedDate(sessionInterface.getCalendarGMT(), l * 1000L);
                        return new TimestampData(l2 / 1000L);
                    }
                    case 93: {
                        long l = HsqlDateTime.getNormalisedDate(sessionInterface.getCalendarGMT(), ((TimestampData)object).getSeconds() * 1000L);
                        return new TimestampData(l / 1000L);
                    }
                }
                throw Error.error(5561);
            }
            case 94: {
                switch (type.typeCode) {
                    case 94: {
                        return this.convertToTypeLimits(sessionInterface, object);
                    }
                    case 92: {
                        TimeData timeData = (TimeData)object;
                        return new TimeData(timeData.getSeconds() - sessionInterface.getZoneSeconds(), this.scaleNanos(timeData.getNanos()), sessionInterface.getZoneSeconds());
                    }
                    case 95: {
                        TimestampData timestampData = (TimestampData)object;
                        long l = HsqlDateTime.convertToNormalisedTime(timestampData.getSeconds() * 1000L) / 1000L;
                        return new TimeData((int)l, this.scaleNanos(timestampData.getNanos()), timestampData.getZone());
                    }
                    case 93: {
                        TimestampData timestampData = (TimestampData)object;
                        long l = timestampData.getSeconds() - (long)sessionInterface.getZoneSeconds();
                        l = HsqlDateTime.convertToNormalisedTime(sessionInterface.getCalendarGMT(), l * 1000L) / 1000L;
                        return new TimeData((int)l, this.scaleNanos(timestampData.getNanos()), sessionInterface.getZoneSeconds());
                    }
                }
                throw Error.error(5561);
            }
            case 92: {
                switch (type.typeCode) {
                    case 94: {
                        TimeData timeData = (TimeData)object;
                        return new TimeData(timeData.getSeconds() + timeData.getZone(), this.scaleNanos(timeData.getNanos()), 0);
                    }
                    case 92: {
                        return this.convertToTypeLimits(sessionInterface, object);
                    }
                    case 95: {
                        TimestampData timestampData = (TimestampData)object;
                        long l = timestampData.getSeconds() + (long)timestampData.getZone();
                        l = HsqlDateTime.convertToNormalisedTime(sessionInterface.getCalendarGMT(), l * 1000L) / 1000L;
                        return new TimeData((int)l, this.scaleNanos(timestampData.getNanos()), 0);
                    }
                    case 93: {
                        TimestampData timestampData = (TimestampData)object;
                        long l = HsqlDateTime.convertToNormalisedTime(sessionInterface.getCalendarGMT(), timestampData.getSeconds() * 1000L) / 1000L;
                        return new TimeData((int)l, this.scaleNanos(timestampData.getNanos()));
                    }
                }
                throw Error.error(5561);
            }
            case 95: {
                switch (type.typeCode) {
                    case 94: {
                        TimeData timeData = (TimeData)object;
                        long l = sessionInterface.getCurrentDate().getSeconds() + (long)timeData.getSeconds();
                        return new TimestampData(l, this.scaleNanos(timeData.getNanos()), timeData.getZone());
                    }
                    case 92: {
                        TimeData timeData = (TimeData)object;
                        long l = sessionInterface.getCurrentDate().getSeconds() + (long)timeData.getSeconds() - (long)sessionInterface.getZoneSeconds();
                        return new TimestampData(l, this.scaleNanos(timeData.getNanos()), sessionInterface.getZoneSeconds());
                    }
                    case 95: {
                        return this.convertToTypeLimits(sessionInterface, object);
                    }
                    case 93: {
                        TimestampData timestampData = (TimestampData)object;
                        long l = timestampData.getSeconds() - (long)sessionInterface.getZoneSeconds();
                        return new TimestampData(l, this.scaleNanos(timestampData.getNanos()), sessionInterface.getZoneSeconds());
                    }
                    case 91: {
                        TimestampData timestampData = (TimestampData)object;
                        return new TimestampData(timestampData.getSeconds(), 0, sessionInterface.getZoneSeconds());
                    }
                }
                throw Error.error(5561);
            }
            case 93: {
                switch (type.typeCode) {
                    case 94: {
                        TimeData timeData = (TimeData)object;
                        long l = sessionInterface.getCurrentDate().getSeconds() + (long)timeData.getSeconds() - (long)sessionInterface.getZoneSeconds();
                        return new TimestampData(l, this.scaleNanos(timeData.getNanos()), sessionInterface.getZoneSeconds());
                    }
                    case 92: {
                        TimeData timeData = (TimeData)object;
                        long l = sessionInterface.getCurrentDate().getSeconds() + (long)timeData.getSeconds();
                        return new TimestampData(l, this.scaleNanos(timeData.getNanos()));
                    }
                    case 95: {
                        TimestampData timestampData = (TimestampData)object;
                        long l = timestampData.getSeconds() + (long)timestampData.getZone();
                        return new TimestampData(l, this.scaleNanos(timestampData.getNanos()));
                    }
                    case 93: {
                        return this.convertToTypeLimits(sessionInterface, object);
                    }
                    case 91: {
                        return object;
                    }
                }
                throw Error.error(5561);
            }
        }
        throw Error.runtimeError(201, "DateTimeType");
    }

    @Override
    public Object convertToDefaultType(SessionInterface sessionInterface, Object object) {
        DateTimeType dateTimeType = object instanceof TimeData ? Type.SQL_TIME : Type.SQL_TIMESTAMP;
        return this.convertToType(sessionInterface, object, dateTimeType);
    }

    @Override
    public Object convertJavaToSQL(SessionInterface sessionInterface, Object object) {
        if (object == null) {
            return null;
        }
        switch (this.typeCode) {
            case 92: 
            case 94: {
                if (object instanceof Date) break;
                if (object instanceof java.util.Date) {
                    long l;
                    int n = 0;
                    int n2 = 0;
                    if (this.typeCode == 92) {
                        l = HsqlDateTime.convertMillisFromCalendar(sessionInterface.getCalendarGMT(), sessionInterface.getCalendar(), ((java.util.Date)object).getTime());
                    } else {
                        l = ((java.util.Date)object).getTime();
                        n2 = sessionInterface.getZoneSeconds();
                    }
                    l = HsqlDateTime.getNormalisedTime(sessionInterface.getCalendarGMT(), l);
                    if (object instanceof Timestamp) {
                        n = ((Timestamp)object).getNanos();
                        n = DateTimeType.normaliseFraction(n, this.scale);
                    }
                    return new TimeData((int)l / 1000, n, n2);
                }
                TimeData timeData = this.convertJavaTimeObject(sessionInterface, object);
                if (timeData == null) break;
                return timeData;
            }
            case 91: {
                if (object instanceof Time) break;
                if (object instanceof java.util.Date) {
                    long l = HsqlDateTime.convertMillisFromCalendar(sessionInterface.getCalendarGMT(), sessionInterface.getCalendar(), ((java.util.Date)object).getTime());
                    l = HsqlDateTime.getNormalisedDate(sessionInterface.getCalendarGMT(), l);
                    long l2 = l / 1000L;
                    if (l2 < epochSeconds || l2 > epochLimitSeconds) {
                        throw Error.error(3408);
                    }
                    return new TimestampData(l2);
                }
                TimestampData timestampData = this.convertJavaTimeObject(sessionInterface, object, false);
                if (timestampData == null) break;
                return timestampData;
            }
            case 93: 
            case 95: {
                if (object instanceof Time) break;
                if (object instanceof java.util.Date) {
                    long l;
                    long l3;
                    int n = 0;
                    int n3 = 0;
                    if (this.typeCode == 93) {
                        l3 = HsqlDateTime.convertMillisFromCalendar(sessionInterface.getCalendarGMT(), sessionInterface.getCalendar(), ((java.util.Date)object).getTime());
                    } else {
                        l3 = ((java.util.Date)object).getTime();
                        n3 = HsqlDateTime.getZoneMillis(sessionInterface.getCalendar(), l3) / 1000;
                    }
                    if (object instanceof Timestamp) {
                        n = ((Timestamp)object).getNanos();
                        n = DateTimeType.normaliseFraction(n, this.scale);
                    }
                    if ((l = l3 / 1000L) < epochSeconds || l > epochLimitSeconds) {
                        throw Error.error(3408);
                    }
                    return new TimestampData(l, n, n3);
                }
                TimestampData timestampData = this.convertJavaTimeObject(sessionInterface, object, true);
                if (timestampData == null) break;
                return timestampData;
            }
        }
        throw Error.error(5561);
    }

    TimestampData convertJavaTimeObject(SessionInterface sessionInterface, Object object, boolean bl) {
        if (object instanceof OffsetDateTime) {
            OffsetDateTime offsetDateTime = (OffsetDateTime)object;
            long l = offsetDateTime.toEpochSecond();
            int n = 0;
            int n2 = 0;
            if (bl) {
                n = offsetDateTime.getNano();
                n = DateTimeType.normaliseFraction(n, this.scale);
                if (this.withTimeZone) {
                    n2 = offsetDateTime.get(ChronoField.OFFSET_SECONDS);
                }
            } else {
                l = HsqlDateTime.getNormalisedDate(sessionInterface.getCalendarGMT(), l * 1000L) / 1000L;
            }
            return new TimestampData(l, n, n2);
        }
        if (object instanceof LocalDateTime) {
            LocalDateTime localDateTime = (LocalDateTime)object;
            int n = localDateTime.getYear();
            int n3 = localDateTime.getMonthValue() - 1;
            int n4 = localDateTime.getDayOfMonth();
            int n5 = 0;
            int n6 = 0;
            int n7 = 0;
            int n8 = 0;
            int n9 = 0;
            if (bl) {
                n5 = localDateTime.getHour();
                n6 = localDateTime.getMinute();
                n7 = localDateTime.getSecond();
                n8 = localDateTime.getNano();
                n8 = DateTimeType.normaliseFraction(n8, this.scale);
                if (this.withTimeZone) {
                    n9 = sessionInterface.getZoneSeconds();
                }
            }
            Calendar calendar = sessionInterface.getCalendarGMT();
            calendar.clear();
            calendar.set(n, n3, n4, n5, n6, n7);
            long l = calendar.getTimeInMillis() / 1000L;
            return new TimestampData(l, n8, n9);
        }
        if (object instanceof LocalDate) {
            LocalDate localDate = (LocalDate)object;
            int n = localDate.getYear();
            int n10 = localDate.getMonthValue() - 1;
            int n11 = localDate.getDayOfMonth();
            int n12 = 0;
            if (bl && this.withTimeZone) {
                n12 = sessionInterface.getZoneSeconds();
            }
            Calendar calendar = sessionInterface.getCalendarGMT();
            calendar.clear();
            calendar.set(n, n10, n11);
            long l = calendar.getTimeInMillis() / 1000L;
            return new TimestampData(l, 0, n12);
        }
        return null;
    }

    TimeData convertJavaTimeObject(SessionInterface sessionInterface, Object object) {
        int n = 86400;
        if (object instanceof OffsetTime) {
            int n2;
            OffsetTime offsetTime = (OffsetTime)object;
            int n3 = 0;
            int n4 = offsetTime.getHour();
            int n5 = offsetTime.getMinute();
            int n6 = offsetTime.getSecond();
            int n7 = offsetTime.getNano();
            n7 = DateTimeType.normaliseFraction(n7, this.scale);
            if (this.withTimeZone) {
                n3 = offsetTime.get(ChronoField.OFFSET_SECONDS);
            }
            if ((n2 = n4 * 3600 + n5 * 60 + n6 - n3) < 0) {
                n2 += n;
            } else if (n2 >= n) {
                n2 -= n;
            }
            return new TimeData(n2, n7, n3);
        }
        if (object instanceof LocalTime) {
            LocalTime localTime = (LocalTime)object;
            long l = localTime.toNanoOfDay();
            int n8 = (int)(l / 1000000000L);
            int n9 = (int)(l % 1000000000L);
            n9 = DateTimeType.normaliseFraction(n9, this.scale);
            int n10 = 0;
            if (this.withTimeZone) {
                n10 = sessionInterface.getZoneSeconds();
            }
            return new TimeData(n8, n9, n10);
        }
        return null;
    }

    public Object convertSQLToJavaGMT(SessionInterface sessionInterface, Object object) {
        switch (this.typeCode) {
            case 92: 
            case 94: {
                long l = (long)((TimeData)object).getSeconds() * 1000L;
                return new Time(l += (long)(((TimeData)object).getNanos() / 1000000));
            }
            case 91: {
                long l = ((TimestampData)object).getSeconds() * 1000L;
                return new Date(l);
            }
            case 93: 
            case 95: {
                long l = ((TimestampData)object).getSeconds() * 1000L;
                Timestamp timestamp = new Timestamp(l);
                timestamp.setNanos(((TimestampData)object).getNanos());
                return timestamp;
            }
        }
        throw Error.runtimeError(201, "DateTimeType");
    }

    @Override
    public Object convertSQLToJava(SessionInterface sessionInterface, Object object) {
        if (object == null) {
            return null;
        }
        switch (this.typeCode) {
            case 92: {
                Calendar calendar = sessionInterface.getCalendar();
                long l = HsqlDateTime.convertMillisToCalendar(calendar, ((TimeData)object).getMillis());
                l = HsqlDateTime.getNormalisedTime(calendar, l);
                Time time = new Time(l);
                return time;
            }
            case 94: {
                long l = ((TimeData)object).getMillis();
                return new Time(l);
            }
            case 91: {
                Calendar calendar = sessionInterface.getCalendar();
                long l = HsqlDateTime.convertMillisToCalendar(calendar, ((TimestampData)object).getMillis());
                Date date2 = new Date(l);
                return date2;
            }
            case 93: {
                Calendar calendar = sessionInterface.getCalendar();
                long l = HsqlDateTime.convertMillisToCalendar(calendar, ((TimestampData)object).getMillis());
                Timestamp timestamp = new Timestamp(l);
                timestamp.setNanos(((TimestampData)object).getNanos());
                return timestamp;
            }
            case 95: {
                long l = ((TimestampData)object).getMillis();
                Timestamp timestamp = new Timestamp(l);
                timestamp.setNanos(((TimestampData)object).getNanos());
                return timestamp;
            }
        }
        throw Error.runtimeError(201, "DateTimeType");
    }

    public static int normaliseTime(int n) {
        while (n < 0) {
            n += 86400;
        }
        if (n >= 86400) {
            n %= 86400;
        }
        return n;
    }

    @Override
    public String convertToString(Object object) {
        boolean bl = false;
        if (object == null) {
            return null;
        }
        switch (this.typeCode) {
            case 91: {
                return HsqlDateTime.getDateString(((TimestampData)object).getSeconds());
            }
            case 92: 
            case 94: {
                TimeData timeData = (TimeData)object;
                int n = DateTimeType.normaliseTime(timeData.getSeconds() + timeData.getZone());
                String string2 = this.intervalSecondToString(n, timeData.getNanos(), false);
                if (!this.withTimeZone) {
                    return string2;
                }
                StringBuilder stringBuilder = new StringBuilder(string2);
                string2 = Type.SQL_INTERVAL_HOUR_TO_MINUTE.intervalSecondToString(((TimeData)object).getZone(), 0, true);
                stringBuilder.append(string2);
                return stringBuilder.toString();
            }
            case 93: 
            case 95: {
                TimestampData timestampData = (TimestampData)object;
                StringBuilder stringBuilder = new StringBuilder();
                HsqlDateTime.getTimestampString(stringBuilder, timestampData.getSeconds() + (long)timestampData.getZone(), timestampData.getNanos(), this.scale);
                if (!this.withTimeZone) {
                    return stringBuilder.toString();
                }
                String string3 = Type.SQL_INTERVAL_HOUR_TO_MINUTE.intervalSecondToString(((TimestampData)object).getZone(), 0, true);
                stringBuilder.append(string3);
                return stringBuilder.toString();
            }
        }
        throw Error.runtimeError(201, "DateTimeType");
    }

    @Override
    public String convertToSQLString(Object object) {
        if (object == null) {
            return "NULL";
        }
        StringBuilder stringBuilder = new StringBuilder(32);
        switch (this.typeCode) {
            case 91: {
                stringBuilder.append("DATE");
                break;
            }
            case 92: 
            case 94: {
                stringBuilder.append("TIME");
                break;
            }
            case 93: 
            case 95: {
                stringBuilder.append("TIMESTAMP");
            }
        }
        stringBuilder.append(StringConverter.toQuotedString(this.convertToString(object), '\'', false));
        return stringBuilder.toString();
    }

    @Override
    public boolean canConvertFrom(Type type) {
        if (type.typeCode == 0) {
            return true;
        }
        if (type.isCharacterType()) {
            return true;
        }
        if (!type.isDateTimeType()) {
            return false;
        }
        if (type.typeCode == 91) {
            return this.typeCode != 92;
        }
        if (type.typeCode == 92) {
            return this.typeCode != 91;
        }
        return true;
    }

    @Override
    public int canMoveFrom(Type type) {
        if (type == this) {
            return 0;
        }
        if (this.typeCode == type.typeCode) {
            return this.scale >= type.scale ? 0 : -1;
        }
        return -1;
    }

    @Override
    public Object add(Session session, Object object, Object object2, Type type) {
        if (object == null || object2 == null) {
            return null;
        }
        if (type.isNumberType()) {
            if (this.typeCode == 91) {
                object2 = ((NumberType)type).floor(object2);
            }
            object2 = Type.SQL_INTERVAL_SECOND_MAX_PRECISION.multiply(IntervalSecondData.oneDay, object2);
        }
        switch (this.typeCode) {
            case 92: 
            case 94: {
                if (object2 instanceof IntervalMonthData) {
                    throw Error.runtimeError(201, "DateTimeType");
                }
                if (!(object2 instanceof IntervalSecondData)) break;
                return DateTimeType.addSeconds((TimeData)object, ((IntervalSecondData)object2).units, ((IntervalSecondData)object2).nanos);
            }
            case 91: 
            case 93: 
            case 95: {
                if (object2 instanceof IntervalMonthData) {
                    return DateTimeType.addMonths(session, (TimestampData)object, ((IntervalMonthData)object2).units);
                }
                if (!(object2 instanceof IntervalSecondData)) break;
                return DateTimeType.addSeconds((TimestampData)object, ((IntervalSecondData)object2).units, ((IntervalSecondData)object2).nanos);
            }
        }
        throw Error.runtimeError(201, "DateTimeType");
    }

    @Override
    public Object subtract(Session session, Object object, Object object2, Type type) {
        if (object == null || object2 == null) {
            return null;
        }
        if (type.isNumberType()) {
            if (this.typeCode == 91) {
                object2 = ((NumberType)type).floor(object2);
            }
            object2 = Type.SQL_INTERVAL_SECOND_MAX_PRECISION.multiply(IntervalSecondData.oneDay, object2);
        }
        switch (this.typeCode) {
            case 92: 
            case 94: {
                if (object2 instanceof IntervalMonthData) {
                    throw Error.runtimeError(201, "DateTimeType");
                }
                if (!(object2 instanceof IntervalSecondData)) break;
                return DateTimeType.addSeconds((TimeData)object, -((IntervalSecondData)object2).units, -((IntervalSecondData)object2).nanos);
            }
            case 91: 
            case 93: 
            case 95: {
                if (object2 instanceof IntervalMonthData) {
                    return DateTimeType.addMonths(session, (TimestampData)object, -((IntervalMonthData)object2).units);
                }
                if (!(object2 instanceof IntervalSecondData)) break;
                return DateTimeType.addSeconds((TimestampData)object, -((IntervalSecondData)object2).units, -((IntervalSecondData)object2).nanos);
            }
        }
        throw Error.runtimeError(201, "DateTimeType");
    }

    public static double convertToDouble(Object object) {
        double d;
        double d2;
        if (object instanceof TimeData) {
            d2 = ((TimeData)object).getSeconds();
            d = (double)((TimeData)object).getNanos() / 1.0E9;
        } else {
            d2 = ((TimestampData)object).getSeconds();
            d = (double)((TimestampData)object).getNanos() / 1.0E9;
        }
        return d2 + d;
    }

    public Object convertFromDouble(Session session, double d) {
        long l = (long)d;
        int n = (int)((d - (double)l) * 1.0E9);
        return this.getValue(session, l, n, 0);
    }

    public Object truncate(Session session, Object object, int n) {
        if (object == null) {
            return null;
        }
        long l = this.getMillis(object);
        Calendar calendar = session.getCalendarGMT();
        l = HsqlDateTime.getTruncatedPart(calendar, l, n);
        l -= this.getZoneMillis(object);
        switch (this.typeCode) {
            case 94: {
                l = HsqlDateTime.getNormalisedTime(calendar, l);
            }
            case 92: {
                return new TimeData((int)(l / 1000L), 0, ((TimeData)object).getZone());
            }
            case 91: 
            case 93: 
            case 95: {
                return new TimestampData(l / 1000L, 0, ((TimestampData)object).getZone());
            }
        }
        throw Error.runtimeError(201, "DateTimeType");
    }

    public Object round(Session session, Object object, int n) {
        if (object == null) {
            return null;
        }
        long l = this.getMillis(object);
        Calendar calendar = session.getCalendarGMT();
        l = HsqlDateTime.getRoundedPart(calendar, l, n);
        l -= this.getZoneMillis(object);
        switch (this.typeCode) {
            case 92: 
            case 94: {
                l = HsqlDateTime.getNormalisedTime(l);
                return new TimeData((int)(l / 1000L), 0, ((TimeData)object).getZone());
            }
            case 91: 
            case 93: 
            case 95: {
                return new TimestampData(l / 1000L, 0, ((TimestampData)object).getZone());
            }
        }
        throw Error.runtimeError(201, "DateTimeType");
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof DateTimeType) {
            return super.equals(object) && ((DateTimeType)object).withTimeZone == this.withTimeZone;
        }
        return false;
    }

    @Override
    public int getPart(Session session, Object object, int n) {
        int n2;
        int n3 = 0;
        int n4 = 1;
        switch (n) {
            case 101: {
                n2 = 1;
                break;
            }
            case 102: {
                n3 = 1;
                n2 = 2;
                break;
            }
            case 103: 
            case 124: {
                n2 = 5;
                break;
            }
            case 104: {
                n2 = 11;
                break;
            }
            case 105: {
                n2 = 12;
                break;
            }
            case 106: {
                n2 = 13;
                break;
            }
            case 123: {
                n2 = 7;
                break;
            }
            case 126: {
                n2 = 3;
                break;
            }
            case 130: {
                if (this.typeCode != 92 && this.typeCode != 94) {
                    try {
                        DateTimeType dateTimeType = this.withTimeZone ? Type.SQL_TIME_WITH_TIME_ZONE : Type.SQL_TIME;
                        object = dateTimeType.castToType(session, object, this);
                    }
                    catch (HsqlException hsqlException) {
                        // empty catch block
                    }
                }
                return ((TimeData)object).getSeconds();
            }
            case 121: {
                if (this.typeCode == 95) {
                    return ((TimestampData)object).getZone() / 3600;
                }
                return ((TimeData)object).getZone() / 3600;
            }
            case 122: {
                if (this.typeCode == 95) {
                    return ((TimestampData)object).getZone() / 60 % 60;
                }
                return ((TimeData)object).getZone() / 60 % 60;
            }
            case 135: {
                if (this.typeCode == 95) {
                    return ((TimestampData)object).getZone() / 60;
                }
                return ((TimeData)object).getZone() / 60;
            }
            case 127: {
                n3 = 1;
                n4 = 3;
                n2 = 2;
                break;
            }
            case 125: {
                n2 = 6;
                break;
            }
            case 132: {
                if (this.isDateOrTimestampType()) {
                    return ((TimestampData)object).getNanos() / 1000000;
                }
                return ((TimeData)object).getNanos() / 1000000;
            }
            case 134: {
                if (this.isDateOrTimestampType()) {
                    return ((TimestampData)object).getNanos();
                }
                return ((TimeData)object).getNanos();
            }
            default: {
                throw Error.runtimeError(201, "DateTimeType - " + n);
            }
        }
        long l = this.getMillis(object);
        return HsqlDateTime.getDateTimePart(session.getCalendarGMT(), l, n2) / n4 + n3;
    }

    public Object addMonthsSpecial(Session session, Object object, int n) {
        TimestampData timestampData = (TimestampData)object;
        Calendar calendar = session.getCalendarGMT();
        long l = (timestampData.getSeconds() + (long)timestampData.getZone()) * 1000L;
        HsqlDateTime.setTimeInMillis(calendar, l);
        calendar.set(5, 1);
        calendar.add(2, 1);
        calendar.add(5, -1);
        boolean bl = l == calendar.getTimeInMillis();
        HsqlDateTime.setTimeInMillis(calendar, l);
        calendar.add(2, n);
        if (bl) {
            calendar.set(5, 1);
            calendar.add(2, 1);
            calendar.add(5, -1);
        }
        l = calendar.getTimeInMillis();
        return new TimestampData(l / 1000L, 0, 0);
    }

    public Object getLastDayOfMonth(Session session, Object object) {
        TimestampData timestampData = (TimestampData)object;
        Calendar calendar = session.getCalendarGMT();
        long l = (timestampData.getSeconds() + (long)timestampData.getZone()) * 1000L;
        HsqlDateTime.setTimeInMillis(calendar, l);
        calendar.set(5, 1);
        calendar.add(2, 1);
        calendar.add(5, -1);
        l = calendar.getTimeInMillis();
        return new TimestampData(l / 1000L, 0, 0);
    }

    long getMillis(Object object) {
        long l = this.typeCode == 92 || this.typeCode == 94 ? (long)(((TimeData)object).getSeconds() + ((TimeData)object).getZone()) * 1000L : (((TimestampData)object).getSeconds() + (long)((TimestampData)object).getZone()) * 1000L;
        return l;
    }

    long getZoneMillis(Object object) {
        long l = this.typeCode == 92 || this.typeCode == 94 ? (long)((TimeData)object).getZone() * 1000L : (long)((TimestampData)object).getZone() * 1000L;
        return l;
    }

    @Override
    public BigDecimal getSecondPart(Session session, Object object) {
        long l = this.getPart(session, object, 106);
        int n = 0;
        if (this.typeCode == 93 || this.typeCode == 95) {
            n = ((TimestampData)object).getNanos();
        } else if (this.typeCode == 92 || this.typeCode == 94) {
            n = ((TimeData)object).getNanos();
        }
        return this.getSecondPart(l, n);
    }

    public String getPartString(Session session, Object object, int n) {
        String string2 = "";
        switch (n) {
            case 128: {
                string2 = "EEEE";
                break;
            }
            case 129: {
                string2 = "MMMM";
            }
        }
        SimpleDateFormat simpleDateFormat = session.getSimpleDateFormatGMT();
        try {
            simpleDateFormat.applyPattern(string2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        java.util.Date date2 = (java.util.Date)this.convertSQLToJavaGMT(session, object);
        return simpleDateFormat.format(date2);
    }

    public Object getValue(Session session, long l, int n, int n2) {
        Calendar calendar = session.getCalendarGMT();
        switch (this.typeCode) {
            case 91: {
                l = HsqlDateTime.getNormalisedDate(calendar, (l + (long)n2) * 1000L) / 1000L;
                return new TimestampData(l);
            }
            case 94: {
                l = HsqlDateTime.getNormalisedDate(calendar, l * 1000L) / 1000L;
                return new TimeData((int)l, n, n2);
            }
            case 92: {
                l = HsqlDateTime.getNormalisedTime(calendar, (l + (long)n2) * 1000L) / 1000L;
                return new TimeData((int)l, n);
            }
            case 95: {
                return new TimestampData(l, n, n2);
            }
            case 93: {
                return new TimestampData(l + (long)n2, n);
            }
        }
        throw Error.runtimeError(201, "DateTimeType");
    }

    public DateTimeType getDateTimeTypeWithoutZone() {
        if (this.withTimeZone) {
            DateTimeType dateTimeType;
            switch (this.typeCode) {
                case 94: {
                    dateTimeType = new DateTimeType(92, 92, this.scale);
                    break;
                }
                case 95: {
                    dateTimeType = new DateTimeType(93, 93, this.scale);
                    break;
                }
                default: {
                    throw Error.runtimeError(201, "DateTimeType");
                }
            }
            dateTimeType.nameString = this.nameString;
            return dateTimeType;
        }
        return this;
    }

    public static DateTimeType getDateTimeType(int n, int n2) {
        if (n2 > 9) {
            throw Error.error(5592);
        }
        switch (n) {
            case 91: {
                return SQL_DATE;
            }
            case 92: {
                if (n2 == 0) {
                    return SQL_TIME;
                }
                return new DateTimeType(92, n, n2);
            }
            case 94: {
                if (n2 == 0) {
                    return SQL_TIME_WITH_TIME_ZONE;
                }
                return new DateTimeType(92, n, n2);
            }
            case 93: {
                if (n2 == 6) {
                    return SQL_TIMESTAMP;
                }
                if (n2 == 0) {
                    return SQL_TIMESTAMP_NO_FRACTION;
                }
                return new DateTimeType(93, n, n2);
            }
            case 95: {
                if (n2 == 6) {
                    return SQL_TIMESTAMP_WITH_TIME_ZONE;
                }
                return new DateTimeType(93, n, n2);
            }
        }
        throw Error.runtimeError(201, "DateTimeType");
    }

    public Object changeZone(Session session, Object object, Type type, int n, int n2) {
        Calendar calendar = session.getCalendarGMT();
        if (object == null) {
            return null;
        }
        if (n > 50400 || -n > 50400) {
            throw Error.error(3409);
        }
        switch (this.typeCode) {
            case 94: {
                TimeData timeData = (TimeData)object;
                if (type.isDateTimeTypeWithZone()) {
                    if (timeData.zone == n) break;
                    return new TimeData(timeData.getSeconds(), timeData.getNanos(), n);
                }
                int n3 = timeData.getSeconds() - n2;
                n3 = (int)(HsqlDateTime.getNormalisedTime(calendar, (long)n3 * 1000L) / 1000L);
                return new TimeData(n3, timeData.getNanos(), n);
            }
            case 95: {
                TimestampData timestampData = (TimestampData)object;
                long l = timestampData.getSeconds();
                if (!type.isDateTimeTypeWithZone()) {
                    l -= (long)n2;
                }
                if (timestampData.getSeconds() == l && timestampData.zone == n) break;
                return new TimestampData(l, timestampData.getNanos(), n);
            }
        }
        return object;
    }

    public boolean canAdd(IntervalType intervalType) {
        return intervalType.startPartIndex >= this.startPartIndex && intervalType.endPartIndex <= this.endPartIndex;
    }

    public int getSqlDateTimeSub() {
        switch (this.typeCode) {
            case 91: {
                return 1;
            }
            case 92: {
                return 2;
            }
            case 93: {
                return 3;
            }
        }
        return 0;
    }

    public static Type normalizeInput(Session session, Object[] objectArray, Type[] typeArray, Object[] objectArray2, Type[] typeArray2, boolean bl) {
        Object object;
        if (objectArray == null || objectArray2 == null) {
            return null;
        }
        if (objectArray[0] == null || objectArray2[0] == null) {
            return null;
        }
        if (objectArray[1] == null) {
            return null;
        }
        if (!bl && objectArray2[1] == null) {
            return null;
        }
        DateTimeType dateTimeType = SQL_TIMESTAMP_WITH_TIME_ZONE;
        objectArray[0] = dateTimeType.castToType(session, objectArray[0], typeArray[0]);
        objectArray2[0] = dateTimeType.castToType(session, objectArray2[0], typeArray2[0]);
        objectArray[1] = typeArray[1].isIntervalType() ? ((Type)dateTimeType).add(session, objectArray[0], objectArray[1], typeArray[1]) : dateTimeType.castToType(session, objectArray[1], typeArray[1]);
        objectArray2[1] = typeArray2[1].isIntervalType() ? ((Type)dateTimeType).add(session, objectArray2[0], objectArray2[1], typeArray2[1]) : (bl ? objectArray2[0] : dateTimeType.castToType(session, objectArray2[1], typeArray2[1]));
        if (((Type)dateTimeType).compare(session, objectArray[0], objectArray[1]) >= 0) {
            object = objectArray[0];
            objectArray[0] = objectArray[1];
            objectArray[1] = object;
        }
        if (!bl && ((Type)dateTimeType).compare(session, objectArray2[0], objectArray2[1]) >= 0) {
            object = objectArray2[0];
            objectArray2[0] = objectArray2[1];
            objectArray2[1] = object;
        }
        return dateTimeType;
    }

    public static Type normalizeInputRelaxed(Session session, Object[] objectArray, Type[] typeArray, Object[] objectArray2, Type[] typeArray2) {
        Object object;
        if (objectArray == null || objectArray2 == null) {
            return null;
        }
        if (objectArray[0] == null || objectArray2[0] == null) {
            return null;
        }
        if (objectArray[1] == null) {
            objectArray[1] = objectArray[0];
        }
        if (objectArray2[1] == null) {
            objectArray2[1] = objectArray2[0];
        }
        Type type = typeArray[0].getCombinedType(session, typeArray2[0], 40);
        objectArray[0] = type.castToType(session, objectArray[0], typeArray[0]);
        objectArray2[0] = type.castToType(session, objectArray2[0], typeArray2[0]);
        objectArray[1] = typeArray[1].isIntervalType() ? type.add(session, objectArray[0], objectArray[1], typeArray[1]) : type.castToType(session, objectArray[1], typeArray[1]);
        objectArray2[1] = typeArray2[1].isIntervalType() ? type.add(session, objectArray2[0], objectArray2[1], typeArray2[1]) : type.castToType(session, objectArray2[1], typeArray2[1]);
        if (type.compare(session, objectArray[0], objectArray[1]) > 0) {
            object = objectArray[0];
            objectArray[0] = objectArray[1];
            objectArray[1] = object;
        }
        if (type.compare(session, objectArray2[0], objectArray2[1]) > 0) {
            object = objectArray2[0];
            objectArray2[0] = objectArray2[1];
            objectArray2[1] = object;
        }
        return type;
    }

    public static Boolean overlaps(Session session, Object[] objectArray, Type[] typeArray, Object[] objectArray2, Type[] typeArray2) {
        Type type = DateTimeType.normalizeInput(session, objectArray, typeArray, objectArray2, typeArray2, false);
        if (type == null) {
            return null;
        }
        if (type.compare(session, objectArray[0], objectArray2[0]) > 0) {
            Object[] objectArray3 = objectArray;
            objectArray = objectArray2;
            objectArray2 = objectArray3;
        }
        if (type.compare(session, objectArray[1], objectArray2[0]) > 0) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public static Boolean overlapsRelaxed(Session session, Object[] objectArray, Type[] typeArray, Object[] objectArray2, Type[] typeArray2) {
        Type type = DateTimeType.normalizeInputRelaxed(session, objectArray, typeArray, objectArray2, typeArray2);
        if (type == null) {
            return null;
        }
        if (type.compare(session, objectArray[0], objectArray2[0]) > 0) {
            Object[] objectArray3 = objectArray;
            objectArray = objectArray2;
            objectArray2 = objectArray3;
        }
        if (type.compare(session, objectArray[1], objectArray2[0]) > 0) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public static Boolean precedes(Session session, Object[] objectArray, Type[] typeArray, Object[] objectArray2, Type[] typeArray2) {
        Type type = DateTimeType.normalizeInput(session, objectArray, typeArray, objectArray2, typeArray2, false);
        if (type == null) {
            return null;
        }
        if (type.compare(session, objectArray[1], objectArray2[0]) <= 0) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public static Boolean immediatelyPrecedes(Session session, Object[] objectArray, Type[] typeArray, Object[] objectArray2, Type[] typeArray2) {
        Type type = DateTimeType.normalizeInput(session, objectArray, typeArray, objectArray2, typeArray2, false);
        if (type == null) {
            return null;
        }
        if (type.compare(session, objectArray[1], objectArray2[0]) == 0) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public static Boolean immediatelySucceeds(Session session, Object[] objectArray, Type[] typeArray, Object[] objectArray2, Type[] typeArray2) {
        Type type = DateTimeType.normalizeInput(session, objectArray, typeArray, objectArray2, typeArray2, false);
        if (type == null) {
            return null;
        }
        if (type.compare(session, objectArray[0], objectArray2[1]) == 0) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public static Boolean succeeds(Session session, Object[] objectArray, Type[] typeArray, Object[] objectArray2, Type[] typeArray2) {
        Type type = DateTimeType.normalizeInput(session, objectArray, typeArray, objectArray2, typeArray2, false);
        if (type == null) {
            return null;
        }
        if (type.compare(session, objectArray[0], objectArray2[1]) >= 0) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public static Boolean equals(Session session, Object[] objectArray, Type[] typeArray, Object[] objectArray2, Type[] typeArray2) {
        Type type = DateTimeType.normalizeInput(session, objectArray, typeArray, objectArray2, typeArray2, false);
        if (type == null) {
            return null;
        }
        if (type.compare(session, objectArray[0], objectArray2[0]) == 0 && type.compare(session, objectArray[1], objectArray2[1]) == 0) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public static Boolean contains(Session session, Object[] objectArray, Type[] typeArray, Object[] objectArray2, Type[] typeArray2, boolean bl) {
        Type type = DateTimeType.normalizeInput(session, objectArray, typeArray, objectArray2, typeArray2, bl);
        if (type == null) {
            return null;
        }
        int n = type.compare(session, objectArray[0], objectArray2[0]);
        int n2 = type.compare(session, objectArray[1], objectArray2[1]);
        if (n <= 0 && n2 >= 0) {
            if (bl && n2 == 0) {
                return Boolean.FALSE;
            }
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public static BigDecimal subtractMonthsSpecial(Session session, TimestampData timestampData, TimestampData timestampData2) {
        long l = (timestampData.getSeconds() + (long)timestampData.getZone()) * 1000L;
        long l2 = (timestampData2.getSeconds() + (long)timestampData2.getZone()) * 1000L;
        boolean bl = false;
        if (l < l2) {
            bl = true;
            long l3 = l;
            l = l2;
            l2 = l3;
        }
        l = HsqlDateTime.getNormalisedDate(session.getCalendarGMT(), l);
        l2 = HsqlDateTime.getNormalisedDate(session.getCalendarGMT(), l2);
        Calendar calendar = session.getCalendarGMT();
        calendar.setTimeInMillis(l);
        int n = calendar.get(2) + calendar.get(1) * 12;
        int n2 = calendar.get(5);
        calendar.set(5, 1);
        long l4 = calendar.getTimeInMillis();
        calendar.add(2, 1);
        l4 = calendar.getTimeInMillis();
        calendar.add(5, -1);
        l4 = calendar.getTimeInMillis();
        int n3 = calendar.get(5);
        calendar.setTimeInMillis(l2);
        int n4 = calendar.get(2) + calendar.get(1) * 12;
        int n5 = calendar.get(5);
        calendar.set(5, 1);
        l4 = calendar.getTimeInMillis();
        calendar.add(2, 1);
        l4 = calendar.getTimeInMillis();
        calendar.add(5, -1);
        l4 = calendar.getTimeInMillis();
        int n6 = calendar.get(5);
        if (n2 == n5 || n2 == n3 && n5 == n6) {
            double d = n - n4;
            if (bl) {
                d = -d;
            }
            return BigDecimal.valueOf(d);
        }
        if (n5 > n2) {
            double d = n - n4 - 1;
            double d2 = n6 - n5 + n2;
            d += d2 / 31.0;
            if (bl) {
                d = -d;
            }
            return BigDecimal.valueOf(d);
        }
        double d = n - n4;
        double d3 = n2 - n5;
        d += d3 / 31.0;
        if (bl) {
            d = -d;
        }
        return BigDecimal.valueOf(d);
    }

    public static int subtractMonths(Session session, TimestampData timestampData, TimestampData timestampData2, boolean bl) {
        Calendar calendar = session.getCalendarGMT();
        boolean bl2 = false;
        if (timestampData2.getSeconds() > timestampData.getSeconds()) {
            bl2 = true;
            TimestampData timestampData3 = timestampData;
            timestampData = timestampData2;
            timestampData2 = timestampData3;
        }
        calendar.setTimeInMillis(timestampData.getSeconds() * 1000L);
        int n = calendar.get(2);
        int n2 = calendar.get(1);
        calendar.setTimeInMillis(timestampData2.getSeconds() * 1000L);
        n -= calendar.get(2);
        n2 -= calendar.get(1);
        if (bl) {
            n = n2 * 12;
        } else {
            if (n < 0) {
                n += 12;
                --n2;
            }
            n += n2 * 12;
        }
        if (bl2) {
            n = -n;
        }
        return n;
    }

    public static TimeData addSeconds(TimeData timeData, long l, int n) {
        l += (long)((n += timeData.getNanos()) / 1000000000);
        if ((n %= 1000000000) < 0) {
            n += 1000000000;
            --l;
        }
        l += (long)timeData.getSeconds();
        TimeData timeData2 = new TimeData((int)(l %= 86400L), n, timeData.getZone());
        return timeData2;
    }

    public static TimestampData addMonths(Session session, TimestampData timestampData, int n) {
        int n2 = timestampData.getNanos();
        Calendar calendar = session.getCalendarGMT();
        HsqlDateTime.setTimeInMillis(calendar, timestampData.getSeconds() * 1000L);
        calendar.add(2, n);
        TimestampData timestampData2 = new TimestampData(calendar.getTimeInMillis() / 1000L, n2, timestampData.getZone());
        return timestampData2;
    }

    public static TimestampData addSeconds(TimestampData timestampData, long l, int n) {
        l += (long)((n += timestampData.getNanos()) / 1000000000);
        if ((n %= 1000000000) < 0) {
            n += 1000000000;
            --l;
        }
        long l2 = timestampData.getSeconds() + l;
        TimestampData timestampData2 = new TimestampData(l2, n, timestampData.getZone());
        return timestampData2;
    }

    public static TimestampData convertToDatetimeSpecial(SessionInterface sessionInterface, String string2, DateTimeType dateTimeType) {
        switch (dateTimeType.typeCode) {
            case 93: {
                String string3;
                if (!(sessionInterface instanceof Session) || !((Session)sessionInterface).database.sqlSyntaxOra) break;
                switch (string2.length()) {
                    case 8: 
                    case 9: {
                        string3 = "DD-MON-YY";
                        break;
                    }
                    case 10: 
                    case 11: {
                        string3 = "DD-MON-YYYY";
                        break;
                    }
                    case 19: 
                    case 20: {
                        string3 = "DD-MON-YYYY HH24:MI:SS";
                        break;
                    }
                    default: {
                        string3 = "DD-MON-YYYY HH24:MI:SS.FF";
                    }
                }
                SimpleDateFormat simpleDateFormat = sessionInterface.getSimpleDateFormatGMT();
                return HsqlDateTime.toDate(string2, string3, simpleDateFormat, true);
            }
        }
        throw Error.error(3407);
    }

    public static TimestampData nextDayOfWeek(Session session, TimestampData timestampData, int n) {
        Calendar calendar = session.getCalendarGMT();
        calendar.setTimeInMillis(timestampData.getMillis());
        int n2 = calendar.get(7);
        if (n2 >= n) {
            n += 7;
        }
        int n3 = n - n2;
        calendar.add(5, n3);
        long l = calendar.getTimeInMillis();
        l = HsqlDateTime.getNormalisedDate(calendar, l);
        return new TimestampData(l / 1000L);
    }

    public static int getDayOfWeek(String string2) {
        if (string2.length() > 0) {
            char c = Character.toUpperCase(string2.charAt(0));
            switch (c) {
                case 'M': {
                    return 2;
                }
                case 'T': {
                    if (string2.length() < 2) break;
                    if (Character.toUpperCase(string2.charAt(1)) == 'U') {
                        return 3;
                    }
                    if (Character.toUpperCase(string2.charAt(1)) != 'H') break;
                    return 5;
                }
                case 'W': {
                    return 4;
                }
                case 'F': {
                    return 6;
                }
                case 'S': {
                    if (string2.length() < 2) break;
                    if (Character.toUpperCase(string2.charAt(1)) == 'A') {
                        return 7;
                    }
                    if (Character.toUpperCase(string2.charAt(1)) != 'U') break;
                    return 1;
                }
            }
        }
        throw Error.error(3407);
    }
}

