/*
 * Decompiled with CFR 0.152.
 */
package pl.touk.nussknacker.engine.javademo;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.flink.api.common.serialization.DeserializationSchema;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.streaming.api.functions.timestamps.BoundedOutOfOrdernessTimestampExtractor;
import org.apache.flink.streaming.api.windowing.time.Time;
import pl.touk.nussknacker.engine.api.CustomStreamTransformer;
import pl.touk.nussknacker.engine.api.ProcessListener;
import pl.touk.nussknacker.engine.api.Service;
import pl.touk.nussknacker.engine.api.exception.ExceptionHandlerFactory;
import pl.touk.nussknacker.engine.api.process.ProcessObjectDependencies;
import pl.touk.nussknacker.engine.api.process.SingleNodeConfig$;
import pl.touk.nussknacker.engine.api.process.SinkFactory;
import pl.touk.nussknacker.engine.api.process.SourceFactory;
import pl.touk.nussknacker.engine.api.process.WithCategories;
import pl.touk.nussknacker.engine.api.signal.ProcessSignalSender;
import pl.touk.nussknacker.engine.api.test.TestParsingUtils;
import pl.touk.nussknacker.engine.demo.LoggingExceptionHandlerFactory;
import pl.touk.nussknacker.engine.javaapi.process.ExpressionConfig;
import pl.touk.nussknacker.engine.javaapi.process.ProcessConfigCreator;
import pl.touk.nussknacker.engine.javademo.ClientService;
import pl.touk.nussknacker.engine.javademo.EventsCounter;
import pl.touk.nussknacker.engine.javademo.Transaction;
import pl.touk.nussknacker.engine.javademo.TransactionAmountAggregator;
import pl.touk.nussknacker.engine.javademo.UtilProcessHelper;
import pl.touk.nussknacker.engine.kafka.serialization.KafkaSerializationSchemaFactory;
import pl.touk.nussknacker.engine.kafka.serialization.schemas;
import pl.touk.nussknacker.engine.kafka.sink.KafkaSinkFactory;
import pl.touk.nussknacker.engine.kafka.source.KafkaSourceFactory;
import scala.Option;
import scala.collection.Iterable;
import scala.collection.JavaConverters;
import scala.reflect.ClassTag$;

public class DemoProcessConfigCreator
implements ProcessConfigCreator {
    private <T> WithCategories<T> all(T t) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("Recommendations");
        arrayList.add("FraudDetection");
        return new WithCategories(t, ((Iterable)JavaConverters.collectionAsScalaIterableConverter(arrayList).asScala()).toList(), SingleNodeConfig$.MODULE$.zero());
    }

    public Map<String, WithCategories<Service>> services(ProcessObjectDependencies processObjectDependencies) {
        HashMap<String, WithCategories<Service>> hashMap = new HashMap<String, WithCategories<Service>>();
        hashMap.put("clientService", this.all(new ClientService()));
        return hashMap;
    }

    public Map<String, WithCategories<SourceFactory<?>>> sourceFactories(ProcessObjectDependencies processObjectDependencies) {
        KafkaSourceFactory<Transaction> kafkaSourceFactory = this.getTransactionKafkaSourceFactory(processObjectDependencies);
        HashMap hashMap = new HashMap();
        hashMap.put("kafka-transaction", this.all(kafkaSourceFactory));
        return hashMap;
    }

    private KafkaSourceFactory<Transaction> getTransactionKafkaSourceFactory(ProcessObjectDependencies processObjectDependencies) {
        BoundedOutOfOrdernessTimestampExtractor<Transaction> boundedOutOfOrdernessTimestampExtractor = new BoundedOutOfOrdernessTimestampExtractor<Transaction>(Time.minutes((long)10L)){

            public long extractTimestamp(Transaction transaction) {
                return transaction.eventDate;
            }
        };
        DeserializationSchema<Transaction> deserializationSchema = new DeserializationSchema<Transaction>(){

            public Transaction deserialize(byte[] byArray) throws IOException {
                return (Transaction)new ObjectMapper().readValue(byArray, Transaction.class);
            }

            public boolean isEndOfStream(Transaction transaction) {
                return false;
            }

            public TypeInformation<Transaction> getProducedType() {
                return TypeInformation.of(Transaction.class);
            }
        };
        return new KafkaSourceFactory((DeserializationSchema)deserializationSchema, Option.apply((Object)boundedOutOfOrdernessTimestampExtractor), TestParsingUtils.newLineSplit(), processObjectDependencies, ClassTag$.MODULE$.apply(Transaction.class));
    }

    public Map<String, WithCategories<SinkFactory>> sinkFactories(ProcessObjectDependencies processObjectDependencies) {
        schemas.ToStringSerializer & Serializable intersect = (schemas.ToStringSerializer & Serializable)object -> {
            if (object instanceof String) {
                return (String)object;
            }
            throw new RuntimeException("Sorry, only strings");
        };
        KafkaSerializationSchemaFactory & Serializable intersect2 = (KafkaSerializationSchemaFactory & Serializable)(string, kafkaConfig) -> new schemas.SimpleSerializationSchema(string, intersect, null);
        KafkaSinkFactory kafkaSinkFactory = new KafkaSinkFactory((KafkaSerializationSchemaFactory)intersect2, processObjectDependencies);
        HashMap<String, WithCategories<SinkFactory>> hashMap = new HashMap<String, WithCategories<SinkFactory>>();
        hashMap.put("kafka-stringSink", this.all(kafkaSinkFactory));
        return hashMap;
    }

    public Map<String, WithCategories<CustomStreamTransformer>> customStreamTransformers(ProcessObjectDependencies processObjectDependencies) {
        HashMap<String, WithCategories<CustomStreamTransformer>> hashMap = new HashMap<String, WithCategories<CustomStreamTransformer>>();
        hashMap.put("eventsCounter", this.all(new EventsCounter()));
        hashMap.put("transactionAmountAggregator", this.all(new TransactionAmountAggregator()));
        return hashMap;
    }

    public Map<String, WithCategories<ProcessSignalSender>> signals(ProcessObjectDependencies processObjectDependencies) {
        return Collections.emptyMap();
    }

    public Collection<ProcessListener> listeners(ProcessObjectDependencies processObjectDependencies) {
        return Collections.emptyList();
    }

    public ExceptionHandlerFactory exceptionHandlerFactory(ProcessObjectDependencies processObjectDependencies) {
        return new LoggingExceptionHandlerFactory(processObjectDependencies.config());
    }

    public ExpressionConfig expressionConfig(ProcessObjectDependencies processObjectDependencies) {
        return new ExpressionConfig(Collections.singletonMap("UTIL", this.all(new UtilProcessHelper())), Collections.emptyList());
    }

    public Map<String, String> buildInfo() {
        return Collections.emptyMap();
    }
}

