/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine;

import com.github.benmanes.caffeine.SCQHeader;
import com.github.benmanes.caffeine.base.UnsafeAccess;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class SingleConsumerQueue<E>
extends SCQHeader.HeadAndTailRef<E>
implements Queue<E>,
Serializable {
    static final int NCPU = Runtime.getRuntime().availableProcessors();
    static final int ARENA_LENGTH = SingleConsumerQueue.ceilingPowerOfTwo((NCPU + 1) / 2);
    static final int ARENA_MASK = ARENA_LENGTH - 1;
    static final Function<?, ?> OPTIMISIC = Node::new;
    static final int SPINS = NCPU == 1 ? 0 : 2000;
    static final long PROBE = UnsafeAccess.objectFieldOffset(Thread.class, "threadLocalRandomProbe");
    final AtomicReference<Node<E>>[] arena = new AtomicReference[ARENA_LENGTH];
    final Function<E, Node<E>> factory;
    static final long serialVersionUID = 1L;

    static int ceilingPowerOfTwo(int x) {
        return 1 << -Integer.numberOfLeadingZeros(x - 1);
    }

    private SingleConsumerQueue(Function<E, Node<E>> factory) {
        for (int i = 0; i < ARENA_LENGTH; ++i) {
            this.arena[i] = new AtomicReference();
        }
        Node<Object> node2 = new Node<Object>(null);
        this.factory = factory;
        this.lazySetTail(node2);
        this.head = node2;
    }

    public static <E> SingleConsumerQueue<E> optimistic() {
        Function<?, ?> factory = OPTIMISIC;
        return new SingleConsumerQueue(factory);
    }

    public static <E> SingleConsumerQueue<E> linearizable() {
        return new SingleConsumerQueue<Object>(LinearizableNode::new);
    }

    @Override
    public boolean isEmpty() {
        return this.head == this.tail;
    }

    @Override
    public int size() {
        int size2;
        Node cursor2 = this.head;
        Node t = this.tail;
        for (size2 = 0; cursor2 != t && size2 != Integer.MAX_VALUE; ++size2) {
            Node next = cursor2.getNextRelaxed();
            if (next == null) {
                while ((next = cursor2.next) == null) {
                }
            }
            cursor2 = next;
        }
        return size2;
    }

    @Override
    public boolean contains(Object o) {
        if (o == null) {
            return false;
        }
        Iterator<E> it = this.iterator();
        while (it.hasNext()) {
            if (!o.equals(it.next())) continue;
            return true;
        }
        return false;
    }

    @Override
    public E peek() {
        Node h2 = this.head;
        Node t = this.tail;
        if (h2 == t) {
            return null;
        }
        Node next = h2.getNextRelaxed();
        if (next == null) {
            while ((next = h2.next) == null) {
            }
        }
        return next.value;
    }

    @Override
    public boolean offer(E e) {
        Objects.requireNonNull(e);
        Node<E> node2 = this.factory.apply(e);
        this.append(node2, node2);
        return true;
    }

    @Override
    public E poll() {
        Node h2 = this.head;
        Node next = h2.getNextRelaxed();
        if (next == null) {
            if (h2 == this.tail) {
                return null;
            }
            while ((next = h2.next) == null) {
            }
        }
        Object e = next.value;
        next.value = null;
        this.head = next;
        if (this.factory == OPTIMISIC) {
            h2.next = null;
        }
        return e;
    }

    @Override
    public boolean add(E e) {
        return this.offer(e);
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        Objects.requireNonNull(c);
        Node<E> first2 = null;
        Node<E> last2 = null;
        for (E e : c) {
            Objects.requireNonNull(e);
            if (first2 == null) {
                last2 = first2 = this.factory.apply(e);
                continue;
            }
            Node<E> newLast = new Node<E>(e);
            last2.lazySetNext(newLast);
            last2 = newLast;
        }
        if (first2 == null) {
            return false;
        }
        this.append(first2, last2);
        return true;
    }

    void append(@NonNull Node<E> first2, @NonNull Node<E> last2) {
        while (true) {
            Node t;
            if (this.casTail(t = this.tail, last2)) {
                t.lazySetNext(first2);
                if (this.factory == OPTIMISIC) {
                    return;
                }
                while (true) {
                    first2.complete();
                    if (first2 == last2) {
                        return;
                    }
                    Node<E> next = first2.getNextRelaxed();
                    if (next == null) {
                        return;
                    }
                    if (next.value == null) {
                        first2.next = null;
                    }
                    first2 = next;
                }
            }
            Node<E> node2 = this.transferOrCombine(first2, last2);
            if (node2 == null) {
                first2.await();
                return;
            }
            if (node2 == first2) continue;
            last2 = node2;
        }
    }

    @Nullable Node<E> transferOrCombine(@NonNull Node<E> first2, Node<E> last2) {
        Node<E> found;
        int index2 = SingleConsumerQueue.index();
        AtomicReference<Node<E>> slot = this.arena[index2];
        while (true) {
            if ((found = slot.get()) == null) {
                if (!slot.compareAndSet(null, first2)) continue;
                for (int spin2 = 0; spin2 < SPINS; ++spin2) {
                    if (slot.get() == first2) continue;
                    return null;
                }
                return slot.compareAndSet(first2, null) ? first2 : null;
            }
            if (slot.compareAndSet(found, null)) break;
        }
        last2.lazySetNext(found);
        last2 = SingleConsumerQueue.findLast(found);
        for (int i = 1; i < ARENA_LENGTH; ++i) {
            slot = this.arena[i + index2 & ARENA_MASK];
            found = slot.get();
            if (found == null || !slot.compareAndSet(found, null)) continue;
            last2.lazySetNext(found);
            last2 = SingleConsumerQueue.findLast(found);
        }
        return last2;
    }

    static int index() {
        int probe = UnsafeAccess.UNSAFE.getInt(Thread.currentThread(), PROBE);
        if (probe == 0) {
            ThreadLocalRandom.current();
            probe = UnsafeAccess.UNSAFE.getInt(Thread.currentThread(), PROBE);
        }
        return probe & ARENA_MASK;
    }

    static <E> @NonNull Node<E> findLast(@NonNull Node<E> node2) {
        Node<E> next;
        while ((next = node2.getNextRelaxed()) != null) {
            node2 = next;
        }
        return node2;
    }

    @Override
    public Iterator<E> iterator() {
        return new Iterator<E>(){
            Node<E> prev;
            Node<E> t;
            Node<E> cursor;
            boolean failOnRemoval;
            {
                this.t = SingleConsumerQueue.this.tail;
                this.cursor = SingleConsumerQueue.this.head;
                this.failOnRemoval = true;
            }

            @Override
            public boolean hasNext() {
                return this.cursor != this.t;
            }

            @Override
            public E next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.advance();
                this.failOnRemoval = false;
                return this.cursor.value;
            }

            private void advance() {
                if (this.prev == null || !this.failOnRemoval) {
                    this.prev = this.cursor;
                }
                this.cursor = this.awaitNext();
            }

            @Override
            public void remove() {
                if (this.failOnRemoval) {
                    throw new IllegalStateException();
                }
                this.failOnRemoval = true;
                this.cursor.value = null;
                if (this.t == this.cursor) {
                    this.prev.lazySetNext(null);
                    if (SingleConsumerQueue.this.casTail(this.t, this.prev)) {
                        return;
                    }
                }
                this.prev.lazySetNext(this.awaitNext());
            }

            Node<E> awaitNext() {
                if (this.cursor.getNextRelaxed() == null) {
                    while (this.cursor.next == null) {
                    }
                }
                return this.cursor.getNextRelaxed();
            }
        };
    }

    Object writeReplace() {
        return new SerializationProxy(this);
    }

    private void readObject(ObjectInputStream stream) throws InvalidObjectException {
        throw new InvalidObjectException("Proxy required");
    }

    static final class LinearizableNode<E>
    extends Node<E> {
        volatile boolean done;

        LinearizableNode(@Nullable E value2) {
            super(value2);
        }

        @Override
        void complete() {
            this.done = true;
        }

        @Override
        void await() {
            while (!this.done) {
            }
        }

        @Override
        boolean isDone() {
            return this.done;
        }
    }

    static class Node<E> {
        static final long NEXT_OFFSET = UnsafeAccess.objectFieldOffset(Node.class, "next");
        @Nullable E value;
        volatile @Nullable Node<E> next;

        Node(@Nullable E value2) {
            this.value = value2;
        }

        @Nullable Node<E> getNextRelaxed() {
            return (Node)UnsafeAccess.UNSAFE.getObject(this, NEXT_OFFSET);
        }

        void lazySetNext(@Nullable Node<E> newNext) {
            UnsafeAccess.UNSAFE.putOrderedObject(this, NEXT_OFFSET, newNext);
        }

        void complete() {
        }

        void await() {
        }

        boolean isDone() {
            return true;
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[" + this.value + "]";
        }
    }

    static final class SerializationProxy<E>
    implements Serializable {
        final boolean linearizable;
        final List<E> elements;
        static final long serialVersionUID = 1L;

        SerializationProxy(SingleConsumerQueue<E> queue) {
            this.linearizable = queue.factory.apply(null) instanceof LinearizableNode;
            this.elements = new ArrayList<E>(queue);
        }

        Object readResolve() {
            SingleConsumerQueue<E> queue = this.linearizable ? SingleConsumerQueue.linearizable() : SingleConsumerQueue.optimistic();
            queue.addAll(this.elements);
            return queue;
        }
    }
}

