/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache;

import com.github.benmanes.caffeine.base.UnsafeAccess;
import com.github.benmanes.caffeine.cache.FSA;
import com.github.benmanes.caffeine.cache.Node;
import java.lang.ref.ReferenceQueue;

class FSAR<K, V>
extends FSA<K, V> {
    protected static final long WRITE_TIME_OFFSET = UnsafeAccess.objectFieldOffset(FSAR.class, "writeTime");
    volatile long writeTime;

    FSAR() {
    }

    FSAR(K key, ReferenceQueue<K> keyReferenceQueue, V value2, ReferenceQueue<V> valueReferenceQueue, int weight, long now) {
        super(key, keyReferenceQueue, value2, valueReferenceQueue, weight, now);
        UnsafeAccess.UNSAFE.putLong(this, WRITE_TIME_OFFSET, now);
    }

    FSAR(Object keyReference, V value2, ReferenceQueue<V> valueReferenceQueue, int weight, long now) {
        super(keyReference, value2, valueReferenceQueue, weight, now);
        UnsafeAccess.UNSAFE.putLong(this, WRITE_TIME_OFFSET, now);
    }

    @Override
    public final long getWriteTime() {
        return UnsafeAccess.UNSAFE.getLong(this, WRITE_TIME_OFFSET);
    }

    @Override
    public final void setWriteTime(long writeTime) {
        UnsafeAccess.UNSAFE.putLong(this, WRITE_TIME_OFFSET, writeTime);
    }

    @Override
    public final boolean casWriteTime(long expect, long update2) {
        return this.writeTime == expect && UnsafeAccess.UNSAFE.compareAndSwapLong(this, WRITE_TIME_OFFSET, expect, update2);
    }

    @Override
    public Node<K, V> newNode(K key, ReferenceQueue<K> keyReferenceQueue, V value2, ReferenceQueue<V> valueReferenceQueue, int weight, long now) {
        return new FSAR<K, V>(key, keyReferenceQueue, value2, valueReferenceQueue, weight, now);
    }

    @Override
    public Node<K, V> newNode(Object keyReference, V value2, ReferenceQueue<V> valueReferenceQueue, int weight, long now) {
        return new FSAR<K, V>(keyReference, value2, valueReferenceQueue, weight, now);
    }
}

