/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.chars;

import it.unimi.dsi.fastutil.chars.CharArrays;
import it.unimi.dsi.fastutil.chars.CharComparator;
import it.unimi.dsi.fastutil.chars.CharPriorityQueue;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.NoSuchElementException;

public class CharArrayPriorityQueue
implements CharPriorityQueue,
Serializable {
    private static final long serialVersionUID = 1L;
    protected transient char[] array = CharArrays.EMPTY_ARRAY;
    protected int size;
    protected CharComparator c;
    protected transient int firstIndex;
    protected transient boolean firstIndexValid;

    public CharArrayPriorityQueue(int capacity, CharComparator c) {
        if (capacity > 0) {
            this.array = new char[capacity];
        }
        this.c = c;
    }

    public CharArrayPriorityQueue(int capacity) {
        this(capacity, null);
    }

    public CharArrayPriorityQueue(CharComparator c) {
        this(0, c);
    }

    public CharArrayPriorityQueue() {
        this(0, null);
    }

    public CharArrayPriorityQueue(char[] a, int size2, CharComparator c) {
        this(c);
        this.array = a;
        this.size = size2;
    }

    public CharArrayPriorityQueue(char[] a, CharComparator c) {
        this(a, a.length, c);
    }

    public CharArrayPriorityQueue(char[] a, int size2) {
        this(a, size2, null);
    }

    public CharArrayPriorityQueue(char[] a) {
        this(a, a.length);
    }

    private int findFirst() {
        if (this.firstIndexValid) {
            return this.firstIndex;
        }
        this.firstIndexValid = true;
        int i = this.size;
        int firstIndex = --i;
        char first2 = this.array[firstIndex];
        if (this.c == null) {
            while (i-- != 0) {
                if (this.array[i] >= first2) continue;
                firstIndex = i;
                first2 = this.array[firstIndex];
            }
        } else {
            while (i-- != 0) {
                if (this.c.compare(this.array[i], first2) >= 0) continue;
                firstIndex = i;
                first2 = this.array[firstIndex];
            }
        }
        this.firstIndex = firstIndex;
        return this.firstIndex;
    }

    private void ensureNonEmpty() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
    }

    @Override
    public void enqueue(char x) {
        if (this.size == this.array.length) {
            this.array = CharArrays.grow(this.array, this.size + 1);
        }
        if (this.firstIndexValid) {
            if (this.c == null) {
                if (x < this.array[this.firstIndex]) {
                    this.firstIndex = this.size;
                }
            } else if (this.c.compare(x, this.array[this.firstIndex]) < 0) {
                this.firstIndex = this.size;
            }
        } else {
            this.firstIndexValid = false;
        }
        this.array[this.size++] = x;
    }

    @Override
    public char dequeueChar() {
        this.ensureNonEmpty();
        int first2 = this.findFirst();
        char result2 = this.array[first2];
        System.arraycopy(this.array, first2 + 1, this.array, first2, --this.size - first2);
        this.firstIndexValid = false;
        return result2;
    }

    @Override
    public char firstChar() {
        this.ensureNonEmpty();
        return this.array[this.findFirst()];
    }

    @Override
    public void changed() {
        this.ensureNonEmpty();
        this.firstIndexValid = false;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public void clear() {
        this.size = 0;
        this.firstIndexValid = false;
    }

    public void trim() {
        this.array = CharArrays.trim(this.array, this.size);
    }

    @Override
    public CharComparator comparator() {
        return this.c;
    }

    private void writeObject(ObjectOutputStream s2) throws IOException {
        s2.defaultWriteObject();
        s2.writeInt(this.array.length);
        for (int i = 0; i < this.size; ++i) {
            s2.writeChar(this.array[i]);
        }
    }

    private void readObject(ObjectInputStream s2) throws IOException, ClassNotFoundException {
        s2.defaultReadObject();
        this.array = new char[s2.readInt()];
        for (int i = 0; i < this.size; ++i) {
            this.array[i] = s2.readChar();
        }
    }
}

