/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.floats;

import it.unimi.dsi.fastutil.HashCommon;
import it.unimi.dsi.fastutil.booleans.AbstractBooleanCollection;
import it.unimi.dsi.fastutil.booleans.BooleanCollection;
import it.unimi.dsi.fastutil.booleans.BooleanIterator;
import it.unimi.dsi.fastutil.floats.AbstractFloat2BooleanFunction;
import it.unimi.dsi.fastutil.floats.AbstractFloatSet;
import it.unimi.dsi.fastutil.floats.Float2BooleanMap;
import it.unimi.dsi.fastutil.floats.Float2BooleanMaps;
import it.unimi.dsi.fastutil.floats.FloatIterator;
import it.unimi.dsi.fastutil.floats.FloatSet;
import it.unimi.dsi.fastutil.objects.AbstractObjectSet;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;

public abstract class AbstractFloat2BooleanMap
extends AbstractFloat2BooleanFunction
implements Float2BooleanMap,
Serializable {
    private static final long serialVersionUID = -4940583368468432370L;

    protected AbstractFloat2BooleanMap() {
    }

    @Override
    public boolean containsValue(boolean v) {
        return this.values().contains(v);
    }

    @Override
    public boolean containsKey(float k) {
        Iterator i = this.float2BooleanEntrySet().iterator();
        while (i.hasNext()) {
            if (((Float2BooleanMap.Entry)i.next()).getFloatKey() != k) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public FloatSet keySet() {
        return new AbstractFloatSet(){

            @Override
            public boolean contains(float k) {
                return AbstractFloat2BooleanMap.this.containsKey(k);
            }

            @Override
            public int size() {
                return AbstractFloat2BooleanMap.this.size();
            }

            @Override
            public void clear() {
                AbstractFloat2BooleanMap.this.clear();
            }

            @Override
            public FloatIterator iterator() {
                return new FloatIterator(){
                    private final ObjectIterator<Float2BooleanMap.Entry> i;
                    {
                        this.i = Float2BooleanMaps.fastIterator(AbstractFloat2BooleanMap.this);
                    }

                    @Override
                    public float nextFloat() {
                        return ((Float2BooleanMap.Entry)this.i.next()).getFloatKey();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.i.hasNext();
                    }

                    @Override
                    public void remove() {
                        this.i.remove();
                    }
                };
            }
        };
    }

    @Override
    public BooleanCollection values() {
        return new AbstractBooleanCollection(){

            @Override
            public boolean contains(boolean k) {
                return AbstractFloat2BooleanMap.this.containsValue(k);
            }

            @Override
            public int size() {
                return AbstractFloat2BooleanMap.this.size();
            }

            @Override
            public void clear() {
                AbstractFloat2BooleanMap.this.clear();
            }

            @Override
            public BooleanIterator iterator() {
                return new BooleanIterator(){
                    private final ObjectIterator<Float2BooleanMap.Entry> i;
                    {
                        this.i = Float2BooleanMaps.fastIterator(AbstractFloat2BooleanMap.this);
                    }

                    @Override
                    public boolean nextBoolean() {
                        return ((Float2BooleanMap.Entry)this.i.next()).getBooleanValue();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.i.hasNext();
                    }
                };
            }
        };
    }

    @Override
    public void putAll(Map<? extends Float, ? extends Boolean> m3) {
        if (m3 instanceof Float2BooleanMap) {
            ObjectIterator<Float2BooleanMap.Entry> i = Float2BooleanMaps.fastIterator((Float2BooleanMap)m3);
            while (i.hasNext()) {
                Float2BooleanMap.Entry e = (Float2BooleanMap.Entry)i.next();
                this.put(e.getFloatKey(), e.getBooleanValue());
            }
        } else {
            int n = m3.size();
            Iterator<Map.Entry<? extends Float, ? extends Boolean>> i = m3.entrySet().iterator();
            while (n-- != 0) {
                Map.Entry<? extends Float, ? extends Boolean> e = i.next();
                this.put(e.getKey(), e.getValue());
            }
        }
    }

    @Override
    public int hashCode() {
        int h2 = 0;
        int n = this.size();
        ObjectIterator<Float2BooleanMap.Entry> i = Float2BooleanMaps.fastIterator(this);
        while (n-- != 0) {
            h2 += ((Float2BooleanMap.Entry)i.next()).hashCode();
        }
        return h2;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Map)) {
            return false;
        }
        Map m3 = (Map)o;
        if (m3.size() != this.size()) {
            return false;
        }
        return this.float2BooleanEntrySet().containsAll(m3.entrySet());
    }

    public String toString() {
        StringBuilder s2 = new StringBuilder();
        ObjectIterator<Float2BooleanMap.Entry> i = Float2BooleanMaps.fastIterator(this);
        int n = this.size();
        boolean first2 = true;
        s2.append("{");
        while (n-- != 0) {
            if (first2) {
                first2 = false;
            } else {
                s2.append(", ");
            }
            Float2BooleanMap.Entry e = (Float2BooleanMap.Entry)i.next();
            s2.append(String.valueOf(e.getFloatKey()));
            s2.append("=>");
            s2.append(String.valueOf(e.getBooleanValue()));
        }
        s2.append("}");
        return s2.toString();
    }

    public static abstract class BasicEntrySet
    extends AbstractObjectSet<Float2BooleanMap.Entry> {
        protected final Float2BooleanMap map;

        public BasicEntrySet(Float2BooleanMap map23) {
            this.map = map23;
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            if (o instanceof Float2BooleanMap.Entry) {
                Float2BooleanMap.Entry e = (Float2BooleanMap.Entry)o;
                float k = e.getFloatKey();
                return this.map.containsKey(k) && this.map.get(k) == e.getBooleanValue();
            }
            Map.Entry e = (Map.Entry)o;
            Object key = e.getKey();
            if (key == null || !(key instanceof Float)) {
                return false;
            }
            float k = ((Float)key).floatValue();
            Object value2 = e.getValue();
            if (value2 == null || !(value2 instanceof Boolean)) {
                return false;
            }
            return this.map.containsKey(k) && this.map.get(k) == ((Boolean)value2).booleanValue();
        }

        @Override
        public boolean remove(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            if (o instanceof Float2BooleanMap.Entry) {
                Float2BooleanMap.Entry e = (Float2BooleanMap.Entry)o;
                return this.map.remove(e.getFloatKey(), e.getBooleanValue());
            }
            Map.Entry e = (Map.Entry)o;
            Object key = e.getKey();
            if (key == null || !(key instanceof Float)) {
                return false;
            }
            float k = ((Float)key).floatValue();
            Object value2 = e.getValue();
            if (value2 == null || !(value2 instanceof Boolean)) {
                return false;
            }
            boolean v = (Boolean)value2;
            return this.map.remove(k, v);
        }

        @Override
        public int size() {
            return this.map.size();
        }
    }

    public static class BasicEntry
    implements Float2BooleanMap.Entry {
        protected float key;
        protected boolean value;

        public BasicEntry() {
        }

        public BasicEntry(Float key, Boolean value2) {
            this.key = key.floatValue();
            this.value = value2;
        }

        public BasicEntry(float key, boolean value2) {
            this.key = key;
            this.value = value2;
        }

        @Override
        public float getFloatKey() {
            return this.key;
        }

        @Override
        public boolean getBooleanValue() {
            return this.value;
        }

        @Override
        public boolean setValue(boolean value2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            if (o instanceof Float2BooleanMap.Entry) {
                Float2BooleanMap.Entry e = (Float2BooleanMap.Entry)o;
                return Float.floatToIntBits(this.key) == Float.floatToIntBits(e.getFloatKey()) && this.value == e.getBooleanValue();
            }
            Map.Entry e = (Map.Entry)o;
            Object key = e.getKey();
            if (key == null || !(key instanceof Float)) {
                return false;
            }
            Object value2 = e.getValue();
            if (value2 == null || !(value2 instanceof Boolean)) {
                return false;
            }
            return Float.floatToIntBits(this.key) == Float.floatToIntBits(((Float)key).floatValue()) && this.value == (Boolean)value2;
        }

        @Override
        public int hashCode() {
            return HashCommon.float2int(this.key) ^ (this.value ? 1231 : 1237);
        }

        public String toString() {
            return this.key + "->" + this.value;
        }
    }
}

