/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.floats;

import it.unimi.dsi.fastutil.BigArrays;
import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.bytes.ByteBigArrays;
import it.unimi.dsi.fastutil.floats.FloatArrays;
import it.unimi.dsi.fastutil.floats.FloatComparator;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Random;

public final class FloatBigArrays {
    public static final float[][] EMPTY_BIG_ARRAY = new float[0][];
    public static final Hash.Strategy HASH_STRATEGY = new BigArrayHashStrategy();
    private static final int SMALL = 7;
    private static final int MEDIUM = 40;
    private static final int DIGIT_BITS = 8;
    private static final int DIGIT_MASK = 255;
    private static final int DIGITS_PER_ELEMENT = 4;

    private FloatBigArrays() {
    }

    public static float get(float[][] array2, long index2) {
        return array2[BigArrays.segment(index2)][BigArrays.displacement(index2)];
    }

    public static void set(float[][] array2, long index2, float value2) {
        array2[BigArrays.segment((long)index2)][BigArrays.displacement((long)index2)] = value2;
    }

    public static void swap(float[][] array2, long first2, long second2) {
        float t = array2[BigArrays.segment(first2)][BigArrays.displacement(first2)];
        array2[BigArrays.segment((long)first2)][BigArrays.displacement((long)first2)] = array2[BigArrays.segment(second2)][BigArrays.displacement(second2)];
        array2[BigArrays.segment((long)second2)][BigArrays.displacement((long)second2)] = t;
    }

    public static void add(float[][] array2, long index2, float incr) {
        float[] fArray = array2[BigArrays.segment(index2)];
        int n = BigArrays.displacement(index2);
        fArray[n] = fArray[n] + incr;
    }

    public static void mul(float[][] array2, long index2, float factor) {
        float[] fArray = array2[BigArrays.segment(index2)];
        int n = BigArrays.displacement(index2);
        fArray[n] = fArray[n] * factor;
    }

    public static void incr(float[][] array2, long index2) {
        float[] fArray = array2[BigArrays.segment(index2)];
        int n = BigArrays.displacement(index2);
        fArray[n] = fArray[n] + 1.0f;
    }

    public static void decr(float[][] array2, long index2) {
        float[] fArray = array2[BigArrays.segment(index2)];
        int n = BigArrays.displacement(index2);
        fArray[n] = fArray[n] - 1.0f;
    }

    public static long length(float[][] array2) {
        int length = array2.length;
        return length == 0 ? 0L : BigArrays.start(length - 1) + (long)array2[length - 1].length;
    }

    public static void copy(float[][] srcArray, long srcPos, float[][] destArray, long destPos, long length) {
        if (destPos <= srcPos) {
            int srcSegment = BigArrays.segment(srcPos);
            int destSegment = BigArrays.segment(destPos);
            int srcDispl = BigArrays.displacement(srcPos);
            int destDispl = BigArrays.displacement(destPos);
            while (length > 0L) {
                int l = (int)Math.min(length, (long)Math.min(srcArray[srcSegment].length - srcDispl, destArray[destSegment].length - destDispl));
                System.arraycopy(srcArray[srcSegment], srcDispl, destArray[destSegment], destDispl, l);
                if ((srcDispl += l) == 0x8000000) {
                    srcDispl = 0;
                    ++srcSegment;
                }
                if ((destDispl += l) == 0x8000000) {
                    destDispl = 0;
                    ++destSegment;
                }
                length -= (long)l;
            }
        } else {
            int srcSegment = BigArrays.segment(srcPos + length);
            int destSegment = BigArrays.segment(destPos + length);
            int srcDispl = BigArrays.displacement(srcPos + length);
            int destDispl = BigArrays.displacement(destPos + length);
            while (length > 0L) {
                if (srcDispl == 0) {
                    srcDispl = 0x8000000;
                    --srcSegment;
                }
                if (destDispl == 0) {
                    destDispl = 0x8000000;
                    --destSegment;
                }
                int l = (int)Math.min(length, (long)Math.min(srcDispl, destDispl));
                System.arraycopy(srcArray[srcSegment], srcDispl - l, destArray[destSegment], destDispl - l, l);
                srcDispl -= l;
                destDispl -= l;
                length -= (long)l;
            }
        }
    }

    public static void copyFromBig(float[][] srcArray, long srcPos, float[] destArray, int destPos, int length) {
        int srcSegment = BigArrays.segment(srcPos);
        int srcDispl = BigArrays.displacement(srcPos);
        while (length > 0) {
            int l = Math.min(srcArray[srcSegment].length - srcDispl, length);
            System.arraycopy(srcArray[srcSegment], srcDispl, destArray, destPos, l);
            if ((srcDispl += l) == 0x8000000) {
                srcDispl = 0;
                ++srcSegment;
            }
            destPos += l;
            length -= l;
        }
    }

    public static void copyToBig(float[] srcArray, int srcPos, float[][] destArray, long destPos, long length) {
        int destSegment = BigArrays.segment(destPos);
        int destDispl = BigArrays.displacement(destPos);
        while (length > 0L) {
            int l = (int)Math.min((long)(destArray[destSegment].length - destDispl), length);
            System.arraycopy(srcArray, srcPos, destArray[destSegment], destDispl, l);
            if ((destDispl += l) == 0x8000000) {
                destDispl = 0;
                ++destSegment;
            }
            srcPos += l;
            length -= (long)l;
        }
    }

    public static float[][] newBigArray(long length) {
        if (length == 0L) {
            return EMPTY_BIG_ARRAY;
        }
        BigArrays.ensureLength(length);
        int baseLength = (int)(length + 0x7FFFFFFL >>> 27);
        float[][] base = new float[baseLength][];
        int residual = (int)(length & 0x7FFFFFFL);
        if (residual != 0) {
            for (int i = 0; i < baseLength - 1; ++i) {
                base[i] = new float[0x8000000];
            }
            base[baseLength - 1] = new float[residual];
        } else {
            for (int i = 0; i < baseLength; ++i) {
                base[i] = new float[0x8000000];
            }
        }
        return base;
    }

    public static float[][] wrap(float[] array2) {
        if (array2.length == 0) {
            return EMPTY_BIG_ARRAY;
        }
        if (array2.length <= 0x8000000) {
            return new float[][]{array2};
        }
        float[][] bigArray = FloatBigArrays.newBigArray(array2.length);
        for (int i = 0; i < bigArray.length; ++i) {
            System.arraycopy(array2, (int)BigArrays.start(i), bigArray[i], 0, bigArray[i].length);
        }
        return bigArray;
    }

    public static float[][] ensureCapacity(float[][] array2, long length) {
        return FloatBigArrays.ensureCapacity(array2, length, FloatBigArrays.length(array2));
    }

    public static float[][] ensureCapacity(float[][] array2, long length, long preserve) {
        long oldLength = FloatBigArrays.length(array2);
        if (length > oldLength) {
            BigArrays.ensureLength(length);
            int valid = array2.length - (array2.length == 0 || array2.length > 0 && array2[array2.length - 1].length == 0x8000000 ? 0 : 1);
            int baseLength = (int)(length + 0x7FFFFFFL >>> 27);
            float[][] base = (float[][])Arrays.copyOf(array2, baseLength);
            int residual = (int)(length & 0x7FFFFFFL);
            if (residual != 0) {
                for (int i = valid; i < baseLength - 1; ++i) {
                    base[i] = new float[0x8000000];
                }
                base[baseLength - 1] = new float[residual];
            } else {
                for (int i = valid; i < baseLength; ++i) {
                    base[i] = new float[0x8000000];
                }
            }
            if (preserve - (long)valid * 0x8000000L > 0L) {
                FloatBigArrays.copy(array2, (long)valid * 0x8000000L, base, (long)valid * 0x8000000L, preserve - (long)valid * 0x8000000L);
            }
            return base;
        }
        return array2;
    }

    public static float[][] grow(float[][] array2, long length) {
        long oldLength = FloatBigArrays.length(array2);
        return length > oldLength ? FloatBigArrays.grow(array2, length, oldLength) : array2;
    }

    public static float[][] grow(float[][] array2, long length, long preserve) {
        long oldLength = FloatBigArrays.length(array2);
        return length > oldLength ? FloatBigArrays.ensureCapacity(array2, Math.max(2L * oldLength, length), preserve) : array2;
    }

    public static float[][] trim(float[][] array2, long length) {
        BigArrays.ensureLength(length);
        long oldLength = FloatBigArrays.length(array2);
        if (length >= oldLength) {
            return array2;
        }
        int baseLength = (int)(length + 0x7FFFFFFL >>> 27);
        float[][] base = (float[][])Arrays.copyOf(array2, baseLength);
        int residual = (int)(length & 0x7FFFFFFL);
        if (residual != 0) {
            base[baseLength - 1] = FloatArrays.trim(base[baseLength - 1], residual);
        }
        return base;
    }

    public static float[][] setLength(float[][] array2, long length) {
        long oldLength = FloatBigArrays.length(array2);
        if (length == oldLength) {
            return array2;
        }
        if (length < oldLength) {
            return FloatBigArrays.trim(array2, length);
        }
        return FloatBigArrays.ensureCapacity(array2, length);
    }

    public static float[][] copy(float[][] array2, long offset, long length) {
        FloatBigArrays.ensureOffsetLength(array2, offset, length);
        float[][] a = FloatBigArrays.newBigArray(length);
        FloatBigArrays.copy(array2, offset, a, 0L, length);
        return a;
    }

    public static float[][] copy(float[][] array2) {
        float[][] base = (float[][])array2.clone();
        int i = base.length;
        while (i-- != 0) {
            base[i] = (float[])array2[i].clone();
        }
        return base;
    }

    public static void fill(float[][] array2, float value2) {
        int i = array2.length;
        while (i-- != 0) {
            Arrays.fill(array2[i], value2);
        }
    }

    public static void fill(float[][] array2, long from2, long to2, float value2) {
        long length = FloatBigArrays.length(array2);
        BigArrays.ensureFromTo(length, from2, to2);
        int fromSegment = BigArrays.segment(from2);
        int toSegment = BigArrays.segment(to2);
        int fromDispl = BigArrays.displacement(from2);
        int toDispl = BigArrays.displacement(to2);
        if (fromSegment == toSegment) {
            Arrays.fill(array2[fromSegment], fromDispl, toDispl, value2);
            return;
        }
        if (toDispl != 0) {
            Arrays.fill(array2[toSegment], 0, toDispl, value2);
        }
        while (--toSegment > fromSegment) {
            Arrays.fill(array2[toSegment], value2);
        }
        Arrays.fill(array2[fromSegment], fromDispl, 0x8000000, value2);
    }

    public static boolean equals(float[][] a1, float[][] a2) {
        if (FloatBigArrays.length(a1) != FloatBigArrays.length(a2)) {
            return false;
        }
        int i = a1.length;
        while (i-- != 0) {
            float[] t = a1[i];
            float[] u = a2[i];
            int j = t.length;
            while (j-- != 0) {
                if (Float.floatToIntBits(t[j]) == Float.floatToIntBits(u[j])) continue;
                return false;
            }
        }
        return true;
    }

    public static String toString(float[][] a) {
        if (a == null) {
            return "null";
        }
        long last2 = FloatBigArrays.length(a) - 1L;
        if (last2 == -1L) {
            return "[]";
        }
        StringBuilder b = new StringBuilder();
        b.append('[');
        long i = 0L;
        while (true) {
            b.append(String.valueOf(FloatBigArrays.get(a, i)));
            if (i == last2) {
                return b.append(']').toString();
            }
            b.append(", ");
            ++i;
        }
    }

    public static void ensureFromTo(float[][] a, long from2, long to2) {
        BigArrays.ensureFromTo(FloatBigArrays.length(a), from2, to2);
    }

    public static void ensureOffsetLength(float[][] a, long offset, long length) {
        BigArrays.ensureOffsetLength(FloatBigArrays.length(a), offset, length);
    }

    private static void vecSwap(float[][] x, long a, long b, long n) {
        int i = 0;
        while ((long)i < n) {
            FloatBigArrays.swap(x, a, b);
            ++i;
            ++a;
            ++b;
        }
    }

    private static long med3(float[][] x, long a, long b, long c, FloatComparator comp) {
        int ab = comp.compare(FloatBigArrays.get(x, a), FloatBigArrays.get(x, b));
        int ac = comp.compare(FloatBigArrays.get(x, a), FloatBigArrays.get(x, c));
        int bc = comp.compare(FloatBigArrays.get(x, b), FloatBigArrays.get(x, c));
        return ab < 0 ? (bc < 0 ? b : (ac < 0 ? c : a)) : (bc > 0 ? b : (ac > 0 ? c : a));
    }

    private static void selectionSort(float[][] a, long from2, long to2, FloatComparator comp) {
        for (long i = from2; i < to2 - 1L; ++i) {
            long m3 = i;
            for (long j = i + 1L; j < to2; ++j) {
                if (comp.compare(FloatBigArrays.get(a, j), FloatBigArrays.get(a, m3)) >= 0) continue;
                m3 = j;
            }
            if (m3 == i) continue;
            FloatBigArrays.swap(a, i, m3);
        }
    }

    public static void quickSort(float[][] x, long from2, long to2, FloatComparator comp) {
        long c;
        long a;
        long len = to2 - from2;
        if (len < 7L) {
            FloatBigArrays.selectionSort(x, from2, to2, comp);
            return;
        }
        long m3 = from2 + len / 2L;
        if (len > 7L) {
            long l = from2;
            long n = to2 - 1L;
            if (len > 40L) {
                long s2 = len / 8L;
                l = FloatBigArrays.med3(x, l, l + s2, l + 2L * s2, comp);
                m3 = FloatBigArrays.med3(x, m3 - s2, m3, m3 + s2, comp);
                n = FloatBigArrays.med3(x, n - 2L * s2, n - s2, n, comp);
            }
            m3 = FloatBigArrays.med3(x, l, m3, n, comp);
        }
        float v = FloatBigArrays.get(x, m3);
        long b = a = from2;
        long d = c = to2 - 1L;
        while (true) {
            int comparison;
            if (b <= c && (comparison = comp.compare(FloatBigArrays.get(x, b), v)) <= 0) {
                if (comparison == 0) {
                    FloatBigArrays.swap(x, a++, b);
                }
                ++b;
                continue;
            }
            while (c >= b && (comparison = comp.compare(FloatBigArrays.get(x, c), v)) >= 0) {
                if (comparison == 0) {
                    FloatBigArrays.swap(x, c, d--);
                }
                --c;
            }
            if (b > c) break;
            FloatBigArrays.swap(x, b++, c--);
        }
        long n = to2;
        long s3 = Math.min(a - from2, b - a);
        FloatBigArrays.vecSwap(x, from2, b - s3, s3);
        s3 = Math.min(d - c, n - d - 1L);
        FloatBigArrays.vecSwap(x, b, n - s3, s3);
        s3 = b - a;
        if (s3 > 1L) {
            FloatBigArrays.quickSort(x, from2, from2 + s3, comp);
        }
        if ((s3 = d - c) > 1L) {
            FloatBigArrays.quickSort(x, n - s3, n, comp);
        }
    }

    private static long med3(float[][] x, long a, long b, long c) {
        int ab = Float.compare(FloatBigArrays.get(x, a), FloatBigArrays.get(x, b));
        int ac = Float.compare(FloatBigArrays.get(x, a), FloatBigArrays.get(x, c));
        int bc = Float.compare(FloatBigArrays.get(x, b), FloatBigArrays.get(x, c));
        return ab < 0 ? (bc < 0 ? b : (ac < 0 ? c : a)) : (bc > 0 ? b : (ac > 0 ? c : a));
    }

    private static void selectionSort(float[][] a, long from2, long to2) {
        for (long i = from2; i < to2 - 1L; ++i) {
            long m3 = i;
            for (long j = i + 1L; j < to2; ++j) {
                if (Float.compare(FloatBigArrays.get(a, j), FloatBigArrays.get(a, m3)) >= 0) continue;
                m3 = j;
            }
            if (m3 == i) continue;
            FloatBigArrays.swap(a, i, m3);
        }
    }

    public static void quickSort(float[][] x, FloatComparator comp) {
        FloatBigArrays.quickSort(x, 0L, FloatBigArrays.length(x), comp);
    }

    public static void quickSort(float[][] x, long from2, long to2) {
        long c;
        long a;
        long len = to2 - from2;
        if (len < 7L) {
            FloatBigArrays.selectionSort(x, from2, to2);
            return;
        }
        long m3 = from2 + len / 2L;
        if (len > 7L) {
            long l = from2;
            long n = to2 - 1L;
            if (len > 40L) {
                long s2 = len / 8L;
                l = FloatBigArrays.med3(x, l, l + s2, l + 2L * s2);
                m3 = FloatBigArrays.med3(x, m3 - s2, m3, m3 + s2);
                n = FloatBigArrays.med3(x, n - 2L * s2, n - s2, n);
            }
            m3 = FloatBigArrays.med3(x, l, m3, n);
        }
        float v = FloatBigArrays.get(x, m3);
        long b = a = from2;
        long d = c = to2 - 1L;
        while (true) {
            int comparison;
            if (b <= c && (comparison = Float.compare(FloatBigArrays.get(x, b), v)) <= 0) {
                if (comparison == 0) {
                    FloatBigArrays.swap(x, a++, b);
                }
                ++b;
                continue;
            }
            while (c >= b && (comparison = Float.compare(FloatBigArrays.get(x, c), v)) >= 0) {
                if (comparison == 0) {
                    FloatBigArrays.swap(x, c, d--);
                }
                --c;
            }
            if (b > c) break;
            FloatBigArrays.swap(x, b++, c--);
        }
        long n = to2;
        long s3 = Math.min(a - from2, b - a);
        FloatBigArrays.vecSwap(x, from2, b - s3, s3);
        s3 = Math.min(d - c, n - d - 1L);
        FloatBigArrays.vecSwap(x, b, n - s3, s3);
        s3 = b - a;
        if (s3 > 1L) {
            FloatBigArrays.quickSort(x, from2, from2 + s3);
        }
        if ((s3 = d - c) > 1L) {
            FloatBigArrays.quickSort(x, n - s3, n);
        }
    }

    public static void quickSort(float[][] x) {
        FloatBigArrays.quickSort(x, 0L, FloatBigArrays.length(x));
    }

    public static long binarySearch(float[][] a, long from2, long to2, float key) {
        --to2;
        while (from2 <= to2) {
            long mid = from2 + to2 >>> 1;
            float midVal = FloatBigArrays.get(a, mid);
            if (midVal < key) {
                from2 = mid + 1L;
                continue;
            }
            if (midVal > key) {
                to2 = mid - 1L;
                continue;
            }
            return mid;
        }
        return -(from2 + 1L);
    }

    public static long binarySearch(float[][] a, float key) {
        return FloatBigArrays.binarySearch(a, 0L, FloatBigArrays.length(a), key);
    }

    public static long binarySearch(float[][] a, long from2, long to2, float key, FloatComparator c) {
        --to2;
        while (from2 <= to2) {
            long mid = from2 + to2 >>> 1;
            float midVal = FloatBigArrays.get(a, mid);
            int cmp = c.compare(midVal, key);
            if (cmp < 0) {
                from2 = mid + 1L;
                continue;
            }
            if (cmp > 0) {
                to2 = mid - 1L;
                continue;
            }
            return mid;
        }
        return -(from2 + 1L);
    }

    public static long binarySearch(float[][] a, float key, FloatComparator c) {
        return FloatBigArrays.binarySearch(a, 0L, FloatBigArrays.length(a), key, c);
    }

    private static final long fixFloat(float f) {
        long i = Float.floatToRawIntBits(f);
        return i >= 0L ? i : i ^ Integer.MAX_VALUE;
    }

    public static void radixSort(float[][] a) {
        FloatBigArrays.radixSort(a, 0L, FloatBigArrays.length(a));
    }

    public static void radixSort(float[][] a, long from2, long to2) {
        int maxLevel = 3;
        int stackSize = 766;
        long[] offsetStack = new long[766];
        int offsetPos = 0;
        long[] lengthStack = new long[766];
        int lengthPos = 0;
        int[] levelStack = new int[766];
        int levelPos = 0;
        offsetStack[offsetPos++] = from2;
        lengthStack[lengthPos++] = to2 - from2;
        levelStack[levelPos++] = 0;
        long[] count2 = new long[256];
        long[] pos = new long[256];
        byte[][] digit = ByteBigArrays.newBigArray(to2 - from2);
        while (offsetPos > 0) {
            int level;
            int signMask;
            long first2 = offsetStack[--offsetPos];
            long length = lengthStack[--lengthPos];
            int n = signMask = (level = levelStack[--levelPos]) % 4 == 0 ? 128 : 0;
            if (length < 40L) {
                FloatBigArrays.selectionSort(a, first2, first2 + length);
                continue;
            }
            int shift2 = (3 - level % 4) * 8;
            long i = length;
            while (i-- != 0L) {
                ByteBigArrays.set(digit, i, (byte)(FloatBigArrays.fixFloat(FloatBigArrays.get(a, first2 + i)) >>> shift2 & 0xFFL ^ (long)signMask));
            }
            i = length;
            while (i-- != 0L) {
                int n2 = ByteBigArrays.get(digit, i) & 0xFF;
                count2[n2] = count2[n2] + 1L;
            }
            int lastUsed = -1;
            long p = 0L;
            for (int i2 = 0; i2 < 256; ++i2) {
                if (count2[i2] != 0L) {
                    lastUsed = i2;
                    if (level < 3 && count2[i2] > 1L) {
                        offsetStack[offsetPos++] = p + first2;
                        lengthStack[lengthPos++] = count2[i2];
                        levelStack[levelPos++] = level + 1;
                    }
                }
                pos[i2] = p += count2[i2];
            }
            long end2 = length - count2[lastUsed];
            count2[lastUsed] = 0L;
            int c = -1;
            for (long i3 = 0L; i3 < end2; i3 += count2[c]) {
                float t = FloatBigArrays.get(a, i3 + first2);
                c = ByteBigArrays.get(digit, i3) & 0xFF;
                while (true) {
                    int n3 = c;
                    long l = pos[n3] - 1L;
                    pos[n3] = l;
                    long d = l;
                    if (l <= i3) break;
                    float z = t;
                    int zz = c;
                    t = FloatBigArrays.get(a, d + first2);
                    c = ByteBigArrays.get(digit, d) & 0xFF;
                    FloatBigArrays.set(a, d + first2, z);
                    ByteBigArrays.set(digit, d, (byte)zz);
                }
                FloatBigArrays.set(a, i3 + first2, t);
                count2[c] = 0L;
            }
        }
    }

    private static void selectionSort(float[][] a, float[][] b, long from2, long to2) {
        for (long i = from2; i < to2 - 1L; ++i) {
            long m3 = i;
            for (long j = i + 1L; j < to2; ++j) {
                if (Float.compare(FloatBigArrays.get(a, j), FloatBigArrays.get(a, m3)) >= 0 && (Float.compare(FloatBigArrays.get(a, j), FloatBigArrays.get(a, m3)) != 0 || Float.compare(FloatBigArrays.get(b, j), FloatBigArrays.get(b, m3)) >= 0)) continue;
                m3 = j;
            }
            if (m3 == i) continue;
            float t = FloatBigArrays.get(a, i);
            FloatBigArrays.set(a, i, FloatBigArrays.get(a, m3));
            FloatBigArrays.set(a, m3, t);
            t = FloatBigArrays.get(b, i);
            FloatBigArrays.set(b, i, FloatBigArrays.get(b, m3));
            FloatBigArrays.set(b, m3, t);
        }
    }

    public static void radixSort(float[][] a, float[][] b) {
        FloatBigArrays.radixSort(a, b, 0L, FloatBigArrays.length(a));
    }

    public static void radixSort(float[][] a, float[][] b, long from2, long to2) {
        int layers = 2;
        if (FloatBigArrays.length(a) != FloatBigArrays.length(b)) {
            throw new IllegalArgumentException("Array size mismatch.");
        }
        int maxLevel = 7;
        int stackSize = 1786;
        long[] offsetStack = new long[1786];
        int offsetPos = 0;
        long[] lengthStack = new long[1786];
        int lengthPos = 0;
        int[] levelStack = new int[1786];
        int levelPos = 0;
        offsetStack[offsetPos++] = from2;
        lengthStack[lengthPos++] = to2 - from2;
        levelStack[levelPos++] = 0;
        long[] count2 = new long[256];
        long[] pos = new long[256];
        byte[][] digit = ByteBigArrays.newBigArray(to2 - from2);
        while (offsetPos > 0) {
            int level;
            int signMask;
            long first2 = offsetStack[--offsetPos];
            long length = lengthStack[--lengthPos];
            int n = signMask = (level = levelStack[--levelPos]) % 4 == 0 ? 128 : 0;
            if (length < 40L) {
                FloatBigArrays.selectionSort(a, b, first2, first2 + length);
                continue;
            }
            float[][] k = level < 4 ? a : b;
            int shift2 = (3 - level % 4) * 8;
            long i = length;
            while (i-- != 0L) {
                ByteBigArrays.set(digit, i, (byte)(FloatBigArrays.fixFloat(FloatBigArrays.get(k, first2 + i)) >>> shift2 & 0xFFL ^ (long)signMask));
            }
            i = length;
            while (i-- != 0L) {
                int n2 = ByteBigArrays.get(digit, i) & 0xFF;
                count2[n2] = count2[n2] + 1L;
            }
            int lastUsed = -1;
            long p = 0L;
            for (int i2 = 0; i2 < 256; ++i2) {
                if (count2[i2] != 0L) {
                    lastUsed = i2;
                    if (level < 7 && count2[i2] > 1L) {
                        offsetStack[offsetPos++] = p + first2;
                        lengthStack[lengthPos++] = count2[i2];
                        levelStack[levelPos++] = level + 1;
                    }
                }
                pos[i2] = p += count2[i2];
            }
            long end2 = length - count2[lastUsed];
            count2[lastUsed] = 0L;
            int c = -1;
            for (long i3 = 0L; i3 < end2; i3 += count2[c]) {
                float t = FloatBigArrays.get(a, i3 + first2);
                float u = FloatBigArrays.get(b, i3 + first2);
                c = ByteBigArrays.get(digit, i3) & 0xFF;
                while (true) {
                    int n3 = c;
                    long l = pos[n3] - 1L;
                    pos[n3] = l;
                    long d = l;
                    if (l <= i3) break;
                    float z = t;
                    int zz = c;
                    t = FloatBigArrays.get(a, d + first2);
                    FloatBigArrays.set(a, d + first2, z);
                    z = u;
                    u = FloatBigArrays.get(b, d + first2);
                    FloatBigArrays.set(b, d + first2, z);
                    c = ByteBigArrays.get(digit, d) & 0xFF;
                    ByteBigArrays.set(digit, d, (byte)zz);
                }
                FloatBigArrays.set(a, i3 + first2, t);
                FloatBigArrays.set(b, i3 + first2, u);
                count2[c] = 0L;
            }
        }
    }

    public static float[][] shuffle(float[][] a, long from2, long to2, Random random) {
        long i = to2 - from2;
        while (i-- != 0L) {
            long p = (random.nextLong() & Long.MAX_VALUE) % (i + 1L);
            float t = FloatBigArrays.get(a, from2 + i);
            FloatBigArrays.set(a, from2 + i, FloatBigArrays.get(a, from2 + p));
            FloatBigArrays.set(a, from2 + p, t);
        }
        return a;
    }

    public static float[][] shuffle(float[][] a, Random random) {
        long i = FloatBigArrays.length(a);
        while (i-- != 0L) {
            long p = (random.nextLong() & Long.MAX_VALUE) % (i + 1L);
            float t = FloatBigArrays.get(a, i);
            FloatBigArrays.set(a, i, FloatBigArrays.get(a, p));
            FloatBigArrays.set(a, p, t);
        }
        return a;
    }

    private static final class BigArrayHashStrategy
    implements Hash.Strategy<float[][]>,
    Serializable {
        private static final long serialVersionUID = -7046029254386353129L;

        private BigArrayHashStrategy() {
        }

        @Override
        public int hashCode(float[][] o) {
            return Arrays.deepHashCode((Object[])o);
        }

        @Override
        public boolean equals(float[][] a, float[][] b) {
            return FloatBigArrays.equals(a, b);
        }
    }
}

