/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.floats;

import it.unimi.dsi.fastutil.floats.FloatBidirectionalIterator;
import it.unimi.dsi.fastutil.floats.FloatComparator;
import it.unimi.dsi.fastutil.floats.FloatIterators;
import it.unimi.dsi.fastutil.floats.FloatSets;
import it.unimi.dsi.fastutil.floats.FloatSortedSet;
import java.io.Serializable;
import java.util.NoSuchElementException;

public final class FloatSortedSets {
    public static final EmptySet EMPTY_SET = new EmptySet();

    private FloatSortedSets() {
    }

    public static FloatSortedSet singleton(float element) {
        return new Singleton(element);
    }

    public static FloatSortedSet singleton(float element, FloatComparator comparator) {
        return new Singleton(element, comparator);
    }

    public static FloatSortedSet singleton(Object element) {
        return new Singleton(((Float)element).floatValue());
    }

    public static FloatSortedSet singleton(Object element, FloatComparator comparator) {
        return new Singleton(((Float)element).floatValue(), comparator);
    }

    public static FloatSortedSet synchronize(FloatSortedSet s2) {
        return new SynchronizedSortedSet(s2);
    }

    public static FloatSortedSet synchronize(FloatSortedSet s2, Object sync) {
        return new SynchronizedSortedSet(s2, sync);
    }

    public static FloatSortedSet unmodifiable(FloatSortedSet s2) {
        return new UnmodifiableSortedSet(s2);
    }

    public static class UnmodifiableSortedSet
    extends FloatSets.UnmodifiableSet
    implements FloatSortedSet,
    Serializable {
        private static final long serialVersionUID = -7046029254386353129L;
        protected final FloatSortedSet sortedSet;

        protected UnmodifiableSortedSet(FloatSortedSet s2) {
            super(s2);
            this.sortedSet = s2;
        }

        @Override
        public FloatComparator comparator() {
            return this.sortedSet.comparator();
        }

        @Override
        public FloatSortedSet subSet(float from2, float to2) {
            return new UnmodifiableSortedSet(this.sortedSet.subSet(from2, to2));
        }

        @Override
        public FloatSortedSet headSet(float to2) {
            return new UnmodifiableSortedSet(this.sortedSet.headSet(to2));
        }

        @Override
        public FloatSortedSet tailSet(float from2) {
            return new UnmodifiableSortedSet(this.sortedSet.tailSet(from2));
        }

        @Override
        public FloatBidirectionalIterator iterator() {
            return FloatIterators.unmodifiable(this.sortedSet.iterator());
        }

        @Override
        public FloatBidirectionalIterator iterator(float from2) {
            return FloatIterators.unmodifiable(this.sortedSet.iterator(from2));
        }

        @Override
        public float firstFloat() {
            return this.sortedSet.firstFloat();
        }

        @Override
        public float lastFloat() {
            return this.sortedSet.lastFloat();
        }

        @Override
        @Deprecated
        public Float first() {
            return this.sortedSet.first();
        }

        @Override
        @Deprecated
        public Float last() {
            return this.sortedSet.last();
        }

        @Override
        @Deprecated
        public FloatSortedSet subSet(Float from2, Float to2) {
            return new UnmodifiableSortedSet(this.sortedSet.subSet(from2, to2));
        }

        @Override
        @Deprecated
        public FloatSortedSet headSet(Float to2) {
            return new UnmodifiableSortedSet(this.sortedSet.headSet(to2));
        }

        @Override
        @Deprecated
        public FloatSortedSet tailSet(Float from2) {
            return new UnmodifiableSortedSet(this.sortedSet.tailSet(from2));
        }
    }

    public static class SynchronizedSortedSet
    extends FloatSets.SynchronizedSet
    implements FloatSortedSet,
    Serializable {
        private static final long serialVersionUID = -7046029254386353129L;
        protected final FloatSortedSet sortedSet;

        protected SynchronizedSortedSet(FloatSortedSet s2, Object sync) {
            super(s2, sync);
            this.sortedSet = s2;
        }

        protected SynchronizedSortedSet(FloatSortedSet s2) {
            super(s2);
            this.sortedSet = s2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public FloatComparator comparator() {
            Object object = this.sync;
            synchronized (object) {
                return this.sortedSet.comparator();
            }
        }

        @Override
        public FloatSortedSet subSet(float from2, float to2) {
            return new SynchronizedSortedSet(this.sortedSet.subSet(from2, to2), this.sync);
        }

        @Override
        public FloatSortedSet headSet(float to2) {
            return new SynchronizedSortedSet(this.sortedSet.headSet(to2), this.sync);
        }

        @Override
        public FloatSortedSet tailSet(float from2) {
            return new SynchronizedSortedSet(this.sortedSet.tailSet(from2), this.sync);
        }

        @Override
        public FloatBidirectionalIterator iterator() {
            return this.sortedSet.iterator();
        }

        @Override
        public FloatBidirectionalIterator iterator(float from2) {
            return this.sortedSet.iterator(from2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public float firstFloat() {
            Object object = this.sync;
            synchronized (object) {
                return this.sortedSet.firstFloat();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public float lastFloat() {
            Object object = this.sync;
            synchronized (object) {
                return this.sortedSet.lastFloat();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Deprecated
        public Float first() {
            Object object = this.sync;
            synchronized (object) {
                return this.sortedSet.first();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Deprecated
        public Float last() {
            Object object = this.sync;
            synchronized (object) {
                return this.sortedSet.last();
            }
        }

        @Override
        @Deprecated
        public FloatSortedSet subSet(Float from2, Float to2) {
            return new SynchronizedSortedSet(this.sortedSet.subSet(from2, to2), this.sync);
        }

        @Override
        @Deprecated
        public FloatSortedSet headSet(Float to2) {
            return new SynchronizedSortedSet(this.sortedSet.headSet(to2), this.sync);
        }

        @Override
        @Deprecated
        public FloatSortedSet tailSet(Float from2) {
            return new SynchronizedSortedSet(this.sortedSet.tailSet(from2), this.sync);
        }
    }

    public static class Singleton
    extends FloatSets.Singleton
    implements FloatSortedSet,
    Serializable,
    Cloneable {
        private static final long serialVersionUID = -7046029254386353129L;
        final FloatComparator comparator;

        protected Singleton(float element, FloatComparator comparator) {
            super(element);
            this.comparator = comparator;
        }

        private Singleton(float element) {
            this(element, (FloatComparator)null);
        }

        final int compare(float k1, float k2) {
            return this.comparator == null ? Float.compare(k1, k2) : this.comparator.compare(k1, k2);
        }

        @Override
        public FloatBidirectionalIterator iterator(float from2) {
            FloatBidirectionalIterator i = this.iterator();
            if (this.compare(this.element, from2) <= 0) {
                i.nextFloat();
            }
            return i;
        }

        @Override
        public FloatComparator comparator() {
            return this.comparator;
        }

        @Override
        public FloatSortedSet subSet(float from2, float to2) {
            if (this.compare(from2, this.element) <= 0 && this.compare(this.element, to2) < 0) {
                return this;
            }
            return EMPTY_SET;
        }

        @Override
        public FloatSortedSet headSet(float to2) {
            if (this.compare(this.element, to2) < 0) {
                return this;
            }
            return EMPTY_SET;
        }

        @Override
        public FloatSortedSet tailSet(float from2) {
            if (this.compare(from2, this.element) <= 0) {
                return this;
            }
            return EMPTY_SET;
        }

        @Override
        public float firstFloat() {
            return this.element;
        }

        @Override
        public float lastFloat() {
            return this.element;
        }

        @Override
        @Deprecated
        public FloatSortedSet subSet(Float from2, Float to2) {
            return this.subSet(from2.floatValue(), to2.floatValue());
        }

        @Override
        @Deprecated
        public FloatSortedSet headSet(Float to2) {
            return this.headSet(to2.floatValue());
        }

        @Override
        @Deprecated
        public FloatSortedSet tailSet(Float from2) {
            return this.tailSet(from2.floatValue());
        }

        @Override
        @Deprecated
        public Float first() {
            return Float.valueOf(this.element);
        }

        @Override
        @Deprecated
        public Float last() {
            return Float.valueOf(this.element);
        }
    }

    public static class EmptySet
    extends FloatSets.EmptySet
    implements FloatSortedSet,
    Serializable,
    Cloneable {
        private static final long serialVersionUID = -7046029254386353129L;

        protected EmptySet() {
        }

        @Override
        public FloatBidirectionalIterator iterator(float from2) {
            return FloatIterators.EMPTY_ITERATOR;
        }

        @Override
        public FloatSortedSet subSet(float from2, float to2) {
            return EMPTY_SET;
        }

        @Override
        public FloatSortedSet headSet(float from2) {
            return EMPTY_SET;
        }

        @Override
        public FloatSortedSet tailSet(float to2) {
            return EMPTY_SET;
        }

        @Override
        public float firstFloat() {
            throw new NoSuchElementException();
        }

        @Override
        public float lastFloat() {
            throw new NoSuchElementException();
        }

        @Override
        public FloatComparator comparator() {
            return null;
        }

        @Override
        @Deprecated
        public FloatSortedSet subSet(Float from2, Float to2) {
            return EMPTY_SET;
        }

        @Override
        @Deprecated
        public FloatSortedSet headSet(Float from2) {
            return EMPTY_SET;
        }

        @Override
        @Deprecated
        public FloatSortedSet tailSet(Float to2) {
            return EMPTY_SET;
        }

        @Override
        @Deprecated
        public Float first() {
            throw new NoSuchElementException();
        }

        @Override
        @Deprecated
        public Float last() {
            throw new NoSuchElementException();
        }

        @Override
        public Object clone() {
            return EMPTY_SET;
        }

        private Object readResolve() {
            return EMPTY_SET;
        }
    }
}

