/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.ints;

import it.unimi.dsi.fastutil.BigArrays;
import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.bytes.ByteBigArrays;
import it.unimi.dsi.fastutil.ints.IntArrays;
import it.unimi.dsi.fastutil.ints.IntComparator;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Random;

public final class IntBigArrays {
    public static final int[][] EMPTY_BIG_ARRAY = new int[0][];
    public static final Hash.Strategy HASH_STRATEGY = new BigArrayHashStrategy();
    private static final int SMALL = 7;
    private static final int MEDIUM = 40;
    private static final int DIGIT_BITS = 8;
    private static final int DIGIT_MASK = 255;
    private static final int DIGITS_PER_ELEMENT = 4;

    private IntBigArrays() {
    }

    public static int get(int[][] array2, long index2) {
        return array2[BigArrays.segment(index2)][BigArrays.displacement(index2)];
    }

    public static void set(int[][] array2, long index2, int value2) {
        array2[BigArrays.segment((long)index2)][BigArrays.displacement((long)index2)] = value2;
    }

    public static void swap(int[][] array2, long first2, long second2) {
        int t = array2[BigArrays.segment(first2)][BigArrays.displacement(first2)];
        array2[BigArrays.segment((long)first2)][BigArrays.displacement((long)first2)] = array2[BigArrays.segment(second2)][BigArrays.displacement(second2)];
        array2[BigArrays.segment((long)second2)][BigArrays.displacement((long)second2)] = t;
    }

    public static void add(int[][] array2, long index2, int incr) {
        int[] nArray = array2[BigArrays.segment(index2)];
        int n = BigArrays.displacement(index2);
        nArray[n] = nArray[n] + incr;
    }

    public static void mul(int[][] array2, long index2, int factor) {
        int[] nArray = array2[BigArrays.segment(index2)];
        int n = BigArrays.displacement(index2);
        nArray[n] = nArray[n] * factor;
    }

    public static void incr(int[][] array2, long index2) {
        int[] nArray = array2[BigArrays.segment(index2)];
        int n = BigArrays.displacement(index2);
        nArray[n] = nArray[n] + 1;
    }

    public static void decr(int[][] array2, long index2) {
        int[] nArray = array2[BigArrays.segment(index2)];
        int n = BigArrays.displacement(index2);
        nArray[n] = nArray[n] - 1;
    }

    public static long length(int[][] array2) {
        int length = array2.length;
        return length == 0 ? 0L : BigArrays.start(length - 1) + (long)array2[length - 1].length;
    }

    public static void copy(int[][] srcArray, long srcPos, int[][] destArray, long destPos, long length) {
        if (destPos <= srcPos) {
            int srcSegment = BigArrays.segment(srcPos);
            int destSegment = BigArrays.segment(destPos);
            int srcDispl = BigArrays.displacement(srcPos);
            int destDispl = BigArrays.displacement(destPos);
            while (length > 0L) {
                int l = (int)Math.min(length, (long)Math.min(srcArray[srcSegment].length - srcDispl, destArray[destSegment].length - destDispl));
                System.arraycopy(srcArray[srcSegment], srcDispl, destArray[destSegment], destDispl, l);
                if ((srcDispl += l) == 0x8000000) {
                    srcDispl = 0;
                    ++srcSegment;
                }
                if ((destDispl += l) == 0x8000000) {
                    destDispl = 0;
                    ++destSegment;
                }
                length -= (long)l;
            }
        } else {
            int srcSegment = BigArrays.segment(srcPos + length);
            int destSegment = BigArrays.segment(destPos + length);
            int srcDispl = BigArrays.displacement(srcPos + length);
            int destDispl = BigArrays.displacement(destPos + length);
            while (length > 0L) {
                if (srcDispl == 0) {
                    srcDispl = 0x8000000;
                    --srcSegment;
                }
                if (destDispl == 0) {
                    destDispl = 0x8000000;
                    --destSegment;
                }
                int l = (int)Math.min(length, (long)Math.min(srcDispl, destDispl));
                System.arraycopy(srcArray[srcSegment], srcDispl - l, destArray[destSegment], destDispl - l, l);
                srcDispl -= l;
                destDispl -= l;
                length -= (long)l;
            }
        }
    }

    public static void copyFromBig(int[][] srcArray, long srcPos, int[] destArray, int destPos, int length) {
        int srcSegment = BigArrays.segment(srcPos);
        int srcDispl = BigArrays.displacement(srcPos);
        while (length > 0) {
            int l = Math.min(srcArray[srcSegment].length - srcDispl, length);
            System.arraycopy(srcArray[srcSegment], srcDispl, destArray, destPos, l);
            if ((srcDispl += l) == 0x8000000) {
                srcDispl = 0;
                ++srcSegment;
            }
            destPos += l;
            length -= l;
        }
    }

    public static void copyToBig(int[] srcArray, int srcPos, int[][] destArray, long destPos, long length) {
        int destSegment = BigArrays.segment(destPos);
        int destDispl = BigArrays.displacement(destPos);
        while (length > 0L) {
            int l = (int)Math.min((long)(destArray[destSegment].length - destDispl), length);
            System.arraycopy(srcArray, srcPos, destArray[destSegment], destDispl, l);
            if ((destDispl += l) == 0x8000000) {
                destDispl = 0;
                ++destSegment;
            }
            srcPos += l;
            length -= (long)l;
        }
    }

    public static int[][] newBigArray(long length) {
        if (length == 0L) {
            return EMPTY_BIG_ARRAY;
        }
        BigArrays.ensureLength(length);
        int baseLength = (int)(length + 0x7FFFFFFL >>> 27);
        int[][] base = new int[baseLength][];
        int residual = (int)(length & 0x7FFFFFFL);
        if (residual != 0) {
            for (int i = 0; i < baseLength - 1; ++i) {
                base[i] = new int[0x8000000];
            }
            base[baseLength - 1] = new int[residual];
        } else {
            for (int i = 0; i < baseLength; ++i) {
                base[i] = new int[0x8000000];
            }
        }
        return base;
    }

    public static int[][] wrap(int[] array2) {
        if (array2.length == 0) {
            return EMPTY_BIG_ARRAY;
        }
        if (array2.length <= 0x8000000) {
            return new int[][]{array2};
        }
        int[][] bigArray = IntBigArrays.newBigArray(array2.length);
        for (int i = 0; i < bigArray.length; ++i) {
            System.arraycopy(array2, (int)BigArrays.start(i), bigArray[i], 0, bigArray[i].length);
        }
        return bigArray;
    }

    public static int[][] ensureCapacity(int[][] array2, long length) {
        return IntBigArrays.ensureCapacity(array2, length, IntBigArrays.length(array2));
    }

    public static int[][] ensureCapacity(int[][] array2, long length, long preserve) {
        long oldLength = IntBigArrays.length(array2);
        if (length > oldLength) {
            BigArrays.ensureLength(length);
            int valid = array2.length - (array2.length == 0 || array2.length > 0 && array2[array2.length - 1].length == 0x8000000 ? 0 : 1);
            int baseLength = (int)(length + 0x7FFFFFFL >>> 27);
            int[][] base = (int[][])Arrays.copyOf(array2, baseLength);
            int residual = (int)(length & 0x7FFFFFFL);
            if (residual != 0) {
                for (int i = valid; i < baseLength - 1; ++i) {
                    base[i] = new int[0x8000000];
                }
                base[baseLength - 1] = new int[residual];
            } else {
                for (int i = valid; i < baseLength; ++i) {
                    base[i] = new int[0x8000000];
                }
            }
            if (preserve - (long)valid * 0x8000000L > 0L) {
                IntBigArrays.copy(array2, (long)valid * 0x8000000L, base, (long)valid * 0x8000000L, preserve - (long)valid * 0x8000000L);
            }
            return base;
        }
        return array2;
    }

    public static int[][] grow(int[][] array2, long length) {
        long oldLength = IntBigArrays.length(array2);
        return length > oldLength ? IntBigArrays.grow(array2, length, oldLength) : array2;
    }

    public static int[][] grow(int[][] array2, long length, long preserve) {
        long oldLength = IntBigArrays.length(array2);
        return length > oldLength ? IntBigArrays.ensureCapacity(array2, Math.max(2L * oldLength, length), preserve) : array2;
    }

    public static int[][] trim(int[][] array2, long length) {
        BigArrays.ensureLength(length);
        long oldLength = IntBigArrays.length(array2);
        if (length >= oldLength) {
            return array2;
        }
        int baseLength = (int)(length + 0x7FFFFFFL >>> 27);
        int[][] base = (int[][])Arrays.copyOf(array2, baseLength);
        int residual = (int)(length & 0x7FFFFFFL);
        if (residual != 0) {
            base[baseLength - 1] = IntArrays.trim(base[baseLength - 1], residual);
        }
        return base;
    }

    public static int[][] setLength(int[][] array2, long length) {
        long oldLength = IntBigArrays.length(array2);
        if (length == oldLength) {
            return array2;
        }
        if (length < oldLength) {
            return IntBigArrays.trim(array2, length);
        }
        return IntBigArrays.ensureCapacity(array2, length);
    }

    public static int[][] copy(int[][] array2, long offset, long length) {
        IntBigArrays.ensureOffsetLength(array2, offset, length);
        int[][] a = IntBigArrays.newBigArray(length);
        IntBigArrays.copy(array2, offset, a, 0L, length);
        return a;
    }

    public static int[][] copy(int[][] array2) {
        int[][] base = (int[][])array2.clone();
        int i = base.length;
        while (i-- != 0) {
            base[i] = (int[])array2[i].clone();
        }
        return base;
    }

    public static void fill(int[][] array2, int value2) {
        int i = array2.length;
        while (i-- != 0) {
            Arrays.fill(array2[i], value2);
        }
    }

    public static void fill(int[][] array2, long from2, long to2, int value2) {
        long length = IntBigArrays.length(array2);
        BigArrays.ensureFromTo(length, from2, to2);
        int fromSegment = BigArrays.segment(from2);
        int toSegment = BigArrays.segment(to2);
        int fromDispl = BigArrays.displacement(from2);
        int toDispl = BigArrays.displacement(to2);
        if (fromSegment == toSegment) {
            Arrays.fill(array2[fromSegment], fromDispl, toDispl, value2);
            return;
        }
        if (toDispl != 0) {
            Arrays.fill(array2[toSegment], 0, toDispl, value2);
        }
        while (--toSegment > fromSegment) {
            Arrays.fill(array2[toSegment], value2);
        }
        Arrays.fill(array2[fromSegment], fromDispl, 0x8000000, value2);
    }

    public static boolean equals(int[][] a1, int[][] a2) {
        if (IntBigArrays.length(a1) != IntBigArrays.length(a2)) {
            return false;
        }
        int i = a1.length;
        while (i-- != 0) {
            int[] t = a1[i];
            int[] u = a2[i];
            int j = t.length;
            while (j-- != 0) {
                if (t[j] == u[j]) continue;
                return false;
            }
        }
        return true;
    }

    public static String toString(int[][] a) {
        if (a == null) {
            return "null";
        }
        long last2 = IntBigArrays.length(a) - 1L;
        if (last2 == -1L) {
            return "[]";
        }
        StringBuilder b = new StringBuilder();
        b.append('[');
        long i = 0L;
        while (true) {
            b.append(String.valueOf(IntBigArrays.get(a, i)));
            if (i == last2) {
                return b.append(']').toString();
            }
            b.append(", ");
            ++i;
        }
    }

    public static void ensureFromTo(int[][] a, long from2, long to2) {
        BigArrays.ensureFromTo(IntBigArrays.length(a), from2, to2);
    }

    public static void ensureOffsetLength(int[][] a, long offset, long length) {
        BigArrays.ensureOffsetLength(IntBigArrays.length(a), offset, length);
    }

    private static void vecSwap(int[][] x, long a, long b, long n) {
        int i = 0;
        while ((long)i < n) {
            IntBigArrays.swap(x, a, b);
            ++i;
            ++a;
            ++b;
        }
    }

    private static long med3(int[][] x, long a, long b, long c, IntComparator comp) {
        int ab = comp.compare(IntBigArrays.get(x, a), IntBigArrays.get(x, b));
        int ac = comp.compare(IntBigArrays.get(x, a), IntBigArrays.get(x, c));
        int bc = comp.compare(IntBigArrays.get(x, b), IntBigArrays.get(x, c));
        return ab < 0 ? (bc < 0 ? b : (ac < 0 ? c : a)) : (bc > 0 ? b : (ac > 0 ? c : a));
    }

    private static void selectionSort(int[][] a, long from2, long to2, IntComparator comp) {
        for (long i = from2; i < to2 - 1L; ++i) {
            long m3 = i;
            for (long j = i + 1L; j < to2; ++j) {
                if (comp.compare(IntBigArrays.get(a, j), IntBigArrays.get(a, m3)) >= 0) continue;
                m3 = j;
            }
            if (m3 == i) continue;
            IntBigArrays.swap(a, i, m3);
        }
    }

    public static void quickSort(int[][] x, long from2, long to2, IntComparator comp) {
        long c;
        long a;
        long len = to2 - from2;
        if (len < 7L) {
            IntBigArrays.selectionSort(x, from2, to2, comp);
            return;
        }
        long m3 = from2 + len / 2L;
        if (len > 7L) {
            long l = from2;
            long n = to2 - 1L;
            if (len > 40L) {
                long s2 = len / 8L;
                l = IntBigArrays.med3(x, l, l + s2, l + 2L * s2, comp);
                m3 = IntBigArrays.med3(x, m3 - s2, m3, m3 + s2, comp);
                n = IntBigArrays.med3(x, n - 2L * s2, n - s2, n, comp);
            }
            m3 = IntBigArrays.med3(x, l, m3, n, comp);
        }
        int v = IntBigArrays.get(x, m3);
        long b = a = from2;
        long d = c = to2 - 1L;
        while (true) {
            int comparison;
            if (b <= c && (comparison = comp.compare(IntBigArrays.get(x, b), v)) <= 0) {
                if (comparison == 0) {
                    IntBigArrays.swap(x, a++, b);
                }
                ++b;
                continue;
            }
            while (c >= b && (comparison = comp.compare(IntBigArrays.get(x, c), v)) >= 0) {
                if (comparison == 0) {
                    IntBigArrays.swap(x, c, d--);
                }
                --c;
            }
            if (b > c) break;
            IntBigArrays.swap(x, b++, c--);
        }
        long n = to2;
        long s3 = Math.min(a - from2, b - a);
        IntBigArrays.vecSwap(x, from2, b - s3, s3);
        s3 = Math.min(d - c, n - d - 1L);
        IntBigArrays.vecSwap(x, b, n - s3, s3);
        s3 = b - a;
        if (s3 > 1L) {
            IntBigArrays.quickSort(x, from2, from2 + s3, comp);
        }
        if ((s3 = d - c) > 1L) {
            IntBigArrays.quickSort(x, n - s3, n, comp);
        }
    }

    private static long med3(int[][] x, long a, long b, long c) {
        int ab = Integer.compare(IntBigArrays.get(x, a), IntBigArrays.get(x, b));
        int ac = Integer.compare(IntBigArrays.get(x, a), IntBigArrays.get(x, c));
        int bc = Integer.compare(IntBigArrays.get(x, b), IntBigArrays.get(x, c));
        return ab < 0 ? (bc < 0 ? b : (ac < 0 ? c : a)) : (bc > 0 ? b : (ac > 0 ? c : a));
    }

    private static void selectionSort(int[][] a, long from2, long to2) {
        for (long i = from2; i < to2 - 1L; ++i) {
            long m3 = i;
            for (long j = i + 1L; j < to2; ++j) {
                if (IntBigArrays.get(a, j) >= IntBigArrays.get(a, m3)) continue;
                m3 = j;
            }
            if (m3 == i) continue;
            IntBigArrays.swap(a, i, m3);
        }
    }

    public static void quickSort(int[][] x, IntComparator comp) {
        IntBigArrays.quickSort(x, 0L, IntBigArrays.length(x), comp);
    }

    public static void quickSort(int[][] x, long from2, long to2) {
        long c;
        long a;
        long len = to2 - from2;
        if (len < 7L) {
            IntBigArrays.selectionSort(x, from2, to2);
            return;
        }
        long m3 = from2 + len / 2L;
        if (len > 7L) {
            long l = from2;
            long n = to2 - 1L;
            if (len > 40L) {
                long s2 = len / 8L;
                l = IntBigArrays.med3(x, l, l + s2, l + 2L * s2);
                m3 = IntBigArrays.med3(x, m3 - s2, m3, m3 + s2);
                n = IntBigArrays.med3(x, n - 2L * s2, n - s2, n);
            }
            m3 = IntBigArrays.med3(x, l, m3, n);
        }
        int v = IntBigArrays.get(x, m3);
        long b = a = from2;
        long d = c = to2 - 1L;
        while (true) {
            int comparison;
            if (b <= c && (comparison = Integer.compare(IntBigArrays.get(x, b), v)) <= 0) {
                if (comparison == 0) {
                    IntBigArrays.swap(x, a++, b);
                }
                ++b;
                continue;
            }
            while (c >= b && (comparison = Integer.compare(IntBigArrays.get(x, c), v)) >= 0) {
                if (comparison == 0) {
                    IntBigArrays.swap(x, c, d--);
                }
                --c;
            }
            if (b > c) break;
            IntBigArrays.swap(x, b++, c--);
        }
        long n = to2;
        long s3 = Math.min(a - from2, b - a);
        IntBigArrays.vecSwap(x, from2, b - s3, s3);
        s3 = Math.min(d - c, n - d - 1L);
        IntBigArrays.vecSwap(x, b, n - s3, s3);
        s3 = b - a;
        if (s3 > 1L) {
            IntBigArrays.quickSort(x, from2, from2 + s3);
        }
        if ((s3 = d - c) > 1L) {
            IntBigArrays.quickSort(x, n - s3, n);
        }
    }

    public static void quickSort(int[][] x) {
        IntBigArrays.quickSort(x, 0L, IntBigArrays.length(x));
    }

    public static long binarySearch(int[][] a, long from2, long to2, int key) {
        --to2;
        while (from2 <= to2) {
            long mid = from2 + to2 >>> 1;
            int midVal = IntBigArrays.get(a, mid);
            if (midVal < key) {
                from2 = mid + 1L;
                continue;
            }
            if (midVal > key) {
                to2 = mid - 1L;
                continue;
            }
            return mid;
        }
        return -(from2 + 1L);
    }

    public static long binarySearch(int[][] a, int key) {
        return IntBigArrays.binarySearch(a, 0L, IntBigArrays.length(a), key);
    }

    public static long binarySearch(int[][] a, long from2, long to2, int key, IntComparator c) {
        --to2;
        while (from2 <= to2) {
            long mid = from2 + to2 >>> 1;
            int midVal = IntBigArrays.get(a, mid);
            int cmp = c.compare(midVal, key);
            if (cmp < 0) {
                from2 = mid + 1L;
                continue;
            }
            if (cmp > 0) {
                to2 = mid - 1L;
                continue;
            }
            return mid;
        }
        return -(from2 + 1L);
    }

    public static long binarySearch(int[][] a, int key, IntComparator c) {
        return IntBigArrays.binarySearch(a, 0L, IntBigArrays.length(a), key, c);
    }

    public static void radixSort(int[][] a) {
        IntBigArrays.radixSort(a, 0L, IntBigArrays.length(a));
    }

    public static void radixSort(int[][] a, long from2, long to2) {
        int maxLevel = 3;
        int stackSize = 766;
        long[] offsetStack = new long[766];
        int offsetPos = 0;
        long[] lengthStack = new long[766];
        int lengthPos = 0;
        int[] levelStack = new int[766];
        int levelPos = 0;
        offsetStack[offsetPos++] = from2;
        lengthStack[lengthPos++] = to2 - from2;
        levelStack[levelPos++] = 0;
        long[] count2 = new long[256];
        long[] pos = new long[256];
        byte[][] digit = ByteBigArrays.newBigArray(to2 - from2);
        while (offsetPos > 0) {
            int level;
            int signMask;
            long first2 = offsetStack[--offsetPos];
            long length = lengthStack[--lengthPos];
            int n = signMask = (level = levelStack[--levelPos]) % 4 == 0 ? 128 : 0;
            if (length < 40L) {
                IntBigArrays.selectionSort(a, first2, first2 + length);
                continue;
            }
            int shift2 = (3 - level % 4) * 8;
            long i = length;
            while (i-- != 0L) {
                ByteBigArrays.set(digit, i, (byte)(IntBigArrays.get(a, first2 + i) >>> shift2 & 0xFF ^ signMask));
            }
            i = length;
            while (i-- != 0L) {
                int n2 = ByteBigArrays.get(digit, i) & 0xFF;
                count2[n2] = count2[n2] + 1L;
            }
            int lastUsed = -1;
            long p = 0L;
            for (int i2 = 0; i2 < 256; ++i2) {
                if (count2[i2] != 0L) {
                    lastUsed = i2;
                    if (level < 3 && count2[i2] > 1L) {
                        offsetStack[offsetPos++] = p + first2;
                        lengthStack[lengthPos++] = count2[i2];
                        levelStack[levelPos++] = level + 1;
                    }
                }
                pos[i2] = p += count2[i2];
            }
            long end2 = length - count2[lastUsed];
            count2[lastUsed] = 0L;
            int c = -1;
            for (long i3 = 0L; i3 < end2; i3 += count2[c]) {
                int t = IntBigArrays.get(a, i3 + first2);
                c = ByteBigArrays.get(digit, i3) & 0xFF;
                while (true) {
                    int n3 = c;
                    long l = pos[n3] - 1L;
                    pos[n3] = l;
                    long d = l;
                    if (l <= i3) break;
                    int z = t;
                    int zz = c;
                    t = IntBigArrays.get(a, d + first2);
                    c = ByteBigArrays.get(digit, d) & 0xFF;
                    IntBigArrays.set(a, d + first2, z);
                    ByteBigArrays.set(digit, d, (byte)zz);
                }
                IntBigArrays.set(a, i3 + first2, t);
                count2[c] = 0L;
            }
        }
    }

    private static void selectionSort(int[][] a, int[][] b, long from2, long to2) {
        for (long i = from2; i < to2 - 1L; ++i) {
            long m3 = i;
            for (long j = i + 1L; j < to2; ++j) {
                if (IntBigArrays.get(a, j) >= IntBigArrays.get(a, m3) && (IntBigArrays.get(a, j) != IntBigArrays.get(a, m3) || IntBigArrays.get(b, j) >= IntBigArrays.get(b, m3))) continue;
                m3 = j;
            }
            if (m3 == i) continue;
            int t = IntBigArrays.get(a, i);
            IntBigArrays.set(a, i, IntBigArrays.get(a, m3));
            IntBigArrays.set(a, m3, t);
            t = IntBigArrays.get(b, i);
            IntBigArrays.set(b, i, IntBigArrays.get(b, m3));
            IntBigArrays.set(b, m3, t);
        }
    }

    public static void radixSort(int[][] a, int[][] b) {
        IntBigArrays.radixSort(a, b, 0L, IntBigArrays.length(a));
    }

    public static void radixSort(int[][] a, int[][] b, long from2, long to2) {
        int layers = 2;
        if (IntBigArrays.length(a) != IntBigArrays.length(b)) {
            throw new IllegalArgumentException("Array size mismatch.");
        }
        int maxLevel = 7;
        int stackSize = 1786;
        long[] offsetStack = new long[1786];
        int offsetPos = 0;
        long[] lengthStack = new long[1786];
        int lengthPos = 0;
        int[] levelStack = new int[1786];
        int levelPos = 0;
        offsetStack[offsetPos++] = from2;
        lengthStack[lengthPos++] = to2 - from2;
        levelStack[levelPos++] = 0;
        long[] count2 = new long[256];
        long[] pos = new long[256];
        byte[][] digit = ByteBigArrays.newBigArray(to2 - from2);
        while (offsetPos > 0) {
            int level;
            int signMask;
            long first2 = offsetStack[--offsetPos];
            long length = lengthStack[--lengthPos];
            int n = signMask = (level = levelStack[--levelPos]) % 4 == 0 ? 128 : 0;
            if (length < 40L) {
                IntBigArrays.selectionSort(a, b, first2, first2 + length);
                continue;
            }
            int[][] k = level < 4 ? a : b;
            int shift2 = (3 - level % 4) * 8;
            long i = length;
            while (i-- != 0L) {
                ByteBigArrays.set(digit, i, (byte)(IntBigArrays.get(k, first2 + i) >>> shift2 & 0xFF ^ signMask));
            }
            i = length;
            while (i-- != 0L) {
                int n2 = ByteBigArrays.get(digit, i) & 0xFF;
                count2[n2] = count2[n2] + 1L;
            }
            int lastUsed = -1;
            long p = 0L;
            for (int i2 = 0; i2 < 256; ++i2) {
                if (count2[i2] != 0L) {
                    lastUsed = i2;
                    if (level < 7 && count2[i2] > 1L) {
                        offsetStack[offsetPos++] = p + first2;
                        lengthStack[lengthPos++] = count2[i2];
                        levelStack[levelPos++] = level + 1;
                    }
                }
                pos[i2] = p += count2[i2];
            }
            long end2 = length - count2[lastUsed];
            count2[lastUsed] = 0L;
            int c = -1;
            for (long i3 = 0L; i3 < end2; i3 += count2[c]) {
                int t = IntBigArrays.get(a, i3 + first2);
                int u = IntBigArrays.get(b, i3 + first2);
                c = ByteBigArrays.get(digit, i3) & 0xFF;
                while (true) {
                    int n3 = c;
                    long l = pos[n3] - 1L;
                    pos[n3] = l;
                    long d = l;
                    if (l <= i3) break;
                    int z = t;
                    int zz = c;
                    t = IntBigArrays.get(a, d + first2);
                    IntBigArrays.set(a, d + first2, z);
                    z = u;
                    u = IntBigArrays.get(b, d + first2);
                    IntBigArrays.set(b, d + first2, z);
                    c = ByteBigArrays.get(digit, d) & 0xFF;
                    ByteBigArrays.set(digit, d, (byte)zz);
                }
                IntBigArrays.set(a, i3 + first2, t);
                IntBigArrays.set(b, i3 + first2, u);
                count2[c] = 0L;
            }
        }
    }

    public static int[][] shuffle(int[][] a, long from2, long to2, Random random) {
        long i = to2 - from2;
        while (i-- != 0L) {
            long p = (random.nextLong() & Long.MAX_VALUE) % (i + 1L);
            int t = IntBigArrays.get(a, from2 + i);
            IntBigArrays.set(a, from2 + i, IntBigArrays.get(a, from2 + p));
            IntBigArrays.set(a, from2 + p, t);
        }
        return a;
    }

    public static int[][] shuffle(int[][] a, Random random) {
        long i = IntBigArrays.length(a);
        while (i-- != 0L) {
            long p = (random.nextLong() & Long.MAX_VALUE) % (i + 1L);
            int t = IntBigArrays.get(a, i);
            IntBigArrays.set(a, i, IntBigArrays.get(a, p));
            IntBigArrays.set(a, p, t);
        }
        return a;
    }

    private static final class BigArrayHashStrategy
    implements Hash.Strategy<int[][]>,
    Serializable {
        private static final long serialVersionUID = -7046029254386353129L;

        private BigArrayHashStrategy() {
        }

        @Override
        public int hashCode(int[][] o) {
            return Arrays.deepHashCode((Object[])o);
        }

        @Override
        public boolean equals(int[][] a, int[][] b) {
            return IntBigArrays.equals(a, b);
        }
    }
}

