/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.io;

import it.unimi.dsi.fastutil.BigArrays;
import it.unimi.dsi.fastutil.booleans.BooleanArrays;
import it.unimi.dsi.fastutil.booleans.BooleanBigArrays;
import it.unimi.dsi.fastutil.booleans.BooleanIterable;
import it.unimi.dsi.fastutil.booleans.BooleanIterator;
import it.unimi.dsi.fastutil.bytes.ByteArrays;
import it.unimi.dsi.fastutil.bytes.ByteBigArrays;
import it.unimi.dsi.fastutil.bytes.ByteIterable;
import it.unimi.dsi.fastutil.bytes.ByteIterator;
import it.unimi.dsi.fastutil.doubles.DoubleArrays;
import it.unimi.dsi.fastutil.doubles.DoubleBigArrays;
import it.unimi.dsi.fastutil.doubles.DoubleIterable;
import it.unimi.dsi.fastutil.doubles.DoubleIterator;
import it.unimi.dsi.fastutil.floats.FloatArrays;
import it.unimi.dsi.fastutil.floats.FloatBigArrays;
import it.unimi.dsi.fastutil.floats.FloatIterable;
import it.unimi.dsi.fastutil.floats.FloatIterator;
import it.unimi.dsi.fastutil.ints.IntArrays;
import it.unimi.dsi.fastutil.ints.IntBigArrays;
import it.unimi.dsi.fastutil.ints.IntIterable;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.io.FastBufferedOutputStream;
import it.unimi.dsi.fastutil.longs.LongArrays;
import it.unimi.dsi.fastutil.longs.LongBigArrays;
import it.unimi.dsi.fastutil.longs.LongIterable;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.shorts.ShortArrays;
import it.unimi.dsi.fastutil.shorts.ShortBigArrays;
import it.unimi.dsi.fastutil.shorts.ShortIterable;
import it.unimi.dsi.fastutil.shorts.ShortIterator;
import java.io.BufferedReader;
import java.io.EOFException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.util.NoSuchElementException;

public class TextIO {
    public static final int BUFFER_SIZE = 8192;

    private TextIO() {
    }

    public static int loadInts(BufferedReader reader, int[] array2, int offset, int length) throws IOException {
        IntArrays.ensureOffsetLength(array2, offset, length);
        int i = 0;
        try {
            String s2;
            for (i = 0; i < length && (s2 = reader.readLine()) != null; ++i) {
                array2[i + offset] = Integer.parseInt(s2.trim());
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        return i;
    }

    public static int loadInts(BufferedReader reader, int[] array2) throws IOException {
        return TextIO.loadInts(reader, array2, 0, array2.length);
    }

    public static int loadInts(File file, int[] array2, int offset, int length) throws IOException {
        BufferedReader reader = new BufferedReader(new FileReader(file));
        int result2 = TextIO.loadInts(reader, array2, offset, length);
        reader.close();
        return result2;
    }

    public static int loadInts(CharSequence filename, int[] array2, int offset, int length) throws IOException {
        return TextIO.loadInts(new File(filename.toString()), array2, offset, length);
    }

    public static int loadInts(File file, int[] array2) throws IOException {
        return TextIO.loadInts(file, array2, 0, array2.length);
    }

    public static int loadInts(CharSequence filename, int[] array2) throws IOException {
        return TextIO.loadInts(filename, array2, 0, array2.length);
    }

    public static void storeInts(int[] array2, int offset, int length, PrintStream stream) {
        IntArrays.ensureOffsetLength(array2, offset, length);
        for (int i = 0; i < length; ++i) {
            stream.println(array2[offset + i]);
        }
    }

    public static void storeInts(int[] array2, PrintStream stream) {
        TextIO.storeInts(array2, 0, array2.length, stream);
    }

    public static void storeInts(int[] array2, int offset, int length, File file) throws IOException {
        PrintStream stream = new PrintStream(new FastBufferedOutputStream(new FileOutputStream(file)));
        TextIO.storeInts(array2, offset, length, stream);
        stream.close();
    }

    public static void storeInts(int[] array2, int offset, int length, CharSequence filename) throws IOException {
        TextIO.storeInts(array2, offset, length, new File(filename.toString()));
    }

    public static void storeInts(int[] array2, File file) throws IOException {
        TextIO.storeInts(array2, 0, array2.length, file);
    }

    public static void storeInts(int[] array2, CharSequence filename) throws IOException {
        TextIO.storeInts(array2, 0, array2.length, filename);
    }

    public static void storeInts(IntIterator i, PrintStream stream) {
        while (i.hasNext()) {
            stream.println(i.nextInt());
        }
    }

    public static void storeInts(IntIterator i, File file) throws IOException {
        PrintStream stream = new PrintStream(new FastBufferedOutputStream(new FileOutputStream(file)));
        TextIO.storeInts(i, stream);
        stream.close();
    }

    public static void storeInts(IntIterator i, CharSequence filename) throws IOException {
        TextIO.storeInts(i, new File(filename.toString()));
    }

    public static long loadInts(BufferedReader reader, int[][] array2, long offset, long length) throws IOException {
        IntBigArrays.ensureOffsetLength(array2, offset, length);
        long c = 0L;
        try {
            for (int i = BigArrays.segment(offset); i < BigArrays.segment(offset + length + 0x7FFFFFFL); ++i) {
                int[] t = array2[i];
                int l = (int)Math.min((long)t.length, offset + length - BigArrays.start(i));
                for (int d = (int)Math.max(0L, offset - BigArrays.start(i)); d < l; ++d) {
                    String s2 = reader.readLine();
                    if (s2 == null) {
                        return c;
                    }
                    t[d] = Integer.parseInt(s2.trim());
                    ++c;
                }
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        return c;
    }

    public static long loadInts(BufferedReader reader, int[][] array2) throws IOException {
        return TextIO.loadInts(reader, array2, 0L, IntBigArrays.length(array2));
    }

    public static long loadInts(File file, int[][] array2, long offset, long length) throws IOException {
        BufferedReader reader = new BufferedReader(new FileReader(file));
        long result2 = TextIO.loadInts(reader, array2, offset, length);
        reader.close();
        return result2;
    }

    public static long loadInts(CharSequence filename, int[][] array2, long offset, long length) throws IOException {
        return TextIO.loadInts(new File(filename.toString()), array2, offset, length);
    }

    public static long loadInts(File file, int[][] array2) throws IOException {
        return TextIO.loadInts(file, array2, 0L, IntBigArrays.length(array2));
    }

    public static long loadInts(CharSequence filename, int[][] array2) throws IOException {
        return TextIO.loadInts(filename, array2, 0L, IntBigArrays.length(array2));
    }

    public static void storeInts(int[][] array2, long offset, long length, PrintStream stream) {
        IntBigArrays.ensureOffsetLength(array2, offset, length);
        for (int i = BigArrays.segment(offset); i < BigArrays.segment(offset + length + 0x7FFFFFFL); ++i) {
            int[] t = array2[i];
            int l = (int)Math.min((long)t.length, offset + length - BigArrays.start(i));
            for (int d = (int)Math.max(0L, offset - BigArrays.start(i)); d < l; ++d) {
                stream.println(t[d]);
            }
        }
    }

    public static void storeInts(int[][] array2, PrintStream stream) {
        TextIO.storeInts(array2, 0L, IntBigArrays.length(array2), stream);
    }

    public static void storeInts(int[][] array2, long offset, long length, File file) throws IOException {
        PrintStream stream = new PrintStream(new FastBufferedOutputStream(new FileOutputStream(file)));
        TextIO.storeInts(array2, offset, length, stream);
        stream.close();
    }

    public static void storeInts(int[][] array2, long offset, long length, CharSequence filename) throws IOException {
        TextIO.storeInts(array2, offset, length, new File(filename.toString()));
    }

    public static void storeInts(int[][] array2, File file) throws IOException {
        TextIO.storeInts(array2, 0L, IntBigArrays.length(array2), file);
    }

    public static void storeInts(int[][] array2, CharSequence filename) throws IOException {
        TextIO.storeInts(array2, 0L, IntBigArrays.length(array2), filename);
    }

    public static IntIterator asIntIterator(BufferedReader reader) {
        return new IntReaderWrapper(reader);
    }

    public static IntIterator asIntIterator(File file) throws IOException {
        return new IntReaderWrapper(new BufferedReader(new FileReader(file)));
    }

    public static IntIterator asIntIterator(CharSequence filename) throws IOException {
        return TextIO.asIntIterator(new File(filename.toString()));
    }

    public static IntIterable asIntIterable(File file) {
        return () -> {
            try {
                return TextIO.asIntIterator(file);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        };
    }

    public static IntIterable asIntIterable(CharSequence filename) {
        return () -> {
            try {
                return TextIO.asIntIterator(filename);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        };
    }

    public static int loadLongs(BufferedReader reader, long[] array2, int offset, int length) throws IOException {
        LongArrays.ensureOffsetLength(array2, offset, length);
        int i = 0;
        try {
            String s2;
            for (i = 0; i < length && (s2 = reader.readLine()) != null; ++i) {
                array2[i + offset] = Long.parseLong(s2.trim());
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        return i;
    }

    public static int loadLongs(BufferedReader reader, long[] array2) throws IOException {
        return TextIO.loadLongs(reader, array2, 0, array2.length);
    }

    public static int loadLongs(File file, long[] array2, int offset, int length) throws IOException {
        BufferedReader reader = new BufferedReader(new FileReader(file));
        int result2 = TextIO.loadLongs(reader, array2, offset, length);
        reader.close();
        return result2;
    }

    public static int loadLongs(CharSequence filename, long[] array2, int offset, int length) throws IOException {
        return TextIO.loadLongs(new File(filename.toString()), array2, offset, length);
    }

    public static int loadLongs(File file, long[] array2) throws IOException {
        return TextIO.loadLongs(file, array2, 0, array2.length);
    }

    public static int loadLongs(CharSequence filename, long[] array2) throws IOException {
        return TextIO.loadLongs(filename, array2, 0, array2.length);
    }

    public static void storeLongs(long[] array2, int offset, int length, PrintStream stream) {
        LongArrays.ensureOffsetLength(array2, offset, length);
        for (int i = 0; i < length; ++i) {
            stream.println(array2[offset + i]);
        }
    }

    public static void storeLongs(long[] array2, PrintStream stream) {
        TextIO.storeLongs(array2, 0, array2.length, stream);
    }

    public static void storeLongs(long[] array2, int offset, int length, File file) throws IOException {
        PrintStream stream = new PrintStream(new FastBufferedOutputStream(new FileOutputStream(file)));
        TextIO.storeLongs(array2, offset, length, stream);
        stream.close();
    }

    public static void storeLongs(long[] array2, int offset, int length, CharSequence filename) throws IOException {
        TextIO.storeLongs(array2, offset, length, new File(filename.toString()));
    }

    public static void storeLongs(long[] array2, File file) throws IOException {
        TextIO.storeLongs(array2, 0, array2.length, file);
    }

    public static void storeLongs(long[] array2, CharSequence filename) throws IOException {
        TextIO.storeLongs(array2, 0, array2.length, filename);
    }

    public static void storeLongs(LongIterator i, PrintStream stream) {
        while (i.hasNext()) {
            stream.println(i.nextLong());
        }
    }

    public static void storeLongs(LongIterator i, File file) throws IOException {
        PrintStream stream = new PrintStream(new FastBufferedOutputStream(new FileOutputStream(file)));
        TextIO.storeLongs(i, stream);
        stream.close();
    }

    public static void storeLongs(LongIterator i, CharSequence filename) throws IOException {
        TextIO.storeLongs(i, new File(filename.toString()));
    }

    public static long loadLongs(BufferedReader reader, long[][] array2, long offset, long length) throws IOException {
        LongBigArrays.ensureOffsetLength(array2, offset, length);
        long c = 0L;
        try {
            for (int i = BigArrays.segment(offset); i < BigArrays.segment(offset + length + 0x7FFFFFFL); ++i) {
                long[] t = array2[i];
                int l = (int)Math.min((long)t.length, offset + length - BigArrays.start(i));
                for (int d = (int)Math.max(0L, offset - BigArrays.start(i)); d < l; ++d) {
                    String s2 = reader.readLine();
                    if (s2 == null) {
                        return c;
                    }
                    t[d] = Long.parseLong(s2.trim());
                    ++c;
                }
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        return c;
    }

    public static long loadLongs(BufferedReader reader, long[][] array2) throws IOException {
        return TextIO.loadLongs(reader, array2, 0L, LongBigArrays.length(array2));
    }

    public static long loadLongs(File file, long[][] array2, long offset, long length) throws IOException {
        BufferedReader reader = new BufferedReader(new FileReader(file));
        long result2 = TextIO.loadLongs(reader, array2, offset, length);
        reader.close();
        return result2;
    }

    public static long loadLongs(CharSequence filename, long[][] array2, long offset, long length) throws IOException {
        return TextIO.loadLongs(new File(filename.toString()), array2, offset, length);
    }

    public static long loadLongs(File file, long[][] array2) throws IOException {
        return TextIO.loadLongs(file, array2, 0L, LongBigArrays.length(array2));
    }

    public static long loadLongs(CharSequence filename, long[][] array2) throws IOException {
        return TextIO.loadLongs(filename, array2, 0L, LongBigArrays.length(array2));
    }

    public static void storeLongs(long[][] array2, long offset, long length, PrintStream stream) {
        LongBigArrays.ensureOffsetLength(array2, offset, length);
        for (int i = BigArrays.segment(offset); i < BigArrays.segment(offset + length + 0x7FFFFFFL); ++i) {
            long[] t = array2[i];
            int l = (int)Math.min((long)t.length, offset + length - BigArrays.start(i));
            for (int d = (int)Math.max(0L, offset - BigArrays.start(i)); d < l; ++d) {
                stream.println(t[d]);
            }
        }
    }

    public static void storeLongs(long[][] array2, PrintStream stream) {
        TextIO.storeLongs(array2, 0L, LongBigArrays.length(array2), stream);
    }

    public static void storeLongs(long[][] array2, long offset, long length, File file) throws IOException {
        PrintStream stream = new PrintStream(new FastBufferedOutputStream(new FileOutputStream(file)));
        TextIO.storeLongs(array2, offset, length, stream);
        stream.close();
    }

    public static void storeLongs(long[][] array2, long offset, long length, CharSequence filename) throws IOException {
        TextIO.storeLongs(array2, offset, length, new File(filename.toString()));
    }

    public static void storeLongs(long[][] array2, File file) throws IOException {
        TextIO.storeLongs(array2, 0L, LongBigArrays.length(array2), file);
    }

    public static void storeLongs(long[][] array2, CharSequence filename) throws IOException {
        TextIO.storeLongs(array2, 0L, LongBigArrays.length(array2), filename);
    }

    public static LongIterator asLongIterator(BufferedReader reader) {
        return new LongReaderWrapper(reader);
    }

    public static LongIterator asLongIterator(File file) throws IOException {
        return new LongReaderWrapper(new BufferedReader(new FileReader(file)));
    }

    public static LongIterator asLongIterator(CharSequence filename) throws IOException {
        return TextIO.asLongIterator(new File(filename.toString()));
    }

    public static LongIterable asLongIterable(File file) {
        return () -> {
            try {
                return TextIO.asLongIterator(file);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        };
    }

    public static LongIterable asLongIterable(CharSequence filename) {
        return () -> {
            try {
                return TextIO.asLongIterator(filename);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        };
    }

    public static int loadDoubles(BufferedReader reader, double[] array2, int offset, int length) throws IOException {
        DoubleArrays.ensureOffsetLength(array2, offset, length);
        int i = 0;
        try {
            String s2;
            for (i = 0; i < length && (s2 = reader.readLine()) != null; ++i) {
                array2[i + offset] = Double.parseDouble(s2.trim());
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        return i;
    }

    public static int loadDoubles(BufferedReader reader, double[] array2) throws IOException {
        return TextIO.loadDoubles(reader, array2, 0, array2.length);
    }

    public static int loadDoubles(File file, double[] array2, int offset, int length) throws IOException {
        BufferedReader reader = new BufferedReader(new FileReader(file));
        int result2 = TextIO.loadDoubles(reader, array2, offset, length);
        reader.close();
        return result2;
    }

    public static int loadDoubles(CharSequence filename, double[] array2, int offset, int length) throws IOException {
        return TextIO.loadDoubles(new File(filename.toString()), array2, offset, length);
    }

    public static int loadDoubles(File file, double[] array2) throws IOException {
        return TextIO.loadDoubles(file, array2, 0, array2.length);
    }

    public static int loadDoubles(CharSequence filename, double[] array2) throws IOException {
        return TextIO.loadDoubles(filename, array2, 0, array2.length);
    }

    public static void storeDoubles(double[] array2, int offset, int length, PrintStream stream) {
        DoubleArrays.ensureOffsetLength(array2, offset, length);
        for (int i = 0; i < length; ++i) {
            stream.println(array2[offset + i]);
        }
    }

    public static void storeDoubles(double[] array2, PrintStream stream) {
        TextIO.storeDoubles(array2, 0, array2.length, stream);
    }

    public static void storeDoubles(double[] array2, int offset, int length, File file) throws IOException {
        PrintStream stream = new PrintStream(new FastBufferedOutputStream(new FileOutputStream(file)));
        TextIO.storeDoubles(array2, offset, length, stream);
        stream.close();
    }

    public static void storeDoubles(double[] array2, int offset, int length, CharSequence filename) throws IOException {
        TextIO.storeDoubles(array2, offset, length, new File(filename.toString()));
    }

    public static void storeDoubles(double[] array2, File file) throws IOException {
        TextIO.storeDoubles(array2, 0, array2.length, file);
    }

    public static void storeDoubles(double[] array2, CharSequence filename) throws IOException {
        TextIO.storeDoubles(array2, 0, array2.length, filename);
    }

    public static void storeDoubles(DoubleIterator i, PrintStream stream) {
        while (i.hasNext()) {
            stream.println(i.nextDouble());
        }
    }

    public static void storeDoubles(DoubleIterator i, File file) throws IOException {
        PrintStream stream = new PrintStream(new FastBufferedOutputStream(new FileOutputStream(file)));
        TextIO.storeDoubles(i, stream);
        stream.close();
    }

    public static void storeDoubles(DoubleIterator i, CharSequence filename) throws IOException {
        TextIO.storeDoubles(i, new File(filename.toString()));
    }

    public static long loadDoubles(BufferedReader reader, double[][] array2, long offset, long length) throws IOException {
        DoubleBigArrays.ensureOffsetLength(array2, offset, length);
        long c = 0L;
        try {
            for (int i = BigArrays.segment(offset); i < BigArrays.segment(offset + length + 0x7FFFFFFL); ++i) {
                double[] t = array2[i];
                int l = (int)Math.min((long)t.length, offset + length - BigArrays.start(i));
                for (int d = (int)Math.max(0L, offset - BigArrays.start(i)); d < l; ++d) {
                    String s2 = reader.readLine();
                    if (s2 == null) {
                        return c;
                    }
                    t[d] = Double.parseDouble(s2.trim());
                    ++c;
                }
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        return c;
    }

    public static long loadDoubles(BufferedReader reader, double[][] array2) throws IOException {
        return TextIO.loadDoubles(reader, array2, 0L, DoubleBigArrays.length(array2));
    }

    public static long loadDoubles(File file, double[][] array2, long offset, long length) throws IOException {
        BufferedReader reader = new BufferedReader(new FileReader(file));
        long result2 = TextIO.loadDoubles(reader, array2, offset, length);
        reader.close();
        return result2;
    }

    public static long loadDoubles(CharSequence filename, double[][] array2, long offset, long length) throws IOException {
        return TextIO.loadDoubles(new File(filename.toString()), array2, offset, length);
    }

    public static long loadDoubles(File file, double[][] array2) throws IOException {
        return TextIO.loadDoubles(file, array2, 0L, DoubleBigArrays.length(array2));
    }

    public static long loadDoubles(CharSequence filename, double[][] array2) throws IOException {
        return TextIO.loadDoubles(filename, array2, 0L, DoubleBigArrays.length(array2));
    }

    public static void storeDoubles(double[][] array2, long offset, long length, PrintStream stream) {
        DoubleBigArrays.ensureOffsetLength(array2, offset, length);
        for (int i = BigArrays.segment(offset); i < BigArrays.segment(offset + length + 0x7FFFFFFL); ++i) {
            double[] t = array2[i];
            int l = (int)Math.min((long)t.length, offset + length - BigArrays.start(i));
            for (int d = (int)Math.max(0L, offset - BigArrays.start(i)); d < l; ++d) {
                stream.println(t[d]);
            }
        }
    }

    public static void storeDoubles(double[][] array2, PrintStream stream) {
        TextIO.storeDoubles(array2, 0L, DoubleBigArrays.length(array2), stream);
    }

    public static void storeDoubles(double[][] array2, long offset, long length, File file) throws IOException {
        PrintStream stream = new PrintStream(new FastBufferedOutputStream(new FileOutputStream(file)));
        TextIO.storeDoubles(array2, offset, length, stream);
        stream.close();
    }

    public static void storeDoubles(double[][] array2, long offset, long length, CharSequence filename) throws IOException {
        TextIO.storeDoubles(array2, offset, length, new File(filename.toString()));
    }

    public static void storeDoubles(double[][] array2, File file) throws IOException {
        TextIO.storeDoubles(array2, 0L, DoubleBigArrays.length(array2), file);
    }

    public static void storeDoubles(double[][] array2, CharSequence filename) throws IOException {
        TextIO.storeDoubles(array2, 0L, DoubleBigArrays.length(array2), filename);
    }

    public static DoubleIterator asDoubleIterator(BufferedReader reader) {
        return new DoubleReaderWrapper(reader);
    }

    public static DoubleIterator asDoubleIterator(File file) throws IOException {
        return new DoubleReaderWrapper(new BufferedReader(new FileReader(file)));
    }

    public static DoubleIterator asDoubleIterator(CharSequence filename) throws IOException {
        return TextIO.asDoubleIterator(new File(filename.toString()));
    }

    public static DoubleIterable asDoubleIterable(File file) {
        return () -> {
            try {
                return TextIO.asDoubleIterator(file);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        };
    }

    public static DoubleIterable asDoubleIterable(CharSequence filename) {
        return () -> {
            try {
                return TextIO.asDoubleIterator(filename);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        };
    }

    public static int loadBooleans(BufferedReader reader, boolean[] array2, int offset, int length) throws IOException {
        BooleanArrays.ensureOffsetLength(array2, offset, length);
        int i = 0;
        try {
            String s2;
            for (i = 0; i < length && (s2 = reader.readLine()) != null; ++i) {
                array2[i + offset] = Boolean.parseBoolean(s2.trim());
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        return i;
    }

    public static int loadBooleans(BufferedReader reader, boolean[] array2) throws IOException {
        return TextIO.loadBooleans(reader, array2, 0, array2.length);
    }

    public static int loadBooleans(File file, boolean[] array2, int offset, int length) throws IOException {
        BufferedReader reader = new BufferedReader(new FileReader(file));
        int result2 = TextIO.loadBooleans(reader, array2, offset, length);
        reader.close();
        return result2;
    }

    public static int loadBooleans(CharSequence filename, boolean[] array2, int offset, int length) throws IOException {
        return TextIO.loadBooleans(new File(filename.toString()), array2, offset, length);
    }

    public static int loadBooleans(File file, boolean[] array2) throws IOException {
        return TextIO.loadBooleans(file, array2, 0, array2.length);
    }

    public static int loadBooleans(CharSequence filename, boolean[] array2) throws IOException {
        return TextIO.loadBooleans(filename, array2, 0, array2.length);
    }

    public static void storeBooleans(boolean[] array2, int offset, int length, PrintStream stream) {
        BooleanArrays.ensureOffsetLength(array2, offset, length);
        for (int i = 0; i < length; ++i) {
            stream.println(array2[offset + i]);
        }
    }

    public static void storeBooleans(boolean[] array2, PrintStream stream) {
        TextIO.storeBooleans(array2, 0, array2.length, stream);
    }

    public static void storeBooleans(boolean[] array2, int offset, int length, File file) throws IOException {
        PrintStream stream = new PrintStream(new FastBufferedOutputStream(new FileOutputStream(file)));
        TextIO.storeBooleans(array2, offset, length, stream);
        stream.close();
    }

    public static void storeBooleans(boolean[] array2, int offset, int length, CharSequence filename) throws IOException {
        TextIO.storeBooleans(array2, offset, length, new File(filename.toString()));
    }

    public static void storeBooleans(boolean[] array2, File file) throws IOException {
        TextIO.storeBooleans(array2, 0, array2.length, file);
    }

    public static void storeBooleans(boolean[] array2, CharSequence filename) throws IOException {
        TextIO.storeBooleans(array2, 0, array2.length, filename);
    }

    public static void storeBooleans(BooleanIterator i, PrintStream stream) {
        while (i.hasNext()) {
            stream.println(i.nextBoolean());
        }
    }

    public static void storeBooleans(BooleanIterator i, File file) throws IOException {
        PrintStream stream = new PrintStream(new FastBufferedOutputStream(new FileOutputStream(file)));
        TextIO.storeBooleans(i, stream);
        stream.close();
    }

    public static void storeBooleans(BooleanIterator i, CharSequence filename) throws IOException {
        TextIO.storeBooleans(i, new File(filename.toString()));
    }

    public static long loadBooleans(BufferedReader reader, boolean[][] array2, long offset, long length) throws IOException {
        BooleanBigArrays.ensureOffsetLength(array2, offset, length);
        long c = 0L;
        try {
            for (int i = BigArrays.segment(offset); i < BigArrays.segment(offset + length + 0x7FFFFFFL); ++i) {
                boolean[] t = array2[i];
                int l = (int)Math.min((long)t.length, offset + length - BigArrays.start(i));
                for (int d = (int)Math.max(0L, offset - BigArrays.start(i)); d < l; ++d) {
                    String s2 = reader.readLine();
                    if (s2 == null) {
                        return c;
                    }
                    t[d] = Boolean.parseBoolean(s2.trim());
                    ++c;
                }
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        return c;
    }

    public static long loadBooleans(BufferedReader reader, boolean[][] array2) throws IOException {
        return TextIO.loadBooleans(reader, array2, 0L, BooleanBigArrays.length(array2));
    }

    public static long loadBooleans(File file, boolean[][] array2, long offset, long length) throws IOException {
        BufferedReader reader = new BufferedReader(new FileReader(file));
        long result2 = TextIO.loadBooleans(reader, array2, offset, length);
        reader.close();
        return result2;
    }

    public static long loadBooleans(CharSequence filename, boolean[][] array2, long offset, long length) throws IOException {
        return TextIO.loadBooleans(new File(filename.toString()), array2, offset, length);
    }

    public static long loadBooleans(File file, boolean[][] array2) throws IOException {
        return TextIO.loadBooleans(file, array2, 0L, BooleanBigArrays.length(array2));
    }

    public static long loadBooleans(CharSequence filename, boolean[][] array2) throws IOException {
        return TextIO.loadBooleans(filename, array2, 0L, BooleanBigArrays.length(array2));
    }

    public static void storeBooleans(boolean[][] array2, long offset, long length, PrintStream stream) {
        BooleanBigArrays.ensureOffsetLength(array2, offset, length);
        for (int i = BigArrays.segment(offset); i < BigArrays.segment(offset + length + 0x7FFFFFFL); ++i) {
            boolean[] t = array2[i];
            int l = (int)Math.min((long)t.length, offset + length - BigArrays.start(i));
            for (int d = (int)Math.max(0L, offset - BigArrays.start(i)); d < l; ++d) {
                stream.println(t[d]);
            }
        }
    }

    public static void storeBooleans(boolean[][] array2, PrintStream stream) {
        TextIO.storeBooleans(array2, 0L, BooleanBigArrays.length(array2), stream);
    }

    public static void storeBooleans(boolean[][] array2, long offset, long length, File file) throws IOException {
        PrintStream stream = new PrintStream(new FastBufferedOutputStream(new FileOutputStream(file)));
        TextIO.storeBooleans(array2, offset, length, stream);
        stream.close();
    }

    public static void storeBooleans(boolean[][] array2, long offset, long length, CharSequence filename) throws IOException {
        TextIO.storeBooleans(array2, offset, length, new File(filename.toString()));
    }

    public static void storeBooleans(boolean[][] array2, File file) throws IOException {
        TextIO.storeBooleans(array2, 0L, BooleanBigArrays.length(array2), file);
    }

    public static void storeBooleans(boolean[][] array2, CharSequence filename) throws IOException {
        TextIO.storeBooleans(array2, 0L, BooleanBigArrays.length(array2), filename);
    }

    public static BooleanIterator asBooleanIterator(BufferedReader reader) {
        return new BooleanReaderWrapper(reader);
    }

    public static BooleanIterator asBooleanIterator(File file) throws IOException {
        return new BooleanReaderWrapper(new BufferedReader(new FileReader(file)));
    }

    public static BooleanIterator asBooleanIterator(CharSequence filename) throws IOException {
        return TextIO.asBooleanIterator(new File(filename.toString()));
    }

    public static BooleanIterable asBooleanIterable(File file) {
        return () -> {
            try {
                return TextIO.asBooleanIterator(file);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        };
    }

    public static BooleanIterable asBooleanIterable(CharSequence filename) {
        return () -> {
            try {
                return TextIO.asBooleanIterator(filename);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        };
    }

    public static int loadBytes(BufferedReader reader, byte[] array2, int offset, int length) throws IOException {
        ByteArrays.ensureOffsetLength(array2, offset, length);
        int i = 0;
        try {
            String s2;
            for (i = 0; i < length && (s2 = reader.readLine()) != null; ++i) {
                array2[i + offset] = Byte.parseByte(s2.trim());
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        return i;
    }

    public static int loadBytes(BufferedReader reader, byte[] array2) throws IOException {
        return TextIO.loadBytes(reader, array2, 0, array2.length);
    }

    public static int loadBytes(File file, byte[] array2, int offset, int length) throws IOException {
        BufferedReader reader = new BufferedReader(new FileReader(file));
        int result2 = TextIO.loadBytes(reader, array2, offset, length);
        reader.close();
        return result2;
    }

    public static int loadBytes(CharSequence filename, byte[] array2, int offset, int length) throws IOException {
        return TextIO.loadBytes(new File(filename.toString()), array2, offset, length);
    }

    public static int loadBytes(File file, byte[] array2) throws IOException {
        return TextIO.loadBytes(file, array2, 0, array2.length);
    }

    public static int loadBytes(CharSequence filename, byte[] array2) throws IOException {
        return TextIO.loadBytes(filename, array2, 0, array2.length);
    }

    public static void storeBytes(byte[] array2, int offset, int length, PrintStream stream) {
        ByteArrays.ensureOffsetLength(array2, offset, length);
        for (int i = 0; i < length; ++i) {
            stream.println(array2[offset + i]);
        }
    }

    public static void storeBytes(byte[] array2, PrintStream stream) {
        TextIO.storeBytes(array2, 0, array2.length, stream);
    }

    public static void storeBytes(byte[] array2, int offset, int length, File file) throws IOException {
        PrintStream stream = new PrintStream(new FastBufferedOutputStream(new FileOutputStream(file)));
        TextIO.storeBytes(array2, offset, length, stream);
        stream.close();
    }

    public static void storeBytes(byte[] array2, int offset, int length, CharSequence filename) throws IOException {
        TextIO.storeBytes(array2, offset, length, new File(filename.toString()));
    }

    public static void storeBytes(byte[] array2, File file) throws IOException {
        TextIO.storeBytes(array2, 0, array2.length, file);
    }

    public static void storeBytes(byte[] array2, CharSequence filename) throws IOException {
        TextIO.storeBytes(array2, 0, array2.length, filename);
    }

    public static void storeBytes(ByteIterator i, PrintStream stream) {
        while (i.hasNext()) {
            stream.println(i.nextByte());
        }
    }

    public static void storeBytes(ByteIterator i, File file) throws IOException {
        PrintStream stream = new PrintStream(new FastBufferedOutputStream(new FileOutputStream(file)));
        TextIO.storeBytes(i, stream);
        stream.close();
    }

    public static void storeBytes(ByteIterator i, CharSequence filename) throws IOException {
        TextIO.storeBytes(i, new File(filename.toString()));
    }

    public static long loadBytes(BufferedReader reader, byte[][] array2, long offset, long length) throws IOException {
        ByteBigArrays.ensureOffsetLength(array2, offset, length);
        long c = 0L;
        try {
            for (int i = BigArrays.segment(offset); i < BigArrays.segment(offset + length + 0x7FFFFFFL); ++i) {
                byte[] t = array2[i];
                int l = (int)Math.min((long)t.length, offset + length - BigArrays.start(i));
                for (int d = (int)Math.max(0L, offset - BigArrays.start(i)); d < l; ++d) {
                    String s2 = reader.readLine();
                    if (s2 == null) {
                        return c;
                    }
                    t[d] = Byte.parseByte(s2.trim());
                    ++c;
                }
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        return c;
    }

    public static long loadBytes(BufferedReader reader, byte[][] array2) throws IOException {
        return TextIO.loadBytes(reader, array2, 0L, ByteBigArrays.length(array2));
    }

    public static long loadBytes(File file, byte[][] array2, long offset, long length) throws IOException {
        BufferedReader reader = new BufferedReader(new FileReader(file));
        long result2 = TextIO.loadBytes(reader, array2, offset, length);
        reader.close();
        return result2;
    }

    public static long loadBytes(CharSequence filename, byte[][] array2, long offset, long length) throws IOException {
        return TextIO.loadBytes(new File(filename.toString()), array2, offset, length);
    }

    public static long loadBytes(File file, byte[][] array2) throws IOException {
        return TextIO.loadBytes(file, array2, 0L, ByteBigArrays.length(array2));
    }

    public static long loadBytes(CharSequence filename, byte[][] array2) throws IOException {
        return TextIO.loadBytes(filename, array2, 0L, ByteBigArrays.length(array2));
    }

    public static void storeBytes(byte[][] array2, long offset, long length, PrintStream stream) {
        ByteBigArrays.ensureOffsetLength(array2, offset, length);
        for (int i = BigArrays.segment(offset); i < BigArrays.segment(offset + length + 0x7FFFFFFL); ++i) {
            byte[] t = array2[i];
            int l = (int)Math.min((long)t.length, offset + length - BigArrays.start(i));
            for (int d = (int)Math.max(0L, offset - BigArrays.start(i)); d < l; ++d) {
                stream.println(t[d]);
            }
        }
    }

    public static void storeBytes(byte[][] array2, PrintStream stream) {
        TextIO.storeBytes(array2, 0L, ByteBigArrays.length(array2), stream);
    }

    public static void storeBytes(byte[][] array2, long offset, long length, File file) throws IOException {
        PrintStream stream = new PrintStream(new FastBufferedOutputStream(new FileOutputStream(file)));
        TextIO.storeBytes(array2, offset, length, stream);
        stream.close();
    }

    public static void storeBytes(byte[][] array2, long offset, long length, CharSequence filename) throws IOException {
        TextIO.storeBytes(array2, offset, length, new File(filename.toString()));
    }

    public static void storeBytes(byte[][] array2, File file) throws IOException {
        TextIO.storeBytes(array2, 0L, ByteBigArrays.length(array2), file);
    }

    public static void storeBytes(byte[][] array2, CharSequence filename) throws IOException {
        TextIO.storeBytes(array2, 0L, ByteBigArrays.length(array2), filename);
    }

    public static ByteIterator asByteIterator(BufferedReader reader) {
        return new ByteReaderWrapper(reader);
    }

    public static ByteIterator asByteIterator(File file) throws IOException {
        return new ByteReaderWrapper(new BufferedReader(new FileReader(file)));
    }

    public static ByteIterator asByteIterator(CharSequence filename) throws IOException {
        return TextIO.asByteIterator(new File(filename.toString()));
    }

    public static ByteIterable asByteIterable(File file) {
        return () -> {
            try {
                return TextIO.asByteIterator(file);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        };
    }

    public static ByteIterable asByteIterable(CharSequence filename) {
        return () -> {
            try {
                return TextIO.asByteIterator(filename);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        };
    }

    public static int loadShorts(BufferedReader reader, short[] array2, int offset, int length) throws IOException {
        ShortArrays.ensureOffsetLength(array2, offset, length);
        int i = 0;
        try {
            String s2;
            for (i = 0; i < length && (s2 = reader.readLine()) != null; ++i) {
                array2[i + offset] = Short.parseShort(s2.trim());
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        return i;
    }

    public static int loadShorts(BufferedReader reader, short[] array2) throws IOException {
        return TextIO.loadShorts(reader, array2, 0, array2.length);
    }

    public static int loadShorts(File file, short[] array2, int offset, int length) throws IOException {
        BufferedReader reader = new BufferedReader(new FileReader(file));
        int result2 = TextIO.loadShorts(reader, array2, offset, length);
        reader.close();
        return result2;
    }

    public static int loadShorts(CharSequence filename, short[] array2, int offset, int length) throws IOException {
        return TextIO.loadShorts(new File(filename.toString()), array2, offset, length);
    }

    public static int loadShorts(File file, short[] array2) throws IOException {
        return TextIO.loadShorts(file, array2, 0, array2.length);
    }

    public static int loadShorts(CharSequence filename, short[] array2) throws IOException {
        return TextIO.loadShorts(filename, array2, 0, array2.length);
    }

    public static void storeShorts(short[] array2, int offset, int length, PrintStream stream) {
        ShortArrays.ensureOffsetLength(array2, offset, length);
        for (int i = 0; i < length; ++i) {
            stream.println(array2[offset + i]);
        }
    }

    public static void storeShorts(short[] array2, PrintStream stream) {
        TextIO.storeShorts(array2, 0, array2.length, stream);
    }

    public static void storeShorts(short[] array2, int offset, int length, File file) throws IOException {
        PrintStream stream = new PrintStream(new FastBufferedOutputStream(new FileOutputStream(file)));
        TextIO.storeShorts(array2, offset, length, stream);
        stream.close();
    }

    public static void storeShorts(short[] array2, int offset, int length, CharSequence filename) throws IOException {
        TextIO.storeShorts(array2, offset, length, new File(filename.toString()));
    }

    public static void storeShorts(short[] array2, File file) throws IOException {
        TextIO.storeShorts(array2, 0, array2.length, file);
    }

    public static void storeShorts(short[] array2, CharSequence filename) throws IOException {
        TextIO.storeShorts(array2, 0, array2.length, filename);
    }

    public static void storeShorts(ShortIterator i, PrintStream stream) {
        while (i.hasNext()) {
            stream.println(i.nextShort());
        }
    }

    public static void storeShorts(ShortIterator i, File file) throws IOException {
        PrintStream stream = new PrintStream(new FastBufferedOutputStream(new FileOutputStream(file)));
        TextIO.storeShorts(i, stream);
        stream.close();
    }

    public static void storeShorts(ShortIterator i, CharSequence filename) throws IOException {
        TextIO.storeShorts(i, new File(filename.toString()));
    }

    public static long loadShorts(BufferedReader reader, short[][] array2, long offset, long length) throws IOException {
        ShortBigArrays.ensureOffsetLength(array2, offset, length);
        long c = 0L;
        try {
            for (int i = BigArrays.segment(offset); i < BigArrays.segment(offset + length + 0x7FFFFFFL); ++i) {
                short[] t = array2[i];
                int l = (int)Math.min((long)t.length, offset + length - BigArrays.start(i));
                for (int d = (int)Math.max(0L, offset - BigArrays.start(i)); d < l; ++d) {
                    String s2 = reader.readLine();
                    if (s2 == null) {
                        return c;
                    }
                    t[d] = Short.parseShort(s2.trim());
                    ++c;
                }
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        return c;
    }

    public static long loadShorts(BufferedReader reader, short[][] array2) throws IOException {
        return TextIO.loadShorts(reader, array2, 0L, ShortBigArrays.length(array2));
    }

    public static long loadShorts(File file, short[][] array2, long offset, long length) throws IOException {
        BufferedReader reader = new BufferedReader(new FileReader(file));
        long result2 = TextIO.loadShorts(reader, array2, offset, length);
        reader.close();
        return result2;
    }

    public static long loadShorts(CharSequence filename, short[][] array2, long offset, long length) throws IOException {
        return TextIO.loadShorts(new File(filename.toString()), array2, offset, length);
    }

    public static long loadShorts(File file, short[][] array2) throws IOException {
        return TextIO.loadShorts(file, array2, 0L, ShortBigArrays.length(array2));
    }

    public static long loadShorts(CharSequence filename, short[][] array2) throws IOException {
        return TextIO.loadShorts(filename, array2, 0L, ShortBigArrays.length(array2));
    }

    public static void storeShorts(short[][] array2, long offset, long length, PrintStream stream) {
        ShortBigArrays.ensureOffsetLength(array2, offset, length);
        for (int i = BigArrays.segment(offset); i < BigArrays.segment(offset + length + 0x7FFFFFFL); ++i) {
            short[] t = array2[i];
            int l = (int)Math.min((long)t.length, offset + length - BigArrays.start(i));
            for (int d = (int)Math.max(0L, offset - BigArrays.start(i)); d < l; ++d) {
                stream.println(t[d]);
            }
        }
    }

    public static void storeShorts(short[][] array2, PrintStream stream) {
        TextIO.storeShorts(array2, 0L, ShortBigArrays.length(array2), stream);
    }

    public static void storeShorts(short[][] array2, long offset, long length, File file) throws IOException {
        PrintStream stream = new PrintStream(new FastBufferedOutputStream(new FileOutputStream(file)));
        TextIO.storeShorts(array2, offset, length, stream);
        stream.close();
    }

    public static void storeShorts(short[][] array2, long offset, long length, CharSequence filename) throws IOException {
        TextIO.storeShorts(array2, offset, length, new File(filename.toString()));
    }

    public static void storeShorts(short[][] array2, File file) throws IOException {
        TextIO.storeShorts(array2, 0L, ShortBigArrays.length(array2), file);
    }

    public static void storeShorts(short[][] array2, CharSequence filename) throws IOException {
        TextIO.storeShorts(array2, 0L, ShortBigArrays.length(array2), filename);
    }

    public static ShortIterator asShortIterator(BufferedReader reader) {
        return new ShortReaderWrapper(reader);
    }

    public static ShortIterator asShortIterator(File file) throws IOException {
        return new ShortReaderWrapper(new BufferedReader(new FileReader(file)));
    }

    public static ShortIterator asShortIterator(CharSequence filename) throws IOException {
        return TextIO.asShortIterator(new File(filename.toString()));
    }

    public static ShortIterable asShortIterable(File file) {
        return () -> {
            try {
                return TextIO.asShortIterator(file);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        };
    }

    public static ShortIterable asShortIterable(CharSequence filename) {
        return () -> {
            try {
                return TextIO.asShortIterator(filename);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        };
    }

    public static int loadFloats(BufferedReader reader, float[] array2, int offset, int length) throws IOException {
        FloatArrays.ensureOffsetLength(array2, offset, length);
        int i = 0;
        try {
            String s2;
            for (i = 0; i < length && (s2 = reader.readLine()) != null; ++i) {
                array2[i + offset] = Float.parseFloat(s2.trim());
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        return i;
    }

    public static int loadFloats(BufferedReader reader, float[] array2) throws IOException {
        return TextIO.loadFloats(reader, array2, 0, array2.length);
    }

    public static int loadFloats(File file, float[] array2, int offset, int length) throws IOException {
        BufferedReader reader = new BufferedReader(new FileReader(file));
        int result2 = TextIO.loadFloats(reader, array2, offset, length);
        reader.close();
        return result2;
    }

    public static int loadFloats(CharSequence filename, float[] array2, int offset, int length) throws IOException {
        return TextIO.loadFloats(new File(filename.toString()), array2, offset, length);
    }

    public static int loadFloats(File file, float[] array2) throws IOException {
        return TextIO.loadFloats(file, array2, 0, array2.length);
    }

    public static int loadFloats(CharSequence filename, float[] array2) throws IOException {
        return TextIO.loadFloats(filename, array2, 0, array2.length);
    }

    public static void storeFloats(float[] array2, int offset, int length, PrintStream stream) {
        FloatArrays.ensureOffsetLength(array2, offset, length);
        for (int i = 0; i < length; ++i) {
            stream.println(array2[offset + i]);
        }
    }

    public static void storeFloats(float[] array2, PrintStream stream) {
        TextIO.storeFloats(array2, 0, array2.length, stream);
    }

    public static void storeFloats(float[] array2, int offset, int length, File file) throws IOException {
        PrintStream stream = new PrintStream(new FastBufferedOutputStream(new FileOutputStream(file)));
        TextIO.storeFloats(array2, offset, length, stream);
        stream.close();
    }

    public static void storeFloats(float[] array2, int offset, int length, CharSequence filename) throws IOException {
        TextIO.storeFloats(array2, offset, length, new File(filename.toString()));
    }

    public static void storeFloats(float[] array2, File file) throws IOException {
        TextIO.storeFloats(array2, 0, array2.length, file);
    }

    public static void storeFloats(float[] array2, CharSequence filename) throws IOException {
        TextIO.storeFloats(array2, 0, array2.length, filename);
    }

    public static void storeFloats(FloatIterator i, PrintStream stream) {
        while (i.hasNext()) {
            stream.println(i.nextFloat());
        }
    }

    public static void storeFloats(FloatIterator i, File file) throws IOException {
        PrintStream stream = new PrintStream(new FastBufferedOutputStream(new FileOutputStream(file)));
        TextIO.storeFloats(i, stream);
        stream.close();
    }

    public static void storeFloats(FloatIterator i, CharSequence filename) throws IOException {
        TextIO.storeFloats(i, new File(filename.toString()));
    }

    public static long loadFloats(BufferedReader reader, float[][] array2, long offset, long length) throws IOException {
        FloatBigArrays.ensureOffsetLength(array2, offset, length);
        long c = 0L;
        try {
            for (int i = BigArrays.segment(offset); i < BigArrays.segment(offset + length + 0x7FFFFFFL); ++i) {
                float[] t = array2[i];
                int l = (int)Math.min((long)t.length, offset + length - BigArrays.start(i));
                for (int d = (int)Math.max(0L, offset - BigArrays.start(i)); d < l; ++d) {
                    String s2 = reader.readLine();
                    if (s2 == null) {
                        return c;
                    }
                    t[d] = Float.parseFloat(s2.trim());
                    ++c;
                }
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        return c;
    }

    public static long loadFloats(BufferedReader reader, float[][] array2) throws IOException {
        return TextIO.loadFloats(reader, array2, 0L, FloatBigArrays.length(array2));
    }

    public static long loadFloats(File file, float[][] array2, long offset, long length) throws IOException {
        BufferedReader reader = new BufferedReader(new FileReader(file));
        long result2 = TextIO.loadFloats(reader, array2, offset, length);
        reader.close();
        return result2;
    }

    public static long loadFloats(CharSequence filename, float[][] array2, long offset, long length) throws IOException {
        return TextIO.loadFloats(new File(filename.toString()), array2, offset, length);
    }

    public static long loadFloats(File file, float[][] array2) throws IOException {
        return TextIO.loadFloats(file, array2, 0L, FloatBigArrays.length(array2));
    }

    public static long loadFloats(CharSequence filename, float[][] array2) throws IOException {
        return TextIO.loadFloats(filename, array2, 0L, FloatBigArrays.length(array2));
    }

    public static void storeFloats(float[][] array2, long offset, long length, PrintStream stream) {
        FloatBigArrays.ensureOffsetLength(array2, offset, length);
        for (int i = BigArrays.segment(offset); i < BigArrays.segment(offset + length + 0x7FFFFFFL); ++i) {
            float[] t = array2[i];
            int l = (int)Math.min((long)t.length, offset + length - BigArrays.start(i));
            for (int d = (int)Math.max(0L, offset - BigArrays.start(i)); d < l; ++d) {
                stream.println(t[d]);
            }
        }
    }

    public static void storeFloats(float[][] array2, PrintStream stream) {
        TextIO.storeFloats(array2, 0L, FloatBigArrays.length(array2), stream);
    }

    public static void storeFloats(float[][] array2, long offset, long length, File file) throws IOException {
        PrintStream stream = new PrintStream(new FastBufferedOutputStream(new FileOutputStream(file)));
        TextIO.storeFloats(array2, offset, length, stream);
        stream.close();
    }

    public static void storeFloats(float[][] array2, long offset, long length, CharSequence filename) throws IOException {
        TextIO.storeFloats(array2, offset, length, new File(filename.toString()));
    }

    public static void storeFloats(float[][] array2, File file) throws IOException {
        TextIO.storeFloats(array2, 0L, FloatBigArrays.length(array2), file);
    }

    public static void storeFloats(float[][] array2, CharSequence filename) throws IOException {
        TextIO.storeFloats(array2, 0L, FloatBigArrays.length(array2), filename);
    }

    public static FloatIterator asFloatIterator(BufferedReader reader) {
        return new FloatReaderWrapper(reader);
    }

    public static FloatIterator asFloatIterator(File file) throws IOException {
        return new FloatReaderWrapper(new BufferedReader(new FileReader(file)));
    }

    public static FloatIterator asFloatIterator(CharSequence filename) throws IOException {
        return TextIO.asFloatIterator(new File(filename.toString()));
    }

    public static FloatIterable asFloatIterable(File file) {
        return () -> {
            try {
                return TextIO.asFloatIterator(file);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        };
    }

    public static FloatIterable asFloatIterable(CharSequence filename) {
        return () -> {
            try {
                return TextIO.asFloatIterator(filename);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        };
    }

    private static final class FloatReaderWrapper
    implements FloatIterator {
        private final BufferedReader reader;
        private boolean toAdvance = true;
        private String s;
        private float next;

        public FloatReaderWrapper(BufferedReader reader) {
            this.reader = reader;
        }

        @Override
        public boolean hasNext() {
            if (!this.toAdvance) {
                return this.s != null;
            }
            this.toAdvance = false;
            try {
                this.s = this.reader.readLine();
            }
            catch (EOFException eOFException) {
            }
            catch (IOException rethrow2) {
                throw new RuntimeException(rethrow2);
            }
            if (this.s == null) {
                return false;
            }
            this.next = Float.parseFloat(this.s.trim());
            return true;
        }

        @Override
        public float nextFloat() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.toAdvance = true;
            return this.next;
        }
    }

    private static final class ShortReaderWrapper
    implements ShortIterator {
        private final BufferedReader reader;
        private boolean toAdvance = true;
        private String s;
        private short next;

        public ShortReaderWrapper(BufferedReader reader) {
            this.reader = reader;
        }

        @Override
        public boolean hasNext() {
            if (!this.toAdvance) {
                return this.s != null;
            }
            this.toAdvance = false;
            try {
                this.s = this.reader.readLine();
            }
            catch (EOFException eOFException) {
            }
            catch (IOException rethrow2) {
                throw new RuntimeException(rethrow2);
            }
            if (this.s == null) {
                return false;
            }
            this.next = Short.parseShort(this.s.trim());
            return true;
        }

        @Override
        public short nextShort() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.toAdvance = true;
            return this.next;
        }
    }

    private static final class ByteReaderWrapper
    implements ByteIterator {
        private final BufferedReader reader;
        private boolean toAdvance = true;
        private String s;
        private byte next;

        public ByteReaderWrapper(BufferedReader reader) {
            this.reader = reader;
        }

        @Override
        public boolean hasNext() {
            if (!this.toAdvance) {
                return this.s != null;
            }
            this.toAdvance = false;
            try {
                this.s = this.reader.readLine();
            }
            catch (EOFException eOFException) {
            }
            catch (IOException rethrow2) {
                throw new RuntimeException(rethrow2);
            }
            if (this.s == null) {
                return false;
            }
            this.next = Byte.parseByte(this.s.trim());
            return true;
        }

        @Override
        public byte nextByte() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.toAdvance = true;
            return this.next;
        }
    }

    private static final class BooleanReaderWrapper
    implements BooleanIterator {
        private final BufferedReader reader;
        private boolean toAdvance = true;
        private String s;
        private boolean next;

        public BooleanReaderWrapper(BufferedReader reader) {
            this.reader = reader;
        }

        @Override
        public boolean hasNext() {
            if (!this.toAdvance) {
                return this.s != null;
            }
            this.toAdvance = false;
            try {
                this.s = this.reader.readLine();
            }
            catch (EOFException eOFException) {
            }
            catch (IOException rethrow2) {
                throw new RuntimeException(rethrow2);
            }
            if (this.s == null) {
                return false;
            }
            this.next = Boolean.parseBoolean(this.s.trim());
            return true;
        }

        @Override
        public boolean nextBoolean() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.toAdvance = true;
            return this.next;
        }
    }

    private static final class DoubleReaderWrapper
    implements DoubleIterator {
        private final BufferedReader reader;
        private boolean toAdvance = true;
        private String s;
        private double next;

        public DoubleReaderWrapper(BufferedReader reader) {
            this.reader = reader;
        }

        @Override
        public boolean hasNext() {
            if (!this.toAdvance) {
                return this.s != null;
            }
            this.toAdvance = false;
            try {
                this.s = this.reader.readLine();
            }
            catch (EOFException eOFException) {
            }
            catch (IOException rethrow2) {
                throw new RuntimeException(rethrow2);
            }
            if (this.s == null) {
                return false;
            }
            this.next = Double.parseDouble(this.s.trim());
            return true;
        }

        @Override
        public double nextDouble() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.toAdvance = true;
            return this.next;
        }
    }

    private static final class LongReaderWrapper
    implements LongIterator {
        private final BufferedReader reader;
        private boolean toAdvance = true;
        private String s;
        private long next;

        public LongReaderWrapper(BufferedReader reader) {
            this.reader = reader;
        }

        @Override
        public boolean hasNext() {
            if (!this.toAdvance) {
                return this.s != null;
            }
            this.toAdvance = false;
            try {
                this.s = this.reader.readLine();
            }
            catch (EOFException eOFException) {
            }
            catch (IOException rethrow2) {
                throw new RuntimeException(rethrow2);
            }
            if (this.s == null) {
                return false;
            }
            this.next = Long.parseLong(this.s.trim());
            return true;
        }

        @Override
        public long nextLong() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.toAdvance = true;
            return this.next;
        }
    }

    private static final class IntReaderWrapper
    implements IntIterator {
        private final BufferedReader reader;
        private boolean toAdvance = true;
        private String s;
        private int next;

        public IntReaderWrapper(BufferedReader reader) {
            this.reader = reader;
        }

        @Override
        public boolean hasNext() {
            if (!this.toAdvance) {
                return this.s != null;
            }
            this.toAdvance = false;
            try {
                this.s = this.reader.readLine();
            }
            catch (EOFException eOFException) {
            }
            catch (IOException rethrow2) {
                throw new RuntimeException(rethrow2);
            }
            if (this.s == null) {
                return false;
            }
            this.next = Integer.parseInt(this.s.trim());
            return true;
        }

        @Override
        public int nextInt() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.toAdvance = true;
            return this.next;
        }
    }
}

