/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.longs;

import it.unimi.dsi.fastutil.BigArrays;
import it.unimi.dsi.fastutil.longs.AbstractLongBigList;
import it.unimi.dsi.fastutil.longs.LongBigArrays;
import it.unimi.dsi.fastutil.longs.LongBigList;
import it.unimi.dsi.fastutil.longs.LongBigListIterator;
import it.unimi.dsi.fastutil.longs.LongCollection;
import it.unimi.dsi.fastutil.longs.LongIterator;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.RandomAccess;

public class LongBigArrayBigList
extends AbstractLongBigList
implements RandomAccess,
Cloneable,
Serializable {
    private static final long serialVersionUID = -7046029254386353130L;
    public static final int DEFAULT_INITIAL_CAPACITY = 16;
    protected transient long[][] a;
    protected long size;
    private static final boolean ASSERTS = false;

    protected LongBigArrayBigList(long[][] a, boolean dummy) {
        this.a = a;
    }

    public LongBigArrayBigList(long capacity) {
        if (capacity < 0L) {
            throw new IllegalArgumentException("Initial capacity (" + capacity + ") is negative");
        }
        this.a = LongBigArrays.newBigArray(capacity);
    }

    public LongBigArrayBigList() {
        this(16L);
    }

    public LongBigArrayBigList(LongCollection c) {
        this(c.size());
        LongIterator i = c.iterator();
        while (i.hasNext()) {
            this.add(i.nextLong());
        }
    }

    public LongBigArrayBigList(LongBigList l) {
        this(l.size64());
        this.size = l.size64();
        l.getElements(0L, this.a, 0L, this.size);
    }

    public LongBigArrayBigList(long[][] a) {
        this(a, 0L, LongBigArrays.length(a));
    }

    public LongBigArrayBigList(long[][] a, long offset, long length) {
        this(length);
        LongBigArrays.copy(a, offset, this.a, 0L, length);
        this.size = length;
    }

    public LongBigArrayBigList(Iterator<? extends Long> i) {
        this();
        while (i.hasNext()) {
            this.add((long)i.next());
        }
    }

    public LongBigArrayBigList(LongIterator i) {
        this();
        while (i.hasNext()) {
            this.add(i.nextLong());
        }
    }

    public long[][] elements() {
        return this.a;
    }

    public static LongBigArrayBigList wrap(long[][] a, long length) {
        if (length > LongBigArrays.length(a)) {
            throw new IllegalArgumentException("The specified length (" + length + ") is greater than the array size (" + LongBigArrays.length(a) + ")");
        }
        LongBigArrayBigList l = new LongBigArrayBigList(a, false);
        l.size = length;
        return l;
    }

    public static LongBigArrayBigList wrap(long[][] a) {
        return LongBigArrayBigList.wrap(a, LongBigArrays.length(a));
    }

    public void ensureCapacity(long capacity) {
        this.a = LongBigArrays.ensureCapacity(this.a, capacity, this.size);
    }

    private void grow(long capacity) {
        this.a = LongBigArrays.grow(this.a, capacity, this.size);
    }

    @Override
    public void add(long index2, long k) {
        this.ensureIndex(index2);
        this.grow(this.size + 1L);
        if (index2 != this.size) {
            LongBigArrays.copy(this.a, index2, this.a, index2 + 1L, this.size - index2);
        }
        LongBigArrays.set(this.a, index2, k);
        ++this.size;
    }

    @Override
    public boolean add(long k) {
        this.grow(this.size + 1L);
        LongBigArrays.set(this.a, this.size++, k);
        return true;
    }

    @Override
    public long getLong(long index2) {
        if (index2 >= this.size) {
            throw new IndexOutOfBoundsException("Index (" + index2 + ") is greater than or equal to list size (" + this.size + ")");
        }
        return LongBigArrays.get(this.a, index2);
    }

    @Override
    public long indexOf(long k) {
        for (long i = 0L; i < this.size; ++i) {
            if (k != LongBigArrays.get(this.a, i)) continue;
            return i;
        }
        return -1L;
    }

    @Override
    public long lastIndexOf(long k) {
        long i = this.size;
        while (i-- != 0L) {
            if (k != LongBigArrays.get(this.a, i)) continue;
            return i;
        }
        return -1L;
    }

    @Override
    public long removeLong(long index2) {
        if (index2 >= this.size) {
            throw new IndexOutOfBoundsException("Index (" + index2 + ") is greater than or equal to list size (" + this.size + ")");
        }
        long old = LongBigArrays.get(this.a, index2);
        --this.size;
        if (index2 != this.size) {
            LongBigArrays.copy(this.a, index2 + 1L, this.a, index2, this.size - index2);
        }
        return old;
    }

    @Override
    public boolean rem(long k) {
        long index2 = this.indexOf(k);
        if (index2 == -1L) {
            return false;
        }
        this.removeLong(index2);
        return true;
    }

    @Override
    public long set(long index2, long k) {
        if (index2 >= this.size) {
            throw new IndexOutOfBoundsException("Index (" + index2 + ") is greater than or equal to list size (" + this.size + ")");
        }
        long old = LongBigArrays.get(this.a, index2);
        LongBigArrays.set(this.a, index2, k);
        return old;
    }

    @Override
    public boolean removeAll(LongCollection c) {
        long[] s2 = null;
        long[] d = null;
        int ss = -1;
        int sd = 0x8000000;
        int ds = -1;
        int dd = 0x8000000;
        for (long i = 0L; i < this.size; ++i) {
            if (sd == 0x8000000) {
                sd = 0;
                s2 = this.a[++ss];
            }
            if (!c.contains((long)s2[sd])) {
                if (dd == 0x8000000) {
                    d = this.a[++ds];
                    dd = 0;
                }
                d[dd++] = s2[sd];
            }
            ++sd;
        }
        long j = BigArrays.index(ds, dd);
        boolean modified = this.size != j;
        this.size = j;
        return modified;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        long[] s2 = null;
        long[] d = null;
        int ss = -1;
        int sd = 0x8000000;
        int ds = -1;
        int dd = 0x8000000;
        for (long i = 0L; i < this.size; ++i) {
            if (sd == 0x8000000) {
                sd = 0;
                s2 = this.a[++ss];
            }
            if (!c.contains((long)s2[sd])) {
                if (dd == 0x8000000) {
                    d = this.a[++ds];
                    dd = 0;
                }
                d[dd++] = s2[sd];
            }
            ++sd;
        }
        long j = BigArrays.index(ds, dd);
        boolean modified = this.size != j;
        this.size = j;
        return modified;
    }

    @Override
    public void clear() {
        this.size = 0L;
    }

    @Override
    public long size64() {
        return this.size;
    }

    @Override
    public void size(long size2) {
        if (size2 > LongBigArrays.length(this.a)) {
            this.ensureCapacity(size2);
        }
        if (size2 > this.size) {
            LongBigArrays.fill(this.a, this.size, size2, 0L);
        }
        this.size = size2;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0L;
    }

    public void trim() {
        this.trim(0L);
    }

    public void trim(long n) {
        long arrayLength = LongBigArrays.length(this.a);
        if (n >= arrayLength || this.size == arrayLength) {
            return;
        }
        this.a = LongBigArrays.trim(this.a, Math.max(n, this.size));
    }

    @Override
    public void getElements(long from2, long[][] a, long offset, long length) {
        LongBigArrays.copy(this.a, from2, a, offset, length);
    }

    @Override
    public void removeElements(long from2, long to2) {
        BigArrays.ensureFromTo(this.size, from2, to2);
        LongBigArrays.copy(this.a, to2, this.a, from2, this.size - to2);
        this.size -= to2 - from2;
    }

    @Override
    public void addElements(long index2, long[][] a, long offset, long length) {
        this.ensureIndex(index2);
        LongBigArrays.ensureOffsetLength(a, offset, length);
        this.grow(this.size + length);
        LongBigArrays.copy(this.a, index2, this.a, index2 + length, this.size - index2);
        LongBigArrays.copy(a, offset, this.a, index2, length);
        this.size += length;
    }

    @Override
    public LongBigListIterator listIterator(final long index2) {
        this.ensureIndex(index2);
        return new LongBigListIterator(){
            long pos;
            long last;
            {
                this.pos = index2;
                this.last = -1L;
            }

            @Override
            public boolean hasNext() {
                return this.pos < LongBigArrayBigList.this.size;
            }

            @Override
            public boolean hasPrevious() {
                return this.pos > 0L;
            }

            @Override
            public long nextLong() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.last = this.pos++;
                return LongBigArrays.get(LongBigArrayBigList.this.a, this.last);
            }

            @Override
            public long previousLong() {
                if (!this.hasPrevious()) {
                    throw new NoSuchElementException();
                }
                this.last = --this.pos;
                return LongBigArrays.get(LongBigArrayBigList.this.a, this.pos);
            }

            @Override
            public long nextIndex() {
                return this.pos;
            }

            @Override
            public long previousIndex() {
                return this.pos - 1L;
            }

            @Override
            public void add(long k) {
                LongBigArrayBigList.this.add(this.pos++, k);
                this.last = -1L;
            }

            @Override
            public void set(long k) {
                if (this.last == -1L) {
                    throw new IllegalStateException();
                }
                LongBigArrayBigList.this.set(this.last, k);
            }

            @Override
            public void remove() {
                if (this.last == -1L) {
                    throw new IllegalStateException();
                }
                LongBigArrayBigList.this.removeLong(this.last);
                if (this.last < this.pos) {
                    --this.pos;
                }
                this.last = -1L;
            }
        };
    }

    public LongBigArrayBigList clone() {
        LongBigArrayBigList c = new LongBigArrayBigList(this.size);
        LongBigArrays.copy(this.a, 0L, c.a, 0L, this.size);
        c.size = this.size;
        return c;
    }

    public boolean equals(LongBigArrayBigList l) {
        if (l == this) {
            return true;
        }
        long s2 = this.size64();
        if (s2 != l.size64()) {
            return false;
        }
        long[][] a1 = this.a;
        long[][] a2 = l.a;
        while (s2-- != 0L) {
            if (LongBigArrays.get(a1, s2) == LongBigArrays.get(a2, s2)) continue;
            return false;
        }
        return true;
    }

    @Override
    public int compareTo(LongBigArrayBigList l) {
        long s1 = this.size64();
        long s2 = l.size64();
        long[][] a1 = this.a;
        long[][] a2 = l.a;
        int i = 0;
        while ((long)i < s1 && (long)i < s2) {
            long e2;
            long e1 = LongBigArrays.get(a1, i);
            int r2 = Long.compare(e1, e2 = LongBigArrays.get(a2, i));
            if (r2 != 0) {
                return r2;
            }
            ++i;
        }
        return (long)i < s2 ? -1 : ((long)i < s1 ? 1 : 0);
    }

    private void writeObject(ObjectOutputStream s2) throws IOException {
        s2.defaultWriteObject();
        int i = 0;
        while ((long)i < this.size) {
            s2.writeLong(LongBigArrays.get(this.a, i));
            ++i;
        }
    }

    private void readObject(ObjectInputStream s2) throws IOException, ClassNotFoundException {
        s2.defaultReadObject();
        this.a = LongBigArrays.newBigArray(this.size);
        int i = 0;
        while ((long)i < this.size) {
            LongBigArrays.set(this.a, i, s2.readLong());
            ++i;
        }
    }
}

