/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.objects;

import it.unimi.dsi.fastutil.objects.AbstractReference2IntMap;
import it.unimi.dsi.fastutil.objects.ObjectBidirectionalIterable;
import it.unimi.dsi.fastutil.objects.ObjectBidirectionalIterator;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import it.unimi.dsi.fastutil.objects.ObjectSortedSet;
import it.unimi.dsi.fastutil.objects.ObjectSortedSets;
import it.unimi.dsi.fastutil.objects.Reference2IntMap;
import it.unimi.dsi.fastutil.objects.Reference2IntMaps;
import it.unimi.dsi.fastutil.objects.Reference2IntSortedMap;
import it.unimi.dsi.fastutil.objects.ReferenceSortedSet;
import it.unimi.dsi.fastutil.objects.ReferenceSortedSets;
import java.io.Serializable;
import java.util.Comparator;
import java.util.Map;
import java.util.NoSuchElementException;

public final class Reference2IntSortedMaps {
    public static final EmptySortedMap EMPTY_MAP = new EmptySortedMap();

    private Reference2IntSortedMaps() {
    }

    public static <K> Comparator<? super Map.Entry<K, ?>> entryComparator(Comparator<? super K> comparator) {
        return (x, y) -> comparator.compare((Object)x.getKey(), (Object)y.getKey());
    }

    public static <K> ObjectBidirectionalIterator<Reference2IntMap.Entry<K>> fastIterator(Reference2IntSortedMap<K> map23) {
        ObjectSet entries = map23.reference2IntEntrySet();
        return entries instanceof Reference2IntSortedMap.FastSortedEntrySet ? ((Reference2IntSortedMap.FastSortedEntrySet)entries).fastIterator() : entries.iterator();
    }

    public static <K> ObjectBidirectionalIterable<Reference2IntMap.Entry<K>> fastIterable(Reference2IntSortedMap<K> map23) {
        ObjectSet entries = map23.reference2IntEntrySet();
        return entries instanceof Reference2IntSortedMap.FastSortedEntrySet ? ((Reference2IntSortedMap.FastSortedEntrySet)entries)::fastIterator : entries;
    }

    public static <K> Reference2IntSortedMap<K> emptyMap() {
        return EMPTY_MAP;
    }

    public static <K> Reference2IntSortedMap<K> singleton(K key, Integer value2) {
        return new Singleton<K>(key, value2);
    }

    public static <K> Reference2IntSortedMap<K> singleton(K key, Integer value2, Comparator<? super K> comparator) {
        return new Singleton<K>(key, value2, comparator);
    }

    public static <K> Reference2IntSortedMap<K> singleton(K key, int value2) {
        return new Singleton<K>(key, value2);
    }

    public static <K> Reference2IntSortedMap<K> singleton(K key, int value2, Comparator<? super K> comparator) {
        return new Singleton<K>(key, value2, comparator);
    }

    public static <K> Reference2IntSortedMap<K> synchronize(Reference2IntSortedMap<K> m3) {
        return new SynchronizedSortedMap<K>(m3);
    }

    public static <K> Reference2IntSortedMap<K> synchronize(Reference2IntSortedMap<K> m3, Object sync) {
        return new SynchronizedSortedMap<K>(m3, sync);
    }

    public static <K> Reference2IntSortedMap<K> unmodifiable(Reference2IntSortedMap<K> m3) {
        return new UnmodifiableSortedMap<K>(m3);
    }

    public static class UnmodifiableSortedMap<K>
    extends Reference2IntMaps.UnmodifiableMap<K>
    implements Reference2IntSortedMap<K>,
    Serializable {
        private static final long serialVersionUID = -7046029254386353129L;
        protected final Reference2IntSortedMap<K> sortedMap;

        protected UnmodifiableSortedMap(Reference2IntSortedMap<K> m3) {
            super(m3);
            this.sortedMap = m3;
        }

        @Override
        public Comparator<? super K> comparator() {
            return this.sortedMap.comparator();
        }

        @Override
        public ObjectSortedSet<Reference2IntMap.Entry<K>> reference2IntEntrySet() {
            if (this.entries == null) {
                this.entries = ObjectSortedSets.unmodifiable(this.sortedMap.reference2IntEntrySet());
            }
            return (ObjectSortedSet)this.entries;
        }

        @Override
        @Deprecated
        public ObjectSortedSet<Map.Entry<K, Integer>> entrySet() {
            return this.reference2IntEntrySet();
        }

        @Override
        public ReferenceSortedSet<K> keySet() {
            if (this.keys == null) {
                this.keys = ReferenceSortedSets.unmodifiable(this.sortedMap.keySet());
            }
            return (ReferenceSortedSet)this.keys;
        }

        @Override
        public Reference2IntSortedMap<K> subMap(K from2, K to2) {
            return new UnmodifiableSortedMap<K>(this.sortedMap.subMap((Object)from2, (Object)to2));
        }

        @Override
        public Reference2IntSortedMap<K> headMap(K to2) {
            return new UnmodifiableSortedMap<K>(this.sortedMap.headMap((Object)to2));
        }

        @Override
        public Reference2IntSortedMap<K> tailMap(K from2) {
            return new UnmodifiableSortedMap<K>(this.sortedMap.tailMap((Object)from2));
        }

        @Override
        public K firstKey() {
            return this.sortedMap.firstKey();
        }

        @Override
        public K lastKey() {
            return this.sortedMap.lastKey();
        }
    }

    public static class SynchronizedSortedMap<K>
    extends Reference2IntMaps.SynchronizedMap<K>
    implements Reference2IntSortedMap<K>,
    Serializable {
        private static final long serialVersionUID = -7046029254386353129L;
        protected final Reference2IntSortedMap<K> sortedMap;

        protected SynchronizedSortedMap(Reference2IntSortedMap<K> m3, Object sync) {
            super(m3, sync);
            this.sortedMap = m3;
        }

        protected SynchronizedSortedMap(Reference2IntSortedMap<K> m3) {
            super(m3);
            this.sortedMap = m3;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Comparator<? super K> comparator() {
            Object object = this.sync;
            synchronized (object) {
                return this.sortedMap.comparator();
            }
        }

        @Override
        public ObjectSortedSet<Reference2IntMap.Entry<K>> reference2IntEntrySet() {
            if (this.entries == null) {
                this.entries = ObjectSortedSets.synchronize(this.sortedMap.reference2IntEntrySet(), this.sync);
            }
            return (ObjectSortedSet)this.entries;
        }

        @Override
        @Deprecated
        public ObjectSortedSet<Map.Entry<K, Integer>> entrySet() {
            return this.reference2IntEntrySet();
        }

        @Override
        public ReferenceSortedSet<K> keySet() {
            if (this.keys == null) {
                this.keys = ReferenceSortedSets.synchronize(this.sortedMap.keySet(), this.sync);
            }
            return (ReferenceSortedSet)this.keys;
        }

        @Override
        public Reference2IntSortedMap<K> subMap(K from2, K to2) {
            return new SynchronizedSortedMap<K>(this.sortedMap.subMap((Object)from2, (Object)to2), this.sync);
        }

        @Override
        public Reference2IntSortedMap<K> headMap(K to2) {
            return new SynchronizedSortedMap<K>(this.sortedMap.headMap((Object)to2), this.sync);
        }

        @Override
        public Reference2IntSortedMap<K> tailMap(K from2) {
            return new SynchronizedSortedMap<K>(this.sortedMap.tailMap((Object)from2), this.sync);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public K firstKey() {
            Object object = this.sync;
            synchronized (object) {
                return this.sortedMap.firstKey();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public K lastKey() {
            Object object = this.sync;
            synchronized (object) {
                return this.sortedMap.lastKey();
            }
        }
    }

    public static class Singleton<K>
    extends Reference2IntMaps.Singleton<K>
    implements Reference2IntSortedMap<K>,
    Serializable,
    Cloneable {
        private static final long serialVersionUID = -7046029254386353129L;
        protected final Comparator<? super K> comparator;

        protected Singleton(K key, int value2, Comparator<? super K> comparator) {
            super(key, value2);
            this.comparator = comparator;
        }

        protected Singleton(K key, int value2) {
            this(key, value2, null);
        }

        final int compare(K k1, K k2) {
            return this.comparator == null ? ((Comparable)k1).compareTo(k2) : this.comparator.compare(k1, k2);
        }

        @Override
        public Comparator<? super K> comparator() {
            return this.comparator;
        }

        @Override
        public ObjectSortedSet<Reference2IntMap.Entry<K>> reference2IntEntrySet() {
            if (this.entries == null) {
                this.entries = ObjectSortedSets.singleton(new AbstractReference2IntMap.BasicEntry<Object>(this.key, this.value), Reference2IntSortedMaps.entryComparator(this.comparator));
            }
            return (ObjectSortedSet)this.entries;
        }

        @Override
        @Deprecated
        public ObjectSortedSet<Map.Entry<K, Integer>> entrySet() {
            return this.reference2IntEntrySet();
        }

        @Override
        public ReferenceSortedSet<K> keySet() {
            if (this.keys == null) {
                this.keys = ReferenceSortedSets.singleton(this.key, this.comparator);
            }
            return (ReferenceSortedSet)this.keys;
        }

        @Override
        public Reference2IntSortedMap<K> subMap(K from2, K to2) {
            if (this.compare(from2, this.key) <= 0 && this.compare(this.key, to2) < 0) {
                return this;
            }
            return EMPTY_MAP;
        }

        @Override
        public Reference2IntSortedMap<K> headMap(K to2) {
            if (this.compare(this.key, to2) < 0) {
                return this;
            }
            return EMPTY_MAP;
        }

        @Override
        public Reference2IntSortedMap<K> tailMap(K from2) {
            if (this.compare(from2, this.key) <= 0) {
                return this;
            }
            return EMPTY_MAP;
        }

        @Override
        public K firstKey() {
            return (K)this.key;
        }

        @Override
        public K lastKey() {
            return (K)this.key;
        }
    }

    public static class EmptySortedMap<K>
    extends Reference2IntMaps.EmptyMap<K>
    implements Reference2IntSortedMap<K>,
    Serializable,
    Cloneable {
        private static final long serialVersionUID = -7046029254386353129L;

        protected EmptySortedMap() {
        }

        @Override
        public Comparator<? super K> comparator() {
            return null;
        }

        @Override
        public ObjectSortedSet<Reference2IntMap.Entry<K>> reference2IntEntrySet() {
            return ObjectSortedSets.EMPTY_SET;
        }

        @Override
        @Deprecated
        public ObjectSortedSet<Map.Entry<K, Integer>> entrySet() {
            return ObjectSortedSets.EMPTY_SET;
        }

        @Override
        public ReferenceSortedSet<K> keySet() {
            return ReferenceSortedSets.EMPTY_SET;
        }

        @Override
        public Reference2IntSortedMap<K> subMap(K from2, K to2) {
            return EMPTY_MAP;
        }

        @Override
        public Reference2IntSortedMap<K> headMap(K to2) {
            return EMPTY_MAP;
        }

        @Override
        public Reference2IntSortedMap<K> tailMap(K from2) {
            return EMPTY_MAP;
        }

        @Override
        public K firstKey() {
            throw new NoSuchElementException();
        }

        @Override
        public K lastKey() {
            throw new NoSuchElementException();
        }
    }
}

